/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimpleCsvProvider<T>
implements ICsvProvider<T> {
    private List<String> mColumnTitles;
    private final List<String> mRowTitles;
    private final List<List<T>> mTable;

    public SimpleCsvProvider(List<String> list) {
        this.mColumnTitles = list;
        this.mTable = new ArrayList<List<T>>();
        this.mRowTitles = new ArrayList<String>();
    }

    @Override
    public List<String> getColumnTitles() {
        return this.mColumnTitles;
    }

    @Override
    public List<List<T>> getTable() {
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>();
        for (List<T> list : this.mTable) {
            arrayList.add(new ArrayList<T>(list));
        }
        return arrayList;
    }

    @Override
    public List<String> getRowHeaders() {
        return this.mRowTitles;
    }

    @Override
    public void addRow(String string, List<T> list) {
        if (list == null || list.size() != this.mColumnTitles.size()) {
            throw new IllegalArgumentException("values are invalid (either null or not the same length as the number of columns of this CsvProvider");
        }
        this.mRowTitles.add(string);
        this.mTable.add(list);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        int n = 0;
        for (String string2 : this.mRowTitles) {
            if (string2 == null || string2.length() <= n) continue;
            n = string2.length();
        }
        int n2 = 0;
        while (n2 < n + 1) {
            stringBuilder.append(" ");
            ++n2;
        }
        for (String string3 : this.mColumnTitles) {
            stringBuilder.append(string3).append(",");
        }
        if (stringBuilder.length() >= 2) {
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        }
        stringBuilder.append(string);
        int n3 = 0;
        while (n3 < this.mTable.size()) {
            List<T> list = this.mTable.get(n3);
            String string4 = this.mRowTitles.get(n3);
            if (string4 == null) {
                string4 = "";
            }
            SimpleCsvProvider.checkForSeparators(string4, ",", string);
            stringBuilder.append(string4);
            int n4 = 0;
            while (n4 < n + 1 - string4.length()) {
                stringBuilder.append(" ");
                ++n4;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string5 = String.valueOf(e);
                SimpleCsvProvider.checkForSeparators(string5, ",", string);
                stringBuilder.append(string5).append(", ");
            }
            if (stringBuilder.length() >= 2) {
                stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
            }
            stringBuilder.append(string);
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder toCsv(StringBuilder stringBuilder, String string, boolean bl) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        boolean bl2 = this.hasRowHeaders();
        String string2 = System.getProperty("line.separator");
        String string3 = ",";
        if (string != null && !string.isEmpty()) {
            string3 = string;
        }
        if (bl2) {
            stringBuilder.append(string3);
        }
        if (bl) {
            for (String string4 : this.mColumnTitles) {
                if (string4 == null || string4.isEmpty()) {
                    stringBuilder.append("NOTITLE").append(string3);
                    continue;
                }
                SimpleCsvProvider.checkForSeparators(string4, string3, string2);
                stringBuilder.append(string4).append(string3);
            }
            if (stringBuilder.length() >= string3.length()) {
                stringBuilder.replace(stringBuilder.length() - string3.length(), stringBuilder.length(), "");
            }
            stringBuilder.append(string2);
        }
        int n = 0;
        while (n < this.mTable.size()) {
            List<T> list = this.mTable.get(n);
            String string5 = this.mRowTitles.get(n);
            if (bl2) {
                if (string5 == null) {
                    string5 = "";
                }
                SimpleCsvProvider.checkForSeparators(string5, string3, string2);
                stringBuilder.append(string5).append(string3);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string6 = String.valueOf(e);
                string6 = string6.replace(string2, "").replace(string3, "");
                SimpleCsvProvider.checkForSeparators(string6, string3, string2);
                stringBuilder.append(string6).append(string3);
            }
            if (stringBuilder.length() >= string3.length()) {
                stringBuilder.replace(stringBuilder.length() - string3.length(), stringBuilder.length(), "");
            }
            stringBuilder.append(string2);
            ++n;
        }
        return stringBuilder;
    }

    private static void checkForSeparators(String string, String string2, String string3) {
        if (string.contains(string2)) {
            throw new IllegalArgumentException("The following cell contains the character that is used to separate cells: " + string);
        }
        if (string.contains(string3)) {
            throw new IllegalArgumentException("The following cell contains the character that is used to separate lines: " + string);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mTable.isEmpty();
    }

    @Override
    public void addRow(List<T> list) {
        this.addRow(null, list);
    }

    @Override
    public List<T> getRow(int n) {
        if (n < 0 || n >= this.mTable.size()) {
            return null;
        }
        return this.mTable.get(n);
    }

    @Override
    public void renameColumnTitle(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : this.getColumnTitles()) {
            if (string3.equals(string)) {
                arrayList.add(string2);
                continue;
            }
            arrayList.add(string3);
        }
        this.mColumnTitles = arrayList;
    }

    private boolean hasRowHeaders() {
        for (String string : this.mRowTitles) {
            if (string == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.mTable.size();
    }

    public static SimpleCsvProvider<Object> constructCsvProviderReflectively(Object object) {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("instance is null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Field[] fieldArray = object.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = fieldArray[n2];
            if (((AccessibleObject)object2).isAnnotationPresent(CsvColumn.class)) {
                try {
                    Object object3 = ((Field)object2).get(object);
                    CsvColumn csvColumn = ((Field)object2).getAnnotation(CsvColumn.class);
                    String string = csvColumn.value();
                    arrayList.add(string);
                    arrayList2.add(object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
            }
            ++n2;
        }
        if (arrayList2.isEmpty()) {
            return new SimpleCsvProvider<Object>(Collections.emptyList());
        }
        object2 = new SimpleCsvProvider(arrayList);
        ((SimpleCsvProvider)object2).addRow(arrayList2);
        return object2;
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CsvColumn {
        public String value();
    }
}

