/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FixpointCheck {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private final TransFormula mStem;
    private final TransFormula mLoop;
    private final HasFixpoint mResult;
    private InfiniteFixpointRepetition mTerminationArgument;

    public FixpointCheck(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, Set<IProgramNonOldVar> set, TransFormula transFormula, TransFormula transFormula2) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mManagedScript = managedScript;
        this.mModifiableGlobalsAtHonda = set;
        this.mStem = transFormula;
        this.mLoop = transFormula2;
        this.mManagedScript.lock((Object)this);
        this.mResult = this.checkForFixpoint();
        this.mManagedScript.unlock((Object)this);
    }

    private HasFixpoint checkForFixpoint() {
        HasFixpoint hasFixpoint;
        Map<Term, Term> map = this.constructSubtitutionMapping(this.mStem, this::getConstantAtInit, this::getConstantAtHonda);
        Map<Term, Term> map2 = this.constructSubtitutionMapping(this.mLoop, this::getConstantAtHonda, this::getConstantAtHonda);
        Term term = Substitution.apply((ManagedScript)this.mManagedScript, map, (Term)this.mStem.getFormula());
        Term term2 = Substitution.apply((ManagedScript)this.mManagedScript, map2, (Term)this.mLoop.getFormula());
        this.mManagedScript.echo((Object)this, new QuotedObject("Start fixpoint check"));
        this.mManagedScript.push((Object)this, 1);
        this.mManagedScript.assertTerm((Object)this, term);
        this.mManagedScript.assertTerm((Object)this, term2);
        Script.LBool lBool = this.mManagedScript.checkSat((Object)this);
        switch (lBool) {
            case SAT: {
                hasFixpoint = HasFixpoint.YES;
                Set<Term> set = FixpointCheck.computeTermsForWhichWeWantValues(map, map2);
                Map map3 = SmtUtils.getValues((Script)this.mManagedScript.getScript(), set);
                Map<Term, Term> map4 = this.computeValuesAtInit(map3);
                Map<Term, Term> map5 = this.computeValuesAtHonda(map3);
                this.mTerminationArgument = new InfiniteFixpointRepetition(map4, map5);
                break;
            }
            case UNKNOWN: {
                hasFixpoint = HasFixpoint.UNKNOWN;
                break;
            }
            case UNSAT: {
                hasFixpoint = HasFixpoint.NO;
                break;
            }
            default: {
                throw new AssertionError(lBool);
            }
        }
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.echo((Object)this, new QuotedObject("Finished fixpoint check"));
        return hasFixpoint;
    }

    private Map<Term, Term> computeValuesAtHonda(Map<Term, Term> map) {
        Term term;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (IProgramVar iProgramVar : this.mStem.getOutVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)iProgramVar.getTermVariable().getSort())) continue;
            term = map.get(this.getConstantAtHonda(iProgramVar));
            assert (term != null);
            hashMap.put((Term)iProgramVar.getTermVariable(), term);
        }
        for (IProgramVar iProgramVar : this.mLoop.getInVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)iProgramVar.getTermVariable().getSort())) continue;
            term = map.get(this.getConstantAtHonda(iProgramVar));
            assert (term != null);
            hashMap.put((Term)iProgramVar.getTermVariable(), term);
        }
        for (IProgramVar iProgramVar : this.mLoop.getOutVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)iProgramVar.getTermVariable().getSort())) continue;
            term = map.get(this.getConstantAtHonda(iProgramVar));
            assert (term != null);
            hashMap.put((Term)iProgramVar.getTermVariable(), term);
        }
        return hashMap;
    }

    private Map<Term, Term> computeValuesAtInit(Map<Term, Term> map) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (IProgramVar iProgramVar : this.mStem.getInVars().keySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)iProgramVar.getTermVariable().getSort())) continue;
            Term term = map.get(this.getConstantAtInit(iProgramVar));
            assert (term != null);
            hashMap.put((Term)iProgramVar.getTermVariable(), term);
        }
        return hashMap;
    }

    private static Set<Term> computeTermsForWhichWeWantValues(Map<Term, Term> map, Map<Term, Term> map2) {
        HashSet<Term> hashSet = new HashSet<Term>();
        Predicate<Term> predicate = term -> SmtUtils.isSortForWhichWeCanGetValues((Sort)term.getSort());
        hashSet.addAll(map.values().stream().filter(predicate).collect(Collectors.toList()));
        hashSet.addAll(map2.values().stream().filter(predicate).collect(Collectors.toList()));
        return hashSet;
    }

    private static IProgramVar replaceOldByNonOld(IProgramVar iProgramVar) {
        if (iProgramVar.isOldvar()) {
            return ((IProgramOldVar)iProgramVar).getNonOldVar();
        }
        return iProgramVar;
    }

    private Map<Term, Term> constructSubtitutionMapping(TransFormula transFormula, IConstantMapper iConstantMapper, IConstantMapper iConstantMapper2) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry termVariable : transFormula.getInVars().entrySet()) {
            hashMap.put((Term)termVariable.getValue(), iConstantMapper.getConstant((IProgramVar)termVariable.getKey()));
        }
        for (Map.Entry entry : transFormula.getOutVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), iConstantMapper2.getConstant((IProgramVar)entry.getKey()));
        }
        for (TermVariable termVariable : transFormula.getAuxVars()) {
            hashMap.put((Term)termVariable, (Term)ProgramVarUtils.getAuxVarConstant((ManagedScript)this.mManagedScript, (TermVariable)termVariable));
        }
        return hashMap;
    }

    private Term getConstantAtInit(IProgramVar iProgramVar) {
        IProgramVar iProgramVar2 = FixpointCheck.replaceOldByNonOld(iProgramVar);
        return iProgramVar2.getDefaultConstant();
    }

    private Term getConstantAtHonda(IProgramVar iProgramVar) {
        IProgramNonOldVar iProgramNonOldVar;
        boolean bl = this.mStem.getAssignedVars().contains(iProgramVar);
        Object object = iProgramVar.isOldvar() ? (this.mModifiableGlobalsAtHonda.contains(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar()) ? iProgramVar : iProgramNonOldVar) : iProgramVar;
        if (bl) {
            return object.getPrimedConstant();
        }
        return object.getDefaultConstant();
    }

    public HasFixpoint getResult() {
        return this.mResult;
    }

    public InfiniteFixpointRepetition getTerminationArgument() {
        return this.mTerminationArgument;
    }

    public static enum HasFixpoint {
        YES,
        NO,
        UNKNOWN;

    }

    @FunctionalInterface
    private static interface IConstantMapper {
        public Term getConstant(IProgramVar var1);
    }
}

