/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;

public abstract class NonCoreBooleanSubTermTransformer {
    private NonCoreBooleanSubtermTransformerHelper mTransformerHelper;

    public Term transform(Term term) {
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            throw new IllegalArgumentException("Input term of sort Bool");
        }
        this.mTransformerHelper = new NonCoreBooleanSubtermTransformerHelper();
        Term term2 = this.mTransformerHelper.transform(term);
        return term2;
    }

    private static boolean hasBooleanParams(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (!SmtSortUtils.isBoolSort(term.getSort())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isCoreBooleanConnective(String string) {
        return string.equals("=") || string.equals("not") || string.equals("and") || string.equals("or") || string.equals("=>") || string.equals("xor") || string.equals("distinct") || string.equals("ite");
    }

    public static boolean isCoreBooleanNonAtom(ApplicationTerm applicationTerm) {
        String string = applicationTerm.getFunction().getName();
        return NonCoreBooleanSubTermTransformer.isCoreBooleanConnective(string) && NonCoreBooleanSubTermTransformer.hasBooleanParams(applicationTerm.getParameters());
    }

    protected abstract Term transformNonCoreBooleanSubterm(Term var1);

    private class NonCoreBooleanSubtermTransformerHelper
    extends TermTransformer {
        private NonCoreBooleanSubtermTransformerHelper() {
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void convert(Term term) {
            assert (SmtSortUtils.isBoolSort(term.getSort())) : "not Bool";
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (!NonCoreBooleanSubTermTransformer.isCoreBooleanNonAtom(applicationTerm)) {
                    Term term2 = NonCoreBooleanSubTermTransformer.this.transformNonCoreBooleanSubterm(term);
                    this.setResult(term2);
                    return;
                }
                super.convert(term);
            } else {
                if (term instanceof LetTerm) {
                    throw new UnsupportedOperationException(NonCoreBooleanSubTermTransformer.class.getSimpleName() + " does not support " + LetTerm.class.getSimpleName());
                }
                if (term instanceof AnnotatedTerm) {
                    throw new UnsupportedOperationException(NonCoreBooleanSubTermTransformer.class.getSimpleName() + " does not support " + AnnotatedTerm.class.getSimpleName());
                }
            }
            super.convert(term);
        }
    }
}

