/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.AnnotateAndAssertCodeBlocks;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AnnotateAndAssertConjunctsOfCodeBlocks<L extends IAction>
extends AnnotateAndAssertCodeBlocks<L> {
    protected final NestedFormulas<L, UnmodifiableTransFormula, IPredicate> mNestedFormulas;
    private final Map<Term, Term> mAnnotated2Original = new HashMap<Term, Term>();
    private final SplitEqualityMapping mSplitEqualityMapping = new SplitEqualityMapping();
    private final ManagedScript mCsToolkitPredicates;
    private static final boolean SPLIT_EQUALITIES = true;

    public AnnotateAndAssertConjunctsOfCodeBlocks(ManagedScript managedScript, TraceCheck.TraceCheckLock traceCheckLock, NestedFormulas<L, Term, Term> nestedFormulas, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas2, ILogger iLogger, ManagedScript managedScript2) {
        super(managedScript, traceCheckLock, nestedFormulas, iLogger);
        this.mNestedFormulas = nestedFormulas2;
        this.mCsToolkitPredicates = managedScript2;
    }

    private Term annotateAndAssertConjuncts(String string, Term term, Term term2) {
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        Term[] termArray2 = SmtUtils.getConjuncts((Term)term2);
        assert (termArray.length == termArray2.length) : "number of original and indexed conjuncts differ";
        LinkedList<Term> linkedList = new LinkedList<Term>();
        int n = 0;
        int n2 = 0;
        while (n2 < termArray.length) {
            Term term3 = termArray[n2];
            Term term4 = termArray2[n2];
            BinaryNumericRelation binaryNumericRelation = AnnotateAndAssertConjunctsOfCodeBlocks.convertToBinaryNumericEquality(term3);
            if (binaryNumericRelation != null) {
                BinaryNumericRelation binaryNumericRelation2 = AnnotateAndAssertConjunctsOfCodeBlocks.convertToBinaryNumericEquality(term4);
                Term[] termArray3 = AnnotateAndAssertConjunctsOfCodeBlocks.transformEqualityToInequalities(binaryNumericRelation2, this.mMgdScript.getScript());
                Term[] termArray4 = AnnotateAndAssertConjunctsOfCodeBlocks.transformEqualityToInequalities(binaryNumericRelation, this.mCsToolkitPredicates.getScript());
                linkedList.add(this.annotateAndAssertTerm(termArray3[0], string, n));
                this.mAnnotated2Original.put((Term)linkedList.get(n), termArray4[0]);
                linkedList.add(this.annotateAndAssertTerm(termArray3[1], string, n + 1));
                this.mAnnotated2Original.put((Term)linkedList.get(n + 1), termArray4[1]);
                this.mSplitEqualityMapping.add((Term)linkedList.get(n), (Term)linkedList.get(n + 1), term3);
                n += 2;
            } else {
                linkedList.add(this.annotateAndAssertTerm(term4, string, n));
                this.mAnnotated2Original.put((Term)linkedList.get(n), term3);
                ++n;
            }
            ++n2;
        }
        return SmtUtils.and((Script)this.mScript, (Term[])linkedList.toArray(new Term[linkedList.size()]));
    }

    private Term annotateAndAssertConjunction(String string, Term term, Term term2) {
        Term term3 = super.annotateAndAssertTerm(term2, string);
        this.mAnnotated2Original.put(term3, term);
        return term3;
    }

    @Override
    protected Term annotateAndAssertPrecondition() {
        String string = super.precondAnnotation();
        Term term = this.mNestedFormulas.getPrecondition().getFormula();
        Term term2 = (Term)this.mSSA.getPrecondition();
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertPostcondition() {
        String string = super.postcondAnnotation();
        Term term = this.mNestedFormulas.getPostcondition().getFormula();
        Term term2 = this.mScript.term("not", new Term[]{(Term)this.mSSA.getPostcondition()});
        return this.annotateAndAssertConjunction(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertNonCall(int n) {
        String string = this.mTrace.isReturnPosition(n) ? this.returnAnnotation(n) : this.internalAnnotation(n);
        Term term = this.mNestedFormulas.getFormulaFromNonCallPos(n).getFormula();
        Term term2 = (Term)this.mSSA.getFormulaFromNonCallPos(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertLocalVarAssignemntCall(int n) {
        String string = super.localVarAssignemntCallAnnotation(n);
        Term term = this.mNestedFormulas.getLocalVarAssignment(n).getFormula();
        Term term2 = (Term)this.mSSA.getLocalVarAssignment(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertGlobalVarAssignemntCall(int n) {
        String string = super.globalVarAssignemntAnnotation(n);
        Term term = this.mNestedFormulas.getGlobalVarAssignment(n).getFormula();
        Term term2 = (Term)this.mSSA.getGlobalVarAssignment(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertOldVarAssignemntCall(int n) {
        String string = super.oldVarAssignemntCallAnnotation(n);
        Term term = this.mNestedFormulas.getOldVarAssignment(n).getFormula();
        Term term2 = (Term)this.mSSA.getOldVarAssignment(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertPendingContext(int n, int n2) {
        String string = super.pendingContextAnnotation(n2);
        Term term = this.mNestedFormulas.getPendingContext(n).getFormula();
        Term term2 = (Term)this.mSSA.getPendingContext(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertLocalVarAssignemntPendingContext(int n, int n2) {
        String string = super.localVarAssignemntPendingReturnAnnotation(n2);
        Term term = this.mNestedFormulas.getLocalVarAssignment(n).getFormula();
        Term term2 = (Term)this.mSSA.getLocalVarAssignment(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    @Override
    protected Term annotateAndAssertOldVarAssignemntPendingContext(int n, int n2) {
        String string = super.oldVarAssignemntPendingReturnAnnotation(n2);
        Term term = this.mNestedFormulas.getOldVarAssignment(n).getFormula();
        Term term2 = (Term)this.mSSA.getOldVarAssignment(n);
        return this.annotateAndAssertConjuncts(string, term, term2);
    }

    protected Term annotateAndAssertTerm(Term term, String string, int n) {
        return super.annotateAndAssertTerm(term, string + "_conjunct" + n);
    }

    private static BinaryNumericRelation convertToBinaryNumericEquality(Term term) {
        BinaryNumericRelation binaryNumericRelation = BinaryNumericRelation.convert((Term)term);
        if (binaryNumericRelation == null) {
            return null;
        }
        if (SmtSortUtils.isBitvecSort((Sort)binaryNumericRelation.getRhs().getSort())) {
            return null;
        }
        if (binaryNumericRelation.getRelationSymbol() == RelationSymbol.EQ) {
            return binaryNumericRelation;
        }
        return null;
    }

    private static Term[] transformEqualityToInequalities(BinaryNumericRelation binaryNumericRelation, Script script) {
        Term term = script.term("<=", new Term[]{binaryNumericRelation.getLhs(), binaryNumericRelation.getRhs()});
        Term term2 = script.term(">=", new Term[]{binaryNumericRelation.getLhs(), binaryNumericRelation.getRhs()});
        return new Term[]{term, term2};
    }

    public Map<Term, Term> getAnnotated2Original() {
        return this.mAnnotated2Original;
    }

    public SplitEqualityMapping getSplitEqualityMapping() {
        return this.mSplitEqualityMapping;
    }

    public static class SplitEqualityMapping {
        private final Map<Term, Term> mInequality2CorrespondingInequality = new HashMap<Term, Term>();
        private final Map<Term, Term> mInequality2OriginalEquality = new HashMap<Term, Term>();

        void add(Term term, Term term2, Term term3) {
            this.mInequality2CorrespondingInequality.put(term, term2);
            this.mInequality2CorrespondingInequality.put(term2, term);
            this.mInequality2OriginalEquality.put(term, term3);
            this.mInequality2OriginalEquality.put(term2, term3);
        }

        public Map<Term, Term> getInequality2CorrespondingInequality() {
            return Collections.unmodifiableMap(this.mInequality2CorrespondingInequality);
        }

        public Map<Term, Term> getInequality2OriginalEquality() {
            return Collections.unmodifiableMap(this.mInequality2OriginalEquality);
        }
    }
}

