/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.ModifiableNestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LiveVariables<L extends IAction> {
    private final Map<Term, IProgramVar> mConstants2BoogieVar;
    private final ModifiableNestedFormulas<L, Map<Term, Term>, Map<Term, Term>> mTraceWithConstants;
    private final Map<IProgramVar, TreeMap<Integer, Term>> mIndexedVarRepresentative;
    private final Collection<Term>[] mConstantsForEachPosition;
    private final Set<Term>[] mLiveConstants;
    private final Set<IProgramVar>[] mLiveVariables;

    public LiveVariables(ModifiableNestedFormulas<L, Map<Term, Term>, Map<Term, Term>> modifiableNestedFormulas, Map<Term, IProgramVar> map, Map<IProgramVar, TreeMap<Integer, Term>> map2) {
        this.mConstants2BoogieVar = map;
        this.mTraceWithConstants = modifiableNestedFormulas;
        this.mIndexedVarRepresentative = map2;
        this.mConstantsForEachPosition = this.fetchConstantsForEachPosition();
        this.mLiveConstants = this.computeLiveConstants();
        this.mLiveVariables = this.computeLiveVariables();
    }

    private Collection<Term>[] fetchConstantsForEachPosition() {
        Collection[] collectionArray = new Collection[this.mTraceWithConstants.getTrace().length() + 2];
        collectionArray[0] = this.extractVarConstants(((Map)this.mTraceWithConstants.getPrecondition()).values());
        int n = this.mTraceWithConstants.getTrace().length() + 1;
        collectionArray[n] = this.extractVarConstants(((Map)this.mTraceWithConstants.getPostcondition()).values());
        int n2 = 0;
        while (n2 < this.mTraceWithConstants.getTrace().length()) {
            if (this.mTraceWithConstants.getTrace().isCallPosition(n2)) {
                assert (collectionArray[n2 + 1] == null) : "constants for position " + (n2 + 1) + " already fetched!";
                collectionArray[n2 + 1] = this.mTraceWithConstants.getTrace().isPendingCall(n2) ? this.extractVarConstants(((Map)this.mTraceWithConstants.getLocalVarAssignment(n2)).values(), ((Map)this.mTraceWithConstants.getGlobalVarAssignment(n2)).values(), ((Map)this.mTraceWithConstants.getOldVarAssignment(n2)).values()) : this.extractVarConstants(((Map)this.mTraceWithConstants.getGlobalVarAssignment(n2)).values());
            } else if (this.mTraceWithConstants.getTrace().isReturnPosition(n2)) {
                assert (collectionArray[n2 + 1] == null) : "constants for position " + (n2 + 1) + " already fetched!";
                if (this.mTraceWithConstants.getTrace().isPendingReturn(n2)) {
                    throw new AssertionError((Object)"not yet implemented");
                }
                int n3 = this.mTraceWithConstants.getTrace().getCallPosition(n2);
                collectionArray[n2 + 1] = this.extractVarConstants(((Map)this.mTraceWithConstants.getFormulaFromNonCallPos(n2)).values(), ((Map)this.mTraceWithConstants.getLocalVarAssignment(n3)).values(), ((Map)this.mTraceWithConstants.getOldVarAssignment(n3)).values());
            } else {
                assert (collectionArray[n2 + 1] == null) : "constants for position " + (n2 + 1) + " already fetched!";
                assert (this.mTraceWithConstants.getTrace().isInternalPosition(n2));
                collectionArray[n2 + 1] = this.extractVarConstants(((Map)this.mTraceWithConstants.getFormulaFromNonCallPos(n2)).values());
            }
            ++n2;
        }
        return collectionArray;
    }

    @SafeVarargs
    private final Set<Term> extractVarConstants(Collection<Term> ... collectionArray) {
        HashSet<Term> hashSet = new HashSet<Term>();
        Collection<Term>[] collectionArray2 = collectionArray;
        int n = collectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<Term> collection = collectionArray2[n2];
            for (Term term : collection) {
                if (!this.mConstants2BoogieVar.containsKey(term)) continue;
                hashSet.add(term);
            }
            ++n2;
        }
        return hashSet;
    }

    private Set<Term>[] computeLiveConstants() {
        Set[] setArray = new Set[this.mTraceWithConstants.getTrace().length() + 1];
        HashSet<Term> hashSet = new HashSet<Term>(this.mConstantsForEachPosition[setArray.length]);
        this.removeConstantsWithIndex_i(hashSet, setArray.length - 1);
        setArray[setArray.length - 1] = hashSet;
        int n = setArray.length - 2;
        while (n >= 0) {
            HashSet<Term> hashSet2 = new HashSet<Term>();
            if (this.mTraceWithConstants.getTrace().isCallPosition(n)) {
                var4_5 = ((IAction)this.mTraceWithConstants.getTrace().getSymbol(n)).getPrecedingProcedure();
                if (this.mTraceWithConstants.getTrace().isPendingCall(n)) {
                    this.addGlobals(hashSet2, setArray[n + 1]);
                    this.addGlobals(hashSet2, this.mConstantsForEachPosition[n + 1]);
                    this.addLocals(var4_5, hashSet2, this.mConstantsForEachPosition[n + 1]);
                } else {
                    int n2 = this.mTraceWithConstants.getTrace().getReturnPosition(n);
                    this.addLocals(var4_5, hashSet2, setArray[n2 + 1]);
                    this.addLocals(var4_5, hashSet2, this.mConstantsForEachPosition[n2 + 1]);
                    this.removeConstantsWithIndex_i(hashSet2, n2);
                    this.addGlobals(hashSet2, setArray[n + 1]);
                    this.addGlobals(hashSet2, this.mConstantsForEachPosition[n + 1]);
                }
            } else if (this.mTraceWithConstants.getTrace().isReturnPosition(n)) {
                var4_5 = ((IAction)this.mTraceWithConstants.getTrace().getSymbol(n)).getPrecedingProcedure();
                this.addGlobals(hashSet2, setArray[n + 1]);
                this.addGlobals(hashSet2, this.mConstantsForEachPosition[n + 1]);
                this.addLocals(var4_5, hashSet2, this.mConstantsForEachPosition[n + 1]);
            } else {
                assert (this.mTraceWithConstants.getTrace().isInternalPosition(n));
                hashSet2.addAll(this.mConstantsForEachPosition[n + 1]);
                hashSet2.addAll(setArray[n + 1]);
            }
            this.removeConstantsWithIndex_i(hashSet2, n);
            setArray[n] = hashSet2;
            --n;
        }
        return setArray;
    }

    private void addGlobals(HashSet<Term> hashSet, Collection<Term> collection) {
        for (Term term : collection) {
            IProgramVar iProgramVar = this.mConstants2BoogieVar.get(term);
            if (!iProgramVar.isGlobal()) continue;
            hashSet.add(term);
        }
    }

    private void addLocals(String string, HashSet<Term> hashSet, Collection<Term> collection) {
        for (Term term : collection) {
            IProgramVar iProgramVar = this.mConstants2BoogieVar.get(term);
            if (iProgramVar.isGlobal() || !iProgramVar.getProcedure().equals(string)) continue;
            hashSet.add(term);
        }
    }

    private void removeConstantsWithIndex_i(HashSet<Term> hashSet, int n) {
        Iterator<Term> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Term term = iterator.next();
            IProgramVar iProgramVar = this.mConstants2BoogieVar.get(term);
            Map map = this.mIndexedVarRepresentative.get(iProgramVar);
            if (map.get(n) != term) continue;
            iterator.remove();
        }
    }

    private Set<IProgramVar>[] computeLiveVariables() {
        Set[] setArray = new Set[this.mTraceWithConstants.getTrace().length() + 1];
        ScopedHashSet scopedHashSet = new ScopedHashSet();
        int n = 0;
        while (n < setArray.length) {
            if (n > 0 && n < setArray.length - 1 && this.mTraceWithConstants.getTrace().isCallPosition(n - 1) && !this.mTraceWithConstants.getTrace().isPendingCall(n - 1)) {
                scopedHashSet.beginScope();
            }
            if (n > 0 && n < setArray.length - 1 && this.mTraceWithConstants.getTrace().isReturnPosition(n - 1)) {
                if (this.mTraceWithConstants.getTrace().isPendingReturn(n - 1)) {
                    throw new AssertionError((Object)"not yet implemented");
                }
                scopedHashSet.endScope();
            }
            HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
            for (Term term : this.mLiveConstants[n]) {
                IProgramVar iProgramVar = this.mConstants2BoogieVar.get(term);
                if (!scopedHashSet.isEmptyScope() && iProgramVar.isGlobal()) {
                    scopedHashSet.add((Object)iProgramVar);
                    continue;
                }
                hashSet.add(iProgramVar);
            }
            hashSet.addAll((Collection<IProgramVar>)scopedHashSet);
            setArray[n] = hashSet;
            ++n;
        }
        return setArray;
    }

    public Set<IProgramVar>[] getLiveVariables() {
        return this.mLiveVariables;
    }
}

