/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.MonolithicHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.ModifiableNestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TraceCheckUtils {
    private TraceCheckUtils() {
    }

    public static List<IcfgLocation> getSequenceOfProgramPoints(Word<? extends IAction> word) {
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        Iterator iterator = word.iterator();
        while (iterator.hasNext()) {
            IAction iAction = (IAction)iterator.next();
            if (!(iAction instanceof IIcfgTransition)) {
                throw new IllegalArgumentException("currentAction is no IIcfgTransition");
            }
            IIcfgTransition iIcfgTransition = (IIcfgTransition)iAction;
            arrayList.add(iIcfgTransition.getSource());
            if (iterator.hasNext()) continue;
            arrayList.add(iIcfgTransition.getTarget());
        }
        return arrayList;
    }

    public static CoverageAnalysis.BackwardCoveringInformation computeCoverageCapability(IUltimateServiceProvider iUltimateServiceProvider, IInterpolantGenerator<?> iInterpolantGenerator, ILogger iLogger) {
        NestedWord nestedWord = TraceCheckUtils.toNestedWord(iInterpolantGenerator.getTrace());
        List<IcfgLocation> list = TraceCheckUtils.getSequenceOfProgramPoints(nestedWord);
        return TraceCheckUtils.computeCoverageCapability(iUltimateServiceProvider, iInterpolantGenerator.getIpp(), list, iLogger, iInterpolantGenerator.getPredicateUnifier());
    }

    public static <L extends IAction> NestedWord<L> toNestedWord(List<L> list) {
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        int[] nArray = new int[list.size()];
        Object[] objectArray = list.toArray(new IAction[list.size()]);
        int n = 0;
        for (IAction iAction : list) {
            objectArray[n] = iAction;
            if (iAction instanceof ICallAction) {
                arrayDeque.push(n);
                nArray[n] = Integer.MAX_VALUE;
            } else if (iAction instanceof IReturnAction) {
                int n2;
                nArray[n] = n2 = ((Integer)arrayDeque.pop()).intValue();
                nArray[n2] = n;
            } else if (iAction instanceof IInternalAction) {
                nArray[n] = -2;
            } else {
                throw new UnsupportedOperationException("Type of letter is unknown: " + String.valueOf(iAction.getClass()));
            }
            ++n;
        }
        return new NestedWord(objectArray, nArray);
    }

    public static <CL> CoverageAnalysis.BackwardCoveringInformation computeCoverageCapability(IUltimateServiceProvider iUltimateServiceProvider, TracePredicates tracePredicates, List<CL> list, ILogger iLogger, IPredicateUnifier iPredicateUnifier) {
        CoverageAnalysis<CL> coverageAnalysis = new CoverageAnalysis<CL>(iUltimateServiceProvider, tracePredicates, list, iLogger, iPredicateUnifier);
        coverageAnalysis.analyze();
        return coverageAnalysis.getBackwardCoveringInformation();
    }

    public static boolean checkInterpolantsInductivityForward(List<IPredicate> list, NestedWord<? extends IAction> nestedWord, IPredicate iPredicate, IPredicate iPredicate2, Map<Integer, IPredicate> map, String string, CfgSmtToolkit cfgSmtToolkit, ILogger iLogger) {
        MonolithicHoareTripleChecker monolithicHoareTripleChecker = new MonolithicHoareTripleChecker(cfgSmtToolkit);
        TracePredicates tracePredicates = new TracePredicates(iPredicate, iPredicate2, list);
        int n = 0;
        while (n <= list.size()) {
            IncrementalPlicationChecker.Validity validity = TraceCheckUtils.checkInductivityAtPosition(n, tracePredicates, nestedWord, map, (IHoareTripleChecker)monolithicHoareTripleChecker, iLogger);
            if (validity != IncrementalPlicationChecker.Validity.VALID && validity != IncrementalPlicationChecker.Validity.UNKNOWN) {
                throw new AssertionError((Object)("invalid Hoare triple in " + string + " Trace length " + nestedWord.length()));
            }
            ++n;
        }
        return true;
    }

    public static boolean checkInterpolantsInductivityBackward(List<IPredicate> list, NestedWord<? extends IAction> nestedWord, IPredicate iPredicate, IPredicate iPredicate2, Map<Integer, IPredicate> map, String string, CfgSmtToolkit cfgSmtToolkit, ILogger iLogger, ManagedScript managedScript) {
        MonolithicHoareTripleChecker monolithicHoareTripleChecker = new MonolithicHoareTripleChecker(cfgSmtToolkit);
        TracePredicates tracePredicates = new TracePredicates(iPredicate, iPredicate2, list);
        int n = list.size();
        while (n >= 0) {
            IncrementalPlicationChecker.Validity validity = TraceCheckUtils.checkInductivityAtPosition(n, tracePredicates, nestedWord, map, (IHoareTripleChecker)monolithicHoareTripleChecker, iLogger);
            if (validity != IncrementalPlicationChecker.Validity.VALID && validity != IncrementalPlicationChecker.Validity.UNKNOWN) {
                throw new AssertionError((Object)("invalid Hoare triple in " + string));
            }
            --n;
        }
        return true;
    }

    private static IncrementalPlicationChecker.Validity checkInductivityAtPosition(int n, TracePredicates tracePredicates, NestedWord<? extends IAction> nestedWord, Map<Integer, IPredicate> map, IHoareTripleChecker iHoareTripleChecker, ILogger iLogger) {
        IncrementalPlicationChecker.Validity validity2;
        IPredicate iPredicate = tracePredicates.getPredicate(n);
        IPredicate iPredicate2 = tracePredicates.getPredicate(n + 1);
        IAction iAction = (IAction)nestedWord.getSymbol(n);
        Function<IncrementalPlicationChecker.Validity, ILogger.LogLevel> function = validity -> validity == IncrementalPlicationChecker.Validity.INVALID ? ILogger.LogLevel.ERROR : (validity == IncrementalPlicationChecker.Validity.VALID ? ILogger.LogLevel.INFO : ILogger.LogLevel.WARN);
        if (nestedWord.isCallPosition(n)) {
            assert (iAction instanceof ICallAction) : "not Call at call position";
            validity2 = iHoareTripleChecker.checkCall(iPredicate, (ICallAction)iAction, iPredicate2);
            iLogger.log(function.apply(validity2), (Object)new DebugMessage("{0}: Hoare triple '{'{1}'}' {2} '{'{3}'}' is {4}", new Object[]{n, iPredicate, iAction, iPredicate2, validity2}));
        } else if (nestedWord.isReturnPosition(n)) {
            IPredicate iPredicate3;
            assert (iAction instanceof IReturnAction) : "not Call at call position";
            if (nestedWord.isPendingReturn(n)) {
                iPredicate3 = map.get(n);
            } else {
                int n2 = nestedWord.getCallPosition(n);
                iPredicate3 = tracePredicates.getPredicate(n2);
            }
            validity2 = iHoareTripleChecker.checkReturn(iPredicate, iPredicate3, (IReturnAction)iAction, iPredicate2);
            iLogger.log(function.apply(validity2), (Object)new DebugMessage("{0}: Hoare quadruple '{'{1}'}' '{'{5}'}' {2} '{'{3}'}' is {4}", new Object[]{n, iPredicate, iAction, iPredicate2, validity2, iPredicate3}));
        } else if (nestedWord.isInternalPosition(n)) {
            assert (iAction instanceof IInternalAction);
            validity2 = iHoareTripleChecker.checkInternal(iPredicate, (IInternalAction)iAction, iPredicate2);
            iLogger.log(function.apply(validity2), (Object)new DebugMessage("{0}: Hoare triple '{'{1}'}' {2} '{'{3}'}' is {4}", new Object[]{n, iPredicate, iAction, iPredicate2, validity2}));
        } else {
            throw new AssertionError((Object)"unsupported position");
        }
        return validity2;
    }

    public static <L extends IAction> IcfgProgramExecution<L> computeSomeIcfgProgramExecutionWithoutValues(Word<L> word) {
        Map[] mapArray = new Map[word.length()];
        int n = 0;
        while (n < mapArray.length) {
            IAction iAction = (IAction)word.getSymbol(n);
            if (iAction instanceof IActionWithBranchEncoders) {
                Set set = ((IActionWithBranchEncoders)iAction).getTransitionFormulaWithBranchEncoders().getBranchEncoders();
                mapArray[n] = set.stream().collect(Collectors.toUnmodifiableMap(termVariable -> termVariable, termVariable -> true));
            } else {
                mapArray[n] = Collections.emptyMap();
            }
            ++n;
        }
        return IcfgProgramExecution.create((List)word.asList(), Collections.emptyMap(), (Map[])mapArray);
    }

    public static TermClassifier classifyTermsInTrace(Word<? extends IAction> word, SmtFunctionsAndAxioms smtFunctionsAndAxioms) {
        TermClassifier termClassifier = new TermClassifier();
        termClassifier.checkTerm(smtFunctionsAndAxioms.getAxioms().getFormula());
        for (IAction iAction : word) {
            if (iAction instanceof IInternalAction) {
                termClassifier.checkTerm(iAction.getTransformula().getFormula());
                continue;
            }
            if (iAction instanceof ICallAction) {
                termClassifier.checkTerm(((ICallAction)iAction).getLocalVarsAssignment().getFormula());
                continue;
            }
            if (!(iAction instanceof IReturnAction)) continue;
            termClassifier.checkTerm(((IReturnAction)iAction).getAssignmentOfReturn().getFormula());
        }
        return termClassifier;
    }

    public static TermVarsFuns getOldVarsEquality(String string, ModifiableGlobalsTable modifiableGlobalsTable, ManagedScript managedScript) {
        IProgramVar iProgramVar2;
        HashSet<Object> hashSet = new HashSet<Object>();
        Term term = managedScript.getScript().term("true", new Term[0]);
        for (IProgramVar iProgramVar2 : modifiableGlobalsTable.getModifiedBoogieVars(string)) {
            hashSet.add(iProgramVar2);
            IProgramOldVar iProgramOldVar = ((IProgramNonOldVar)iProgramVar2).getOldVar();
            hashSet.add(iProgramOldVar);
            TermVariable termVariable = iProgramVar2.getTermVariable();
            TermVariable termVariable2 = iProgramOldVar.getTermVariable();
            Term term2 = SmtUtils.binaryEquality((Script)managedScript.getScript(), (Term)termVariable, (Term)termVariable2);
            term = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term, term2});
        }
        iProgramVar2 = new TermVarsFuns(term, hashSet, Collections.emptySet(), PredicateUtils.computeClosedFormula((Term)term, hashSet, (ManagedScript)managedScript));
        return iProgramVar2;
    }

    public static <L extends IAction> NestedFormulas<L, UnmodifiableTransFormula, IPredicate> decoupleArrayValues(ManagedScript managedScript, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas) {
        ModifiableNestedFormulas modifiableNestedFormulas = new ModifiableNestedFormulas(nestedFormulas.getCounterexample(), new TreeMap());
        modifiableNestedFormulas.setPrecondition(nestedFormulas.getPrecondition());
        modifiableNestedFormulas.setPostcondition(nestedFormulas.getPostcondition());
        int n = 0;
        while (n < nestedFormulas.getTrace().length()) {
            if (nestedFormulas.getTrace().isCallPosition(n)) {
                var4_4 = TransFormulaUtils.decoupleArrayValues((UnmodifiableTransFormula)nestedFormulas.getLocalVarAssignment(n), (ManagedScript)managedScript);
                modifiableNestedFormulas.setLocalVarAssignmentAtPos(n, var4_4);
                modifiableNestedFormulas.setGlobalVarAssignmentAtPos(n, nestedFormulas.getGlobalVarAssignment(n));
                modifiableNestedFormulas.setOldVarAssignmentAtPos(n, nestedFormulas.getOldVarAssignment(n));
            } else {
                var4_4 = TransFormulaUtils.decoupleArrayValues((UnmodifiableTransFormula)nestedFormulas.getFormulaFromNonCallPos(n), (ManagedScript)managedScript);
                modifiableNestedFormulas.setFormulaAtNonCallPos(n, var4_4);
                if (nestedFormulas.getTrace().isPendingReturn(n)) {
                    modifiableNestedFormulas.setPendingContext(n, nestedFormulas.getPendingContext(n));
                    modifiableNestedFormulas.setOldVarAssignmentAtPos(n, nestedFormulas.getOldVarAssignment(n));
                }
            }
            ++n;
        }
        return modifiableNestedFormulas;
    }
}

