/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.BasicAbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.IterableWithAdditionalElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeterministicInterpolantAutomaton<LETTER extends IAction>
extends BasicAbstractInterpolantAutomaton<LETTER> {
    private final Map<ImmutableSet<IPredicate>, IPredicate> mInputPreds2ResultPreds = new HashMap<ImmutableSet<IPredicate>, IPredicate>();
    private final HashRelation<IPredicate, IPredicate> mResPred2InputPreds = new HashRelation();
    private final IPredicateUnifier mPredicateUnifier;
    protected final Set<IPredicate> mNonTrivialPredicates;
    private final boolean mCannibalize;
    private final boolean mSplitNumericEqualities = true;
    private final boolean mDivisibilityPredicates = false;
    private final boolean mConservativeSuccessorCandidateSelection;

    public DeterministicInterpolantAutomaton(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, IHoareTripleChecker iHoareTripleChecker, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, IPredicateUnifier iPredicateUnifier, boolean bl, boolean bl2) {
        super(iUltimateServiceProvider, cfgSmtToolkit, iHoareTripleChecker, true, iPredicateUnifier, iNestedWordAutomaton);
        IPredicate iPredicate2;
        Set set;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mCannibalize = bl2;
        this.mConservativeSuccessorCandidateSelection = bl;
        if (this.mConservativeSuccessorCandidateSelection && this.mCannibalize) {
            throw new IllegalArgumentException("ConservativeSuccessorCandidateSelection and Cannibalize are incompatible");
        }
        if (this.mCannibalize) {
            set = this.mPredicateUnifier.cannibalizeAll(true, (Collection)iNestedWordAutomaton.getStates());
            for (IPredicate iPredicate2 : set) {
                if (iNestedWordAutomaton.getStates().contains(iPredicate2)) continue;
                this.mAlreadyConstructedAutomaton.addState(false, false, (Object)iPredicate2);
            }
        } else {
            set = iNestedWordAutomaton.getStates();
        }
        iPredicate2 = (IPredicate)iNestedWordAutomaton.getInitialStates().iterator().next();
        this.mAlreadyConstructedAutomaton.addState(true, false, (Object)iPredicate2);
        this.mResPred2InputPreds.addPair((Object)iPredicate2, (Object)iPredicate2);
        if (!iPredicate2.equals(this.mIaTrueState)) {
            assert (SmtUtils.isTrueLiteral((Term)this.mIaTrueState.getFormula()));
            this.mAlreadyConstructedAutomaton.addState(false, false, (Object)this.mIaTrueState);
        }
        assert (SmtUtils.isFalseLiteral((Term)this.mIaFalseState.getFormula()));
        this.mAlreadyConstructedAutomaton.addState(false, true, (Object)this.mIaFalseState);
        this.mResPred2InputPreds.addPair((Object)this.mIaFalseState, (Object)this.mIaFalseState);
        this.mNonTrivialPredicates = new HashSet<IPredicate>();
        for (IPredicate iPredicate3 : set) {
            if (iPredicate3 == this.mIaTrueState || iPredicate3 == this.mIaFalseState) continue;
            this.processResPredInputPredsMapping(iPredicate3);
            this.mNonTrivialPredicates.add(iPredicate3);
        }
        this.mLogger.info((Object)this.startMessage());
        if (this.mPredicateUnifier.getCoverageRelation() instanceof PredicateUnifier.CoverageRelation) {
            this.mLogger.info((Object)((PredicateUnifier.CoverageRelation)this.mPredicateUnifier.getCoverageRelation()).getCoverageRelationStatistics());
        } else {
            this.mLogger.info((Object)("No coverage relation statistics for " + this.mPredicateUnifier.getCoverageRelation().getClass().getSimpleName()));
        }
    }

    private void processResPredInputPredsMapping(IPredicate iPredicate) {
        Set set = this.mPredicateUnifier.getCoverageRelation().getCoveringPredicates(iPredicate);
        for (IPredicate iPredicate2 : set) {
            if (iPredicate2 == this.mIaTrueState || !this.mInputInterpolantAutomaton.getStates().contains(iPredicate2)) continue;
            this.mResPred2InputPreds.addPair((Object)iPredicate, (Object)iPredicate2);
        }
    }

    @Override
    protected String startMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing interpolant automaton ");
        stringBuilder.append("starting with ");
        stringBuilder.append(this.mNonTrivialPredicates.size() + 2);
        stringBuilder.append(" interpolants.");
        return stringBuilder.toString();
    }

    @Override
    protected String switchToReadonlyMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Switched to read-only mode: deterministic interpolant automaton has ");
        stringBuilder.append(this.mAlreadyConstructedAutomaton.size()).append(" states. ");
        return stringBuilder.toString();
    }

    @Override
    protected String switchToOnDemandConstructionMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Switched to On-DemandConstruction mode: deterministic interpolant automaton has ");
        stringBuilder.append(this.mAlreadyConstructedAutomaton.size()).append(" states. ");
        return stringBuilder.toString();
    }

    @Override
    protected void addOtherSuccessors(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper, Set<IPredicate> set) {
        for (IPredicate iPredicate3 : this.selectSuccessorCandidates(iPredicate, iPredicate2)) {
            IncrementalPlicationChecker.Validity validity;
            if (set.contains(iPredicate3) || (validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, iPredicate3)) != IncrementalPlicationChecker.Validity.VALID) continue;
            set.add(iPredicate3);
        }
    }

    private Set<IPredicate> selectSuccessorCandidates(IPredicate iPredicate, IPredicate iPredicate2) {
        if (this.mConservativeSuccessorCandidateSelection) {
            return this.selectSuccessorCandidates_TryConservative(iPredicate, iPredicate2);
        }
        return this.selectSuccessorCandidates_TryAll();
    }

    private Set<IPredicate> selectSuccessorCandidates_TryConservative(IPredicate iPredicate, IPredicate iPredicate2) {
        HashSet hashSet;
        if (iPredicate2 != null) {
            hashSet = new HashSet(this.mResPred2InputPreds.getImage((Object)iPredicate));
            hashSet.addAll(this.mResPred2InputPreds.getImage((Object)iPredicate2));
        } else {
            hashSet = this.mResPred2InputPreds.getImage((Object)iPredicate);
        }
        return hashSet;
    }

    private Set<IPredicate> selectSuccessorCandidates_TryAll() {
        return this.mNonTrivialPredicates;
    }

    @Override
    protected void addInputAutomatonSuccs(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper, Set<IPredicate> set) {
        IterableWithAdditionalElement<IPredicate> iterableWithAdditionalElement;
        Set set2 = this.mResPred2InputPreds.getImage((Object)iPredicate);
        assert (this.mCannibalize || set2 != null);
        if (set2 == null) {
            set2 = Collections.emptySet();
        }
        Iterable<Object> iterable = this.mInputInterpolantAutomaton.getStates().contains(this.mIaTrueState) ? new IterableWithAdditionalElement<IPredicate>(set2, this.mIaTrueState) : set2;
        if (iPredicate2 == null) {
            iterableWithAdditionalElement = null;
        } else {
            Set set3 = this.mResPred2InputPreds.getImage((Object)iPredicate2);
            iterableWithAdditionalElement = new IterableWithAdditionalElement<IPredicate>(set3, this.mIaTrueState);
        }
        for (IPredicate iPredicate3 : iterable) {
            if (iPredicate2 == null) {
                set.addAll(successorComputationHelper.getSuccsInterpolantAutomaton(iPredicate3, null, LETTER));
                continue;
            }
            for (IPredicate iPredicate4 : iterableWithAdditionalElement) {
                set.addAll(successorComputationHelper.getSuccsInterpolantAutomaton(iPredicate3, iPredicate4, LETTER));
            }
        }
    }

    private IPredicate getOrConstructPredicate(ImmutableSet<IPredicate> immutableSet) {
        IPredicate iPredicate;
        if (immutableSet.isEmpty()) {
            iPredicate = this.mIaTrueState;
        } else if (immutableSet.size() == 1) {
            iPredicate = (IPredicate)immutableSet.iterator().next();
            if (!this.mAlreadyConstructedAutomaton.contains((Object)iPredicate)) {
                this.mAlreadyConstructedAutomaton.addState(false, false, (Object)iPredicate);
            }
        } else {
            IPredicate iPredicate2 = this.mInputPreds2ResultPreds.get(immutableSet);
            if (iPredicate2 == null) {
                iPredicate2 = this.mPredicateUnifier.getOrConstructPredicateForConjunction(immutableSet);
                this.mInputPreds2ResultPreds.put(immutableSet, iPredicate2);
                for (IPredicate iPredicate3 : immutableSet) {
                    assert (this.mAlreadyConstructedAutomaton.contains((Object)iPredicate3) || this.mInputInterpolantAutomaton.getStates().contains(iPredicate3)) : "unknown state " + String.valueOf(iPredicate3);
                    if (!this.mNonTrivialPredicates.contains(iPredicate3)) continue;
                    this.mResPred2InputPreds.addPair((Object)iPredicate2, (Object)iPredicate3);
                }
                if (!this.mAlreadyConstructedAutomaton.contains((Object)iPredicate2)) {
                    this.processResPredInputPredsMapping(iPredicate2);
                    this.mAlreadyConstructedAutomaton.addState(false, false, (Object)iPredicate2);
                }
            }
            iPredicate = iPredicate2;
        }
        return iPredicate;
    }

    @Override
    protected void constructSuccessorsAndTransitions(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper, ImmutableSet<IPredicate> immutableSet) {
        IPredicate iPredicate3 = this.getOrConstructPredicate(immutableSet);
        successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, iPredicate3);
        successorComputationHelper.reportSuccsComputed(iPredicate, iPredicate2, LETTER);
    }
}

