/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.TimedIndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticConditionEliminator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceConditionGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SemanticIndependenceRelation<L extends IAction>
implements IIndependenceRelation<IPredicate, L> {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private static final boolean ENABLE_AUXVAR_ELIMINATION = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final boolean mConditional;
    private final boolean mSymmetric;
    private final IndependenceConditions mSymbolicIndependenceMode;
    private final BasicPredicateFactory mPredicateFactory;
    private final SemanticIndependenceConditionGenerator mIndependenceGenerator;
    private final Statistics mStatistics = new Statistics();

    public SemanticIndependenceRelation(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, boolean bl2) {
        this(iUltimateServiceProvider, managedScript, bl, bl2, IndependenceConditions.NONE, null, null);
    }

    public SemanticIndependenceRelation(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, boolean bl2, IndependenceConditions independenceConditions, BasicPredicateFactory basicPredicateFactory, SemanticIndependenceConditionGenerator semanticIndependenceConditionGenerator) {
        this.mServices = iUltimateServiceProvider;
        this.mManagedScript = managedScript;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mConditional = bl;
        this.mSymmetric = bl2;
        this.mSymbolicIndependenceMode = independenceConditions;
        this.mPredicateFactory = independenceConditions.requiresPredicateFactory() ? Objects.requireNonNull(basicPredicateFactory) : null;
        this.mIndependenceGenerator = independenceConditions.requiresConditionGenerator() ? Objects.requireNonNull(semanticIndependenceConditionGenerator) : null;
    }

    public boolean isSymmetric() {
        return this.mSymmetric;
    }

    public boolean isConditional() {
        return this.mConditional;
    }

    public IIndependenceRelation.Dependence isIndependent(IPredicate iPredicate, L l, L l2) {
        this.mStatistics.startQuery();
        IIndependenceRelation.Dependence dependence = SemanticIndependenceRelation.toDependence(this.contains(iPredicate, l, l2));
        this.mStatistics.reportQuery(dependence, this.mConditional && iPredicate != null);
        return dependence;
    }

    public ISymbolicIndependenceRelation<L, IPredicate> getSymbolicRelation() {
        return switch (this.mSymbolicIndependenceMode) {
            case IndependenceConditions.NONE -> null;
            case IndependenceConditions.SUFFICIENT -> new ConditionGeneratorIndependence(this.mIndependenceGenerator, false);
            case IndependenceConditions.SUFFICIENT_WITH_CONTEXT -> new ConditionGeneratorIndependence(this.mIndependenceGenerator, true);
            case IndependenceConditions.NECESSARY_AND_SUFFICIENT -> new SymbolicSemanticIndependence(this.mPredicateFactory);
            default -> throw new MatchException(null, null);
        };
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private Script.LBool contains(IPredicate iPredicate, L l, L l2) {
        IPredicate iPredicate2;
        Object object = iPredicate2 = this.mConditional ? iPredicate : null;
        if (iPredicate2 instanceof IMLPredicate) {
            this.mLogger.warn((Object)"Predicates with locations should not be used for independence.");
        }
        Pair<UnmodifiableTransFormula, UnmodifiableTransFormula> pair = this.buildCompositions(l, l2);
        UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)pair.getFirst();
        UnmodifiableTransFormula unmodifiableTransFormula2 = (UnmodifiableTransFormula)pair.getSecond();
        Script.LBool lBool = this.checkInclusionWithGuard(iPredicate2, unmodifiableTransFormula, unmodifiableTransFormula2);
        if (!this.mSymmetric) {
            return lBool;
        }
        return SemanticIndependenceRelation.and(lBool, () -> this.checkInclusionWithGuard(iPredicate2, unmodifiableTransFormula2, unmodifiableTransFormula));
    }

    private final Script.LBool checkInclusionWithGuard(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        UnmodifiableTransFormula unmodifiableTransFormula3;
        if (iPredicate != null && SmtUtils.isFalseLiteral((Term)iPredicate.getFormula())) {
            return Script.LBool.UNSAT;
        }
        if (this.mManagedScript.isLocked()) {
            this.mLogger.warn((Object)"Requesting ManagedScript unlock before implication check");
            boolean bl = this.mManagedScript.requestLockRelease();
            if (!bl) {
                this.mLogger.warn((Object)"Failed to unlock ManagedScript. Unable to check independence, returning UNKNOWN.");
                return Script.LBool.UNKNOWN;
            }
        }
        if (iPredicate == null) {
            unmodifiableTransFormula3 = unmodifiableTransFormula;
        } else {
            UnmodifiableTransFormula unmodifiableTransFormula4 = TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate, (ManagedScript)this.mManagedScript);
            unmodifiableTransFormula3 = this.compose(unmodifiableTransFormula4, unmodifiableTransFormula, false);
        }
        return TransFormulaUtils.checkImplication((UnmodifiableTransFormula)unmodifiableTransFormula3, (UnmodifiableTransFormula)unmodifiableTransFormula2, (ManagedScript)this.mManagedScript);
    }

    private Pair<UnmodifiableTransFormula, UnmodifiableTransFormula> buildCompositions(L l, L l2) {
        UnmodifiableTransFormula unmodifiableTransFormula = l.getTransformula();
        UnmodifiableTransFormula unmodifiableTransFormula2 = l2.getTransformula();
        UnmodifiableTransFormula unmodifiableTransFormula3 = this.compose(unmodifiableTransFormula, unmodifiableTransFormula2, false);
        UnmodifiableTransFormula unmodifiableTransFormula4 = this.compose(unmodifiableTransFormula2, unmodifiableTransFormula, false);
        return new Pair((Object)unmodifiableTransFormula3, (Object)unmodifiableTransFormula4);
    }

    private final UnmodifiableTransFormula compose(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, boolean bl) {
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)bl, (boolean)false, (SmtUtils.SimplificationTechnique)SIMPLIFICATION_TECHNIQUE, Arrays.asList(unmodifiableTransFormula, unmodifiableTransFormula2));
    }

    private static Script.LBool and(Script.LBool lBool, Supplier<Script.LBool> supplier) {
        if (lBool == Script.LBool.SAT) {
            return Script.LBool.SAT;
        }
        Script.LBool lBool2 = supplier.get();
        if (lBool2 == Script.LBool.SAT) {
            return Script.LBool.SAT;
        }
        if (lBool == Script.LBool.UNSAT && lBool2 == Script.LBool.UNSAT) {
            return Script.LBool.UNSAT;
        }
        return Script.LBool.UNKNOWN;
    }

    private static IIndependenceRelation.Dependence toDependence(Script.LBool lBool) {
        return switch (lBool) {
            case Script.LBool.UNSAT -> IIndependenceRelation.Dependence.INDEPENDENT;
            case Script.LBool.SAT -> IIndependenceRelation.Dependence.DEPENDENT;
            case Script.LBool.UNKNOWN -> IIndependenceRelation.Dependence.UNKNOWN;
            default -> throw new MatchException(null, null);
        };
    }

    public class ConditionGeneratorIndependence
    implements ISymbolicIndependenceRelation<L, IPredicate> {
        private static final boolean QUANTIFY_IRRELEVANT_CONTEXT_VARS = true;
        private final SemanticIndependenceConditionGenerator mGenerator;
        private final boolean mIsConditional;

        public ConditionGeneratorIndependence(SemanticIndependenceConditionGenerator semanticIndependenceConditionGenerator, boolean bl) {
            this.mGenerator = semanticIndependenceConditionGenerator;
            this.mIsConditional = bl;
            assert (this.mGenerator.isSymmetric() == SemanticIndependenceRelation.this.mSymmetric) : "Symmetry of relation and generator does not match";
        }

        public IPredicate getCommutativityCondition(IPredicate iPredicate, L l, L l2) {
            SemanticIndependenceRelation.this.mStatistics.reportSymbolicConditionComputation();
            if (this.mIsConditional && iPredicate != null) {
                IPredicate iPredicate2 = this.mGenerator.generateCondition(iPredicate, l.getTransformula(), l2.getTransformula());
                if (iPredicate2 == null) {
                    return null;
                }
                Term term = SmtUtils.and((Script)SemanticIndependenceRelation.this.mManagedScript.getScript(), (Term[])new Term[]{iPredicate.getFormula(), iPredicate2.getFormula()});
                List list = iPredicate.getVars().stream().filter(iProgramVar -> !SemanticConditionEliminator.isRelevant(iPredicate, l) && !SemanticConditionEliminator.isRelevant(iPredicate, l2)).map(IProgramVar::getTermVariable).collect(Collectors.toList());
                Term term2 = SmtUtils.quantifier((Script)SemanticIndependenceRelation.this.mManagedScript.getScript(), (int)0, list, (Term)term);
                return SemanticIndependenceRelation.this.mPredicateFactory.newPredicate(term2);
            }
            return this.mGenerator.generateCondition(l.getTransformula(), l2.getTransformula());
        }

        public boolean isSymmetric() {
            return SemanticIndependenceRelation.this.mSymmetric;
        }

        public boolean isConditional() {
            return this.mIsConditional;
        }
    }

    public static enum IndependenceConditions {
        NONE(false, false),
        SUFFICIENT(false, true),
        SUFFICIENT_WITH_CONTEXT(true, true),
        NECESSARY_AND_SUFFICIENT(true, false);

        private final boolean mRequiresPredicateFactory;
        private final boolean mRequiresConditionGenerator;

        private IndependenceConditions(boolean bl, boolean bl2) {
            this.mRequiresPredicateFactory = bl;
            this.mRequiresConditionGenerator = bl2;
        }

        public boolean requiresPredicateFactory() {
            return this.mRequiresPredicateFactory;
        }

        public boolean requiresConditionGenerator() {
            return this.mRequiresConditionGenerator;
        }
    }

    private static final class Statistics
    extends TimedIndependenceStatisticsDataProvider {
        private static final String SYMBOLIC_CONDITION_COMPUTATIONS = "Symbolic Condition Computations";
        private static final String UNKNOWN_SYMBOLIC_CONDITIONS = "Symbolic Conditions with UNKNOWN Satisfiability";
        private int mSymbolicConditionComputations;
        private int mUnknownSymbolicConditions;

        private Statistics() {
            super(SemanticIndependenceRelation.class);
            this.declare(SYMBOLIC_CONDITION_COMPUTATIONS, () -> this.mSymbolicConditionComputations, KeyType.COUNTER);
            this.declare(UNKNOWN_SYMBOLIC_CONDITIONS, () -> this.mUnknownSymbolicConditions, KeyType.COUNTER);
        }

        private void reportSymbolicConditionComputation() {
            ++this.mSymbolicConditionComputations;
        }

        private void reportUnknownSymbolicCondition() {
            ++this.mUnknownSymbolicConditions;
        }
    }

    public class SymbolicSemanticIndependence
    implements ISymbolicIndependenceRelation<L, IPredicate> {
        private final BasicPredicateFactory mFactory;

        public SymbolicSemanticIndependence(BasicPredicateFactory basicPredicateFactory) {
            this.mFactory = basicPredicateFactory;
        }

        public IPredicate getCommutativityCondition(IPredicate iPredicate, L l, L l2) {
            Term term;
            SemanticIndependenceRelation.this.mStatistics.reportSymbolicConditionComputation();
            Pair<UnmodifiableTransFormula, UnmodifiableTransFormula> pair = SemanticIndependenceRelation.this.buildCompositions(l, l2);
            UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)pair.getFirst();
            UnmodifiableTransFormula unmodifiableTransFormula2 = (UnmodifiableTransFormula)pair.getSecond();
            Term term2 = this.computeInclusionTerm(unmodifiableTransFormula, unmodifiableTransFormula2);
            if (!SemanticIndependenceRelation.this.mSymmetric || SmtUtils.isFalseLiteral((Term)term2)) {
                term = term2;
            } else {
                Term term3 = this.computeInclusionTerm(unmodifiableTransFormula2, unmodifiableTransFormula);
                term = SmtUtils.and((Script)SemanticIndependenceRelation.this.mManagedScript.getScript(), (Term[])new Term[]{term2, term3});
            }
            if (SmtUtils.isFalseLiteral((Term)term)) {
                return null;
            }
            return this.mFactory.newPredicate(term);
        }

        private Term computeInclusionTerm(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
            Term term;
            UnmodifiableTransFormula unmodifiableTransFormula3 = TransFormulaUtils.intersect((ManagedScript)SemanticIndependenceRelation.this.mManagedScript, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{unmodifiableTransFormula, TransFormulaUtils.negate((UnmodifiableTransFormula)unmodifiableTransFormula2, (ManagedScript)SemanticIndependenceRelation.this.mManagedScript, (IUltimateServiceProvider)SemanticIndependenceRelation.this.mServices)});
            Term term2 = TransFormulaUtils.computeGuardTerm((IUltimateServiceProvider)SemanticIndependenceRelation.this.mServices, (ManagedScript)SemanticIndependenceRelation.this.mManagedScript, (UnmodifiableTransFormula)unmodifiableTransFormula3, (boolean)true);
            Term term3 = SmtUtils.not((Script)SemanticIndependenceRelation.this.mManagedScript.getScript(), (Term)term2);
            SemanticIndependenceRelation.this.mManagedScript.lock((Object)this);
            Script.LBool lBool = SmtUtils.checkSatTerm((Script)SemanticIndependenceRelation.this.mManagedScript.getScript(), (Term)term3);
            SemanticIndependenceRelation.this.mManagedScript.unlock((Object)this);
            switch (lBool) {
                case UNKNOWN: {
                    SemanticIndependenceRelation.this.mStatistics.reportUnknownSymbolicCondition();
                }
                case SAT: {
                    term = term3;
                    break;
                }
                case UNSAT: {
                    term = SemanticIndependenceRelation.this.mManagedScript.getScript().term("false", new Term[0]);
                    break;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
            return term;
        }

        public boolean isSymmetric() {
            return SemanticIndependenceRelation.this.mSymmetric;
        }

        public boolean isConditional() {
            return false;
        }
    }
}

