/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Concatenation;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.EmptySet;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Epsilon;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Literal;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Union;

public abstract class Regex {
    public static <L> IRegex<L> union(IRegex<L> iRegex, IRegex<L> iRegex2) {
        return new Union<L>(iRegex, iRegex2);
    }

    public static <L> IRegex<L> concat(IRegex<L> iRegex, IRegex<L> iRegex2) {
        return new Concatenation<L>(iRegex, iRegex2);
    }

    public static <L> IRegex<L> star(IRegex<L> iRegex) {
        return new Star<L>(iRegex);
    }

    public static <L> IRegex<L> literal(L l) {
        return new Literal<L>(l);
    }

    public static final <L> Epsilon<L> epsilon() {
        return Epsilon.INSTANCE;
    }

    public static final <L> EmptySet<L> emptySet() {
        return EmptySet.INSTANCE;
    }

    public static <L> IRegex<L> simplifiedUnion(IRegex<L> iRegex, IRegex<L> iRegex2) {
        if (iRegex instanceof EmptySet) {
            return iRegex2;
        }
        if (iRegex2 instanceof EmptySet) {
            return iRegex;
        }
        if (iRegex.equals(iRegex2)) {
            return iRegex;
        }
        return Regex.union(iRegex, iRegex2);
    }

    public static <L> IRegex<L> simplifiedConcatenation(IRegex<L> iRegex, IRegex<L> iRegex2) {
        if (iRegex instanceof EmptySet || iRegex2 instanceof EmptySet) {
            return Regex.emptySet();
        }
        if (iRegex instanceof Epsilon) {
            return iRegex2;
        }
        if (iRegex2 instanceof Epsilon) {
            return iRegex;
        }
        return Regex.concat(iRegex, iRegex2);
    }

    public static <L> IRegex<L> simplifiedStar(IRegex<L> iRegex) {
        if (iRegex instanceof EmptySet || iRegex instanceof Epsilon) {
            return Regex.epsilon();
        }
        return Regex.star(iRegex);
    }
}

