/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.util;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public class LoggerOutputStream
extends OutputStream {
    private final Consumer<String> mLinePrinter;
    private static final String LINE_BREAK = CoreUtil.getPlatformLineSeparator();
    private StringBuilder mLineBuffer;

    public LoggerOutputStream(Consumer<String> consumer) {
        this.mLinePrinter = consumer;
        this.mLineBuffer = new StringBuilder();
    }

    @Override
    public void write(int n) {
        this.mLineBuffer.append(new String(new byte[]{(byte)(n & 0xFF)}, Charset.defaultCharset()));
        int n2 = this.mLineBuffer.length();
        int n3 = n2 - LINE_BREAK.length();
        if (n3 <= 0) {
            return;
        }
        if (LINE_BREAK.equals(this.mLineBuffer.substring(n3))) {
            this.mLineBuffer.delete(n3, n2);
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.mLinePrinter.accept(this.mLineBuffer.toString());
        this.mLineBuffer = new StringBuilder();
    }
}

