/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.function.Predicate;

public class AffineTermTransformer
extends TermTransformer {
    private final Script mScript;
    private final Predicate<Term> mIsAffineVariable = term -> term instanceof TermVariable || term instanceof ApplicationTerm;

    public AffineTermTransformer(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (!AffineTermTransformer.hasSupportedSort(term)) {
            this.inputIsNotAffine();
            return;
        }
        Rational rational = SmtUtils.tryToConvertToLiteral(term);
        if (rational != null) {
            AffineTerm affineTerm = AffineTerm.constructConstant(term.getSort(), rational);
            this.setResult(affineTerm);
            return;
        }
        if (AffineTermTransformer.isAffineFunction(term)) {
            super.convert(term);
            return;
        }
        if (this.mIsAffineVariable.test(term)) {
            AffineTerm affineTerm = AffineTerm.constructVariable(term);
            this.setResult(affineTerm);
            return;
        }
        this.inputIsNotAffine();
    }

    private void inputIsNotAffine() {
        this.setResult(new AffineTerm());
    }

    private static boolean hasSupportedSort(Term term) {
        return SmtSortUtils.isNumericSort(term.getSort()) || SmtSortUtils.isBitvecSort(term.getSort());
    }

    private static boolean isAffineFunction(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            return AffineTermTransformer.isAffineFunctionSymbol(applicationTerm.getFunction().getName());
        }
        return false;
    }

    private static boolean isAffineFunctionSymbol(String string) {
        return string.equals("+") || string.equals("-") || string.equals("*") || string.equals("/") || string.equals("bvadd") || string.equals("bvsub") || string.equals("bvmul");
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        assert (AffineTermTransformer.isAffineFunctionSymbol(applicationTerm.getFunction().getName())) : "We only descended for affine functions";
        AffineTerm[] affineTermArray = AffineTermTransformer.castAndCheckForNonAffineArguments(termArray);
        if (affineTermArray == null) {
            throw new AssertionError();
        }
        String string = applicationTerm.getFunction().getName();
        if (string.equals("*") || string.equals("bvmul")) {
            Sort sort = applicationTerm.getSort();
            AffineTerm affineTerm = AffineTermTransformer.tryToMultiply(sort, affineTermArray);
            if (affineTerm == null) {
                this.setResult(AffineTerm.constructVariable((Term)applicationTerm));
                return;
            }
            this.setResult(affineTerm);
        } else if (string.equals("+") || string.equals("bvadd")) {
            AffineTerm affineTerm = AffineTermTransformer.add(affineTermArray);
            this.setResult(affineTerm);
        } else if (string.equals("-") || string.equals("bvsub")) {
            AffineTerm affineTerm = affineTermArray.length == 1 ? AffineTermTransformer.negate(affineTermArray[0]) : AffineTermTransformer.subtract(affineTermArray);
            this.setResult(affineTerm);
        } else if (string.equals("/")) {
            Sort sort = applicationTerm.getSort();
            AffineTerm affineTerm = AffineTermTransformer.divide(sort, affineTermArray);
            if (affineTerm == null) {
                this.setResult(AffineTerm.constructVariable((Term)applicationTerm));
                return;
            }
            this.setResult(affineTerm);
        } else {
            throw new UnsupportedOperationException("unsupported symbol " + string);
        }
    }

    private static AffineTerm[] castAndCheckForNonAffineArguments(Term[] termArray) {
        AffineTerm[] affineTermArray = new AffineTerm[termArray.length];
        int n = 0;
        while (n < affineTermArray.length) {
            if (termArray[n] instanceof AffineTerm) {
                affineTermArray[n] = (AffineTerm)termArray[n];
                if (affineTermArray[n].isErrorTerm()) {
                    return null;
                }
            } else {
                throw new AssertionError();
            }
            ++n;
        }
        return affineTermArray;
    }

    private static AffineTerm add(AffineTerm[] affineTermArray) {
        AffineTerm affineTerm = AffineTerm.sum(affineTermArray);
        return affineTerm;
    }

    private static AffineTerm negate(AffineTerm affineTerm) {
        return AffineTerm.mul(affineTerm, Rational.MONE);
    }

    private static AffineTerm subtract(AffineTerm[] affineTermArray) {
        assert (affineTermArray.length > 1);
        AffineTerm[] affineTermArray2 = new AffineTerm[affineTermArray.length];
        affineTermArray2[0] = affineTermArray[0];
        int n = 1;
        while (n < affineTermArray2.length) {
            affineTermArray2[n] = AffineTerm.mul(affineTermArray[n], Rational.MONE);
            ++n;
        }
        return AffineTermTransformer.add(affineTermArray2);
    }

    private static AffineTerm tryToMultiply(Sort sort, AffineTerm[] affineTermArray) {
        AffineTerm affineTerm = null;
        Rational rational = Rational.ONE;
        AffineTerm[] affineTermArray2 = affineTermArray;
        int n = affineTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            AffineTerm affineTerm2 = affineTermArray2[n2];
            if (affineTerm2.isConstant()) {
                rational = rational.mul(affineTerm2.getConstant());
            } else if (affineTerm == null) {
                affineTerm = affineTerm2;
            } else {
                return null;
            }
            ++n2;
        }
        AffineTerm affineTerm3 = affineTerm == null ? AffineTerm.constructConstant(sort, rational) : AffineTerm.mul(affineTerm, rational);
        return affineTerm3;
    }

    private static AffineTerm divide(Sort sort, AffineTerm[] affineTermArray) {
        Rational rational;
        AffineTerm affineTerm;
        assert (SmtSortUtils.isRealSort(sort));
        if (affineTermArray[0].isConstant()) {
            affineTerm = null;
            rational = affineTermArray[0].getConstant();
        } else {
            affineTerm = affineTermArray[0];
            rational = Rational.ONE;
        }
        int n = 1;
        while (n < affineTermArray.length) {
            if (!affineTermArray[n].isConstant() || affineTermArray[n].isZero()) {
                return null;
            }
            rational = rational.mul(affineTermArray[n].getConstant().inverse());
            ++n;
        }
        AffineTerm affineTerm2 = affineTerm == null ? AffineTerm.constructConstant(sort, rational) : AffineTerm.mul(affineTerm, rational);
        return affineTerm2;
    }

    private static AffineTerm convertConstantNumericTerm(ConstantTerm constantTerm) {
        Rational rational = SmtUtils.toRational(constantTerm);
        AffineTerm affineTerm = AffineTerm.constructConstant(constantTerm.getSort(), rational);
        return affineTerm;
    }

    private static AffineTerm convertToReal(ApplicationTerm applicationTerm) {
        AffineTerm affineTerm;
        if (!applicationTerm.getFunction().getName().equals("to_real")) {
            throw new IllegalArgumentException("no to_real term");
        }
        Term[] termArray = applicationTerm.getParameters();
        if (termArray.length > 1) {
            throw new UnsupportedOperationException();
        }
        Term term = termArray[0];
        if (term instanceof ConstantTerm) {
            AffineTerm affineTerm2;
            ConstantTerm constantTerm = (ConstantTerm)term;
            if (!SmtSortUtils.isIntSort(constantTerm.getSort())) {
                throw new UnsupportedOperationException();
            }
            AffineTerm affineTerm3 = AffineTermTransformer.convertConstantNumericTerm(constantTerm);
            affineTerm = affineTerm2 = AffineTerm.constructConstant(applicationTerm.getSort(), affineTerm3.getConstant());
        } else {
            affineTerm = AffineTerm.constructVariable((Term)applicationTerm);
        }
        return affineTerm;
    }
}

