/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DualJunctionQuantifierElimination {
    protected final Script mScript;
    protected final ManagedScript mMgdScript;
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;

    public DualJunctionQuantifierElimination(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
    }

    public abstract String getName();

    public abstract String getAcronym();

    public abstract EliminationResult tryToEliminate(EliminationTask var1);

    public static class EliminationResult
    implements Comparable<EliminationResult> {
        private final EliminationTask mEliminationTask;
        private final Set<TermVariable> mNewEliminatees;
        private final int mNumberOfEliminatees;
        private final long mTreeSize;

        public EliminationResult(EliminationTask eliminationTask, Set<TermVariable> set) {
            this.mEliminationTask = eliminationTask;
            this.mNewEliminatees = Arrays.stream(eliminationTask.getTerm().getFreeVars()).filter(set::contains).collect(Collectors.toSet());
            this.mNumberOfEliminatees = this.mEliminationTask.getEliminatees().size() + this.mNewEliminatees.size();
            this.mTreeSize = new DAGSize().treesize(this.mEliminationTask.getTerm());
        }

        public EliminationTask getEliminationTask() {
            return this.mEliminationTask;
        }

        public Set<TermVariable> getNewEliminatees() {
            return this.mNewEliminatees;
        }

        public EliminationTask integrateNewEliminatees() {
            return this.mEliminationTask.integrateNewEliminatees(this.mNewEliminatees);
        }

        @Override
        public int compareTo(EliminationResult eliminationResult) {
            int n = Integer.compare(this.mNumberOfEliminatees, eliminationResult.mNumberOfEliminatees);
            if (n != 0) {
                return n;
            }
            int n2 = Double.compare(this.mTreeSize, eliminationResult.mTreeSize);
            if (n2 != 0) {
                return n2;
            }
            return this.mEliminationTask.getTerm().toString().compareTo(eliminationResult.mEliminationTask.getTerm().toString());
        }
    }
}

