/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic;

import java.math.BigDecimal;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class LiteralCollection {
    private final List<BigDecimal> mSortedNumbersSet;

    public LiteralCollection(Set<BigDecimal> set) {
        this.mSortedNumbersSet = set.stream().sorted().collect(Collectors.toList());
    }

    public BigDecimal getNextRealPositive(BigDecimal bigDecimal) {
        return this.getNextNumberPositive(bigDecimal);
    }

    public BigDecimal getNextRealNegative(BigDecimal bigDecimal) {
        return this.getNextNumberNegative(bigDecimal);
    }

    private BigDecimal getNextNumberPositive(BigDecimal bigDecimal) {
        ListIterator<BigDecimal> listIterator = this.mSortedNumbersSet.listIterator();
        while (listIterator.hasNext()) {
            BigDecimal bigDecimal2 = listIterator.next();
            if (bigDecimal2.compareTo(bigDecimal) <= 0) continue;
            return bigDecimal2;
        }
        return null;
    }

    private BigDecimal getNextNumberNegative(BigDecimal bigDecimal) {
        ListIterator<BigDecimal> listIterator = this.mSortedNumbersSet.listIterator(this.mSortedNumbersSet.size());
        while (listIterator.hasPrevious()) {
            BigDecimal bigDecimal2 = listIterator.previous();
            if (bigDecimal2.compareTo(bigDecimal) >= 0) continue;
            return bigDecimal2;
        }
        return null;
    }

    public String toString() {
        if (this.mSortedNumbersSet.isEmpty()) {
            return "Empty LiteralCollection";
        }
        return "LiteralCollection " + String.join((CharSequence)"; ", this.mSortedNumbersSet.stream().map(bigDecimal -> bigDecimal.toPlainString()).collect(Collectors.toList()));
    }
}

