/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctMatrix;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.TreeSet;

public class OctLiteralWideningOperator
implements IAbstractStateBinaryOperator<OctDomainState>,
OctMatrix.WideningStepSupplier {
    private final TreeSet<OctValue> wideningSteps = new TreeSet();

    public OctLiteralWideningOperator(Collection<BigDecimal> collection) {
        for (BigDecimal bigDecimal : collection) {
            BigDecimal bigDecimal2 = bigDecimal.add(bigDecimal);
            this.wideningSteps.add(new OctValue(bigDecimal));
            this.wideningSteps.add(new OctValue(bigDecimal2));
            this.wideningSteps.add(new OctValue(bigDecimal.negate()));
            this.wideningSteps.add(new OctValue(bigDecimal2.negate()));
        }
    }

    @Override
    public OctValue nextWideningStep(OctValue octValue) {
        OctValue octValue2 = this.wideningSteps.ceiling(octValue);
        return octValue2 == null ? OctValue.INFINITY : octValue2;
    }

    public OctDomainState apply(OctDomainState octDomainState, OctDomainState octDomainState2) {
        return octDomainState.widen(octDomainState2, (octMatrix, octMatrix2) -> octMatrix.widenStepwise((OctMatrix)octMatrix2, this));
    }
}

