/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiIndexArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SimultaneousUpdate {
    private final Map<IProgramVar, Term> mDeterministicAssignment;
    private final Map<IProgramVar, MultiDimensionalNestedStore> mDeterministicArrayWrites;
    private final Map<IProgramVar, NondetArrayWriteConstraints> mNondetArrayWriteConstraints;
    private final Set<IProgramVar> mHavocedVars;
    private final Set<IProgramVar> mReadonlyVars;

    public SimultaneousUpdate(Map<IProgramVar, Term> map, Map<IProgramVar, MultiDimensionalNestedStore> map2, Map<IProgramVar, NondetArrayWriteConstraints> map3, Set<IProgramVar> set, Set<IProgramVar> set2) {
        this.mDeterministicAssignment = map;
        this.mDeterministicArrayWrites = map2;
        this.mNondetArrayWriteConstraints = map3;
        this.mHavocedVars = set;
        this.mReadonlyVars = set2;
    }

    public static SimultaneousUpdate fromTransFormula(IUltimateServiceProvider iUltimateServiceProvider, TransFormula transFormula, ManagedScript managedScript) throws SimultaneousUpdateException {
        Triple<Term, NondetArrayWriteConstraints, Set<ExtractionImpediments>> triple;
        TermVariable termVariable;
        Term term;
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        HashSet<IProgramVar> hashSet3 = new HashSet<IProgramVar>();
        Set<IProgramVar> set = TransFormula.collectAllProgramVars(transFormula);
        for (IProgramVar object2 : set) {
            if (transFormula.getInVars().get(object2) == transFormula.getOutVars().get(object2)) {
                hashSet3.add(object2);
                continue;
            }
            if (transFormula.isHavocedOut(object2)) {
                hashSet.add(object2);
                continue;
            }
            hashSet2.add(object2);
        }
        Map<TermVariable, IProgramVar> map = TransFormulaUtils.constructReverseMapping(transFormula.getInVars());
        Map<TermVariable, IProgramVar> map2 = TransFormulaUtils.constructReverseMapping(transFormula.getOutVars());
        Term[] termArray = SmtUtils.getConjuncts((Term)transFormula.getFormula());
        HashRelation hashRelation = new HashRelation();
        Object object2 = termArray;
        int hashMap2 = termArray.length;
        int hashMap = 0;
        while (hashMap < hashMap2) {
            term = object2[hashMap];
            termVariable = term.getFreeVars();
            int n = ((TermVariable[])termVariable).length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable2 = termVariable[n2];
                triple = (Triple<Term, NondetArrayWriteConstraints, Set<ExtractionImpediments>>)map2.get(termVariable2);
                if (triple != null) {
                    hashRelation.addPair((Object)triple, (Object)term);
                }
                ++n2;
            }
            ++hashMap;
        }
        term = new HashMap();
        HashMap<IProgramVar, MultiDimensionalNestedStore> hashMap3 = new HashMap<IProgramVar, MultiDimensionalNestedStore>();
        HashMap<IProgramVar, NondetArrayWriteConstraints> hashMap4 = new HashMap<IProgramVar, NondetArrayWriteConstraints>();
        for (Object object2 : hashSet2) {
            Set set2 = hashRelation.getImage(object2);
            if (set2.isEmpty()) {
                if (transFormula.getInVars().get(object2) != transFormula.getOutVars().get(object2)) {
                    throw new AssertionError((Object)"in and out have to be similar");
                }
                continue;
            }
            Term term2 = SimultaneousUpdate.isAssignedWithBooleanConstant(managedScript, transFormula, (IProgramVar)object2, set2);
            if (term2 != null) {
                term.put(object2, term2);
                continue;
            }
            termVariable = transFormula.getOutVars().get(object2);
            triple = SimultaneousUpdate.extractUpdateRhs(iUltimateServiceProvider, termVariable, transFormula, map.keySet(), managedScript);
            assert (triple.getFirst() == null ^ triple.getThird() == null);
            if (triple.getThird() != null) {
                throw new SimultaneousUpdateException(String.format(" Reasons: %s. Size: %s. Cannot find an inVar-based term that is equivalent to %s's outVar %s in TransFormula %s.", triple.getThird(), new DAGSize().treesize(transFormula.getFormula()), object2, termVariable, transFormula));
            }
            Term term3 = (Term)triple.getFirst();
            if (SmtSortUtils.isArraySort((Sort)object2.getSort())) {
                if (term3 instanceof TermVariable) {
                    term.put(object2, term3);
                    continue;
                }
                MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of((Term)term3);
                if (!object2.getTermVariable().equals(multiDimensionalNestedStore.getArray())) {
                    throw new UnsupportedOperationException("Yet, we support only self-updates.");
                }
                hashMap3.put((IProgramVar)object2, multiDimensionalNestedStore);
                hashMap4.put((IProgramVar)object2, (NondetArrayWriteConstraints)triple.getSecond());
                continue;
            }
            term.put(object2, term3);
        }
        object2 = new HashSet();
        for (IProgramVar iProgramVar : hashSet3) {
            if (!SimultaneousUpdate.isReadInSomeAssignment(iProgramVar, (Map<IProgramVar, Term>)term, hashMap3)) continue;
            object2.add(iProgramVar);
        }
        return new SimultaneousUpdate((Map<IProgramVar, Term>)term, hashMap3, hashMap4, hashSet, (Set<IProgramVar>)object2);
    }

    private static boolean isReadInSomeAssignment(IProgramVar iProgramVar, Map<IProgramVar, Term> map, Map<IProgramVar, MultiDimensionalNestedStore> map2) {
        for (Map.Entry<IProgramVar, Term> entry : map.entrySet()) {
            if (!Arrays.asList(entry.getValue().getFreeVars()).contains(iProgramVar.getTermVariable())) continue;
            return true;
        }
        for (Map.Entry<IProgramVar, Term> entry : map2.entrySet()) {
            MultiDimensionalNestedStore multiDimensionalNestedStore = (MultiDimensionalNestedStore)entry.getValue();
            for (ArrayIndex arrayIndex : multiDimensionalNestedStore.getIndices()) {
                if (!arrayIndex.getFreeVars().contains(iProgramVar.getTermVariable())) continue;
                return true;
            }
            for (ArrayIndex arrayIndex : multiDimensionalNestedStore.getValues()) {
                if (!Arrays.asList(arrayIndex.getFreeVars()).contains(iProgramVar.getTermVariable())) continue;
                return true;
            }
        }
        return false;
    }

    private static Term tryToExtractAssigedTerm(Script script, Term term, TermVariable termVariable, Set<TermVariable> set) {
        Term[] termArray;
        Term[] termArray2 = termArray = SmtUtils.getConjuncts((Term)term);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            PolynomialRelation polynomialRelation;
            SolvedBinaryRelation solvedBinaryRelation;
            Term term2 = termArray2[n2];
            if (Arrays.asList(term2.getFreeVars()).contains(termVariable) && (solvedBinaryRelation = (polynomialRelation = PolynomialRelation.of((Script)script, (Term)term2)).solveForSubject(script, (Term)termVariable)) != null) {
                Term term3 = solvedBinaryRelation.getLeftHandSide();
                if (Arrays.asList(term3.getFreeVars()).stream().noneMatch(set::contains)) {
                    return term3;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Term isAssignedWithBooleanConstant(ManagedScript managedScript, TransFormula transFormula, IProgramVar iProgramVar, Set<Term> set) {
        if (SmtSortUtils.isBoolSort((Sort)iProgramVar.getTerm().getSort()) && set.size() == 1) {
            Term term = set.iterator().next();
            if (DualJunctionDer.isSimilarModuloNegation((Term)term, (Term)((Term)transFormula.getOutVars().get(iProgramVar)))) {
                return managedScript.getScript().term("true", new Term[0]);
            }
            if (DualJunctionDer.isDistinctModuloNegation((Term)term, (Term)((Term)transFormula.getOutVars().get(iProgramVar)))) {
                return managedScript.getScript().term("false", new Term[0]);
            }
        }
        return null;
    }

    private static Triple<Term, NondetArrayWriteConstraints, Set<ExtractionImpediments>> extractUpdateRhs(IUltimateServiceProvider iUltimateServiceProvider, TermVariable termVariable, TransFormula transFormula, Set<TermVariable> set, ManagedScript managedScript) {
        Set set2 = Arrays.asList(transFormula.getFormula().getFreeVars()).stream().filter(termVariable2 -> termVariable2 != termVariable && !set.contains(termVariable2)).collect(Collectors.toSet());
        Term term2 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, set2, (Term)transFormula.getFormula());
        Term term3 = PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term2);
        Term[] termArray = SmtUtils.getConjuncts((Term)term3);
        Term[] termArray2 = (Term[])Arrays.stream(termArray).filter(term -> Arrays.asList(term.getFreeVars()).contains(termVariable)).toArray(Term[]::new);
        return SimultaneousUpdate.extractUpdateRhs(termVariable, transFormula, managedScript, termArray2);
    }

    public static Triple<Term, NondetArrayWriteConstraints, Set<ExtractionImpediments>> extractUpdateRhs(TermVariable termVariable, TransFormula transFormula, ManagedScript managedScript, Term[] termArray) {
        HashSet<ExtractionImpediments> hashSet = new HashSet<ExtractionImpediments>();
        int n = 0;
        while (n < termArray.length) {
            block27: {
                Term term;
                block28: {
                    block26: {
                        term = termArray[n];
                        if (!(term instanceof QuantifiedFormula)) break block26;
                        hashSet.add(ExtractionImpediments.QUANTIFIER);
                        break block27;
                    }
                    if (!(term instanceof ApplicationTerm)) break block28;
                    ApplicationTerm applicationTerm = (ApplicationTerm)term;
                    switch (applicationTerm.getFunction().getName()) {
                        case "or": {
                            hashSet.add(ExtractionImpediments.DISJUNCTION);
                            break;
                        }
                        case "=": {
                            Pair<MultiDimensionalNestedStore, NondetArrayWriteConstraints> pair;
                            BinaryEqualityRelation binaryEqualityRelation = BinaryEqualityRelation.convert((Term)applicationTerm);
                            assert (binaryEqualityRelation != null) : "Must succeed for equality";
                            SolvedBinaryRelation solvedBinaryRelation = binaryEqualityRelation.solveForSubject(managedScript.getScript(), (Term)termVariable);
                            if (solvedBinaryRelation == null) {
                                if (SmtSortUtils.isArraySort((Sort)termVariable.getSort())) {
                                    pair = SimultaneousUpdate.checkForNondeterministicArrayUpdate(termVariable, managedScript, termArray, n);
                                    if (pair == null) {
                                        hashSet.add(ExtractionImpediments.NORHSARRAY);
                                        break;
                                    }
                                    Term term2 = TransFormulaUtils.renameInvarsToDefaultVars(transFormula, managedScript, ((MultiDimensionalNestedStore)pair.getFirst()).toTerm(managedScript.getScript()));
                                    TermVariable termVariable2 = TransFormulaUtils.constructOutvarsToDefaultvarsMap(transFormula).get(termVariable);
                                    Term term3 = Substitution.apply((ManagedScript)managedScript, Collections.singletonMap(termVariable, termVariable2), (Term)term2);
                                    return new Triple((Object)term3, (Object)((NondetArrayWriteConstraints)pair.getSecond()), null);
                                }
                                pair = PolynomialRelation.of((Script)managedScript.getScript(), (Term)applicationTerm);
                                assert (pair != null) : "Must succeed for equality";
                                solvedBinaryRelation = pair.solveForSubject(managedScript.getScript(), (Term)termVariable);
                                if (solvedBinaryRelation == null) {
                                    hashSet.add(ExtractionImpediments.NORHS);
                                    break;
                                }
                            }
                            pair = TransFormulaUtils.renameInvarsToDefaultVars(transFormula, managedScript, solvedBinaryRelation.getRightHandSide());
                            return new Triple(pair, (Object)new NondetArrayWriteConstraints(Collections.emptyMap()), null);
                        }
                        case "<": 
                        case ">": 
                        case "<=": 
                        case ">=": {
                            hashSet.add(ExtractionImpediments.INEQUALITY);
                            break;
                        }
                        default: {
                            hashSet.add(ExtractionImpediments.OTHER);
                            break;
                        }
                    }
                    break block27;
                }
                throw new UnsupportedOperationException("Unsupported term " + term.getClass().getSimpleName());
            }
            ++n;
        }
        return new Triple(null, null, hashSet);
    }

    public static Pair<MultiDimensionalNestedStore, NondetArrayWriteConstraints> checkForNondeterministicArrayUpdate(TermVariable termVariable, ManagedScript managedScript, Term[] termArray, int n) throws AssertionError {
        assert (SmtSortUtils.isArraySort((Sort)termVariable.getSort()));
        MultiIndexArrayUpdate multiIndexArrayUpdate = MultiIndexArrayUpdate.of((Script)managedScript.getScript(), (Term)termArray[n]);
        if (multiIndexArrayUpdate == null) {
            return null;
        }
        if (multiIndexArrayUpdate.getNewArray() != termVariable) {
            throw new AssertionError((Object)"Wrong array");
        }
        HashMap<Integer, Term> hashMap = new HashMap<Integer, Term>();
        HashMap<Integer, List<SolvedBinaryRelation>> hashMap2 = new HashMap<Integer, List<SolvedBinaryRelation>>();
        if (multiIndexArrayUpdate.isNondeterministicUpdate()) {
            int n2 = 0;
            while (n2 < multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().size()) {
                ArrayIndex arrayIndex = (ArrayIndex)multiIndexArrayUpdate.getMultiDimensionalNestedStore().getIndices().get(n2);
                if (arrayIndex.getFreeVars().contains(termVariable)) {
                    throw new AssertionError((Object)String.format("Unsupported: Index %s of update contains array outVar %s", arrayIndex, termVariable));
                }
                Term term = (Term)multiIndexArrayUpdate.getMultiDimensionalNestedStore().getValues().get(n2);
                if (multiIndexArrayUpdate.isNondeterministicUpdate(n2)) {
                    hashMap.put(n2, term);
                    hashMap2.computeIfAbsent(n2, ArrayList::new);
                } else if (Arrays.asList(term.getFreeVars()).contains(termVariable)) {
                    throw new AssertionError((Object)String.format("Unsupported: Value %s of deterministic update contains array outVar %s", term, termVariable));
                }
                ++n2;
            }
        }
        List list = DataStructureUtils.copyAllButOne(Arrays.asList(termArray), (int)n);
        for (ArrayIndex arrayIndex : list) {
            Pair<Integer, SolvedBinaryRelation> pair = SimultaneousUpdate.findConstraint(managedScript, hashMap, (Term)arrayIndex);
            if (pair == null) {
                throw new AssertionError((Object)String.format("Conjunct %s is not a constraint for a nondeterministic update", arrayIndex));
            }
            ((List)hashMap2.get(pair.getKey())).add((SolvedBinaryRelation)pair.getValue());
        }
        return new Pair((Object)multiIndexArrayUpdate.getMultiDimensionalNestedStore(), (Object)new NondetArrayWriteConstraints(hashMap2));
    }

    public static Pair<Integer, SolvedBinaryRelation> findConstraint(ManagedScript managedScript, Map<Integer, Term> map, Term term) {
        for (Map.Entry<Integer, Term> entry : map.entrySet()) {
            SolvedBinaryRelation solvedBinaryRelation;
            PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)managedScript.getScript(), (Term)term);
            if (polynomialRelation == null || (solvedBinaryRelation = polynomialRelation.solveForSubject(managedScript.getScript(), entry.getValue())) == null) continue;
            if (!Arrays.asList(solvedBinaryRelation.getRightHandSide().getFreeVars()).isEmpty()) {
                throw new AssertionError((Object)String.format("Nondet update at position %s. Constraint %s %s contains variable. Variables are not yet supported", entry.getKey(), solvedBinaryRelation.getRelationSymbol(), solvedBinaryRelation.getRightHandSide()));
            }
            return new Pair((Object)entry.getKey(), (Object)solvedBinaryRelation);
        }
        return null;
    }

    public Map<IProgramVar, Term> getDeterministicAssignment() {
        return this.mDeterministicAssignment;
    }

    public Map<IProgramVar, MultiDimensionalNestedStore> getDeterministicArrayWrites() {
        return this.mDeterministicArrayWrites;
    }

    public Map<IProgramVar, NondetArrayWriteConstraints> getNondetArrayWriteConstraints() {
        return this.mNondetArrayWriteConstraints;
    }

    public Set<IProgramVar> getHavocedVars() {
        return this.mHavocedVars;
    }

    public Set<IProgramVar> getReadonlyVars() {
        return this.mReadonlyVars;
    }

    private static enum ExtractionImpediments {
        QUANTIFIER,
        DISJUNCTION,
        INEQUALITY,
        NORHS,
        OTHER,
        NORHSARRAY;

    }

    public static class NondetArrayWriteConstraints {
        final Map<Integer, List<SolvedBinaryRelation>> mConstraints;

        public NondetArrayWriteConstraints(Map<Integer, List<SolvedBinaryRelation>> map) {
            this.mConstraints = map;
        }

        public boolean isNondeterministicArrayUpdate(int n) {
            return this.mConstraints.containsKey(n);
        }

        public Term constructConstraints(Script script, int n, Term term) {
            if (!this.mConstraints.containsKey(n)) {
                throw new AssertionError((Object)("There is no nondeterministic update a position " + n));
            }
            ArrayList<Term> arrayList = new ArrayList<Term>();
            List<SolvedBinaryRelation> list = this.mConstraints.get(n);
            for (SolvedBinaryRelation solvedBinaryRelation : list) {
                arrayList.add(solvedBinaryRelation.getRelationSymbol().constructTerm(script, term, solvedBinaryRelation.getRightHandSide()));
            }
            return SmtUtils.and((Script)script, arrayList);
        }
    }

    public static class SimultaneousUpdateException
    extends Exception {
        public SimultaneousUpdateException(String string) {
            super(string);
        }
    }
}

