/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslatedACSLValue;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.CACSL2BoogieBacktranslator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BacktranslationPointer1D
implements CACSL2BoogieBacktranslator.IBacktranslationPointer {
    private final CACSL2BoogieBacktranslator mBacktranslator;

    public BacktranslationPointer1D(CACSL2BoogieBacktranslator cACSL2BoogieBacktranslator) {
        this.mBacktranslator = cACSL2BoogieBacktranslator;
    }

    @Override
    public List<Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>>> collectAllPointers(List<Pair<Expression, Collection<Expression>>> list) {
        ArrayList<Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>>> arrayList = new ArrayList<Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>>>();
        Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>> pair = BacktranslationPointer1D.extractTemporaryPointerExpression(list);
        while (pair != null) {
            arrayList.add(pair);
            pair = BacktranslationPointer1D.extractTemporaryPointerExpression(list);
        }
        return arrayList;
    }

    private static Pair<Expression, Collection<CACSL2BoogieBacktranslator.IExpressionOrPointer>> extractTemporaryPointerExpression(List<Pair<Expression, Collection<Expression>>> list) {
        int n = list.size() - 1;
        while (n >= 0) {
            Pair<Expression, Collection<Expression>> pair = list.get(n);
            PointerVariable1D pointerVariable1D = PointerVariable1D.fromBaseExpression((Expression)pair.getFirst());
            if (pointerVariable1D != null) {
                Expression expression = (Expression)DataStructureUtils.getOneAndOnly((Iterable)((Iterable)pair.getSecond()), (String)"pointer base");
                PointerValue1D pointerValue1D = new PointerValue1D(expression);
                list.remove(pair);
                ArrayList<PointerValue1D> arrayList = new ArrayList<PointerValue1D>();
                arrayList.add(pointerValue1D);
                return new Pair((Object)pointerVariable1D.toExpression(), arrayList);
            }
            --n;
        }
        return null;
    }

    @Override
    public BacktranslatedACSLValue translatePointer(CACSL2BoogieBacktranslator.IPointerValue iPointerValue) {
        assert (iPointerValue instanceof PointerValue1D) : "pointer must be a PointerValue1D";
        PointerValue1D pointerValue1D = (PointerValue1D)iPointerValue;
        BacktranslatedACSLValue.BacktranslatedExpression backtranslatedExpression = this.mBacktranslator.translateExpression(pointerValue1D.base());
        if (!backtranslatedExpression.range().isSingleton()) {
            this.mBacktranslator.reportUnfinishedBacktranslation("Pointer with non-unique base value");
            return null;
        }
        BigInteger bigInteger = backtranslatedExpression.range().getMinValue();
        return new BacktranslatedACSLValue.FakePointer1D(bigInteger);
    }

    private record PointerValue1D(Expression base) implements CACSL2BoogieBacktranslator.IPointerValue
    {
    }

    private record PointerVariable1D(ILocation loc, IdentifierExpression rawPointer, boolean isOld) {
        static PointerVariable1D fromBaseExpression(Expression expression) {
            PointerVariable1D pointerVariable1D;
            UnaryExpression unaryExpression;
            IdentifierExpression identifierExpression;
            if (expression instanceof IdentifierExpression && (identifierExpression = (IdentifierExpression)expression).getIdentifier().endsWith("base")) {
                String string = identifierExpression.getIdentifier();
                String string2 = string.substring(0, string.length() - "base".length() - 1);
                IdentifierExpression identifierExpression2 = new IdentifierExpression(identifierExpression.getLoc(), identifierExpression.getType(), string2, identifierExpression.getDeclarationInformation());
                return new PointerVariable1D(identifierExpression2.getLoc(), identifierExpression2, false);
            }
            if (expression instanceof UnaryExpression && (unaryExpression = (UnaryExpression)expression).getOperator() == UnaryExpression.Operator.OLD && (pointerVariable1D = PointerVariable1D.fromBaseExpression(unaryExpression.getExpr())) != null) {
                return new PointerVariable1D(unaryExpression.getLoc(), pointerVariable1D.rawPointer(), true);
            }
            return null;
        }

        Expression toExpression() {
            if (this.isOld) {
                return new UnaryExpression(this.loc, UnaryExpression.Operator.OLD, (Expression)this.rawPointer);
            }
            return this.rawPointer;
        }
    }
}

