/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Assignments {
    private final Map<String, Boolean> mAssignment;
    private int mNumTrue = -1;

    public Assignments(Map<String, Boolean> map) {
        this.mAssignment = map;
    }

    public Boolean getAssignment(String string) {
        return this.mAssignment.get(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Map.Entry<String, Boolean> entry : this.mAssignment.entrySet()) {
            stringBuilder.append('(').append(entry.getKey()).append(' ').append(entry.getValue()).append(')');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public Iterable<String> getTrueAssignments() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TruthIterator(Boolean.TRUE);
            }
        };
    }

    public Iterable<String> getFalseAssignments() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TruthIterator(Boolean.FALSE);
            }
        };
    }

    public int getNumTrueAssignments() {
        if (this.mNumTrue == -1) {
            this.mNumTrue = 0;
            for (Map.Entry<String, Boolean> entry : this.mAssignment.entrySet()) {
                if (entry.getValue() != Boolean.TRUE) continue;
                ++this.mNumTrue;
            }
        }
        return this.mNumTrue;
    }

    public int getNumFalseAssignments() {
        return this.mAssignment.size() - this.getNumTrueAssignments();
    }

    private class TruthIterator
    implements Iterator<String> {
        private final Boolean mTruthVal;
        private final Iterator<Map.Entry<String, Boolean>> mIt;
        private String mNextVal;

        public TruthIterator(Boolean bl) {
            this.mTruthVal = bl;
            this.mIt = Assignments.this.mAssignment.entrySet().iterator();
            this.nextVal();
        }

        private void nextVal() {
            while (this.mIt.hasNext()) {
                Map.Entry<String, Boolean> entry = this.mIt.next();
                if (entry.getValue() != this.mTruthVal) continue;
                this.mNextVal = entry.getKey();
                return;
            }
            this.mNextVal = null;
        }

        @Override
        public boolean hasNext() {
            return this.mNextVal != null;
        }

        @Override
        public String next() {
            String string = this.mNextVal;
            if (string == null) {
                throw new NoSuchElementException();
            }
            this.nextVal();
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

