/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanDecomposition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAcceleration;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.RationalMatrix;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.math.BigInteger;

public class PolynomialTermMatrix {
    private final int mDimension;
    private final IPolynomialTerm[][] mEntries;
    private BigInteger mDenominator;

    public PolynomialTermMatrix(BigInteger bigInteger, IPolynomialTerm[][] iPolynomialTermArray) {
        int n = iPolynomialTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n != iPolynomialTermArray[n2].length) {
                throw new AssertionError((Object)"Some matrix is not quadratic");
            }
            ++n2;
        }
        this.mEntries = iPolynomialTermArray;
        this.mDimension = n;
        this.mDenominator = bigInteger;
    }

    private static PolynomialTermMatrix constructConstantZeroMatrix(ManagedScript managedScript, int n) {
        Script script = managedScript.getScript();
        IPolynomialTerm[][] iPolynomialTermArray = new IPolynomialTerm[n][n];
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        AffineTerm affineTerm = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.ZERO);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                iPolynomialTermArray[n2][n3] = affineTerm;
                ++n3;
            }
            ++n2;
        }
        PolynomialTermMatrix polynomialTermMatrix = new PolynomialTermMatrix(BigInteger.ONE, iPolynomialTermArray);
        return polynomialTermMatrix;
    }

    public static PolynomialTermMatrix rationalMatrix2TermMatrix(Script script, RationalMatrix rationalMatrix) {
        int n = rationalMatrix.getIntMatrix().getDimension();
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        IPolynomialTerm[][] iPolynomialTermArray = new IPolynomialTerm[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                Rational rational = Rational.valueOf((BigInteger)rationalMatrix.getIntMatrix().getEntry(n2, n3), (BigInteger)BigInteger.ONE);
                iPolynomialTermArray[n2][n3] = AffineTerm.constructConstant((Sort)sort, (Rational)rational);
                ++n3;
            }
            ++n2;
        }
        PolynomialTermMatrix polynomialTermMatrix = new PolynomialTermMatrix(rationalMatrix.getDenominator(), iPolynomialTermArray);
        return polynomialTermMatrix;
    }

    private static IPolynomialTerm constructBinomialCoefficientNumerator(Script script, IPolynomialTerm iPolynomialTerm, int n, int n2) {
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        if (n == 0) {
            return AffineTerm.constructConstant((Sort)sort, (BigInteger)PolynomialTermMatrix.computeFacultyWithStartValue(1, n2 - 1));
        }
        if (n == 1) {
            return PolynomialTerm.mulPolynomials((IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (BigInteger)PolynomialTermMatrix.computeFacultyWithStartValue(1, n2 - 1)), (IPolynomialTerm)iPolynomialTerm);
        }
        AffineTerm affineTerm = AffineTerm.constructConstant((Sort)sort, (BigInteger)PolynomialTermMatrix.computeFacultyWithStartValue(n + 1, n2 - 1));
        IPolynomialTerm iPolynomialTerm2 = PolynomialTerm.mulPolynomials((IPolynomialTerm)affineTerm, (IPolynomialTerm)iPolynomialTerm);
        int n3 = 1;
        while (n3 < n) {
            AffineTerm affineTerm2 = AffineTerm.constructConstant((Sort)sort, (long)(-n3));
            AbstractGeneralizedAffineTerm abstractGeneralizedAffineTerm = PolynomialTerm.sum((IPolynomialTerm[])new IPolynomialTerm[]{iPolynomialTerm, affineTerm2});
            iPolynomialTerm2 = PolynomialTerm.mulPolynomials((IPolynomialTerm)iPolynomialTerm2, (IPolynomialTerm)abstractGeneralizedAffineTerm);
            ++n3;
        }
        return iPolynomialTerm2;
    }

    private static BigInteger computeFacultyWithStartValue(int n, int n2) {
        BigInteger bigInteger = BigInteger.ONE;
        int n3 = n;
        while (n3 <= n2) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(n3));
            ++n3;
        }
        return bigInteger;
    }

    private static PolynomialTermMatrix createBlock(ManagedScript managedScript, IPolynomialTerm iPolynomialTerm, int n, int n2, JordanLoopAcceleration.Iterations iterations) {
        if (n != -1 && n != 0 && n != 1) {
            throw new UnsupportedOperationException("Only eigenvalues -1,0,1 are supported");
        }
        Script script = managedScript.getScript();
        PolynomialTermMatrix polynomialTermMatrix = PolynomialTermMatrix.constructConstantZeroMatrix(managedScript, n2);
        if (n == 0) {
            return polynomialTermMatrix;
        }
        Sort sort = SmtSortUtils.getIntSort((Script)script);
        int n3 = 0;
        while (n3 < n2) {
            IPolynomialTerm iPolynomialTerm2 = PolynomialTermMatrix.constructBinomialCoefficientNumerator(script, iPolynomialTerm, n3, n2);
            IPolynomialTerm iPolynomialTerm3 = n == -1 && iterations == JordanLoopAcceleration.Iterations.EVEN != (n3 % 2 == 0) ? PolynomialTerm.mulPolynomials((IPolynomialTerm)iPolynomialTerm2, (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (long)-1L)) : iPolynomialTerm2;
            polynomialTermMatrix.mEntries[0][n3] = iPolynomialTerm3;
            if (n3 != 0) {
                int n4 = 1;
                while (n4 < n2) {
                    polynomialTermMatrix.mEntries[n4][n3] = polynomialTermMatrix.mEntries[n4 - 1][n3 - 1];
                    ++n4;
                }
            }
            ++n3;
        }
        polynomialTermMatrix.mDenominator = PolynomialTermMatrix.computeFacultyWithStartValue(1, n2 - 1);
        return polynomialTermMatrix;
    }

    private void addBlockToJordanPower(ManagedScript managedScript, PolynomialTermMatrix polynomialTermMatrix, int n) {
        int n2;
        if (this.mDimension < polynomialTermMatrix.mDimension + n) {
            throw new AssertionError((Object)"Block does not fit into matrix");
        }
        Sort sort = SmtSortUtils.getIntSort((Script)managedScript.getScript());
        int n3 = polynomialTermMatrix.mDimension;
        BigInteger bigInteger = Rational.gcd((BigInteger)this.mDenominator, (BigInteger)polynomialTermMatrix.mDenominator);
        int n4 = 0;
        while (n4 < n3) {
            n2 = 0;
            while (n2 < n3) {
                this.mEntries[n4 + n][n2 + n] = PolynomialTerm.mulPolynomials((IPolynomialTerm)polynomialTermMatrix.mEntries[n4][n2], (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (BigInteger)this.mDenominator.divide(bigInteger)));
                ++n2;
            }
            ++n4;
        }
        this.mDenominator = this.mDenominator.multiply(polynomialTermMatrix.mDenominator.divide(bigInteger));
        n4 = 0;
        while (n4 < n) {
            n2 = 0;
            while (n2 < this.mDimension) {
                this.mEntries[n4][n2] = PolynomialTerm.mulPolynomials((IPolynomialTerm)this.mEntries[n4][n2], (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (BigInteger)polynomialTermMatrix.mDenominator.divide(bigInteger)));
                ++n2;
            }
            ++n4;
        }
        n4 = n + n3;
        while (n4 < this.mDimension) {
            n2 = 0;
            while (n2 < this.mDimension) {
                this.mEntries[n4][n2] = PolynomialTerm.mulPolynomials((IPolynomialTerm)this.mEntries[n4][n2], (IPolynomialTerm)AffineTerm.constructConstant((Sort)sort, (BigInteger)polynomialTermMatrix.mDenominator.divide(bigInteger)));
                ++n2;
            }
            ++n4;
        }
    }

    public static PolynomialTermMatrix jordan2JordanPower(ManagedScript managedScript, IPolynomialTerm iPolynomialTerm, JordanLoopAcceleration.Iterations iterations, JordanDecomposition jordanDecomposition) {
        int n = jordanDecomposition.getJnf().getDimension();
        PolynomialTermMatrix polynomialTermMatrix = PolynomialTermMatrix.constructConstantZeroMatrix(managedScript, n);
        NestedMap2<Integer, Integer, Integer> nestedMap2 = jordanDecomposition.getJordanBlockSizes();
        int n2 = 0;
        int n3 = -1;
        while (n3 <= 1) {
            if (nestedMap2.get((Object)n3) != null) {
                for (Integer n4 : nestedMap2.get((Object)n3).keySet()) {
                    if (n4 == null) continue;
                    int n5 = 1;
                    while (n5 <= (Integer)nestedMap2.get((Object)n3, (Object)n4)) {
                        PolynomialTermMatrix polynomialTermMatrix2 = PolynomialTermMatrix.createBlock(managedScript, iPolynomialTerm, n3, n4, iterations);
                        polynomialTermMatrix.addBlockToJordanPower(managedScript, polynomialTermMatrix2, n2);
                        n2 += n4.intValue();
                        ++n5;
                    }
                }
            }
            ++n3;
        }
        return polynomialTermMatrix;
    }

    public static PolynomialTermMatrix computeClosedFormMatrix(ManagedScript managedScript, JordanDecomposition jordanDecomposition, IPolynomialTerm iPolynomialTerm, JordanLoopAcceleration.Iterations iterations) {
        int n = jordanDecomposition.getJnf().getDimension();
        Script script = managedScript.getScript();
        RationalMatrix rationalMatrix = jordanDecomposition.getModal();
        RationalMatrix rationalMatrix2 = jordanDecomposition.getInverseModal();
        PolynomialTermMatrix polynomialTermMatrix = PolynomialTermMatrix.constructConstantZeroMatrix(managedScript, n);
        PolynomialTermMatrix polynomialTermMatrix2 = PolynomialTermMatrix.jordan2JordanPower(managedScript, iPolynomialTerm, iterations, jordanDecomposition);
        PolynomialTermMatrix polynomialTermMatrix3 = PolynomialTermMatrix.multiplication(managedScript, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, rationalMatrix), polynomialTermMatrix2);
        polynomialTermMatrix = PolynomialTermMatrix.multiplication(managedScript, polynomialTermMatrix3, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, rationalMatrix2));
        return PolynomialTermMatrix.cancelDenominator(managedScript, polynomialTermMatrix);
    }

    public static PolynomialTermMatrix computeClosedFormMatrix(ManagedScript managedScript, JordanDecomposition jordanDecomposition, int n) {
        Script script = managedScript.getScript();
        RationalMatrix rationalMatrix = jordanDecomposition.getModal();
        RationalMatrix rationalMatrix2 = jordanDecomposition.getInverseModal();
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.power(jordanDecomposition.getJnf(), n);
        PolynomialTermMatrix polynomialTermMatrix = PolynomialTermMatrix.rationalMatrix2TermMatrix(script, new RationalMatrix(BigInteger.ONE, quadraticMatrix));
        PolynomialTermMatrix polynomialTermMatrix2 = PolynomialTermMatrix.multiplication(managedScript, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, rationalMatrix), polynomialTermMatrix);
        PolynomialTermMatrix polynomialTermMatrix3 = PolynomialTermMatrix.multiplication(managedScript, polynomialTermMatrix2, PolynomialTermMatrix.rationalMatrix2TermMatrix(script, rationalMatrix2));
        return PolynomialTermMatrix.cancelDenominator(managedScript, polynomialTermMatrix3);
    }

    public static PolynomialTermMatrix multiplication(ManagedScript managedScript, PolynomialTermMatrix polynomialTermMatrix, PolynomialTermMatrix polynomialTermMatrix2) {
        if (polynomialTermMatrix.mDimension != polynomialTermMatrix2.mDimension) {
            throw new AssertionError((Object)"Some matrices for multiplication are not of the same dimension.");
        }
        int n = polynomialTermMatrix.mDimension;
        PolynomialTermMatrix polynomialTermMatrix3 = PolynomialTermMatrix.constructConstantZeroMatrix(managedScript, n);
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)managedScript);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                AffineTerm affineTerm = AffineTerm.constructConstant((Sort)sort, (Rational)Rational.ZERO);
                int n4 = 0;
                while (n4 < n) {
                    IPolynomialTerm iPolynomialTerm = PolynomialTerm.mulPolynomials((IPolynomialTerm)polynomialTermMatrix.mEntries[n2][n4], (IPolynomialTerm)polynomialTermMatrix2.mEntries[n4][n3]);
                    affineTerm = PolynomialTerm.sum((IPolynomialTerm[])new IPolynomialTerm[]{affineTerm, iPolynomialTerm});
                    ++n4;
                }
                polynomialTermMatrix3.mEntries[n2][n3] = affineTerm;
                ++n3;
            }
            ++n2;
        }
        polynomialTermMatrix3.mDenominator = polynomialTermMatrix.mDenominator.multiply(polynomialTermMatrix2.mDenominator);
        return polynomialTermMatrix3;
    }

    public IPolynomialTerm getEntry(int n, int n2) {
        return this.mEntries[n][n2];
    }

    public void setEntry(int n, int n2, IPolynomialTerm iPolynomialTerm) {
        this.mEntries[n][n2] = iPolynomialTerm;
    }

    public BigInteger getDenominator() {
        return this.mDenominator;
    }

    public int getDimension() {
        return this.mDimension;
    }

    public static PolynomialTermMatrix cancelDenominator(ManagedScript managedScript, PolynomialTermMatrix polynomialTermMatrix) {
        PolynomialTermMatrix polynomialTermMatrix2 = PolynomialTermMatrix.constructConstantZeroMatrix(managedScript, polynomialTermMatrix.getDimension());
        int n = 0;
        while (n < polynomialTermMatrix2.getDimension()) {
            int n2 = 0;
            while (n2 < polynomialTermMatrix2.getDimension()) {
                IPolynomialTerm iPolynomialTerm = polynomialTermMatrix.getEntry(n, n2);
                IPolynomialTerm iPolynomialTerm2 = iPolynomialTerm.divInvertible(Rational.valueOf((BigInteger)polynomialTermMatrix.getDenominator(), (BigInteger)BigInteger.ONE));
                if (iPolynomialTerm2 == null) {
                    return null;
                }
                polynomialTermMatrix2.setEntry(n, n2, iPolynomialTerm2);
                ++n2;
            }
            ++n;
        }
        return polynomialTermMatrix2;
    }
}

