/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTermPairHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CompareTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class CCTerm
extends SimpleListable<CCTerm> {
    CCTerm mEqualEdge;
    CCTerm mRepStar;
    CCTerm mRep;
    CCTerm mOldRep;
    CCEquality mReasonLiteral;
    int mMergeTime = Integer.MAX_VALUE;
    CCParentInfo mCCPars;
    SimpleList<CCTerm> mMembers;
    int mNumMembers;
    SimpleList<CCTermPairHash.Info.Entry> mPairInfos;
    CCTerm mSharedTerm;
    Term mFlatTerm;
    int mHashCode;
    final int mAge;
    boolean mIsFunc;
    int mParentPosition;

    protected CCTerm(boolean bl, int n, int n2, int n3) {
        this.mIsFunc = bl;
        this.mCCPars = null;
        if (bl) {
            this.mParentPosition = n;
        }
        this.mCCPars = new CCParentInfo();
        this.mRep = this.mRepStar = this;
        this.mMembers = new SimpleList();
        this.mPairInfos = new SimpleList();
        this.mMembers.append(this);
        this.mNumMembers = 1;
        assert (this.invariant());
        this.mHashCode = n2;
        this.mAge = n3;
    }

    public boolean isFunc() {
        return this.mIsFunc;
    }

    boolean pairHashValid(CClosure cClosure) {
        return true;
    }

    final boolean invariant() {
        return true;
    }

    public final CCTerm getRepresentative() {
        return this.mRepStar;
    }

    public final boolean isRepresentative() {
        return this.mRep == this;
    }

    public void share(CClosure cClosure) {
        boolean bl;
        CCTerm cCTerm;
        assert (this.mSharedTerm != this);
        cClosure.getLogger().debug("CC-Share %s", this);
        CCTerm cCTerm2 = this;
        if (this.mSharedTerm != null) {
            cCTerm = this.mSharedTerm;
            bl = true;
        } else {
            cCTerm2.mSharedTerm = this;
            while (cCTerm2.mRep.mSharedTerm == null) {
                cCTerm2 = cCTerm2.mRep;
                cCTerm2.mSharedTerm = this;
            }
            if (cCTerm2 != cCTerm2.mRep) {
                CCTerm cCTerm3 = cCTerm2.mRep;
                assert (cCTerm3.mSharedTerm != null);
                cCTerm = cCTerm3.mSharedTerm;
                if (cCTerm == cCTerm3) {
                    bl = false;
                } else {
                    CCTerm cCTerm4 = cCTerm;
                    while (cCTerm4.mRep != cCTerm3) {
                        cCTerm4 = cCTerm4.mRep;
                    }
                    assert (cCTerm4.mRep == cCTerm3 && cCTerm2.mRep == cCTerm3);
                    assert (cCTerm4 != cCTerm2);
                    bl = cCTerm2.mMergeTime < cCTerm4.mMergeTime;
                }
                cCTerm2 = cCTerm3;
            } else {
                cCTerm = null;
                bl = true;
            }
        }
        if (cCTerm != null) {
            if (bl) {
                while (cCTerm2.mSharedTerm == cCTerm) {
                    cCTerm2.mSharedTerm = this;
                    cCTerm2 = cCTerm2.mRep;
                }
            }
            this.propagateSharedEquality(cClosure, cCTerm);
        }
    }

    public void unshare() {
        assert (this.mSharedTerm == this);
        assert (this.isRepresentative());
        this.mSharedTerm = null;
    }

    private void propagateSharedEquality(CClosure cClosure, CCTerm cCTerm) {
        assert (this.mRepStar == cCTerm.mRepStar);
        CCEquality cCEquality = cClosure.createEquality(this, cCTerm, true);
        assert (cCEquality != null);
        if (cClosure.getLogger().isDebugEnabled()) {
            cClosure.getLogger().debug("PL: %s", cCEquality);
        }
        if (cCEquality.getDecideStatus() == null) {
            assert (cClosure.mPendingLits.contains(cCEquality));
        } else if (cCEquality.getLASharedData().getDecideStatus() == null) {
            assert (cCEquality.getDecideStatus() == cCEquality);
            cClosure.addPending(cCEquality.getLASharedData());
            cClosure.mRecheckOnBacktrackLits.add(cCEquality);
        }
    }

    public void invertEqualEdges(CClosure cClosure) {
        if (this.mEqualEdge == null) {
            return;
        }
        long l = System.nanoTime();
        CCTerm cCTerm = null;
        CCTerm cCTerm2 = null;
        CCTerm cCTerm3 = this;
        while (cCTerm3 != null) {
            CCTerm cCTerm4 = cCTerm3;
            cCTerm3 = cCTerm3.mEqualEdge;
            cCTerm4.mEqualEdge = cCTerm;
            CCTerm cCTerm5 = cCTerm4.mOldRep;
            cCTerm4.mOldRep = cCTerm2;
            cCTerm = cCTerm4;
            cCTerm2 = cCTerm5;
        }
        cClosure.addInvertEdgeTime(System.nanoTime() - l);
    }

    public Clause merge(CClosure cClosure, CCTerm cCTerm, CCEquality cCEquality) {
        Clause clause;
        assert (cCEquality != null || this instanceof CCAppTerm && cCTerm instanceof CCAppTerm);
        CCTerm cCTerm2 = cCTerm.mRepStar;
        CCTerm cCTerm3 = this.mRepStar;
        assert (cCTerm2.invariant());
        assert (cCTerm2.pairHashValid(cClosure));
        assert (cCTerm3.invariant());
        assert (cCTerm3.pairHashValid(cClosure));
        if (cCTerm2 == cCTerm3) {
            return null;
        }
        cClosure.incMergeCount();
        if (cCTerm2.mNumMembers > cCTerm3.mNumMembers) {
            clause = cCTerm.mergeInternal(cClosure, this, cCEquality);
            if (clause == null && cCEquality == null) {
                ((CCAppTerm)this).markParentInfos();
            }
        } else {
            clause = this.mergeInternal(cClosure, cCTerm, cCEquality);
            if (clause == null && cCEquality == null) {
                ((CCAppTerm)cCTerm).markParentInfos();
            }
        }
        assert (this.invariant());
        assert (cCTerm.invariant());
        assert (this.mRepStar.pairHashValid(cClosure));
        return clause;
    }

    /*
     * WARNING - void declaration
     */
    private Clause mergeInternal(CClosure cClosure, CCTerm cCTerm, CCEquality cCEquality) {
        CCTerm cCTerm2 = cCTerm.mRepStar;
        CCTerm cCTerm3 = this.mRepStar;
        CCEquality cCEquality2 = null;
        CCTermPairHash.Info info = cClosure.mPairHash.getInfo(cCTerm2, cCTerm3);
        if (info != null) {
            cCEquality2 = info.mDiseq;
        }
        boolean bl = false;
        if (cCEquality2 == null && cCTerm2.mSharedTerm != null) {
            if (cCTerm3.mSharedTerm == null) {
                cCTerm3.mSharedTerm = cCTerm2.mSharedTerm;
            } else {
                boolean bl2 = cCTerm3.mSharedTerm.mFlatTerm.getSort().isNumericSort();
                CCEquality cCEquality3 = cClosure.createEquality(cCTerm2.mSharedTerm, cCTerm3.mSharedTerm, bl2);
                bl = cCEquality3 == null;
            }
        }
        cCTerm.invertEqualEdges(cClosure);
        cCTerm.mEqualEdge = this;
        cCTerm.mOldRep = cCTerm2;
        cCTerm2.mReasonLiteral = cCEquality;
        if (bl || cCEquality2 != null) {
            Clause clause = bl ? cClosure.computeCycle(cCTerm2.mSharedTerm, cCTerm3.mSharedTerm) : cClosure.computeCycle(cCEquality2);
            cCTerm.mEqualEdge = null;
            cCTerm.mOldRep = null;
            cCTerm2.mReasonLiteral = null;
            return clause;
        }
        cCTerm2.mMergeTime = cClosure.getMergeDepth();
        cClosure.recordMerge(cCTerm);
        cClosure.getLogger().debug("M %s %s", this, cCTerm);
        long l = System.nanoTime();
        cCTerm2.mRep = cCTerm3;
        for (CCTerm object2 : cCTerm2.mMembers) {
            object2.mRepStar = cCTerm3;
        }
        cClosure.addSetRepTime(System.nanoTime() - l);
        cCTerm3.mMembers.joinList(cCTerm2.mMembers);
        cCTerm3.mNumMembers += cCTerm2.mNumMembers;
        l = System.nanoTime();
        for (CCTermPairHash.Info.Entry entry : cCTerm2.mPairInfos) {
            CCTermPairHash.Info info2 = entry.getInfo();
            assert (entry.getOtherEntry().mOther == cCTerm2);
            Iterator<CCAppTerm.Parent> iterator = entry.mOther;
            assert (((CCTerm)((Object)iterator)).mRepStar == iterator);
            if (iterator == cCTerm3) {
                assert (info2.mDiseq == null);
                for (CCEquality.Entry entry2 : info2.mEqlits) {
                    cClosure.addPending(entry2.getCCEquality());
                }
                for (CompareTrigger compareTrigger : info2.mCompareTriggers) {
                    compareTrigger.activate();
                }
            } else {
                void var15_35;
                CCTermPairHash.Info info3 = cClosure.mPairHash.getInfo(cCTerm3, (CCTerm)((Object)iterator));
                if (info3 == null) {
                    CCTermPairHash.Info info4 = new CCTermPairHash.Info(cCTerm3, (CCTerm)((Object)iterator));
                    cClosure.mPairHash.add(info4);
                }
                if (var15_35.mDiseq == null && info2.mDiseq != null) {
                    var15_35.mDiseq = info2.mDiseq;
                    for (CCEquality.Entry entry3 : var15_35.mEqlits) {
                        assert (entry3.getCCEquality().getDecideStatus() != entry3.getCCEquality());
                        if (entry3.getCCEquality().getDecideStatus() != null) continue;
                        entry3.getCCEquality().mDiseqReason = info2.mDiseq;
                        cClosure.addPending(entry3.getCCEquality().negate());
                    }
                } else if (var15_35.mDiseq != null && info2.mDiseq == null) {
                    for (CCEquality.Entry entry4 : info2.mEqlits) {
                        assert (entry4.getCCEquality().getDecideStatus() != entry4.getCCEquality());
                        if (entry4.getCCEquality().getDecideStatus() != null) continue;
                        entry4.getCCEquality().mDiseqReason = var15_35.mDiseq;
                        cClosure.addPending(entry4.getCCEquality().negate());
                    }
                }
                var15_35.mEqlits.joinList(info2.mEqlits);
                var15_35.mCompareTriggers.joinList(info2.mCompareTriggers);
            }
            entry.getOtherEntry().unlink();
            assert (((CCTerm)((Object)iterator)).mPairInfos.wellformed());
            cClosure.removePairHash(info2);
        }
        cClosure.addEqTime(System.nanoTime() - l);
        l = System.nanoTime();
        if (this.mIsFunc) {
            CCParentInfo cCParentInfo = cCTerm2.mCCPars.mNext;
            var12_13 = cCTerm3.mCCPars.mNext;
            if (cCParentInfo != null) {
                assert (cCParentInfo.mFuncSymbNr == ((CCParentInfo)var12_13).mFuncSymbNr);
                assert (cCParentInfo.mReverseTriggers.isEmpty());
                block6: for (CCAppTerm.Parent parent : cCParentInfo.mCCParents) {
                    if (parent.isMarked()) continue;
                    CCAppTerm cCAppTerm = parent.getData();
                    for (CCAppTerm.Parent parent2 : ((CCParentInfo)var12_13).mCCParents) {
                        if (parent2.isMarked()) continue;
                        cClosure.incCcCount();
                        if (cCAppTerm.mArg.mRepStar != parent2.getData().mArg.mRepStar) continue;
                        cClosure.addPendingCongruence(cCAppTerm, parent2.getData());
                        continue block6;
                    }
                }
                ((CCParentInfo)var12_13).mCCParents.joinList(cCParentInfo.mCCParents);
            }
        } else {
            void var11_19;
            CCParentInfo cCParentInfo = cCTerm2.mCCPars.mNext;
            var12_13 = cCTerm3.mCCPars.mNext;
            while (var11_19 != null && var12_13 != null) {
                if (var11_19.mFuncSymbNr < ((CCParentInfo)var12_13).mFuncSymbNr) {
                    CCParentInfo cCParentInfo2 = var11_19.mNext;
                    continue;
                }
                if (var11_19.mFuncSymbNr > ((CCParentInfo)var12_13).mFuncSymbNr) {
                    var12_13 = ((CCParentInfo)var12_13).mNext;
                    continue;
                }
                assert (var11_19.mFuncSymbNr == ((CCParentInfo)var12_13).mFuncSymbNr);
                block9: for (CCAppTerm.Parent parent : var11_19.mCCParents) {
                    if (parent.isMarked()) continue;
                    CCAppTerm cCAppTerm = parent.getData();
                    for (CCAppTerm.Parent parent3 : ((CCParentInfo)var12_13).mCCParents) {
                        if (parent3.isMarked()) continue;
                        cClosure.incCcCount();
                        if (cCAppTerm.mFunc.mRepStar != parent3.getData().mFunc.mRepStar) continue;
                        cClosure.addPendingCongruence(cCAppTerm, parent3.getData());
                        continue block9;
                    }
                }
                if (!var11_19.mReverseTriggers.isEmpty()) {
                    for (CCAppTerm.Parent parent : ((CCParentInfo)var12_13).mCCParents) {
                        void var15_41;
                        if (parent.isMarked()) continue;
                        List<CCAppTerm> list = Collections.singletonList(parent.getData());
                        while (((CCTerm)var15_41.get((int)0)).mIsFunc) {
                            List<CCTerm> list2 = CClosure.getApplications((List<CCTerm>)var15_41);
                        }
                        for (CCTerm cCTerm4 : var15_41) {
                            for (ReverseTrigger reverseTrigger : var11_19.mReverseTriggers) {
                                reverseTrigger.activate((CCAppTerm)cCTerm4, false);
                            }
                        }
                    }
                }
                if (!((CCParentInfo)var12_13).mReverseTriggers.isEmpty()) {
                    for (CCAppTerm.Parent parent : var11_19.mCCParents) {
                        void var15_44;
                        if (parent.isMarked()) continue;
                        List<CCAppTerm> list = Collections.singletonList(parent.getData());
                        while (((CCTerm)var15_44.get((int)0)).mIsFunc) {
                            List<CCTerm> list3 = CClosure.getApplications((List<CCTerm>)var15_44);
                        }
                        for (CCTerm cCTerm5 : var15_44) {
                            for (ReverseTrigger reverseTrigger : ((CCParentInfo)var12_13).mReverseTriggers) {
                                reverseTrigger.activate((CCAppTerm)cCTerm5, false);
                            }
                        }
                    }
                }
                CCParentInfo cCParentInfo3 = var11_19.mNext;
                var12_13 = ((CCParentInfo)var12_13).mNext;
            }
            cCTerm3.mCCPars.mergeParentInfo(cCTerm2.mCCPars);
        }
        cClosure.addCcTime(System.nanoTime() - l);
        assert (this.invariant());
        assert (cCTerm.invariant());
        assert (cCTerm2.invariant());
        assert (cCTerm3.invariant());
        return null;
    }

    public void undoMerge(CClosure cClosure, CCTerm cCTerm) {
        cClosure.getLogger().debug("U %s %s", cCTerm, this);
        assert (this.invariant());
        assert (cCTerm.invariant());
        assert (this.mRepStar.pairHashValid(cClosure));
        assert (this.mEqualEdge == cCTerm);
        assert (this.mRepStar == cCTerm.mRepStar);
        CCTerm cCTerm2 = this.mOldRep;
        this.mEqualEdge = null;
        this.mOldRep = null;
        CCTerm cCTerm3 = this.mRepStar;
        assert (cCTerm2.mRep == cCTerm3);
        cCTerm3.mCCPars.unmergeParentInfo(cCTerm2.mCCPars);
        if (cCTerm2.mReasonLiteral == null) {
            ((CCAppTerm)this).unmarkParentInfos();
        }
        cCTerm2.mReasonLiteral = null;
        for (CCTermPairHash.Info.Entry simpleListable : cCTerm2.mPairInfos.reverse()) {
            CCTermPairHash.Info info;
            CCTermPairHash.Info info2 = simpleListable.getInfo();
            assert (simpleListable.getOtherEntry().mOther == cCTerm2);
            cClosure.mPairHash.add(simpleListable.getInfo());
            assert (simpleListable.mOther.mPairInfos.wellformed());
            simpleListable.mOther.mPairInfos.append(simpleListable.getOtherEntry());
            assert (simpleListable.mOther.mPairInfos.wellformed());
            CCTerm cCTerm4 = simpleListable.mOther;
            assert (cCTerm4.mRepStar == cCTerm4);
            if (cCTerm4 == cCTerm3 || (info = cClosure.mPairHash.getInfo(cCTerm3, cCTerm4)) == null) continue;
            info.mCompareTriggers.unjoinList(info2.mCompareTriggers);
            assert (info.mEqlits.wellformed());
            info.mEqlits.unjoinList(info2.mEqlits);
            assert (info2.mEqlits.wellformed() && info.mEqlits.wellformed());
            if (info.mDiseq == info2.mDiseq) {
                info.mDiseq = null;
            }
            if (info.mDiseq != null || !info.mEqlits.isEmpty() || !info.mCompareTriggers.isEmpty()) continue;
            info.mLhsEntry.unlink();
            info.mRhsEntry.unlink();
            cClosure.removePairHash(info);
        }
        cCTerm3.mNumMembers -= cCTerm2.mNumMembers;
        long l = System.nanoTime();
        cCTerm3.mMembers.unjoinList(cCTerm2.mMembers);
        for (CCTerm cCTerm5 : cCTerm2.mMembers) {
            cCTerm5.mRepStar = cCTerm2;
        }
        cCTerm2.mRep = cCTerm2;
        assert (cCTerm2.mMergeTime == cClosure.getMergeDepth());
        cCTerm2.mMergeTime = Integer.MAX_VALUE;
        cClosure.addSetRepTime(System.nanoTime() - l);
        if (cCTerm3.mSharedTerm == cCTerm2.mSharedTerm) {
            cCTerm3.mSharedTerm = null;
        }
        assert (this.invariant());
        assert (cCTerm.invariant());
        assert (cCTerm2.invariant());
        assert (cCTerm3.invariant());
        assert (cCTerm2.pairHashValid(cClosure));
        assert (cCTerm3.pairHashValid(cClosure));
    }

    public CCTerm getSharedTerm() {
        return this.mSharedTerm;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public Term getFlatTerm() {
        return this.mFlatTerm;
    }

    public int getNumMembers() {
        return this.mNumMembers;
    }

    public int getAge() {
        return this.mAge;
    }

    static class CongruenceInfo {
        CCAppTerm mAppTerm1;
        CCAppTerm mAppTerm2;
        boolean mMerged;
        CongruenceInfo mNext;

        public CongruenceInfo(CCAppTerm cCAppTerm, CCAppTerm cCAppTerm2, CongruenceInfo congruenceInfo) {
            this.mAppTerm1 = cCAppTerm;
            this.mAppTerm2 = cCAppTerm2;
            this.mNext = congruenceInfo;
        }
    }

    static class TermPairMergeInfo {
        CCTermPairHash.Info.Entry mInfo;
        TermPairMergeInfo mNext;

        public TermPairMergeInfo(CCTermPairHash.Info.Entry entry, TermPairMergeInfo termPairMergeInfo) {
            this.mInfo = entry;
            this.mNext = termPairMergeInfo;
        }
    }
}

