/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.TotalizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.UnionNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IUnionStateFactory;

public final class Union<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mResult;

    public Union(AutomataLibraryServices automataLibraryServices, IUnionStateFactory<STATE> iUnionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        TotalizeNwa<LETTER, IUnionStateFactory<STATE>> totalizeNwa = new TotalizeNwa<LETTER, IUnionStateFactory<STATE>>(this.mFstOperand, iUnionStateFactory, false);
        TotalizeNwa<LETTER, IUnionStateFactory<STATE>> totalizeNwa2 = new TotalizeNwa<LETTER, IUnionStateFactory<STATE>>(this.mSndOperand, iUnionStateFactory, false);
        UnionNwa<LETTER, IUnionStateFactory<STATE>> unionNwa = new UnionNwa<LETTER, IUnionStateFactory<STATE>>(totalizeNwa, totalizeNwa2, iUnionStateFactory, false);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, IUnionStateFactory<STATE>>(this.mServices, unionNwa);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        INestedWordAutomaton iNestedWordAutomaton = new Difference<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mResult, this.mFstOperand).getResult();
        INestedWordAutomaton iNestedWordAutomaton2 = new Difference<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mResult, this.mSndOperand).getResult();
        boolean bl = new IsIncluded<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mSndOperand, iNestedWordAutomaton).getResult();
        assert (bl);
        boolean bl2 = bl = bl && new IsIncluded<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mFstOperand, iNestedWordAutomaton2).getResult() != false;
        assert (bl);
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mFstOperand, this.mSndOperand);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }
}

