/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;

public class ConstantDfsOrder<L, S>
implements IDfsOrder<L, S> {
    private final Comparator<L> mComparator;

    public ConstantDfsOrder(Comparator<L> comparator) {
        this.mComparator = comparator;
    }

    @Override
    public Comparator<L> getOrder(S s) {
        return this.mComparator;
    }

    @Override
    public boolean isPositional() {
        return false;
    }

    public static <L, S, U extends Comparable<U>> ConstantDfsOrder<L, S> comparing(Function<L, U> function) {
        return new ConstantDfsOrder<L, S>(Comparator.comparing(function));
    }

    public static <L, S, U> ConstantDfsOrder<L, S> comparing(Function<L, U> function, Comparator<U> comparator) {
        return new ConstantDfsOrder<L, S>(Comparator.comparing(function, comparator));
    }

    public static <L, S> ConstantDfsOrder<L, S> byHashCode() {
        return ConstantDfsOrder.comparing(Object::hashCode);
    }

    public static <L, S> ConstantDfsOrder<L, S> fromIterable(Iterable<L> iterable) {
        HashMap<L, Integer> hashMap = new HashMap<L, Integer>();
        int n = 0;
        for (L l : iterable) {
            hashMap.put(l, n);
            ++n;
        }
        return ConstantDfsOrder.comparing(hashMap::get);
    }
}

