/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.DfsBookkeeping;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class DepthFirstTraversal<L, S> {
    private static final String ABORT_MSG = "visitor aborted traversal";
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final INwaOutgoingLetterAndTransitionProvider<L, S> mOperand;
    private final S mStartState;
    private final IDfsOrder<L, S> mOrder;
    private final IDfsVisitor<L, S> mVisitor;
    private final Deque<Pair<S, OutgoingInternalTransition<L, S>>> mWorklist = new ArrayDeque<Pair<S, OutgoingInternalTransition<L, S>>>();
    private final DfsBookkeeping<S> mDfs = new DfsBookkeeping();
    private int mIndentLevel = -1;

    public DepthFirstTraversal(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, S> iDfsOrder, IDfsVisitor<L, S> iDfsVisitor, S s) throws AutomataOperationCanceledException {
        assert (NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingLetterAndTransitionProvider)) : "DFS supports only finite automata";
        this.mServices = automataLibraryServices;
        this.mLogger = automataLibraryServices.getLoggingService().getLogger(DepthFirstTraversal.class);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStartState = s;
        this.mOrder = iDfsOrder;
        this.mVisitor = iDfsVisitor;
        this.traverse();
    }

    public static <L, S> void traverse(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, S> iDfsOrder, IDfsVisitor<L, S> iDfsVisitor) throws AutomataOperationCanceledException {
        Optional optional = DataStructureUtils.getOnly(iNwaOutgoingLetterAndTransitionProvider.getInitialStates(), (String)"There must only be one initial state");
        if (optional.isPresent()) {
            new DepthFirstTraversal<L, S>(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, iDfsOrder, iDfsVisitor, optional.get());
        } else {
            ILogger iLogger = automataLibraryServices.getLoggingService().getLogger(DepthFirstTraversal.class);
            iLogger.warn((Object)"Depth first traversal did not find any initial state. Returning directly.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void traverse() throws AutomataOperationCanceledException {
        var1_1 = this.visitState(this.mStartState);
        if (!var1_1) ** GOTO lbl35
        this.mLogger.debug((Object)"visitor aborted traversal");
        return;
lbl-1000:
        // 1 sources

        {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            var2_2 = this.mWorklist.pop();
            var3_4 = var2_2.getFirst();
            var4_5 = this.backtrackUntil(var3_4);
            if (var4_5) {
                this.mLogger.debug((Object)"visitor aborted traversal");
                return;
            }
            var5_6 = (OutgoingInternalTransition)var2_2.getSecond();
            var6_7 = var5_6.getSucc();
            this.debugIndent("Now exploring transition %s --> %s (label: %s)", new Object[]{var3_4, var6_7, var5_6.getLetter()});
            var7_8 = this.mVisitor.discoverTransition(var3_4, var5_6.getLetter(), var6_7);
            if (this.mVisitor.isFinished()) {
                this.mLogger.debug((Object)"visitor aborted traversal");
                return;
            }
            if (var7_8) {
                this.debugIndent("-> visitor pruned transition", new Object[0]);
                continue;
            }
            if (!this.mDfs.isVisited(var6_7)) {
                var9_10 = this.visitState(var6_7);
                if (!var9_10) continue;
                this.mLogger.debug((Object)"visitor aborted traversal");
                return;
            }
            var8_9 = this.mDfs.stackIndexOf(var6_7);
            if (var8_9 != -1) {
                this.debugIndent("-> state is on stack -- do not unroll loop", new Object[0]);
                this.mDfs.updateLoopHead(var3_4, new Pair((Object)var8_9, var6_7));
                continue;
            }
            this.debugIndent("-> state was visited before -- no re-exploration", new Object[0]);
            this.mDfs.backPropagateLoopHead(var3_4, var6_7);
lbl35:
            // 5 sources

            ** while (!this.mWorklist.isEmpty())
        }
lbl36:
        // 1 sources

        var2_3 = this.backtrackUntil(this.mStartState);
        if (var2_3) {
            this.mLogger.debug((Object)"visitor aborted traversal");
            return;
        }
        this.backtrack();
        this.mLogger.debug((Object)"traversal completed");
    }

    private boolean backtrackUntil(S s) {
        while (!this.mDfs.peek().equals(s)) {
            boolean bl = this.backtrack();
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean backtrack() {
        Object object = this.mDfs.peek();
        boolean bl = this.mDfs.backtrack();
        this.debugIndent("backtracking state %s (complete: %s)", object, bl);
        --this.mIndentLevel;
        this.mVisitor.backtrackState(object, bl);
        return this.mVisitor.isFinished();
    }

    private boolean visitState(S s) {
        boolean bl;
        assert (!this.mDfs.isVisited(s)) : "must never re-visit state";
        ++this.mIndentLevel;
        this.debugIndent("visiting state %s", s);
        if (this.mStartState.equals(s)) {
            this.debugIndent("-> state is start state", new Object[0]);
            assert (!this.mDfs.hasStarted()) : "start state should be first visited state";
            bl = this.mVisitor.addStartState(s);
        } else {
            assert (this.mDfs.hasStarted()) : "first visited state should be start state";
            bl = this.mVisitor.discoverState(s);
        }
        if (this.mVisitor.isFinished()) {
            return true;
        }
        this.mDfs.push(s);
        if (bl) {
            this.debugIndent("-> visitor pruned all outgoing edges", new Object[0]);
        } else {
            Comparator<OutgoingInternalTransition> comparator = Comparator.comparing(OutgoingInternalTransition::getLetter, this.mOrder.getOrder(s)).reversed();
            StreamSupport.stream(this.mOperand.internalSuccessors(s).spliterator(), false).sorted(comparator).forEachOrdered(outgoingInternalTransition -> this.mWorklist.push(new Pair(s, outgoingInternalTransition)));
        }
        return false;
    }

    private void debugIndent(String string, Object ... objectArray) {
        this.mLogger.debug("  ".repeat(this.mIndentLevel) + string, objectArray);
    }
}

