/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;

public class Transition<LETTER, PLACE>
implements Serializable,
Comparable<Transition<LETTER, PLACE>> {
    private static final long serialVersionUID = 5948089529814334197L;
    private static final boolean USE_HASH_JENKINS = false;
    private final int mHashCode;
    private final LETTER mSymbol;
    private final ImmutableSet<PLACE> mPredecessors;
    private final ImmutableSet<PLACE> mSuccessors;
    private final int mTotalOrderId;

    public Transition(LETTER LETTER, ImmutableSet<PLACE> immutableSet, ImmutableSet<PLACE> immutableSet2, int n) {
        this.mSymbol = Objects.requireNonNull(LETTER, "Transition must not be labeled with null");
        this.mPredecessors = immutableSet;
        this.mSuccessors = immutableSet2;
        this.mHashCode = this.mTotalOrderId = n;
    }

    public LETTER getSymbol() {
        return this.mSymbol;
    }

    public ImmutableSet<PLACE> getPredecessors() {
        return this.mPredecessors;
    }

    public ImmutableSet<PLACE> getSuccessors() {
        return this.mSuccessors;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        return this.mSymbol.toString() + "[" + this.mTotalOrderId + "]";
    }

    public int getTotalOrderId() {
        return this.mTotalOrderId;
    }

    @Override
    public int compareTo(Transition<LETTER, PLACE> transition) {
        return this.mTotalOrderId - transition.mTotalOrderId;
    }
}

