/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class HashedPriorityQueue<E>
implements Queue<E>,
Set<E>,
Collection<E> {
    private final Queue<E> mQueue;
    private final Set<E> mSet;

    public HashedPriorityQueue(Comparator<E> comparator) {
        this.mQueue = new PriorityQueue<E>(comparator);
        this.mSet = new HashSet();
    }

    public E find(Object object) {
        if (object == null) {
            return null;
        }
        int n = object.hashCode();
        for (Object e : this.mQueue) {
            if (e.hashCode() != n) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean remove(Object object) {
        if (this.mSet.remove(object)) {
            this.mQueue.remove(object);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        E e = this.mQueue.poll();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    @Override
    public boolean add(E e) {
        if (this.mSet.add(e)) {
            this.mQueue.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.mSet.contains(object);
    }

    public String toString() {
        return CoreUtil.join(this.mQueue, ", ");
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mQueue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.mQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.mQueue.toArray(TArray);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mSet.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.mSet.addAll(collection)) {
            this.mQueue.addAll(collection);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.mSet.removeAll(collection)) {
            this.mQueue.removeAll(collection);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.mSet.retainAll(collection)) {
            this.mQueue.retainAll(collection);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.mSet.clear();
        this.mQueue.clear();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E remove() {
        E e = this.mQueue.remove();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public E element() {
        return this.mQueue.element();
    }

    @Override
    public E peek() {
        return this.mQueue.peek();
    }
}

