/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.BPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.ProofAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareMapping;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheckCraig;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.AbstractInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppHyperEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.ImpRootNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.RCFG2AnnotatedRCFG;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.CodeCheckBenchmarks;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.CodeCheckSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.CodeChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.GraphWriter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.emptinesscheck.NWAEmptinessCheck;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.impulse.ImpulseChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.kojak.UltimateChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.preferences.CodeCheckPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantconsolidation.InterpolantGeneratorWithConsolidation;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class CodeCheckObserver
implements IUnmanagedObserver {
    private static final boolean OUTPUT_HOARE_ANNOTATION = true;
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IPredicateUnifier mPredicateUnifier;
    private IIcfg<IcfgLocation> mOriginalRoot;
    private ImpRootNode mGraphRoot;
    private CodeCheckSettings mGlobalSettings;
    private CfgSmtToolkit mCsToolkit;
    private GraphWriter mGraphWriter;
    private Collection<IcfgLocation> mErrNodesOfAllProc;
    private boolean mLoopForever = true;
    private int mIterationsLimit = -1;
    private PredicateFactory mPredicateFactory;

    CodeCheckObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger("de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck");
    }

    private boolean initialize(IIcfg<IcfgLocation> iIcfg) {
        Object object;
        if (IcfgUtils.isConcurrent(iIcfg)) {
            throw new UnsupportedOperationException("Concurrent programs are currently unsupported");
        }
        this.readPreferencePage();
        this.mOriginalRoot = iIcfg;
        this.mCsToolkit = this.mOriginalRoot.getCfgSmtToolkit();
        this.mPredicateFactory = new PredicateFactory(this.mServices, this.mCsToolkit.getManagedScript(), this.mCsToolkit.getSymbolTable());
        this.mPredicateUnifier = this.mServices.getPreferenceProvider("de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck").getBoolean("Use predicate trie based predicate unification") ? new BPredicateUnifier(this.mServices, this.mLogger, this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mOriginalRoot.getCfgSmtToolkit().getSymbolTable()) : new PredicateUnifier(this.mLogger, this.mServices, this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mOriginalRoot.getCfgSmtToolkit().getSymbolTable(), SIMPLIFICATION_TECHNIQUE, new IPredicate[0]);
        Map map = this.mOriginalRoot.getProcedureErrorNodes();
        this.mErrNodesOfAllProc = new ArrayList<IcfgLocation>();
        for (Set set : map.values()) {
            this.mErrNodesOfAllProc.addAll(set);
        }
        this.mGraphWriter = new GraphWriter(this.mLogger, this.mGlobalSettings.getDotGraphPath(), true, true, true);
        boolean bl = this.mGlobalSettings.getUseAbstractInterpretation();
        Object object2 = null;
        if (bl) {
            object = this.mServices.getProgressMonitorService().getChildTimer(0.2);
            IAbstractInterpretationResult iAbstractInterpretationResult = AbstractInterpreter.runFuture(this.mOriginalRoot, (IProgressAwareTimer)object, (IUltimateServiceProvider)this.mServices, (boolean)false, (ILogger)this.mLogger);
            if (iAbstractInterpretationResult == null) {
                this.mLogger.warn((Object)"was not able to retrieve initial predicates from abstract interpretation --> wrong toolchain?? (using \"true\")");
            } else {
                object2 = iAbstractInterpretationResult.getLoc2Term().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
        }
        object = new RCFG2AnnotatedRCFG(this.mCsToolkit, this.mPredicateFactory, this.mLogger, this.mPredicateUnifier.getTruePredicate(), (Map<IcfgLocation, Term>)object2);
        this.mGraphRoot = ((RCFG2AnnotatedRCFG)object).convert(this.mOriginalRoot);
        this.removeSummaryEdges();
        this.mIterationsLimit = this.mGlobalSettings.getIterations();
        this.mLoopForever = this.mIterationsLimit == -1;
        return false;
    }

    private CodeChecker createCodeChecker() {
        IHoareTripleChecker iHoareTripleChecker = this.createHoareTripleChecker();
        if (this.mGlobalSettings.getChecker() == CodeCheckPreferenceInitializer.Checker.IMPULSE) {
            return new ImpulseChecker(this.mCsToolkit, this.mOriginalRoot, this.mGraphRoot, this.mGraphWriter, iHoareTripleChecker, this.mPredicateUnifier, this.mLogger, this.mGlobalSettings);
        }
        return new UltimateChecker(this.mCsToolkit, this.mOriginalRoot, this.mGraphRoot, this.mGraphWriter, iHoareTripleChecker, this.mPredicateUnifier, this.mLogger, this.mGlobalSettings);
    }

    private IHoareTripleChecker createHoareTripleChecker() {
        return HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.mServices, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)this.mCsToolkit, (IPredicateUnifier)this.mPredicateUnifier);
    }

    private void readPreferencePage() {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider("de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck");
        this.mGlobalSettings = new CodeCheckSettings();
        CodeCheckPreferenceInitializer.Checker checker = (CodeCheckPreferenceInitializer.Checker)iPreferenceProvider.getEnum("the checking algorithm to use", CodeCheckPreferenceInitializer.Checker.class);
        this.mGlobalSettings.setChecker(checker);
        this.mGlobalSettings.setMemoizeNormalEdgeChecks(iPreferenceProvider.getBoolean("memoize already made edge checks for non-return edges", true));
        this.mGlobalSettings.setMemoizeReturnEdgeChecks(iPreferenceProvider.getBoolean("memoize already made edge checks for return edges", true));
        this.mGlobalSettings.setInterpolationMode((InterpolationTechnique)iPreferenceProvider.getEnum("interpolation mode", InterpolationTechnique.class));
        this.mGlobalSettings.setUseInterpolantconsolidation(iPreferenceProvider.getBoolean("use interpolant consolidation (only useful for interpolationmode fp+bp)", false));
        this.mGlobalSettings.setPredicateUnification((CodeCheckPreferenceInitializer.PredicateUnification)iPreferenceProvider.getEnum("Predicate Unification Mode", CodeCheckPreferenceInitializer.PredicateUnification.class));
        this.mGlobalSettings.setEdgeCheckOptimization((CodeCheckPreferenceInitializer.EdgeCheckOptimization)iPreferenceProvider.getEnum("EdgeCheck Optimization Mode", CodeCheckPreferenceInitializer.EdgeCheckOptimization.class));
        this.mGlobalSettings.setIterations(iPreferenceProvider.getInt("Limit maxmium number of iterations. (-1 for no limitations)", -1));
        this.mGlobalSettings.setDotGraphPath(iPreferenceProvider.getString("write dot graph files here (empty for don't write)", ""));
        this.mGlobalSettings.setRedirectionStrategy((CodeCheckPreferenceInitializer.RedirectionStrategy)iPreferenceProvider.getEnum("The redirection strategy for Impulse", CodeCheckPreferenceInitializer.RedirectionStrategy.class));
        this.mGlobalSettings.setDefaultRedirection(iPreferenceProvider.getBoolean("Default Redirection", false));
        this.mGlobalSettings.setRemoveFalseNodes(iPreferenceProvider.getBoolean("Remove False Nodes Manually", false));
        this.mGlobalSettings.setCheckSatisfiability(iPreferenceProvider.getBoolean("Check edges satisfiability", false));
        this.mGlobalSettings.setUseSeparateSolverForTracechecks(iPreferenceProvider.getBoolean("Use separate solver for tracechecks", true));
        this.mGlobalSettings.setUseFallbackForSeparateSolverForTracechecks(iPreferenceProvider.getBoolean("Use standard solver (from RCFGBuilder) with FP interpolation as fallback", true));
        this.mGlobalSettings.setChooseSeparateSolverForTracechecks((SolverBuilder.SolverMode)iPreferenceProvider.getEnum("Choose which separate solver to use for tracechecks", SolverBuilder.SolverMode.class));
        this.mGlobalSettings.setSeparateSolverForTracechecksCommand(iPreferenceProvider.getString("Command for calling external solver", ""));
        this.mGlobalSettings.setSeparateSolverForTracechecksTheory(Logics.valueOf((String)iPreferenceProvider.getString("Theory for external solver", "QF_AUFLIA")));
        this.mGlobalSettings.setUseLiveVariables(iPreferenceProvider.getBoolean("Use live variables in FP/BP interpolation", true));
        this.mGlobalSettings.setUseUnsatCores((ITraceCheckPreferences.UnsatCores)iPreferenceProvider.getEnum("Use unsat cores in FP/BP interpolation", ITraceCheckPreferences.UnsatCores.class));
        this.mGlobalSettings.setUseAbstractInterpretation(iPreferenceProvider.getBoolean("Use predicates from abstract interpretation", false));
    }

    private void removeSummaryEdges() {
        ArrayDeque<AnnotatedProgramPoint> arrayDeque = new ArrayDeque<AnnotatedProgramPoint>();
        HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
        hashSet.add(this.mGraphRoot);
        arrayDeque.add(this.mGraphRoot);
        while (!arrayDeque.isEmpty()) {
            AnnotatedProgramPoint annotatedProgramPoint = (AnnotatedProgramPoint)((Object)arrayDeque.pop());
            for (AppEdge appEdge : new ArrayList(annotatedProgramPoint.getOutgoingEdges())) {
                AnnotatedProgramPoint annotatedProgramPoint2 = (AnnotatedProgramPoint)appEdge.getTarget();
                if (appEdge.getStatement() instanceof IIcfgSummaryTransition && ((IIcfgSummaryTransition)appEdge.getStatement()).calledProcedureHasImplementation()) {
                    appEdge.disconnect();
                }
                if (!hashSet.add(annotatedProgramPoint2)) continue;
                arrayDeque.add(annotatedProgramPoint2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean process(IElement iElement) {
        void var12_19;
        NWAEmptinessCheck nWAEmptinessCheck;
        if (!(iElement instanceof IIcfg)) {
            return false;
        }
        IIcfg iIcfg = (IIcfg)iElement;
        this.initialize((IIcfg<IcfgLocation>)iIcfg);
        ImpRootNode impRootNode = this.copyGraph(this.mGraphRoot);
        ArrayList<AnnotatedProgramPoint> arrayList = new ArrayList<AnnotatedProgramPoint>();
        for (AnnotatedProgramPoint annotatedProgramPoint : this.mGraphRoot.getOutgoingNodes()) {
            if (!annotatedProgramPoint.getProgramPoint().getProcedure().startsWith("ULTIMATE.start")) continue;
            arrayList.add(annotatedProgramPoint);
            break;
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(this.mGraphRoot.getOutgoingNodes());
        }
        boolean bl = true;
        boolean bl2 = false;
        IcfgProgramExecution icfgProgramExecution = null;
        CegarLoopStatisticsGenerator cegarLoopStatisticsGenerator = new CegarLoopStatisticsGenerator();
        cegarLoopStatisticsGenerator.start(CegarLoopStatisticsDefinitions.OverallTime.toString());
        int n = 0;
        InterpolatingTraceCheck<IIcfgTransition<IcfgLocation>> interpolatingTraceCheck = null;
        CodeChecker codeChecker = this.createCodeChecker();
        for (AnnotatedProgramPoint object2 : arrayList) {
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                bl2 = true;
                break;
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Exploring : " + String.valueOf((Object)object2)));
            }
            nWAEmptinessCheck = new NWAEmptinessCheck(this.mServices);
            while (this.mLoopForever || n < this.mIterationsLimit) {
                ManagedScript managedScript;
                SolverBuilder.SolverSettings solverSettings;
                IPredicate[] iPredicateArray;
                SolverBuilder.SolverMode solverMode;
                NestedRun<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> nestedRun;
                ++n;
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    bl2 = true;
                    break;
                }
                cegarLoopStatisticsGenerator.announceNextIteration();
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)String.format("Iterations = %d%n", n));
                }
                if ((nestedRun = nWAEmptinessCheck.checkForEmptiness(object2)) == null) {
                    this.mGraphWriter.writeGraphAsImage(object2, String.format("graph_%s_%s_noEP", this.mGraphWriter.getGraphCounter(), object2.toString().substring(0, 5)));
                    this.mLogger.warn((Object)("This Program is SAFE, Check terminated with " + n + " iterations."));
                    break;
                }
                this.mLogger.info((Object)"Error Path is FOUND.");
                this.mGraphWriter.writeGraphAsImage(object2, String.format("graph_%s_%s_foundEP", this.mGraphWriter.getGraphCounter(), object2.toString().substring(0, 5)), nestedRun.getStateSequence().toArray(new AnnotatedProgramPoint[0]));
                if (this.mGlobalSettings.isUseSeparateSolverForTracechecks()) {
                    solverMode = this.mGlobalSettings.getChooseSeparateSolverForTracechecks();
                    iPredicateArray = this.mGlobalSettings.getSeparateSolverForTracechecksCommand();
                    solverSettings = SolverBuilder.constructSolverSettings().setSolverMode(solverMode).setUseFakeIncrementalScript(false).setUseExternalSolver(!iPredicateArray.isEmpty(), (String)iPredicateArray, this.mGlobalSettings.getSeparateSolverForTracechecksTheory());
                    managedScript = this.mOriginalRoot.getCfgSmtToolkit().createFreshManagedScript(this.mServices, solverSettings, "TraceCheck_Iteration" + n);
                } else {
                    managedScript = this.mCsToolkit.getManagedScript();
                }
                interpolatingTraceCheck = this.createTraceCheck(nestedRun, managedScript);
                if (this.mGlobalSettings.isUseSeparateSolverForTracechecks()) {
                    managedScript.getScript().exit();
                }
                solverMode = interpolatingTraceCheck.isCorrect();
                cegarLoopStatisticsGenerator.addTraceCheckData((IStatisticsDataProvider)interpolatingTraceCheck.getStatistics());
                if (solverMode == Script.LBool.UNSAT) {
                    iPredicateArray = null;
                    if (this.mGlobalSettings.isUseInterpolantconsolidation()) {
                        try {
                            solverSettings = new InterpolantGeneratorWithConsolidation(this.mCsToolkit, this.mServices, this.mLogger, this.mPredicateFactory, interpolatingTraceCheck);
                            iPredicateArray = solverSettings.getInterpolants();
                        }
                        catch (AutomataOperationCanceledException automataOperationCanceledException) {
                            this.mLogger.error((Object)"Timeout during automata operation: ", (Throwable)automataOperationCanceledException);
                        }
                    } else {
                        iPredicateArray = interpolatingTraceCheck.getInterpolants();
                    }
                    codeChecker.codeCheck(nestedRun, iPredicateArray, object2);
                    cegarLoopStatisticsGenerator.addEdgeCheckerData(codeChecker.mEdgeChecker.getStatistics());
                    continue;
                }
                if (solverMode == Script.LBool.SAT) {
                    this.mLogger.warn((Object)("This program is UNSAFE, Check terminated with " + n + " iterations."));
                    bl = false;
                    if (interpolatingTraceCheck.providesRcfgProgramExecution()) {
                        icfgProgramExecution = interpolatingTraceCheck.getRcfgProgramExecution();
                        break;
                    }
                    icfgProgramExecution = TraceCheckUtils.computeSomeIcfgProgramExecutionWithoutValues((Word)nestedRun.getWord());
                    break;
                }
                assert (solverMode == Script.LBool.UNKNOWN);
                throw new UnsupportedOperationException("Solver said unknown");
            }
            this.mGraphRoot = this.copyGraph(impRootNode);
            if (!bl) break;
        }
        AbstractCegarLoop.Result result = AbstractCegarLoop.Result.UNKNOWN;
        if (!bl2) {
            if (bl) {
                AbstractCegarLoop.Result result2 = AbstractCegarLoop.Result.SAFE;
            } else {
                AbstractCegarLoop.Result result3 = AbstractCegarLoop.Result.UNSAFE;
            }
        } else {
            this.reportTimeoutResult(this.mErrNodesOfAllProc);
        }
        cegarLoopStatisticsGenerator.stop(CegarLoopStatisticsDefinitions.OverallTime.toString());
        cegarLoopStatisticsGenerator.addPredicateUnifierData(this.mPredicateUnifier.getPredicateUnifierBenchmark());
        Object object3 = new CodeCheckBenchmarks(this.mOriginalRoot);
        object3.aggregateBenchmarkData((IStatisticsDataProvider)cegarLoopStatisticsGenerator);
        this.reportBenchmark((ICsvProviderProvider)object3);
        if (var12_19 == AbstractCegarLoop.Result.SAFE) {
            this.reportPositiveResults(this.mErrNodesOfAllProc);
            this.createInvariantAndContractResults(arrayList, (IIcfg<IcfgLocation>)iIcfg, this.mServices.getBacktranslationService());
        } else if (var12_19 == AbstractCegarLoop.Result.UNSAFE) {
            this.reportCounterexampleResult(icfgProgramExecution);
        } else {
            nWAEmptinessCheck = new GenericResult("CodeCheck", "Unable to decide if program is safe!", "Unable to decide if program is safe!", IResultWithSeverity.Severity.INFO);
            this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck", (IResult)nWAEmptinessCheck);
        }
        return false;
    }

    private void createInvariantAndContractResults(List<AnnotatedProgramPoint> list, IIcfg<IcfgLocation> iIcfg, IBacktranslationService iBacktranslationService) {
        for (AnnotatedProgramPoint annotatedProgramPoint : list) {
            FloydHoareMapping<IcfgLocation> floydHoareMapping = this.computeHoareAnnotation(annotatedProgramPoint, iIcfg);
            FloydHoareUtils.writeHoareAnnotationToLogger(iIcfg, floydHoareMapping, (ILogger)this.mLogger, (boolean)true);
            ProofAnnotation.addProof(iIcfg, floydHoareMapping);
            FloydHoareUtils.createInvariantResults((String)"CodeCheck", iIcfg, floydHoareMapping, (IBacktranslationService)iBacktranslationService, this::reportResult);
            FloydHoareUtils.createProcedureContractResults((IUltimateServiceProvider)this.mServices, (String)"CodeCheck", iIcfg, floydHoareMapping, (IBacktranslationService)iBacktranslationService, this::reportResult);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InterpolatingTraceCheck<IIcfgTransition<IcfgLocation>> createTraceCheck(NestedRun<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> nestedRun, ManagedScript managedScript) {
        NestedWord nestedWord = nestedRun.getWord();
        Counterexample counterexample = new Counterexample((Word)nestedWord, TraceCheckUtils.getSequenceOfProgramPoints((Word)nestedWord));
        switch (this.mGlobalSettings.getInterpolationMode()) {
            case Craig_NestedInterpolation: 
            case Craig_TreeInterpolation: {
                try {
                    InterpolatingTraceCheckCraig interpolatingTraceCheckCraig = new InterpolatingTraceCheckCraig(this.mPredicateUnifier.getTruePredicate(), this.mPredicateUnifier.getFalsePredicate(), new TreeMap(), counterexample, this.mServices, this.mCsToolkit, managedScript, this.mPredicateFactory, this.mPredicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, true, true, this.mGlobalSettings.getInterpolationMode(), true, SIMPLIFICATION_TECHNIQUE, false);
                    if (!interpolatingTraceCheckCraig.getInterpolantComputationStatus().wasComputationSuccessful()) return new TraceCheckSpWp(this.mPredicateUnifier.getTruePredicate(), this.mPredicateUnifier.getFalsePredicate(), new TreeMap(), counterexample, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, true, this.mServices, true, this.mPredicateFactory, this.mPredicateUnifier, InterpolationTechnique.ForwardPredicates, this.mCsToolkit.getManagedScript(), SIMPLIFICATION_TECHNIQUE, true);
                    return interpolatingTraceCheckCraig;
                }
                catch (Exception exception) {
                    this.mLogger.error((Object)("First Tracecheck threw exception " + exception.getMessage()));
                    if (this.mGlobalSettings.isUseFallbackForSeparateSolverForTracechecks()) return new TraceCheckSpWp(this.mPredicateUnifier.getTruePredicate(), this.mPredicateUnifier.getFalsePredicate(), new TreeMap(), counterexample, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, true, this.mServices, true, this.mPredicateFactory, this.mPredicateUnifier, InterpolationTechnique.ForwardPredicates, this.mCsToolkit.getManagedScript(), SIMPLIFICATION_TECHNIQUE, true);
                    throw exception;
                }
            }
            case ForwardPredicates: 
            case BackwardPredicates: 
            case FPandBP: 
            case FPandBPonlyIfFpWasNotPerfect: {
                try {
                    return new TraceCheckSpWp(this.mPredicateUnifier.getTruePredicate(), this.mPredicateUnifier.getFalsePredicate(), new TreeMap(), counterexample, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, this.mGlobalSettings.getUseUnsatCores(), this.mGlobalSettings.isUseLiveVariables(), this.mServices, true, this.mPredicateFactory, this.mPredicateUnifier, this.mGlobalSettings.getInterpolationMode(), managedScript, SIMPLIFICATION_TECHNIQUE, true);
                }
                catch (Exception exception) {
                    if (this.mGlobalSettings.isUseFallbackForSeparateSolverForTracechecks()) return new TraceCheckSpWp(this.mPredicateUnifier.getTruePredicate(), this.mPredicateUnifier.getFalsePredicate(), new TreeMap(), counterexample, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, true, this.mServices, true, this.mPredicateFactory, this.mPredicateUnifier, this.mGlobalSettings.getInterpolationMode(), this.mCsToolkit.getManagedScript(), SIMPLIFICATION_TECHNIQUE, true);
                    throw exception;
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported interpolation mode: " + String.valueOf(this.mGlobalSettings.getInterpolationMode()));
    }

    private FloydHoareMapping<IcfgLocation> computeHoareAnnotation(AnnotatedProgramPoint annotatedProgramPoint2, IIcfg<IcfgLocation> iIcfg) {
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        Map<IcfgLocation, Set<AnnotatedProgramPoint>> map = CodeCheckObserver.computeProgramPointToAnnotatedProgramPoints(annotatedProgramPoint2);
        for (Map.Entry<IcfgLocation, Set<AnnotatedProgramPoint>> entry : map.entrySet()) {
            List list = entry.getValue().stream().map(annotatedProgramPoint -> annotatedProgramPoint.getPredicate().getFormula()).collect(Collectors.toList());
            Term term = SmtUtils.orWithExtendedLocalSimplification((Script)this.mCsToolkit.getManagedScript().getScript(), list);
            Term term2 = SmtUtils.simplify((ManagedScript)this.mCsToolkit.getManagedScript(), (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            hashMap.put(entry.getKey(), this.mPredicateUnifier.getOrConstructPredicate(term2));
        }
        return new FloydHoareMapping(PrePostConditionSpecification.forIcfg(iIcfg, (IPredicateUnifier)this.mPredicateUnifier), hashMap);
    }

    private static Map<IcfgLocation, Set<AnnotatedProgramPoint>> computeProgramPointToAnnotatedProgramPoints(AnnotatedProgramPoint annotatedProgramPoint) {
        HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
        ArrayDeque<AnnotatedProgramPoint> arrayDeque = new ArrayDeque<AnnotatedProgramPoint>();
        HashMap<IcfgLocation, Set<AnnotatedProgramPoint>> hashMap = new HashMap<IcfgLocation, Set<AnnotatedProgramPoint>>();
        arrayDeque.push(annotatedProgramPoint);
        while (!arrayDeque.isEmpty()) {
            AnnotatedProgramPoint annotatedProgramPoint2 = (AnnotatedProgramPoint)((Object)arrayDeque.pop());
            HashSet<AnnotatedProgramPoint> hashSet2 = (HashSet<AnnotatedProgramPoint>)hashMap.get(annotatedProgramPoint2.getProgramPoint());
            if (hashSet2 == null) {
                hashSet2 = new HashSet<AnnotatedProgramPoint>();
                hashMap.put(annotatedProgramPoint2.getProgramPoint(), hashSet2);
            }
            hashSet2.add(annotatedProgramPoint2);
            for (AppEdge appEdge : annotatedProgramPoint2.getOutgoingEdges()) {
                if (hashSet.contains(appEdge.getTarget())) continue;
                arrayDeque.push((AnnotatedProgramPoint)appEdge.getTarget());
                hashSet.add((AnnotatedProgramPoint)appEdge.getTarget());
            }
        }
        return hashMap;
    }

    public ImpRootNode copyGraph(ImpRootNode impRootNode) {
        AnnotatedProgramPoint annotatedProgramPoint;
        Object object;
        HashMap<AnnotatedProgramPoint, AnnotatedProgramPoint> hashMap = new HashMap<AnnotatedProgramPoint, AnnotatedProgramPoint>();
        ImpRootNode impRootNode2 = new ImpRootNode();
        hashMap.put(impRootNode, impRootNode2);
        ArrayDeque<AnnotatedProgramPoint> arrayDeque = new ArrayDeque<AnnotatedProgramPoint>(impRootNode.getOutgoingNodes());
        while (!arrayDeque.isEmpty()) {
            AnnotatedProgramPoint object2 = (AnnotatedProgramPoint)((Object)arrayDeque.pop());
            if (hashMap.containsKey((Object)object2)) continue;
            hashMap.put(object2, new AnnotatedProgramPoint(object2));
            List list = object2.getOutgoingNodes();
            object = list.iterator();
            while (object.hasNext()) {
                annotatedProgramPoint = (AnnotatedProgramPoint)((Object)object.next());
                if (hashMap.containsKey((Object)annotatedProgramPoint)) continue;
                arrayDeque.add(annotatedProgramPoint);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            annotatedProgramPoint = (AnnotatedProgramPoint)((Object)entry.getKey());
            object = (AnnotatedProgramPoint)((Object)entry.getValue());
            for (AppEdge appEdge : annotatedProgramPoint.getOutgoingEdges()) {
                if (appEdge instanceof AppHyperEdge) {
                    AppHyperEdge appHyperEdge = (AppHyperEdge)appEdge;
                    AnnotatedProgramPoint annotatedProgramPoint2 = (AnnotatedProgramPoint)((Object)hashMap.get((Object)appHyperEdge.getHier()));
                    if (annotatedProgramPoint2 == null) continue;
                    ((AnnotatedProgramPoint)((Object)object)).connectOutgoingReturn(annotatedProgramPoint2, (IIcfgReturnTransition)appHyperEdge.getStatement(), (AnnotatedProgramPoint)((Object)hashMap.get(appHyperEdge.getTarget())));
                    continue;
                }
                ((AnnotatedProgramPoint)((Object)object)).connectOutgoing(appEdge.getStatement(), (AnnotatedProgramPoint)((Object)hashMap.get(appEdge.getTarget())));
            }
        }
        return impRootNode2;
    }

    private <T> void reportBenchmark(ICsvProviderProvider<T> iCsvProviderProvider) {
        StatisticsResult statisticsResult = new StatisticsResult("CodeCheck", "Ultimate CodeCheck benchmark data", iCsvProviderProvider);
        this.reportResult((IResult)statisticsResult);
    }

    private void reportPositiveResults(Collection<IcfgLocation> collection) {
        if (!collection.isEmpty()) {
            for (IcfgLocation allSpecificationsHoldResult2 : collection) {
                PositiveResult positiveResult = new PositiveResult("CodeCheck", (IElement)allSpecificationsHoldResult2, this.mServices.getBacktranslationService());
                this.reportResult((IResult)positiveResult);
            }
        }
        AllSpecificationsHoldResult allSpecificationsHoldResult = AllSpecificationsHoldResult.createAllSpecificationsHoldResult((String)"CodeCheck", (int)collection.size());
        this.reportResult((IResult)allSpecificationsHoldResult);
        this.mLogger.info((Object)(allSpecificationsHoldResult.getShortDescription() + " " + allSpecificationsHoldResult.getLongDescription()));
    }

    private void reportCounterexampleResult(IcfgProgramExecution<IIcfgTransition<IcfgLocation>> icfgProgramExecution) {
        List list = UnprovabilityReason.getUnprovabilityReasons(icfgProgramExecution);
        if (!list.isEmpty()) {
            this.reportUnproveableResult(icfgProgramExecution, list);
            return;
        }
        this.reportResult((IResult)new CounterExampleResult((IElement)this.getErrorPP(icfgProgramExecution), "CodeCheck", this.mServices.getBacktranslationService(), icfgProgramExecution));
    }

    private void reportUnproveableResult(IcfgProgramExecution<IIcfgTransition<IcfgLocation>> icfgProgramExecution, List<UnprovabilityReason> list) {
        IcfgLocation icfgLocation = this.getErrorPP(icfgProgramExecution);
        this.reportResult((IResult)new UnprovableResult("CodeCheck", (IElement)icfgLocation, this.mServices.getBacktranslationService(), icfgProgramExecution, list));
    }

    public IcfgLocation getErrorPP(IcfgProgramExecution<IIcfgTransition<IcfgLocation>> icfgProgramExecution) {
        int n = icfgProgramExecution.getLength() - 1;
        IIcfgTransition iIcfgTransition = (IIcfgTransition)icfgProgramExecution.getTraceElement(n).getTraceElement();
        return iIcfgTransition.getTarget();
    }

    private void reportTimeoutResult(Collection<IcfgLocation> collection) {
        for (IcfgLocation icfgLocation : collection) {
            ILocation iLocation = ILocation.getAnnotation((IElement)icfgLocation);
            StringBuilder stringBuilder = new StringBuilder("Unable to prove that ").append(Check.getAnnotation((IElement)icfgLocation).getPositiveMessage());
            stringBuilder.append(" (line ").append(iLocation.getStartLine()).append(")");
            TimeoutResultAtElement timeoutResultAtElement = new TimeoutResultAtElement((IElement)icfgLocation, "CodeCheck", this.mServices.getBacktranslationService(), stringBuilder.toString());
            this.reportResult((IResult)timeoutResultAtElement);
        }
    }

    private void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck", iResult);
    }

    public ImpRootNode getRoot() {
        return this.mGraphRoot;
    }

    public void finish() {
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public boolean performedChanges() {
        return false;
    }
}

