/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.annotation;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LTLPropertyCheck
extends Check {
    private static final long serialVersionUID = 1L;
    private static final String KEY = LTLPropertyCheck.class.getSimpleName();
    @Visualizable
    private final String mUltimateLTLProptery;
    private final Map<String, CheckableExpression> mCheckableAtomicPropositions;
    private final List<VariableDeclaration> mGlobalDeclarations;
    private final String mLTL2BALTLProptery;

    public LTLPropertyCheck(String string, Map<String, CheckableExpression> map, List<VariableDeclaration> list) {
        super(Spec.LTL);
        assert (string != null) : "There is no property";
        assert (map != null) : "There is a property the map between APs and Boogie expressions is not there";
        assert (!map.isEmpty()) : "The map between APs and Boogie expressions is empty (remember, even true and false are Boogie expressions)";
        this.mUltimateLTLProptery = LTLPropertyCheck.prettyPrintProperty(map, string);
        this.mLTL2BALTLProptery = LTLPropertyCheck.getLTL2BAProperty(string);
        this.mCheckableAtomicPropositions = map;
        this.mGlobalDeclarations = list == null ? Collections.emptyList() : list;
    }

    public Map<String, CheckableExpression> getCheckableAtomicPropositions() {
        return this.mCheckableAtomicPropositions;
    }

    public List<VariableDeclaration> getGlobalDeclarations() {
        return this.mGlobalDeclarations;
    }

    public String getUltimateLTLProperty() {
        return this.mUltimateLTLProptery;
    }

    public String getLTL2BALTLProperty() {
        return this.mLTL2BALTLProptery;
    }

    public String getNegativeMessage() {
        return "The LTL property " + this.mUltimateLTLProptery + " was violated.";
    }

    public String getPositiveMessage() {
        return "The LTL property " + this.mUltimateLTLProptery + " holds.";
    }

    private static String prettyPrintProperty(Map<String, CheckableExpression> map, String string) {
        String string2 = string;
        for (Map.Entry<String, CheckableExpression> entry : map.entrySet()) {
            string2 = string2.replaceAll(entry.getKey(), "(" + BoogiePrettyPrinter.print(entry.getValue().getExpression()) + ")");
        }
        return string2;
    }

    private static String getLTL2BAProperty(String string) {
        String string2 = string.toLowerCase();
        string2 = string2.replaceAll("\\bf\\b", " <> ");
        string2 = string2.replaceAll("\\bg\\b", " [] ");
        string2 = string2.replaceAll("\\bx\\b", " X ");
        string2 = string2.replaceAll("\\bu\\b", " U ");
        string2 = string2.replaceAll("\\br\\b", " V ");
        string2 = string2.replace("<==>", "<->");
        string2 = string2.replace("==>", "->");
        string2 = string2.replaceAll("\\s+", " ");
        return string2;
    }

    public void annotate(IElement iElement) {
        iElement.getPayload().getAnnotations().put(KEY, this);
    }

    public static LTLPropertyCheck getAnnotation(IElement iElement) {
        return (LTLPropertyCheck)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (LTLPropertyCheck)((Object)iAnnotations));
    }

    public static class CheckableExpression {
        private final Expression mExpression;
        private List<Statement> mStatements;

        public CheckableExpression(Expression expression, List<Statement> list) {
            assert (expression != null);
            this.mExpression = expression;
            this.mStatements = list;
        }

        public Expression getExpression() {
            return this.mExpression;
        }

        public List<Statement> getStatements() {
            if (this.mStatements == null) {
                this.mStatements = new ArrayList<Statement>(0);
            }
            return this.mStatements;
        }
    }
}

