/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class BinaryExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(BinaryExpression.class);
    Operator operator;
    Expression left;
    Expression right;

    public BinaryExpression(ILocation iLocation, Operator operator, Expression expression, Expression expression2) {
        super(iLocation);
        this.operator = operator;
        this.left = expression;
        this.right = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BinaryExpression: " + String.valueOf((Object)this);
    }

    public BinaryExpression(ILocation iLocation, IBoogieType iBoogieType, Operator operator, Expression expression, Expression expression2) {
        super(iLocation, iBoogieType);
        this.operator = operator;
        this.left = expression;
        this.right = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BinaryExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BinaryExpression").append('[');
        stringBuffer.append((Object)this.operator);
        stringBuffer.append(',').append((Object)this.left);
        stringBuffer.append(',').append((Object)this.right);
        return stringBuffer.append(']').toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.left);
        list.add(this.right);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.left != null) {
                this.left.accept(generatedBoogieAstVisitor);
            }
            if (this.right != null) {
                this.right.accept(generatedBoogieAstVisitor);
            }
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.left != null) {
            expression2 = this.left.accept(generatedBoogieAstTransformer);
        }
        Expression expression3 = null;
        if (this.right != null) {
            expression3 = this.right.accept(generatedBoogieAstTransformer);
        }
        if (this.left != expression2 || this.right != expression3) {
            return new BinaryExpression(this.loc, this.type, this.operator, expression2, expression3);
        }
        return this;
    }

    public static enum Operator {
        LOGICIFF,
        LOGICIMPLIES,
        LOGICAND,
        LOGICOR,
        COMPLT,
        COMPGT,
        COMPLEQ,
        COMPGEQ,
        COMPEQ,
        COMPNEQ,
        COMPPO,
        BITVECCONCAT,
        ARITHPLUS,
        ARITHMINUS,
        ARITHMUL,
        ARITHDIV,
        ARITHMOD;

    }
}

