/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Label
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Label.class);
    String name;
    NamedAttribute[] attributes;

    public Label(ILocation iLocation, String string) {
        super(iLocation);
        this.name = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Label: " + String.valueOf((Object)this);
    }

    public Label(ILocation iLocation, String string, NamedAttribute[] namedAttributeArray) {
        super(iLocation);
        this.name = string;
        this.attributes = namedAttributeArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Label: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Label").append('[');
        stringBuffer.append(this.name);
        stringBuffer.append(',');
        if (this.attributes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.attributes.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.attributes[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getName() {
        return this.name;
    }

    public NamedAttribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.attributes != null) {
            list.addAll(Arrays.asList(this.attributes));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.attributes != null) {
            NamedAttribute[] namedAttributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                NamedAttribute namedAttribute = namedAttributeArray[n2];
                namedAttribute.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<NamedAttribute> arrayList = new ArrayList<NamedAttribute>();
        if (this.attributes != null) {
            NamedAttribute[] namedAttributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                NamedAttribute namedAttribute = namedAttributeArray[n2];
                NamedAttribute namedAttribute2 = (NamedAttribute)namedAttribute.accept(generatedBoogieAstTransformer);
                bl = bl || namedAttribute2 != namedAttribute;
                arrayList.add(namedAttribute2);
                ++n2;
            }
        }
        if (bl) {
            return new Label(this.loc, this.name, arrayList.toArray(new NamedAttribute[0]));
        }
        return this;
    }
}

