/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.PEA2TCSConverter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public abstract class TCSWriter {
    protected String mFileName;
    protected PEA2TCSConverter mConverter;

    public PEA2TCSConverter getConverter() {
        return this.mConverter;
    }

    public void setConverter(PEA2TCSConverter pEA2TCSConverter) {
        this.mConverter = pEA2TCSConverter;
    }

    public TCSWriter(String string) {
        this.mFileName = string;
    }

    public abstract void write();

    protected void writeConjunction(CDD cDD, Writer writer) throws IOException {
        if (cDD == CDD.TRUE) {
            return;
        }
        if (cDD == CDD.FALSE) {
            throw new IllegalArgumentException("A constraint equal to false not allowed here");
        }
        int n = 0;
        while (n < cDD.getChilds().length) {
            if (cDD.getChilds()[n] != CDD.FALSE) {
                this.writeDecision(cDD.getDecision(), n, writer);
                this.writeAndDelimiter(writer);
                this.writeConjunction(cDD.getChilds()[n], writer);
            }
            ++n;
        }
    }

    protected abstract void writeAndDelimiter(Writer var1) throws IOException;

    protected abstract void writeDecision(Decision<?> var1, int var2, Writer var3) throws IOException;

    protected CDD processDeclarations(List<String> list, Map<String, String> map) {
        return CDD.TRUE;
    }
}

