/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.SingleUpdateNormalFormTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEquality;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TransFormulaLRWithArrayInformation {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final boolean mContainsArrays;
    static final String s_AuxArray = "auxArray";
    private final ManagedScript mScript;
    private HashRelation<Term, ArrayIndex> mArrayFirstGeneration2Indices;
    private final HashRelation<TermVariable, TermVariable> mArrayFirstGeneration2Instances;
    private final Map<ArrayIndex, ArrayIndex> mIndexInstance2IndexRepresentative = new HashMap<ArrayIndex, ArrayIndex>();
    private final List<List<ArrayUpdate>> mArrayUpdates;
    private final List<List<MultiDimensionalSelect>> mArrayReads;
    private final List<MultiDimensionalSelect> mAdditionalArrayReads = new ArrayList<MultiDimensionalSelect>();
    private final ArrayGenealogy[] mArrayGenealogy;
    private final Term[] sunnf;
    private final List<List<ArrayEquality>> mArrayEqualities;
    private final ModifiableTransFormula mTransFormulaLR;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellInVars = new NestedMap2();
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellOutVars = new NestedMap2();
    private Map<Term, Term> mInVars2OutVars;
    private Map<Term, Term> mOutVars2InVars;

    public TransFormulaLRWithArrayInformation(IUltimateServiceProvider iUltimateServiceProvider, ModifiableTransFormula modifiableTransFormula, ReplacementVarFactory replacementVarFactory, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, TransFormulaLRWithArrayInformation transFormulaLRWithArrayInformation, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mSimplificationTechnique = simplificationTechnique;
        this.mTransFormulaLR = modifiableTransFormula;
        this.mScript = managedScript;
        this.mReplacementVarFactory = replacementVarFactory;
        if (!SmtUtils.containsArrayVariables((Term[])new Term[]{this.mTransFormulaLR.getFormula()})) {
            this.mContainsArrays = false;
            this.sunnf = null;
            this.mArrayUpdates = null;
            this.mArrayReads = null;
            this.mArrayEqualities = null;
            this.mArrayGenealogy = null;
            this.mArrayFirstGeneration2Instances = null;
        } else {
            this.mContainsArrays = true;
            Term term = SmtUtils.simplify((ManagedScript)this.mScript, (Term)this.mTransFormulaLR.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            Term term2 = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)term);
            term2 = SmtUtils.simplify((ManagedScript)this.mScript, (Term)term2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            Term[] termArray = SmtUtils.getDisjuncts((Term)term2);
            this.sunnf = new Term[termArray.length];
            this.mArrayUpdates = new ArrayList<List<ArrayUpdate>>(termArray.length);
            this.mArrayReads = new ArrayList<List<MultiDimensionalSelect>>(termArray.length);
            this.mArrayEqualities = new ArrayList<List<ArrayEquality>>(termArray.length);
            this.mArrayGenealogy = new ArrayGenealogy[termArray.length];
            SingleUpdateNormalFormTransformer.FreshAuxVarGenerator freshAuxVarGenerator = new SingleUpdateNormalFormTransformer.FreshAuxVarGenerator(this.mReplacementVarFactory);
            SingleUpdateNormalFormTransformer[] singleUpdateNormalFormTransformerArray = new SingleUpdateNormalFormTransformer[termArray.length];
            int n = 0;
            while (n < termArray.length) {
                Term[] termArray2 = SmtUtils.getConjuncts((Term)termArray[n]);
                ArrayEquality.ArrayEqualityExtractor arrayEqualityExtractor = new ArrayEquality.ArrayEqualityExtractor(termArray2);
                this.mArrayEqualities.add(arrayEqualityExtractor.getArrayEqualities());
                singleUpdateNormalFormTransformerArray[n] = new SingleUpdateNormalFormTransformer(SmtUtils.and((Script)this.mScript.getScript(), (Term[])arrayEqualityExtractor.getRemainingTerms().toArray(new Term[0])), this.mScript.getScript(), freshAuxVarGenerator);
                this.mArrayUpdates.add(singleUpdateNormalFormTransformerArray[n].getArrayUpdates());
                this.sunnf[n] = singleUpdateNormalFormTransformerArray[n].getRemainderTerm();
                this.mArrayReads.add(this.extractArrayReads(singleUpdateNormalFormTransformerArray[n].getArrayUpdates(), singleUpdateNormalFormTransformerArray[n].getRemainderTerm()));
                this.mArrayGenealogy[n] = new ArrayGenealogy(this.mTransFormulaLR, this.mArrayEqualities.get(n), this.mArrayUpdates.get(n), this.mArrayReads.get(n));
                ++n;
            }
            assert (this.checkSunftranformation(iUltimateServiceProvider, this.mLogger, this.mScript, iIcfgSymbolTable, this.mArrayEqualities, singleUpdateNormalFormTransformerArray)) : "error in sunftransformation";
            this.constructSubstitutions();
            HashRelation<TermVariable, ArrayIndex> hashRelation = transFormulaLRWithArrayInformation == null ? null : this.computeForeignIndices(transFormulaLRWithArrayInformation);
            new IndexCollector(this.mTransFormulaLR, hashRelation);
            this.mArrayFirstGeneration2Instances = this.computeArrayFirstGeneration2Instances();
            this.computeInVarAndOutVarArrayCells();
        }
    }

    private boolean checkSunftranformation(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, List<List<ArrayEquality>> list, SingleUpdateNormalFormTransformer[] singleUpdateNormalFormTransformerArray) {
        ModifiableTransFormula modifiableTransFormula = TransFormulaLRWithArrayInformation.constructTransFormulaLRWInSunf(iUltimateServiceProvider, this.mSimplificationTechnique, iLogger, managedScript, this.mReplacementVarFactory, this.mScript.getScript(), this.mTransFormulaLR, list, singleUpdateNormalFormTransformerArray);
        Script.LBool lBool = ModifiableTransFormulaUtils.implies((IUltimateServiceProvider)this.mServices, (ILogger)this.mLogger, (ModifiableTransFormula)this.mTransFormulaLR, (ModifiableTransFormula)modifiableTransFormula, (ManagedScript)this.mScript, (IIcfgSymbolTable)iIcfgSymbolTable);
        if (lBool != Script.LBool.SAT && lBool != Script.LBool.UNSAT) {
            iLogger.warn((Object)("result of sunf transformation notStronger check is " + String.valueOf(lBool)));
        }
        assert (lBool != Script.LBool.SAT) : "result of sunf transformation too strong";
        Script.LBool lBool2 = ModifiableTransFormulaUtils.implies((IUltimateServiceProvider)this.mServices, (ILogger)this.mLogger, (ModifiableTransFormula)modifiableTransFormula, (ModifiableTransFormula)this.mTransFormulaLR, (ManagedScript)this.mScript, (IIcfgSymbolTable)iIcfgSymbolTable);
        if (lBool2 != Script.LBool.SAT && lBool2 != Script.LBool.UNSAT) {
            iLogger.warn((Object)("result of sunf transformation notWeaker check is " + String.valueOf(lBool2)));
        }
        assert (lBool2 != Script.LBool.SAT) : "result of sunf transformation too weak";
        return lBool != Script.LBool.SAT && lBool2 != Script.LBool.SAT;
    }

    private HashRelation<TermVariable, ArrayIndex> computeForeignIndices(TransFormulaLRWithArrayInformation transFormulaLRWithArrayInformation) {
        HashRelation hashRelation = new HashRelation();
        for (Triple triple : transFormulaLRWithArrayInformation.getArrayCellOutVars().entrySet()) {
            ArrayCellReplacementVarInformation arrayCellReplacementVarInformation = (ArrayCellReplacementVarInformation)triple.getThird();
            IProgramVar iProgramVar = arrayCellReplacementVarInformation.getArrayRankVar();
            TermVariable termVariable = (TermVariable)this.mTransFormulaLR.getInVars().get(iProgramVar);
            if (termVariable == null) continue;
            ArrayIndex arrayIndex = this.computeForeignIndex(iProgramVar, arrayCellReplacementVarInformation.getIndex(), arrayCellReplacementVarInformation.termVariableToRankVarMappingForIndex());
            assert (ModifiableTransFormulaUtils.allVariablesAreInVars((List)arrayIndex, (ModifiableTransFormula)this.mTransFormulaLR));
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Adding foreign index " + String.valueOf(arrayIndex) + " for array " + String.valueOf(termVariable)));
            }
            hashRelation.addPair((Object)termVariable, (Object)arrayIndex);
        }
        return hashRelation;
    }

    private ArrayIndex computeForeignIndex(IProgramVar iProgramVar, ArrayIndex arrayIndex, Map<TermVariable, IProgramVar> map) {
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        for (Map.Entry<TermVariable, IProgramVar> arrayIndex22 : map.entrySet()) {
            if (!this.mTransFormulaLR.getInVars().containsKey(arrayIndex22.getValue())) {
                this.addForeignInVarAndOutVar(arrayIndex22.getValue());
            }
            TermVariable termVariable = (TermVariable)this.mTransFormulaLR.getInVars().get(arrayIndex22.getValue());
            hashMap.put((Term)arrayIndex22.getKey(), termVariable);
        }
        ArrayIndex arrayIndex2 = arrayIndex.applySubstitution(this.mScript, hashMap);
        return arrayIndex2;
    }

    private void addForeignInVarAndOutVar(IProgramVar iProgramVar) {
        String string = iProgramVar.getGloballyUniqueId() + "_ForeignInOutVar";
        Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)iProgramVar).getSort();
        TermVariable termVariable = this.mScript.constructFreshTermVariable(string, sort);
        assert (!this.mTransFormulaLR.getInVars().containsKey(iProgramVar));
        this.mTransFormulaLR.addInVar(iProgramVar, termVariable);
        assert (!this.mTransFormulaLR.getOutVars().containsKey(iProgramVar));
        this.mTransFormulaLR.addOutVar(iProgramVar, termVariable);
    }

    public boolean containsArrays() {
        return this.mContainsArrays;
    }

    private HashRelation<TermVariable, TermVariable> computeArrayFirstGeneration2Instances() {
        HashRelation hashRelation = new HashRelation();
        int n = 0;
        while (n < this.numberOfDisjuncts()) {
            for (TermVariable termVariable : this.mArrayGenealogy[n].getInstances()) {
                TermVariable termVariable2 = this.mArrayGenealogy[n].getProgenitor(termVariable);
                hashRelation.addPair((Object)termVariable2, (Object)termVariable);
            }
            ++n;
        }
        return hashRelation;
    }

    public HashRelation<Term, ArrayIndex> getArrayFirstGeneration2Indices() {
        return this.mArrayFirstGeneration2Indices;
    }

    public HashRelation<TermVariable, TermVariable> getArrayFirstGeneration2Instances() {
        return this.mArrayFirstGeneration2Instances;
    }

    public List<List<ArrayUpdate>> getArrayUpdates() {
        return this.mArrayUpdates;
    }

    public List<List<MultiDimensionalSelect>> getArrayReads() {
        return this.mArrayReads;
    }

    public List<MultiDimensionalSelect> getAdditionalArrayReads() {
        return this.mAdditionalArrayReads;
    }

    public List<List<ArrayEquality>> getArrayEqualities() {
        return this.mArrayEqualities;
    }

    public int numberOfDisjuncts() {
        return this.sunnf.length;
    }

    public Term[] getSunnf() {
        return this.sunnf;
    }

    public ModifiableTransFormula getTransFormulaLR() {
        return this.mTransFormulaLR;
    }

    public ArrayIndex getOrConstructIndexRepresentative(ArrayIndex arrayIndex) {
        ArrayIndex arrayIndex2 = this.mIndexInstance2IndexRepresentative.get(arrayIndex);
        if (arrayIndex2 == null) {
            arrayIndex2 = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions((ManagedScript)this.mScript, (ModifiableTransFormula)this.mTransFormulaLR, (List)arrayIndex));
            this.mIndexInstance2IndexRepresentative.put(arrayIndex, arrayIndex2);
        }
        return arrayIndex2;
    }

    private List<MultiDimensionalSelect> extractArrayReads(List<ArrayUpdate> list, Term term) {
        ArrayList<MultiDimensionalSelect> arrayList = new ArrayList<MultiDimensionalSelect>();
        for (ArrayUpdate arrayUpdate : list) {
            for (Term term2 : arrayUpdate.getIndex()) {
                arrayList.addAll(MultiDimensionalSelect.extractSelectDeep((Term)term2));
            }
            arrayList.addAll(MultiDimensionalSelect.extractSelectDeep((Term)arrayUpdate.getValue()));
        }
        arrayList.addAll(MultiDimensionalSelect.extractSelectDeep((Term)term));
        return arrayList;
    }

    private void constructSubstitutions() {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        HashMap<Term, Term> hashMap2 = new HashMap<Term, Term>();
        for (IProgramVar iProgramVar : this.mTransFormulaLR.getInVars().keySet()) {
            Term term = (Term)this.mTransFormulaLR.getInVars().get(iProgramVar);
            assert (term != null);
            Term term2 = (Term)this.mTransFormulaLR.getOutVars().get(iProgramVar);
            assert (term2 != null);
            hashMap.put(term, term2);
            hashMap2.put(term2, term);
        }
        this.mInVars2OutVars = hashMap;
        this.mOutVars2InVars = hashMap2;
    }

    public void computeInVarAndOutVarArrayCells() {
        for (TermVariable termVariable : this.getArrayFirstGeneration2Instances().getDomain()) {
            for (TermVariable termVariable2 : this.getArrayFirstGeneration2Instances().getImage((Object)termVariable)) {
                Set set = this.getArrayFirstGeneration2Indices().getImage((Object)termVariable);
                if (set == null) {
                    this.mLogger.info((Object)("Array " + String.valueOf(termVariable) + " is never accessed"));
                    continue;
                }
                for (ArrayIndex arrayIndex : set) {
                    boolean bl = this.requiresRepVar(termVariable2, arrayIndex);
                    if (!bl) continue;
                    TermVariable termVariable3 = (TermVariable)ModifiableTransFormulaUtils.getDefinition((ModifiableTransFormula)this.mTransFormulaLR, (TermVariable)termVariable2);
                    ArrayIndex arrayIndex2 = this.getOrConstructIndexRepresentative(arrayIndex);
                    TermVariable termVariable4 = this.computeInVarInstance(termVariable2);
                    assert (this.getTransFormulaLR().getInVarsReverseMapping().containsKey(termVariable4));
                    ArrayIndex arrayIndex3 = this.computeInVarIndex(arrayIndex);
                    assert (ModifiableTransFormulaUtils.allVariablesAreInVars((List)arrayIndex3, (ModifiableTransFormula)this.getTransFormulaLR()));
                    ArrayCellReplacementVarInformation arrayCellReplacementVarInformation = new ArrayCellReplacementVarInformation(termVariable4, termVariable3, arrayIndex3, arrayIndex2, ArrayCellReplacementVarInformation.VarType.InVar, this.getTransFormulaLR());
                    this.mArrayCellInVars.put((Object)termVariable3, (Object)arrayIndex2, (Object)arrayCellReplacementVarInformation);
                    termVariable4 = this.computeOutVarInstance(termVariable2);
                    assert (this.getTransFormulaLR().getOutVarsReverseMapping().containsKey(termVariable4));
                    arrayIndex3 = this.computeOutVarIndex(arrayIndex);
                    assert (ModifiableTransFormulaUtils.allVariablesAreOutVars((List)arrayIndex3, (ModifiableTransFormula)this.getTransFormulaLR()));
                    arrayCellReplacementVarInformation = new ArrayCellReplacementVarInformation(termVariable4, termVariable3, arrayIndex3, arrayIndex2, ArrayCellReplacementVarInformation.VarType.OutVar, this.getTransFormulaLR());
                    this.mArrayCellOutVars.put((Object)termVariable3, (Object)arrayIndex2, (Object)arrayCellReplacementVarInformation);
                }
            }
        }
    }

    private ArrayIndex computeInVarIndex(ArrayIndex arrayIndex) {
        return arrayIndex.applySubstitution(this.mScript, this.mOutVars2InVars);
    }

    private ArrayIndex computeOutVarIndex(ArrayIndex arrayIndex) {
        return arrayIndex.applySubstitution(this.mScript, this.mInVars2OutVars);
    }

    private TermVariable computeInVarInstance(TermVariable termVariable) {
        if (this.mInVars2OutVars.containsKey(termVariable)) {
            return termVariable;
        }
        TermVariable termVariable2 = (TermVariable)this.mOutVars2InVars.get(termVariable);
        if (termVariable2 == null) {
            throw new AssertionError((Object)"Neither inVar nor outVar");
        }
        return termVariable2;
    }

    private TermVariable computeOutVarInstance(TermVariable termVariable) {
        if (this.mOutVars2InVars.containsKey(termVariable)) {
            return termVariable;
        }
        TermVariable termVariable2 = (TermVariable)this.mInVars2OutVars.get(termVariable);
        if (termVariable2 == null) {
            throw new AssertionError((Object)"Neither inVar nor outVar");
        }
        return termVariable2;
    }

    public NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> getArrayCellInVars() {
        return this.mArrayCellInVars;
    }

    public NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> getArrayCellOutVars() {
        return this.mArrayCellOutVars;
    }

    public boolean requiresRepVar(TermVariable termVariable, ArrayIndex arrayIndex) {
        if (this.getTransFormulaLR().getOutVarsReverseMapping().containsKey(termVariable) || this.getTransFormulaLR().getInVarsReverseMapping().containsKey(termVariable)) {
            return ModifiableTransFormulaUtils.allVariablesAreVisible((List)arrayIndex, (ModifiableTransFormula)this.getTransFormulaLR());
        }
        return false;
    }

    public boolean isInVarCell(TermVariable termVariable, ArrayIndex arrayIndex) {
        if (ModifiableTransFormulaUtils.isInVar((TermVariable)termVariable, (ModifiableTransFormula)this.getTransFormulaLR())) {
            return ModifiableTransFormulaUtils.allVariablesAreInVars((List)arrayIndex, (ModifiableTransFormula)this.getTransFormulaLR());
        }
        return false;
    }

    public boolean isOutVarCell(TermVariable termVariable, ArrayIndex arrayIndex) {
        if (ModifiableTransFormulaUtils.isOutVar((TermVariable)termVariable, (ModifiableTransFormula)this.getTransFormulaLR())) {
            return ModifiableTransFormulaUtils.allVariablesAreOutVars((List)arrayIndex, (ModifiableTransFormula)this.getTransFormulaLR());
        }
        return false;
    }

    private static ModifiableTransFormula constructTransFormulaLRWInSunf(IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique, ILogger iLogger, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory, Script script, ModifiableTransFormula modifiableTransFormula, List<List<ArrayEquality>> list, SingleUpdateNormalFormTransformer ... singleUpdateNormalFormTransformerArray) {
        ModifiableTransFormula modifiableTransFormula2 = new ModifiableTransFormula(modifiableTransFormula);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        assert (list.size() == singleUpdateNormalFormTransformerArray.length);
        int n = 0;
        while (n < singleUpdateNormalFormTransformerArray.length) {
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            for (ArrayUpdate arrayUpdate : singleUpdateNormalFormTransformerArray[n].getArrayUpdates()) {
                arrayList2.add(arrayUpdate.getArrayUpdateTerm());
            }
            for (ArrayEquality arrayEquality : list.get(n)) {
                arrayList2.add(arrayEquality.getOriginalTerm());
            }
            arrayList2.add(singleUpdateNormalFormTransformerArray[n].getRemainderTerm());
            Term term = SmtUtils.and((Script)script, arrayList2);
            HashSet<TermVariable> hashSet = new HashSet<TermVariable>(singleUpdateNormalFormTransformerArray[n].getAuxVars());
            Term arrayUpdate2 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            arrayList.add(arrayUpdate2);
            modifiableTransFormula2.addAuxVars((Set)hashSet);
            ++n;
        }
        Term term = SmtUtils.or((Script)script, arrayList);
        modifiableTransFormula2.setFormula(term);
        return modifiableTransFormula2;
    }

    private class ArrayGenealogy {
        Map<ArrayGeneration, ArrayGeneration> mGeneration2OriginalGeneration = new HashMap<ArrayGeneration, ArrayGeneration>();
        Map<TermVariable, TermVariable> mInstance2Representative = new HashMap<TermVariable, TermVariable>();
        Map<ArrayGeneration, ArrayGeneration> mParentGeneration = new HashMap<ArrayGeneration, ArrayGeneration>();
        Map<TermVariable, ArrayGeneration> mArray2Generation = new HashMap<TermVariable, ArrayGeneration>();
        List<ArrayGeneration> mArrayGenerations = new ArrayList<ArrayGeneration>();
        private final ModifiableTransFormula mTransFormula;

        private ArrayGeneration getOrConstructArrayGeneration(TermVariable termVariable) {
            ArrayGeneration arrayGeneration = this.mArray2Generation.get(termVariable);
            if (arrayGeneration == null) {
                arrayGeneration = new ArrayGeneration(this.mTransFormula, termVariable);
                this.mArrayGenerations.add(arrayGeneration);
            }
            return arrayGeneration;
        }

        ArrayGenealogy(ModifiableTransFormula modifiableTransFormula, List<ArrayEquality> list, List<ArrayUpdate> list2, List<MultiDimensionalSelect> list3) {
            Object object5;
            Object object2;
            this.mTransFormula = modifiableTransFormula;
            UnionFind unionFind = new UnionFind();
            for (ArrayEquality object3 : list) {
                TermVariable termVariable;
                object2 = object3.getLhsTermVariable();
                object5 = object3.getRhsTermVariable();
                Object object4 = (TermVariable)unionFind.find(object2);
                if (object4 == null) {
                    unionFind.makeEquivalenceClass(object2);
                    object4 = object2;
                }
                if ((termVariable = (TermVariable)unionFind.find(object5)) == null) {
                    unionFind.makeEquivalenceClass(object5);
                    termVariable = object5;
                }
                unionFind.union(object4, (Object)termVariable);
            }
            for (TermVariable termVariable : unionFind.getAllRepresentatives()) {
                object2 = this.getOrConstructArrayGeneration(termVariable);
                for (Object object5 : unionFind.getEquivalenceClassMembers((Object)termVariable)) {
                    if (object5 == termVariable) continue;
                    ((ArrayGeneration)object2).add((TermVariable)object5);
                }
            }
            for (ArrayUpdate arrayUpdate : list2) {
                object2 = this.getOrConstructArrayGeneration((TermVariable)arrayUpdate.getOldArray());
                if (object2 == (object5 = this.getOrConstructArrayGeneration(arrayUpdate.getNewArray()))) {
                    TransFormulaLRWithArrayInformation.this.mLogger.warn((Object)"self update, this is not tested very well ");
                    continue;
                }
                this.putParentGeneration((ArrayGeneration)object5, (ArrayGeneration)object2);
            }
            for (ArrayGeneration arrayGeneration : this.mArrayGenerations) {
                object2 = this.getFirstGeneration(arrayGeneration);
                this.putInstance2FirstGeneration(arrayGeneration, (ArrayGeneration)object2);
            }
            for (MultiDimensionalSelect multiDimensionalSelect : list3) {
                this.determineRepresentative((TermVariable)multiDimensionalSelect.getArray());
            }
            for (ArrayEquality arrayEquality : list) {
                this.determineRepresentative(arrayEquality.getLhsTermVariable());
                this.determineRepresentative(arrayEquality.getRhsTermVariable());
            }
            for (ArrayUpdate arrayUpdate : list2) {
                this.determineRepresentative(arrayUpdate.getNewArray());
                this.determineRepresentative((TermVariable)arrayUpdate.getOldArray());
            }
        }

        private void determineRepresentative(TermVariable termVariable) {
            if (this.mInstance2Representative.containsKey(termVariable)) {
                return;
            }
            ArrayGeneration arrayGeneration = this.mArray2Generation.get(termVariable);
            if (arrayGeneration == null) {
                this.mInstance2Representative.put(termVariable, termVariable);
            } else {
                ArrayGeneration arrayGeneration2 = this.mGeneration2OriginalGeneration.get(arrayGeneration);
                assert (arrayGeneration2 != null) : "no original generation!";
                TermVariable termVariable2 = arrayGeneration2.getRepresentative();
                if (ModifiableTransFormulaUtils.isInVar((TermVariable)termVariable2, (ModifiableTransFormula)this.mTransFormula)) {
                    this.mInstance2Representative.put(termVariable, termVariable2);
                } else {
                    throw new AssertionError((Object)"no invar");
                }
            }
        }

        private void putParentGeneration(ArrayGeneration arrayGeneration, ArrayGeneration arrayGeneration2) {
            assert (arrayGeneration != null);
            assert (arrayGeneration2 != null);
            assert (arrayGeneration != arrayGeneration2);
            assert (arrayGeneration.toString() != null);
            assert (arrayGeneration2.toString() != null);
            this.mParentGeneration.put(arrayGeneration, arrayGeneration2);
        }

        private void putInstance2FirstGeneration(ArrayGeneration arrayGeneration, ArrayGeneration arrayGeneration2) {
            assert (arrayGeneration != null);
            assert (arrayGeneration2 != null);
            assert (arrayGeneration.toString() != null);
            assert (arrayGeneration2.toString() != null);
            this.mGeneration2OriginalGeneration.put(arrayGeneration, arrayGeneration2);
        }

        private ArrayGeneration getFirstGeneration(ArrayGeneration arrayGeneration) {
            ArrayGeneration arrayGeneration2 = this.mParentGeneration.get(arrayGeneration);
            if (arrayGeneration2 == null) {
                return arrayGeneration;
            }
            return this.getFirstGeneration(arrayGeneration2);
        }

        public TermVariable getProgenitor(TermVariable termVariable) {
            return this.mInstance2Representative.get(termVariable);
        }

        public Set<TermVariable> getInstances() {
            return this.mInstance2Representative.keySet();
        }

        private class ArrayGeneration {
            private final Set<TermVariable> mArrays = new HashSet<TermVariable>();
            private TermVariable mRepresentative;
            private final ModifiableTransFormula mTransFormula;

            public ArrayGeneration(ModifiableTransFormula modifiableTransFormula, TermVariable termVariable) {
                this.mTransFormula = modifiableTransFormula;
                this.add(termVariable);
            }

            public TermVariable getRepresentative() {
                if (this.mRepresentative == null) {
                    this.determineRepresentative();
                }
                return this.mRepresentative;
            }

            private void determineRepresentative() {
                for (TermVariable termVariable : this.mArrays) {
                    if (!ModifiableTransFormulaUtils.isInVar((TermVariable)termVariable, (ModifiableTransFormula)this.mTransFormula)) continue;
                    this.mRepresentative = termVariable;
                    return;
                }
                this.mRepresentative = this.mArrays.iterator().next();
            }

            public void add(TermVariable termVariable) {
                ArrayGenealogy.this.mArray2Generation.put(termVariable, this);
                if (this.mRepresentative != null) {
                    throw new AssertionError((Object)"has already representative, cannot modify");
                }
                this.mArrays.add(termVariable);
            }

            public String toString() {
                return "ArrayGeneration [Arrays=" + String.valueOf(this.mArrays) + ", Representative=" + String.valueOf(this.mRepresentative) + "]";
            }
        }
    }

    private class IndexCollector {
        private final ModifiableTransFormula mTransFormula;

        public IndexCollector(ModifiableTransFormula modifiableTransFormula, HashRelation<TermVariable, ArrayIndex> hashRelation) {
            Object object;
            this.mTransFormula = modifiableTransFormula;
            TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices = new HashRelation();
            int n = 0;
            while (n < TransFormulaLRWithArrayInformation.this.sunnf.length) {
                ArrayIndex arrayIndex;
                for (ArrayUpdate arrayUpdate : TransFormulaLRWithArrayInformation.this.mArrayUpdates.get(n)) {
                    object = TransFormulaLRWithArrayInformation.this.mArrayGenealogy[n].getProgenitor((TermVariable)arrayUpdate.getOldArray());
                    arrayIndex = arrayUpdate.getIndex();
                    this.addFirstGenerationIndexPair((TermVariable)object, arrayIndex);
                }
                for (MultiDimensionalSelect multiDimensionalSelect : TransFormulaLRWithArrayInformation.this.mArrayReads.get(n)) {
                    object = TransFormulaLRWithArrayInformation.this.mArrayGenealogy[n].getProgenitor((TermVariable)multiDimensionalSelect.getArray());
                    arrayIndex = multiDimensionalSelect.getIndex();
                    this.addFirstGenerationIndexPair((TermVariable)object, arrayIndex);
                }
                ++n;
            }
            if (hashRelation != null) {
                for (TermVariable termVariable : hashRelation.getDomain()) {
                    TermVariable termVariable2 = null;
                    ArrayGenealogy[] arrayGenealogyArray = TransFormulaLRWithArrayInformation.this.mArrayGenealogy;
                    int n2 = TransFormulaLRWithArrayInformation.this.mArrayGenealogy.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        object = arrayGenealogyArray[n3];
                        termVariable2 = ((ArrayGenealogy)object).getProgenitor(termVariable);
                        if (termVariable2 != null) break;
                        ++n3;
                    }
                    if (termVariable2 == null) {
                        TransFormulaLRWithArrayInformation.this.mLogger.warn((Object)(String.valueOf(termVariable) + " has no progenitor"));
                    }
                    object = hashRelation.getImage((Object)termVariable);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ArrayIndex arrayIndex = (ArrayIndex)iterator.next();
                        this.addFirstGenerationIndexPair(termVariable2, arrayIndex);
                    }
                }
            }
        }

        private boolean occursInArrayEqualities(TermVariable termVariable) {
            for (List<ArrayEquality> list : TransFormulaLRWithArrayInformation.this.mArrayEqualities) {
                for (ArrayEquality arrayEquality : list) {
                    if (arrayEquality.getLhsTermVariable() == termVariable) {
                        return true;
                    }
                    if (arrayEquality.getRhsTermVariable() != termVariable) continue;
                    return true;
                }
            }
            return false;
        }

        private void addFirstGenerationIndexPair(TermVariable termVariable, ArrayIndex arrayIndex) {
            TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices.addPair((Object)termVariable, (Object)arrayIndex);
            if (TransFormulaLRWithArrayInformation.this.mTransFormulaLR.getInVarsReverseMapping().containsKey(termVariable)) {
                ArrayIndex arrayIndex2;
                Function<Term, Term> function;
                if (ModifiableTransFormulaUtils.allVariablesAreInVars((List)arrayIndex, (ModifiableTransFormula)TransFormulaLRWithArrayInformation.this.getTransFormulaLR())) {
                    function = term -> Substitution.apply((ManagedScript)TransFormulaLRWithArrayInformation.this.mScript, TransFormulaLRWithArrayInformation.this.mInVars2OutVars, (Term)term);
                    arrayIndex2 = new ArrayIndex(arrayIndex.stream().map(function).collect(Collectors.toList()));
                    TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices.addPair((Object)termVariable, (Object)arrayIndex2);
                    TransFormulaLRWithArrayInformation.this.mAdditionalArrayReads.addAll(this.extractArrayReads((List<Term>)arrayIndex2));
                }
                if (ModifiableTransFormulaUtils.allVariablesAreOutVars((List)arrayIndex, (ModifiableTransFormula)TransFormulaLRWithArrayInformation.this.getTransFormulaLR())) {
                    function = term -> Substitution.apply((ManagedScript)TransFormulaLRWithArrayInformation.this.mScript, TransFormulaLRWithArrayInformation.this.mOutVars2InVars, (Term)term);
                    arrayIndex2 = new ArrayIndex(arrayIndex.stream().map(function).collect(Collectors.toList()));
                    TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices.addPair((Object)termVariable, (Object)arrayIndex2);
                    TransFormulaLRWithArrayInformation.this.mAdditionalArrayReads.addAll(this.extractArrayReads((List<Term>)arrayIndex2));
                }
            }
        }

        private boolean allVariablesOccurInFormula(ArrayIndex arrayIndex, ModifiableTransFormula modifiableTransFormula) {
            HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(modifiableTransFormula.getFormula().getFreeVars()));
            for (Term term : arrayIndex) {
                TermVariable[] termVariableArray = term.getFreeVars();
                int n = termVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TermVariable termVariable = termVariableArray[n2];
                    if (!hashSet.contains(termVariable)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private List<MultiDimensionalSelect> extractArrayReads(List<Term> list) {
            ArrayList<MultiDimensionalSelect> arrayList = new ArrayList<MultiDimensionalSelect>();
            for (Term term : list) {
                arrayList.addAll(MultiDimensionalSelect.extractSelectDeep((Term)term));
            }
            return arrayList;
        }
    }
}

