/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;

public class SupportingInvariant
extends AffineFunction {
    private static final long serialVersionUID = -8409937196513651751L;
    public boolean strict;

    public SupportingInvariant() {
    }

    public SupportingInvariant(AffineFunction affineFunction) {
        this.mCoefficients.putAll(affineFunction.mCoefficients);
        this.mConstant = affineFunction.mConstant;
    }

    public boolean isFalse() {
        if (!this.mCoefficients.isEmpty()) {
            return false;
        }
        int n = this.mConstant.compareTo(BigInteger.ZERO);
        return n <= 0 && this.strict || n < 0 && !this.strict;
    }

    public boolean isTrue() {
        if (!this.mCoefficients.isEmpty()) {
            return false;
        }
        int n = this.mConstant.compareTo(BigInteger.ZERO);
        return n > 0 && this.strict || n >= 0 && !this.strict;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(this.strict ? " > 0" : " >= 0");
        return stringBuilder.toString();
    }

    @Override
    public Term asTerm(Script script) throws SMTLIBException {
        Term term = super.asTerm(script);
        return script.term(this.strict ? ">" : ">=", new Term[]{term, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
    }
}

