/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.MultiphaseRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiphaseTemplate
extends ComposableTemplate {
    public final int size;
    private static final String s_name_delta = "delta_";
    private static final String s_name_function = "rank_";
    private final Term[] mdeltas;
    private final AffineFunctionGenerator[] mfgens;

    public MultiphaseTemplate(int n) {
        assert (n > 1);
        this.size = n;
        this.mdeltas = new Term[this.size];
        this.mfgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        int n = 0;
        while (n < this.size) {
            this.mdeltas[n] = this.newDelta(s_name_delta + this.getInstanceNumber() + "_" + n);
            this.mfgens[n] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + this.getInstanceNumber() + "_" + n);
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.size + "-phase";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.size);
        stringBuilder.append("-phase template:\n   ");
        int n = 0;
        while (n < this.size) {
            stringBuilder.append(s_name_delta + n + " > 0\n/\\ ");
            ++n;
        }
        stringBuilder.append("( ");
        n = 0;
        while (n < this.size) {
            if (n > 0) {
                stringBuilder.append(" \\/ ");
            }
            stringBuilder.append("f_" + n + "(x) > 0");
            ++n;
        }
        stringBuilder.append(" )\n");
        n = 0;
        while (n < this.size) {
            stringBuilder.append("/\\ ");
            stringBuilder.append(n > 0 ? "( " : "  ");
            stringBuilder.append("f_" + n + "(x') < f_" + n + "(x) - delta_" + n);
            if (n > 0) {
                stringBuilder.append(" \\/ f_" + (n - 1) + "(x) > 0 )");
            }
            stringBuilder.append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < this.size) {
            arrayList.addAll(this.mfgens[n].getCoefficients());
            arrayList.add(this.mdeltas[n]);
            ++n;
        }
        return arrayList;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        AffineFunction[] affineFunctionArray = new AffineFunction[this.size];
        int n = 0;
        while (n < this.size) {
            affineFunctionArray[n] = this.mfgens[n].extractAffineFunction(map);
            ++n;
        }
        return new MultiphaseRankingFunction(affineFunctionArray);
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return this.size - 1;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        int n = 0;
        while (n < this.size) {
            ArrayList<LinearInequality> arrayList2 = new ArrayList<LinearInequality>();
            LinearInequality linearInequality = this.mfgens[n].generate(map);
            LinearInequality linearInequality2 = this.mfgens[n].generate(map2);
            linearInequality2.negate();
            linearInequality.add(linearInequality2);
            AffineTerm affineTerm = new AffineTerm(this.mdeltas[n], Rational.MONE);
            linearInequality.add(affineTerm);
            linearInequality.setStrict(true);
            linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
            arrayList2.add(linearInequality);
            if (n > 0) {
                LinearInequality linearInequality3 = this.mfgens[n - 1].generate(map);
                linearInequality3.setStrict(true);
                linearInequality3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
                arrayList2.add(linearInequality3);
            }
            arrayList.add(arrayList2);
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        int n = 0;
        while (n < this.size) {
            ArrayList<LinearInequality> arrayList2 = new ArrayList<LinearInequality>();
            LinearInequality linearInequality = this.mfgens[n].generate(map);
            LinearInequality linearInequality2 = this.mfgens[n].generate(map2);
            linearInequality2.negate();
            linearInequality.add(linearInequality2);
            linearInequality.setStrict(false);
            linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
            arrayList2.add(linearInequality);
            if (n > 0) {
                LinearInequality linearInequality3 = this.mfgens[n - 1].generate(map);
                linearInequality3.setStrict(true);
                linearInequality3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
                arrayList2.add(linearInequality3);
            }
            arrayList.add(arrayList2);
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        ArrayList<LinearInequality> arrayList = new ArrayList<LinearInequality>();
        int n = 0;
        while (n < this.size) {
            LinearInequality linearInequality = this.mfgens[n].generate(map);
            linearInequality.setStrict(true);
            linearInequality.mMotzkinCoefficient = n == 0 || n > 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            arrayList.add(linearInequality);
            ++n;
        }
        return Collections.singletonList(arrayList);
    }

    @Override
    public List<String> getAnnotationsDec() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.size) {
            arrayList.add("rank f" + n + " is decreasing in phase " + n);
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.size) {
            arrayList.add("rank f" + n + " is nonincreasing in phase " + n);
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<String> getAnnotationsBounded() {
        return Collections.singletonList("one of the ranks is bounded");
    }
}

