/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class EprHelpers {
    public static HashSet<ApplicationTerm> collectAppearingConstants(Literal[] literalArray, Theory theory) {
        HashSet<ApplicationTerm> hashSet = new HashSet<ApplicationTerm>();
        Literal[] literalArray2 = literalArray;
        int n = literalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal = literalArray2[n2];
            DPLLAtom dPLLAtom = literal.getAtom();
            Term term = dPLLAtom.getSMTFormula(theory);
            if (term instanceof ApplicationTerm && (dPLLAtom instanceof EprAtom || dPLLAtom instanceof CCEquality)) {
                Term[] termArray = ((ApplicationTerm)term).getParameters();
                int n3 = termArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Term term2 = termArray[n4];
                    if (term2 instanceof ApplicationTerm) {
                        assert (((ApplicationTerm)term2).getFunction().getParameterSorts().length == 0);
                        hashSet.add((ApplicationTerm)term2);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public static Literal applySubstitution(TTSubstitution tTSubstitution, Literal literal, EprTheory eprTheory) {
        return EprHelpers.applySubstitution(tTSubstitution, literal, eprTheory, false);
    }

    public static Literal applySubstitution(TTSubstitution tTSubstitution, Literal literal, EprTheory eprTheory, boolean bl) {
        boolean bl2 = literal.getSign() == 1;
        DPLLAtom dPLLAtom = literal.getAtom();
        Theory theory = eprTheory.getTheory();
        Literal literal2 = null;
        EprPredicateAtom eprPredicateAtom = null;
        if (dPLLAtom instanceof EprQuantifiedPredicateAtom) {
            EprQuantifiedPredicateAtom eprQuantifiedPredicateAtom = (EprQuantifiedPredicateAtom)dPLLAtom;
            TermTuple termTuple = tTSubstitution.apply(eprQuantifiedPredicateAtom.getArgumentsAsTermTuple());
            eprPredicateAtom = eprQuantifiedPredicateAtom.getEprPredicate().getAtomForTermTuple(termTuple, theory, eprTheory.getClausifier().getStackLevel(), eprQuantifiedPredicateAtom.getSourceAnnotation());
        } else if (dPLLAtom instanceof EprQuantifiedEqualityAtom) {
            EprQuantifiedEqualityAtom eprQuantifiedEqualityAtom = (EprQuantifiedEqualityAtom)dPLLAtom;
            TermTuple termTuple = tTSubstitution.apply(eprQuantifiedEqualityAtom.getArgumentsAsTermTuple());
            ApplicationTerm applicationTerm = (ApplicationTerm)theory.term("=", termTuple.terms);
            if (applicationTerm.getFreeVars().length > 0 ? !$assertionsDisabled : !$assertionsDisabled) {
                throw new AssertionError((Object)"TODO: reactivate below code?");
            }
        } else {
            return literal;
        }
        literal2 = bl2 ? eprPredicateAtom : eprPredicateAtom.negate();
        return literal2;
    }

    public static Literal[] applyUnifierToEqualities(EprQuantifiedEqualityAtom[] eprQuantifiedEqualityAtomArray, EprQuantifiedEqualityAtom[] eprQuantifiedEqualityAtomArray2, TTSubstitution tTSubstitution, EprTheory eprTheory) {
        EprQuantifiedEqualityAtom eprQuantifiedEqualityAtom;
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        EprQuantifiedEqualityAtom[] eprQuantifiedEqualityAtomArray3 = eprQuantifiedEqualityAtomArray;
        int n = eprQuantifiedEqualityAtomArray.length;
        int n2 = 0;
        while (n2 < n) {
            eprQuantifiedEqualityAtom = eprQuantifiedEqualityAtomArray3[n2];
            arrayList.add(EprHelpers.applySubstitution(tTSubstitution, eprQuantifiedEqualityAtom, eprTheory));
            ++n2;
        }
        eprQuantifiedEqualityAtomArray3 = eprQuantifiedEqualityAtomArray2;
        n = eprQuantifiedEqualityAtomArray2.length;
        n2 = 0;
        while (n2 < n) {
            eprQuantifiedEqualityAtom = eprQuantifiedEqualityAtomArray3[n2];
            arrayList.add(EprHelpers.applySubstitution(tTSubstitution, eprQuantifiedEqualityAtom, eprTheory));
            ++n2;
        }
        return arrayList.toArray(new Literal[arrayList.size()]);
    }

    public static ArrayList<DPLLAtom> substituteInExceptions(EprQuantifiedEqualityAtom[] eprQuantifiedEqualityAtomArray, TTSubstitution tTSubstitution, EprTheory eprTheory) {
        ArrayList<DPLLAtom> arrayList = new ArrayList<DPLLAtom>();
        EprQuantifiedEqualityAtom[] eprQuantifiedEqualityAtomArray2 = eprQuantifiedEqualityAtomArray;
        int n = eprQuantifiedEqualityAtomArray.length;
        int n2 = 0;
        while (n2 < n) {
            EprQuantifiedEqualityAtom eprQuantifiedEqualityAtom = eprQuantifiedEqualityAtomArray2[n2];
            arrayList.add((DPLLAtom)EprHelpers.applySubstitution(tTSubstitution, eprQuantifiedEqualityAtom, eprTheory));
            ++n2;
        }
        return arrayList;
    }

    public static ApplicationTerm[] castTermsToConstants(Term[] termArray) {
        ApplicationTerm[] applicationTermArray = new ApplicationTerm[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            assert (termArray[n] instanceof ApplicationTerm && ((ApplicationTerm)termArray[n]).getParameters().length == 0) : "This method should only be called on arrays of constants";
            applicationTermArray[n] = (ApplicationTerm)termArray[n];
            ++n;
        }
        return applicationTermArray;
    }

    public static <LETTER> Set<List<LETTER>> computeNCrossproduct(Set<LETTER> set, int n, LogProxy logProxy) {
        HashSet<List<Object>> hashSet = new HashSet<List<LETTER>>();
        hashSet.add(new ArrayList());
        int n2 = 0;
        while (n2 < n) {
            HashSet hashSet2 = new HashSet();
            for (List list : hashSet) {
                for (LETTER LETTER : set) {
                    ArrayList<LETTER> arrayList = new ArrayList<LETTER>(list);
                    arrayList.add(LETTER);
                    hashSet2.add(arrayList);
                }
            }
            hashSet = hashSet2;
            ++n2;
        }
        return hashSet;
    }

    public static <COLNAMES> COLNAMES[] applyMapping(COLNAMES[] COLNAMESArray, Map<COLNAMES, COLNAMES> map) {
        assert (COLNAMESArray.length > 0);
        Object[] objectArray = (Object[])COLNAMESArray.clone();
        int n = 0;
        while (n < COLNAMESArray.length) {
            COLNAMES COLNAMES = map.get(COLNAMESArray[n]);
            if (COLNAMES != null) {
                objectArray[n] = COLNAMES;
            }
            ++n;
        }
        return objectArray;
    }

    public static <COLNAMES> List<COLNAMES> applyMapping(List<COLNAMES> list, Map<COLNAMES, COLNAMES> map) {
        assert (list.size() > 0);
        ArrayList<COLNAMES> arrayList = new ArrayList<COLNAMES>();
        for (COLNAMES COLNAMES : list) {
            COLNAMES COLNAMES2 = map.get(COLNAMES);
            if (COLNAMES2 != null) {
                arrayList.add(COLNAMES2);
                continue;
            }
            arrayList.add(COLNAMES);
        }
        return arrayList;
    }

    public static <COLNAMES> SortedSet<COLNAMES> applyMapping(SortedSet<COLNAMES> sortedSet, Map<COLNAMES, COLNAMES> map) {
        assert (sortedSet.size() > 0);
        TreeSet<COLNAMES> treeSet = new TreeSet<COLNAMES>(EprHelpers.getColumnNamesComparator());
        for (Object e : sortedSet) {
            COLNAMES COLNAMES = map.get(e);
            if (COLNAMES != null) {
                treeSet.add(COLNAMES);
                continue;
            }
            treeSet.add(e);
        }
        return treeSet;
    }

    public static List<ApplicationTerm> convertTermListToConstantList(List<Term> list) {
        ArrayList<ApplicationTerm> arrayList = new ArrayList<ApplicationTerm>(list.size());
        for (Term term : list) {
            arrayList.add((ApplicationTerm)term);
        }
        return arrayList;
    }

    public static List<ApplicationTerm> convertTermArrayToConstantList(Term[] termArray) {
        ArrayList<ApplicationTerm> arrayList = new ArrayList<ApplicationTerm>(termArray.length);
        int n = 0;
        while (n < termArray.length) {
            arrayList.add((ApplicationTerm)termArray[n]);
            ++n;
        }
        return arrayList;
    }

    public static <COLNAMES> Comparator<COLNAMES> getColumnNamesComparator() {
        return ColNameComparator.getInstance();
    }

    public static <COLNAMES> Map<COLNAMES, Integer> computeColnamesToIndex(SortedSet<COLNAMES> sortedSet) {
        HashMap hashMap = new HashMap();
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (n < sortedSet.size()) {
            Object e = iterator.next();
            hashMap.put(e, n);
            ++n;
        }
        return hashMap;
    }

    public static ArrayList<TTSubstitution> getAllInstantiationsForNewConstant(Set<TermVariable> set, Set<ApplicationTerm> set2, Set<ApplicationTerm> set3) {
        ArrayList<TTSubstitution> arrayList = new ArrayList<TTSubstitution>();
        ArrayList<TTSubstitution> arrayList2 = new ArrayList<TTSubstitution>();
        HashSet<ApplicationTerm> hashSet = new HashSet<ApplicationTerm>(set3);
        hashSet.addAll(set2);
        arrayList.add(new TTSubstitution());
        arrayList2.add(new TTSubstitution());
        for (TermVariable termVariable : set) {
            TTSubstitution tTSubstitution;
            ArrayList<TTSubstitution> arrayList3 = new ArrayList<TTSubstitution>();
            ArrayList<TTSubstitution> arrayList4 = new ArrayList<TTSubstitution>();
            for (TTSubstitution tTSubstitution2 : arrayList) {
                for (ApplicationTerm applicationTerm : hashSet) {
                    if (applicationTerm.getSort().getRealSort() != termVariable.getSort().getRealSort()) continue;
                    tTSubstitution = new TTSubstitution(tTSubstitution2);
                    tTSubstitution.addSubs((Term)applicationTerm, termVariable);
                    arrayList3.add(tTSubstitution);
                }
            }
            for (TTSubstitution tTSubstitution2 : arrayList2) {
                for (ApplicationTerm applicationTerm : set3) {
                    if (!applicationTerm.getSort().equals(termVariable.getSort())) continue;
                    tTSubstitution = new TTSubstitution(tTSubstitution2);
                    tTSubstitution.addSubs((Term)applicationTerm, termVariable);
                    arrayList4.add(tTSubstitution);
                }
                for (ApplicationTerm applicationTerm : set2) {
                    if (!applicationTerm.getSort().equals(termVariable.getSort())) continue;
                    tTSubstitution = new TTSubstitution(tTSubstitution2);
                    tTSubstitution.addSubs((Term)applicationTerm, termVariable);
                    arrayList3.add(tTSubstitution);
                }
            }
            arrayList = arrayList3;
            arrayList2 = arrayList4;
        }
        return arrayList;
    }

    public static ArrayList<TTSubstitution> getAllInstantiations(Set<TermVariable> set, Set<ApplicationTerm> set2) {
        ArrayList<TTSubstitution> arrayList = new ArrayList<TTSubstitution>();
        arrayList.add(new TTSubstitution());
        for (TermVariable termVariable : set) {
            ArrayList<TTSubstitution> arrayList2 = new ArrayList<TTSubstitution>();
            for (TTSubstitution tTSubstitution : arrayList) {
                for (ApplicationTerm applicationTerm : set2) {
                    if (applicationTerm.getSort().getRealSort() != termVariable.getSort().getRealSort()) continue;
                    TTSubstitution tTSubstitution2 = new TTSubstitution(tTSubstitution);
                    tTSubstitution2.addSubs((Term)applicationTerm, termVariable);
                    arrayList2.add(tTSubstitution2);
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public static <LETTER, COLNAMES> boolean verifySortsOfPoints(Iterable<List<LETTER>> iterable, SortedSet<COLNAMES> sortedSet) {
        return true;
    }

    public static <LETTER, COLNAMES> boolean verifySortsOfPoint(List<LETTER> list, SortedSet<COLNAMES> sortedSet) {
        if (list.size() == 0) {
            return true;
        }
        if (!(list.get(0) instanceof ApplicationTerm) || !(sortedSet.iterator().next() instanceof TermVariable)) {
            return true;
        }
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (n < list.size()) {
            ApplicationTerm applicationTerm = (ApplicationTerm)list.get(n);
            TermVariable termVariable = (TermVariable)iterator.next();
            if (applicationTerm.getSort().getRealSort() != termVariable.getSort().getRealSort()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean verifyUnitClauseAfterPropagation(Clause clause, Literal literal, LogProxy logProxy) {
        return EprHelpers.verifyUnitClause(clause, literal, true, null, logProxy);
    }

    public static boolean verifyUnitClauseBeforePropagation(Clause clause, Literal literal, LogProxy logProxy) {
        return EprHelpers.verifyUnitClause(clause, literal, false, null, logProxy);
    }

    private static boolean verifyUnitClause(Clause clause, Literal literal, boolean bl, Deque<Literal> deque, LogProxy logProxy) {
        int n = 0;
        while (n < clause.getSize()) {
            Literal literal2 = clause.getLiteral(n);
            if (literal2 == literal) {
                if (bl && literal2.getAtom().getDecideStatus() != literal2) {
                    logProxy.error("EPRDEBUG: (EprHelpers.verifyUnitClause): The unit literal " + String.valueOf(literal) + " is not set.");
                    return false;
                }
                if (!bl && literal2.getAtom().getDecideStatus() != null) {
                    logProxy.error("EPRDEBUG: (EprHelpers.verifyUnitClause): The unit literal " + String.valueOf(literal) + " is not undecided.");
                    return false;
                }
            } else {
                boolean bl2;
                boolean bl3 = literal2.getAtom().getDecideStatus() == literal2.negate();
                boolean bl4 = bl2 = deque != null && deque.contains(literal2.negate());
                if (!bl3 && !bl2) {
                    logProxy.error("EPRDEBUG: (EprHelpers.verifyUnitClause): Literal " + String.valueOf(literal2) + " is not the unit literal but is not currently refuted");
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static boolean verifyConflictClause(Clause clause, LogProxy logProxy) {
        if (clause == null) {
            return true;
        }
        int n = 0;
        while (n < clause.getSize()) {
            Literal literal = clause.getLiteral(n);
            assert (!(literal.getAtom() instanceof EprGroundEqualityAtom)) : "TODO: deal with this case";
            if (literal.getAtom().getDecideStatus() != literal.negate()) {
                logProxy.error("EPRDEBUG: (EprHelpers.verifyConflictClause): Literal " + String.valueOf(literal) + " is not currently refuted");
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean verifyUnitClauseAtEnqueue(Literal literal, Clause clause, Deque<Literal> deque, LogProxy logProxy) {
        return EprHelpers.verifyUnitClause(clause, literal, false, deque, logProxy);
    }

    public static <COLNAMES> SortedSet<COLNAMES> transformSignature(SortedSet<COLNAMES> sortedSet, BinaryRelation<COLNAMES, COLNAMES> binaryRelation) {
        TreeSet<COLNAMES> treeSet = new TreeSet<COLNAMES>(EprHelpers.getColumnNamesComparator());
        for (Object e : sortedSet) {
            Set<COLNAMES> set = binaryRelation.getImage(e);
            if (set == null) {
                treeSet.add(e);
            }
            for (COLNAMES COLNAMES : set) {
                treeSet.add(COLNAMES);
            }
        }
        return treeSet;
    }

    public static <COLNAMES> Object extractSortFromColname(COLNAMES COLNAMES) {
        if (TermVariable.class.isInstance(COLNAMES)) {
            TermVariable termVariable = (TermVariable)COLNAMES;
            return termVariable.getSort();
        }
        return EprHelpers.getDummySortId();
    }

    public static Object getDummySortId() {
        return "dummySort";
    }

    public static Clause sanitizeGroundConflict(Clausifier clausifier, LogProxy logProxy, Clause clause) {
        Clause clause2 = EprHelpers.replaceEprGroundEqualityAtoms(clausifier, clause);
        assert (EprHelpers.verifyConflictClause(clause2, logProxy));
        return clause2;
    }

    public static Clause sanitizeReasonUnitClauseBeforeEnqueue(Clausifier clausifier, LogProxy logProxy, Literal literal, Clause clause, Deque<Literal> deque) {
        Clause clause2 = EprHelpers.replaceEprGroundEqualityAtoms(clausifier, clause);
        assert (EprHelpers.verifyUnitClauseAtEnqueue(literal, clause2, deque, logProxy));
        return clause2;
    }

    private static Clause replaceEprGroundEqualityAtoms(Clausifier clausifier, Clause clause) {
        if (clause == null) {
            return null;
        }
        ArrayList<Literal> arrayList = new ArrayList<Literal>(clause.getSize());
        int n = 0;
        while (n < clause.getSize()) {
            Literal literal = clause.getLiteral(n);
            if (literal.getAtom() instanceof EprGroundEqualityAtom) {
                EprGroundEqualityAtom eprGroundEqualityAtom = (EprGroundEqualityAtom)literal.getAtom();
                if (eprGroundEqualityAtom.getArguments()[0] != eprGroundEqualityAtom.getArguments()[1] || literal.getSign() == 1) {
                    if (eprGroundEqualityAtom.getArguments()[0] == eprGroundEqualityAtom.getArguments()[1] && literal.getSign() == 1) {
                        assert (false) : "the given clause is equivalent to true; does this make sense??";
                    } else {
                        CCEquality cCEquality = ((EprGroundEqualityAtom)literal.getAtom()).getCCEquality(clausifier);
                        arrayList.add(literal.getSign() == 1 ? cCEquality : cCEquality.negate());
                    }
                }
            } else {
                arrayList.add(literal);
            }
            ++n;
        }
        Clause clause2 = new Clause(arrayList.toArray(new Literal[arrayList.size()]));
        return clause2;
    }

    public static boolean containsBooleanTerm(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if ("Bool".equals(term.getSort().getRealSort().getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static class ColNameComparator<COLNAMES>
    implements Comparator<COLNAMES> {
        private static ColNameComparator instance = new ColNameComparator();

        private ColNameComparator() {
        }

        public static <COLNAMES> ColNameComparator<COLNAMES> getInstance() {
            return instance;
        }

        @Override
        public int compare(COLNAMES COLNAMES, COLNAMES COLNAMES2) {
            if (COLNAMES instanceof TermVariable) {
                TermVariable termVariable = (TermVariable)COLNAMES;
                TermVariable termVariable2 = (TermVariable)COLNAMES2;
                return termVariable.getName().compareTo(termVariable2.getName());
            }
            if (COLNAMES instanceof String) {
                return ((String)COLNAMES).compareTo((String)COLNAMES2);
            }
            if (COLNAMES instanceof Integer) {
                return ((Integer)COLNAMES).compareTo((Integer)COLNAMES2);
            }
            throw new UnsupportedOperationException("unexpected comparator call");
        }
    }
}

