/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.mso;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Union;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IUnionStateFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.mso.MSODAlphabetSymbol;
import de.uni_freiburg.informatik.ultimate.mso.MSODStringFactory;
import de.uni_freiburg.informatik.ultimate.mso.MSODUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class MSODAutomataOperations {
    public static NestedWordAutomaton<MSODAlphabetSymbol, String> emptyAutomaton(AutomataLibraryServices automataLibraryServices) {
        return new NestedWordAutomaton(automataLibraryServices, new VpAlphabet(new HashSet()), (IEmptyStackStateFactory)new MSODStringFactory());
    }

    public static INestedWordAutomaton<MSODAlphabetSymbol, String> project(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton, Set<MSODAlphabetSymbol> set, boolean bl) throws AutomataLibraryException {
        set.containsAll(iNestedWordAutomaton.getAlphabet());
        NestedWordAutomaton<MSODAlphabetSymbol, String> nestedWordAutomaton = MSODAutomataOperations.emptyAutomaton(automataLibraryServices);
        nestedWordAutomaton.getAlphabet().addAll(set);
        for (String string : iNestedWordAutomaton.getStates()) {
            nestedWordAutomaton.addState(iNestedWordAutomaton.isInitial((Object)string), iNestedWordAutomaton.isFinal((Object)string), (Object)string);
        }
        for (String string : iNestedWordAutomaton.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors((Object)string)) {
                if (bl) {
                    set.stream().filter(mSODAlphabetSymbol -> mSODAlphabetSymbol.contains((MSODAlphabetSymbol)outgoingInternalTransition.getLetter())).forEach(mSODAlphabetSymbol -> nestedWordAutomaton.addInternalTransition((Object)string, mSODAlphabetSymbol, (Object)((String)outgoingInternalTransition.getSucc())));
                }
                if (bl) continue;
                set.stream().filter(mSODAlphabetSymbol -> ((MSODAlphabetSymbol)outgoingInternalTransition.getLetter()).contains((MSODAlphabetSymbol)mSODAlphabetSymbol)).forEach(mSODAlphabetSymbol -> nestedWordAutomaton.addInternalTransition((Object)string, mSODAlphabetSymbol, (Object)((String)outgoingInternalTransition.getSucc())));
            }
        }
        return new MinimizeSevpa(automataLibraryServices, (IMinimizationStateFactory)new MSODStringFactory(), nestedWordAutomaton).getResult();
    }

    public static INestedWordAutomaton<MSODAlphabetSymbol, String> saturate(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton, MSODAlphabetSymbol mSODAlphabetSymbol) throws AutomataLibraryException {
        String string;
        NestedWordAutomaton nestedWordAutomaton = (NestedWordAutomaton)iNestedWordAutomaton;
        HashSet hashSet = new HashSet();
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(nestedWordAutomaton.getFinalStates());
        HashSet<String> hashSet2 = new HashSet<String>();
        boolean bl = false;
        while (!arrayDeque.isEmpty()) {
            string = (String)arrayDeque.pop();
            for (String string2 : MSODUtils.hierarchicalPredecessorsIncoming((INestedWordAutomaton<MSODAlphabetSymbol, String>)nestedWordAutomaton, string, mSODAlphabetSymbol)) {
                if (!hashSet2.add(string)) continue;
                bl = bl || nestedWordAutomaton.isInitial((Object)string2);
                nestedWordAutomaton.internalPredecessors((Object)string2).forEach(incomingInternalTransition -> {
                    boolean bl = hashSet.add(incomingInternalTransition);
                });
                arrayDeque.add(string2);
            }
        }
        string = ((MSODStringFactory)nestedWordAutomaton.getStateFactory()).newString();
        nestedWordAutomaton.addState(bl, true, (Object)string);
        for (String string2 : hashSet) {
            nestedWordAutomaton.addInternalTransition((Object)((String)string2.getPred()), (Object)((MSODAlphabetSymbol)string2.getLetter()), (Object)string);
        }
        return new MinimizeSevpa(automataLibraryServices, (IMinimizationStateFactory)new MSODStringFactory(), (INestedWordAutomaton)nestedWordAutomaton).getResult();
    }

    public static NestedWordAutomaton<MSODAlphabetSymbol, String> intVariableAutomaton(AutomataLibraryServices automataLibraryServices, Term term) {
        if (!MSODUtils.isIntConstantOrTermVariable(term)) {
            throw new IllegalArgumentException("Input x must be an Int variable.");
        }
        MSODAlphabetSymbol mSODAlphabetSymbol = new MSODAlphabetSymbol(term, false);
        MSODAlphabetSymbol mSODAlphabetSymbol2 = new MSODAlphabetSymbol(term, true);
        NestedWordAutomaton<MSODAlphabetSymbol, String> nestedWordAutomaton = MSODAutomataOperations.emptyAutomaton(automataLibraryServices);
        nestedWordAutomaton.getAlphabet().addAll(Arrays.asList(mSODAlphabetSymbol, mSODAlphabetSymbol2));
        nestedWordAutomaton.addState(true, false, (Object)"init");
        nestedWordAutomaton.addState(false, true, (Object)"final");
        nestedWordAutomaton.addInternalTransition((Object)"init", (Object)mSODAlphabetSymbol, (Object)"init");
        nestedWordAutomaton.addInternalTransition((Object)"init", (Object)mSODAlphabetSymbol2, (Object)"final");
        nestedWordAutomaton.addInternalTransition((Object)"final", (Object)mSODAlphabetSymbol, (Object)"final");
        return nestedWordAutomaton;
    }

    public INestedWordAutomaton<MSODAlphabetSymbol, String> fixIntVariables(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton2 = iNestedWordAutomaton;
        if (!iNestedWordAutomaton2.getAlphabet().isEmpty()) {
            Set<Term> set = ((MSODAlphabetSymbol)iNestedWordAutomaton2.getAlphabet().iterator().next()).containsSort("Int");
            for (Term term : set) {
                NestedWordAutomaton<MSODAlphabetSymbol, String> nestedWordAutomaton = MSODAutomataOperations.intVariableAutomaton(automataLibraryServices, term);
                nestedWordAutomaton = MSODAutomataOperations.project(automataLibraryServices, nestedWordAutomaton, iNestedWordAutomaton2.getAlphabet(), true);
                iNestedWordAutomaton2 = this.intersect(automataLibraryServices, iNestedWordAutomaton2, (INestedWordAutomaton<MSODAlphabetSymbol, String>)nestedWordAutomaton);
            }
        }
        return iNestedWordAutomaton2;
    }

    public INestedWordAutomaton<MSODAlphabetSymbol, String> union(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton, INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton2) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton3 = new Union(automataLibraryServices, (IUnionStateFactory)new MSODStringFactory(), iNestedWordAutomaton, iNestedWordAutomaton2).getResult();
        iNestedWordAutomaton3 = this.fixIntVariables(automataLibraryServices, iNestedWordAutomaton3);
        return new MinimizeSevpa(automataLibraryServices, (IMinimizationStateFactory)new MSODStringFactory(), iNestedWordAutomaton3).getResult();
    }

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> complement(AutomataLibraryServices var1, INestedWordAutomaton<MSODAlphabetSymbol, String> var2) throws AutomataLibraryException;

    public abstract INestedWordAutomaton<MSODAlphabetSymbol, String> intersect(AutomataLibraryServices var1, INestedWordAutomaton<MSODAlphabetSymbol, String> var2, INestedWordAutomaton<MSODAlphabetSymbol, String> var3) throws AutomataLibraryException;

    public abstract NestedLassoWord<MSODAlphabetSymbol> getWord(AutomataLibraryServices var1, INestedWordAutomaton<MSODAlphabetSymbol, String> var2) throws AutomataLibraryException;
}

