/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.mso;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.mso.MSODAlphabetSymbol;
import de.uni_freiburg.informatik.ultimate.mso.MSODAutomataOperations;
import de.uni_freiburg.informatik.ultimate.mso.MSODAutomataOperationsBuchi;
import de.uni_freiburg.informatik.ultimate.mso.MSODAutomataOperationsWeak;
import de.uni_freiburg.informatik.ultimate.mso.MSODFormulaOperations;
import de.uni_freiburg.informatik.ultimate.mso.MSODFormulaOperationsInt;
import de.uni_freiburg.informatik.ultimate.mso.MSODFormulaOperationsNat;
import de.uni_freiburg.informatik.ultimate.mso.MSODUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MSODSolver {
    private final Script mScript;
    private final ILogger mLogger;
    private final AutomataLibraryServices mAutomataLibrarayServices;
    private final MSODFormulaOperations mFormulaOperations;
    private final MSODAutomataOperations mAutomataOperations;

    public MSODSolver(IUltimateServiceProvider iUltimateServiceProvider, Script script, ILogger iLogger, MSODLogic mSODLogic) {
        this.mScript = script;
        this.mLogger = iLogger;
        this.mAutomataLibrarayServices = new AutomataLibraryServices(iUltimateServiceProvider);
        switch (mSODLogic) {
            case MSODNatWeak: {
                this.mFormulaOperations = new MSODFormulaOperationsNat();
                this.mAutomataOperations = new MSODAutomataOperationsWeak();
                break;
            }
            case MSODIntWeak: {
                this.mFormulaOperations = new MSODFormulaOperationsInt();
                this.mAutomataOperations = new MSODAutomataOperationsWeak();
                break;
            }
            case MSODNat: {
                this.mFormulaOperations = new MSODFormulaOperationsNat();
                this.mAutomataOperations = new MSODAutomataOperationsBuchi();
                break;
            }
            case MSODInt: {
                this.mFormulaOperations = new MSODFormulaOperationsInt();
                this.mAutomataOperations = new MSODAutomataOperationsBuchi();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logic: " + String.valueOf((Object)mSODLogic));
            }
        }
    }

    public String automatonToString(IAutomaton<?, ?> iAutomaton, AutomatonDefinitionPrinter.Format format) {
        return AutomatonDefinitionPrinter.toString((AutomataLibraryServices)this.mAutomataLibrarayServices, (String)"", iAutomaton);
    }

    public INestedWordAutomaton<MSODAlphabetSymbol, String> traversePostOrder(Term term) throws AutomataLibraryException {
        QuantifiedFormula quantifiedFormula;
        this.mLogger.info((Object)("Traverse term: " + String.valueOf(term)));
        if (term instanceof QuantifiedFormula) {
            quantifiedFormula = (QuantifiedFormula)term;
            if (quantifiedFormula.getQuantifier() == 1) {
                return this.processForall(quantifiedFormula);
            }
            if (quantifiedFormula.getQuantifier() == 0) {
                return this.processExists(quantifiedFormula);
            }
        }
        if (term instanceof ApplicationTerm) {
            quantifiedFormula = (ApplicationTerm)term;
            String string = quantifiedFormula.getFunction().getName();
            if (string.equals("true")) {
                return this.processTrue();
            }
            if (string.equals("false")) {
                return this.processFalse();
            }
            if (string.equals("not")) {
                return this.processNegation((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("and")) {
                return this.processConjunction((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("or")) {
                return this.processDisjunction((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("=>")) {
                return this.processImplication((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("strictSubsetInt")) {
                return this.processStrictSubset((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("subsetInt")) {
                return this.processSubset((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("element")) {
                return this.processElement((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("=")) {
                return this.processEqual((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals(">")) {
                return this.processGreater((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals(">=")) {
                return this.processGreaterEqual((ApplicationTerm)quantifiedFormula);
            }
            if (string.equals("<") || string.equals("<=")) {
                return this.processLessOrLessEqual((ApplicationTerm)quantifiedFormula);
            }
        }
        throw new IllegalArgumentException("Input must be a QuantifiedFormula or an ApplicationTerm.");
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processForall(QuantifiedFormula quantifiedFormula) throws AutomataLibraryException {
        Term term = SmtUtils.not((Script)this.mScript, (Term)this.mScript.quantifier(0, quantifiedFormula.getVariables(), SmtUtils.not((Script)this.mScript, (Term)quantifiedFormula.getSubformula()), (Term[][])new Term[0][]));
        return this.traversePostOrder(term);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processExists(QuantifiedFormula quantifiedFormula) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton = this.traversePostOrder(quantifiedFormula.getSubformula());
        this.mLogger.info((Object)("Construct \u2203 \u03c6: " + String.valueOf(quantifiedFormula)));
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(Arrays.asList(quantifiedFormula.getFreeVars()));
        arrayList.addAll(SmtUtils.extractConstants((Term)quantifiedFormula, (boolean)true));
        Set<MSODAlphabetSymbol> set = MSODUtils.createAlphabet(arrayList);
        iNestedWordAutomaton = MSODAutomataOperations.project(this.mAutomataLibrarayServices, iNestedWordAutomaton, set, false);
        MSODAlphabetSymbol mSODAlphabetSymbol = new MSODAlphabetSymbol(arrayList, false);
        iNestedWordAutomaton = MSODAutomataOperations.saturate(this.mAutomataLibrarayServices, iNestedWordAutomaton, mSODAlphabetSymbol);
        return iNestedWordAutomaton;
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processTrue() {
        this.mLogger.info((Object)"Construct true");
        return MSODFormulaOperations.trueAutomaton(this.mAutomataLibrarayServices);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processFalse() {
        this.mLogger.info((Object)"Construct false");
        return MSODFormulaOperations.falseAutomaton(this.mAutomataLibrarayServices);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processNegation(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton = this.traversePostOrder(applicationTerm.getParameters()[0]);
        this.mLogger.info((Object)("Construct not \u03c6: " + String.valueOf(applicationTerm)));
        iNestedWordAutomaton = this.mAutomataOperations.complement(this.mAutomataLibrarayServices, iNestedWordAutomaton);
        return iNestedWordAutomaton;
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processConjunction(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton = this.traversePostOrder(applicationTerm.getParameters()[0]);
        this.mLogger.info((Object)("Construct \u03c6 and \u03c8 (0): " + String.valueOf(applicationTerm)));
        int n = 1;
        while (n < applicationTerm.getParameters().length) {
            INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton2 = this.traversePostOrder(applicationTerm.getParameters()[n]);
            this.mLogger.info((Object)("Construct \u03c6 and \u03c8 (" + n + "): " + String.valueOf(applicationTerm)));
            Set<MSODAlphabetSymbol> set = MSODUtils.mergeAlphabets(iNestedWordAutomaton.getAlphabet(), iNestedWordAutomaton2.getAlphabet());
            iNestedWordAutomaton = MSODAutomataOperations.project(this.mAutomataLibrarayServices, iNestedWordAutomaton, set, true);
            iNestedWordAutomaton2 = MSODAutomataOperations.project(this.mAutomataLibrarayServices, iNestedWordAutomaton2, set, true);
            iNestedWordAutomaton = this.mAutomataOperations.intersect(this.mAutomataLibrarayServices, iNestedWordAutomaton, iNestedWordAutomaton2);
            ++n;
        }
        return iNestedWordAutomaton;
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processDisjunction(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton = this.traversePostOrder(applicationTerm.getParameters()[0]);
        this.mLogger.info((Object)("Construct \u03c6 and \u03c8 (0): " + String.valueOf(applicationTerm)));
        int n = 1;
        while (n < applicationTerm.getParameters().length) {
            INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton2 = this.traversePostOrder(applicationTerm.getParameters()[n]);
            this.mLogger.info((Object)("Construct \u03c6 and \u03c8 (" + n + "): " + String.valueOf(applicationTerm)));
            Set<MSODAlphabetSymbol> set = MSODUtils.mergeAlphabets(iNestedWordAutomaton.getAlphabet(), iNestedWordAutomaton2.getAlphabet());
            iNestedWordAutomaton = MSODAutomataOperations.project(this.mAutomataLibrarayServices, iNestedWordAutomaton, set, true);
            iNestedWordAutomaton2 = MSODAutomataOperations.project(this.mAutomataLibrarayServices, iNestedWordAutomaton2, set, true);
            iNestedWordAutomaton = this.mAutomataOperations.union(this.mAutomataLibrarayServices, iNestedWordAutomaton, iNestedWordAutomaton2);
            ++n;
        }
        return iNestedWordAutomaton;
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processImplication(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        Term[] termArray = applicationTerm.getParameters();
        int n = 0;
        while (n < termArray.length - 1) {
            termArray[n] = SmtUtils.not((Script)this.mScript, (Term)termArray[n]);
            ++n;
        }
        return this.traversePostOrder(SmtUtils.or((Script)this.mScript, (Term[])termArray));
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processEqual(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        Term term;
        Term term2 = applicationTerm.getParameters();
        int n = ((Term[])term2).length;
        int n2 = 0;
        while (n2 < n) {
            term = term2[n2];
            this.mLogger.error((Object)("TERM: " + String.valueOf(term)));
            ++n2;
        }
        term = applicationTerm.getParameters();
        Term term3 = SmtUtils.leq((Script)this.mScript, (Term)term[0], (Term)term[1]);
        Term term4 = this.mScript.term("not", new Term[]{SmtUtils.less((Script)this.mScript, (Term)term[0], (Term)term[1])});
        term2 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term3, term4});
        this.mLogger.error((Object)("equal: " + String.valueOf(term2)));
        return this.traversePostOrder(term2);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processGreater(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        Term[] termArray = applicationTerm.getParameters();
        Term term = SmtUtils.not((Script)this.mScript, (Term)SmtUtils.leq((Script)this.mScript, (Term)termArray[0], (Term)termArray[1]));
        return this.traversePostOrder(term);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processGreaterEqual(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        Term[] termArray = applicationTerm.getParameters();
        Term term = SmtUtils.not((Script)this.mScript, (Term)SmtUtils.less((Script)this.mScript, (Term)termArray[0], (Term)termArray[1]));
        return this.traversePostOrder(term);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processLessOrLessEqual(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        Map.Entry entry;
        PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)this.mScript, (Term)applicationTerm, (PolynomialRelation.TransformInequality)PolynomialRelation.TransformInequality.NONSTRICT2STRICT);
        AffineTerm affineTerm = (AffineTerm)polynomialRelation.getPolynomialTerm();
        Map map = affineTerm.getVariable2Coefficient();
        Rational rational = affineTerm.getConstant().negate();
        if (map.size() == 1) {
            entry = map.entrySet().iterator().next();
            if (((Rational)entry.getValue()).equals((Object)Rational.ONE)) {
                this.mLogger.info((Object)("Construct x < c: " + String.valueOf(applicationTerm)));
                return this.mFormulaOperations.strictIneqAutomaton(this.mAutomataLibrarayServices, (Term)entry.getKey(), rational);
            }
            if (((Rational)entry.getValue()).equals((Object)Rational.MONE)) {
                this.mLogger.info((Object)("Construct -x < c: " + String.valueOf(applicationTerm)));
                return this.mFormulaOperations.strictNegIneqAutomaton(this.mAutomataLibrarayServices, (Term)entry.getKey(), rational);
            }
        }
        if (map.size() == 2) {
            this.mLogger.info((Object)("Construct x-y < c: " + String.valueOf(applicationTerm)));
            entry = map.entrySet().iterator();
            Map.Entry entry2 = (Map.Entry)entry.next();
            Map.Entry entry3 = (Map.Entry)entry.next();
            if (!((Rational)entry2.getValue()).add((Rational)entry3.getValue()).equals((Object)Rational.ZERO)) {
                throw new IllegalArgumentException("Input is not difference logic.");
            }
            if (((Rational)entry2.getValue()).equals((Object)Rational.ONE)) {
                this.mLogger.error((Object)("x: " + String.valueOf(entry2.getKey()) + ", y: " + String.valueOf(entry3.getKey()) + ", c: " + String.valueOf(rational)));
                return this.mFormulaOperations.strictIneqAutomaton(this.mAutomataLibrarayServices, (Term)entry2.getKey(), (Term)entry3.getKey(), rational);
            }
            if (((Rational)entry3.getValue()).equals((Object)Rational.ONE)) {
                this.mLogger.error((Object)("x: " + String.valueOf(entry3.getKey()) + ", y: " + String.valueOf(entry2.getKey()) + ", c: " + String.valueOf(rational)));
                return this.mFormulaOperations.strictIneqAutomaton(this.mAutomataLibrarayServices, (Term)entry3.getKey(), (Term)entry2.getKey(), rational);
            }
        }
        throw new IllegalArgumentException("Invalid inequality");
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processStrictSubset(ApplicationTerm applicationTerm) {
        this.mLogger.info((Object)("Construct X strictSubset Y: " + String.valueOf(applicationTerm)));
        if (applicationTerm.getParameters().length != 2) {
            throw new IllegalArgumentException("StrictSubset must have exactly two parameters.");
        }
        return this.mFormulaOperations.strictSubsetAutomaton(this.mAutomataLibrarayServices, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processSubset(ApplicationTerm applicationTerm) {
        this.mLogger.info((Object)("Construct X subset Y: " + String.valueOf(applicationTerm)));
        if (applicationTerm.getParameters().length != 2) {
            throw new IllegalArgumentException("Subset must have exactly two parameters.");
        }
        return this.mFormulaOperations.subsetAutomaton(this.mAutomataLibrarayServices, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
    }

    private INestedWordAutomaton<MSODAlphabetSymbol, String> processElement(ApplicationTerm applicationTerm) throws AutomataLibraryException {
        if (applicationTerm.getParameters().length != 2) {
            throw new IllegalArgumentException("Element must have exactly two parameters.");
        }
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(this.mScript).transform(applicationTerm.getParameters()[0]);
        if (affineTerm.isErrorTerm()) {
            throw new IllegalArgumentException("Could not create AffineTerm.");
        }
        Map map = affineTerm.getVariable2Coefficient();
        Rational rational = affineTerm.getConstant();
        if (map.size() == 0) {
            this.mLogger.info((Object)("Construct c element X: " + String.valueOf(applicationTerm)));
            return this.mFormulaOperations.constElementAutomaton(this.mAutomataLibrarayServices, rational, applicationTerm.getParameters()[1]);
        }
        if (map.size() == 1) {
            this.mLogger.info((Object)("Construct x+c element Y: " + String.valueOf(applicationTerm)));
            Map.Entry entry = map.entrySet().iterator().next();
            if (!((Rational)entry.getValue()).equals((Object)Rational.ONE)) {
                throw new IllegalArgumentException("Invalid input.");
            }
            return this.mFormulaOperations.elementAutomaton(this.mAutomataLibrarayServices, (Term)entry.getKey(), rational, applicationTerm.getParameters()[1]);
        }
        throw new IllegalArgumentException("Invalid input.");
    }

    public Map<Term, Term> getResult(Script script, ILogger iLogger, AutomataLibraryServices automataLibraryServices, Term term) throws AutomataLibraryException {
        INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton = this.traversePostOrder(term);
        this.mLogger.info((Object)MSODUtils.automatonToString(this.mAutomataLibrarayServices, iNestedWordAutomaton));
        this.mLogger.info((Object)("info: " + iNestedWordAutomaton.sizeInformation()));
        NestedLassoWord nestedLassoWord = this.mAutomataOperations.getWord(automataLibraryServices, iNestedWordAutomaton);
        if (nestedLassoWord == null) {
            return null;
        }
        if (this.mFormulaOperations instanceof MSODFormulaOperationsInt && nestedLassoWord.getLoop().length() % 2 != 0) {
            nestedLassoWord = new NestedLassoWord(nestedLassoWord.getStem(), nestedLassoWord.getLoop().concatenate(nestedLassoWord.getLoop()));
        }
        iLogger.info((Object)("Word: " + String.valueOf(nestedLassoWord)));
        Map<Term, List<Integer>> map = this.mFormulaOperations.wordToNumbers((NestedWord<MSODAlphabetSymbol>)nestedLassoWord.getStem(), 0);
        Map<Term, List<Integer>> map2 = this.mFormulaOperations.wordToNumbers((NestedWord<MSODAlphabetSymbol>)nestedLassoWord.getLoop(), nestedLassoWord.getStem().length());
        int n = nestedLassoWord.getStem().length();
        int n2 = this.mFormulaOperations instanceof MSODFormulaOperationsInt ? nestedLassoWord.getLoop().length() / 2 : nestedLassoWord.getLoop().length();
        Pair<Integer, Integer> pair = this.mFormulaOperations.stemBounds(n);
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Term term2 : map.keySet()) {
            hashMap.put(term2, SmtUtils.or((Script)script, (Term[])new Term[]{MSODFormulaOperations.stemResult(script, term2, map.get(term2)), MSODFormulaOperations.loopResult(script, term2, map2.get(term2), pair, n2)}));
        }
        return hashMap;
    }

    public static enum MSODLogic {
        MSODInt,
        MSODNat,
        MSODIntWeak,
        MSODNatWeak;

    }
}

