/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation;

import de.uni_freiburg.informatik.ultimate.cdt.translation.LineDirectiveMapping;
import de.uni_freiburg.informatik.ultimate.cdt.translation.LineOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.CdtASTUtils;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.MergedLocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class CLocation
extends CACSLLocation {
    private static final long serialVersionUID = -7497131349540138810L;
    private final List<IASTNode> mNodes;
    private final LineDirectiveMapping mLineDirectiveMapping;
    private final LineOffsetComputer mLineOffsetComputer;

    protected CLocation(IASTNode iASTNode, boolean bl, LineDirectiveMapping lineDirectiveMapping, LineOffsetComputer lineOffsetComputer) {
        this(iASTNode == null ? List.of() : List.of(iASTNode), bl, lineDirectiveMapping, lineOffsetComputer);
    }

    private CLocation(List<IASTNode> list, boolean bl, LineDirectiveMapping lineDirectiveMapping, LineOffsetComputer lineOffsetComputer) {
        super(bl);
        this.mNodes = list;
        this.mLineDirectiveMapping = lineDirectiveMapping;
        this.mLineOffsetComputer = lineOffsetComputer;
    }

    private Pair<Integer, String> getOriginalLocation(int n, String string) {
        if (this.mLineDirectiveMapping == null) {
            return new Pair((Object)n, (Object)string);
        }
        return this.mLineDirectiveMapping.getOriginal(n, string);
    }

    private Stream<IASTFileLocation> getValidFileLocations() {
        return this.mNodes.stream().map(IASTNode::getFileLocation).filter(Objects::nonNull);
    }

    private static <T> T getUniqueElementOrNull(Stream<T> stream) {
        return (T)stream.collect(Collectors.collectingAndThen(Collectors.toSet(), set -> set.size() == 1 ? set.iterator().next() : null));
    }

    public String getFileName() {
        return CLocation.getUniqueElementOrNull(this.getValidFileLocations().map(iASTFileLocation -> (String)this.getOriginalLocation(iASTFileLocation.getStartingLineNumber(), iASTFileLocation.getFileName()).getSecond()));
    }

    public int getStartLine() {
        return this.getValidFileLocations().mapToInt(iASTFileLocation -> (Integer)this.getOriginalLocation(iASTFileLocation.getStartingLineNumber(), iASTFileLocation.getFileName()).getFirst()).min().orElse(-1);
    }

    public int getEndLine() {
        return this.getValidFileLocations().mapToInt(iASTFileLocation -> (Integer)this.getOriginalLocation(iASTFileLocation.getEndingLineNumber(), iASTFileLocation.getFileName()).getFirst()).max().orElse(-1);
    }

    public int getStartColumn() {
        int n = this.getStartLine();
        if (this.mLineOffsetComputer == null || n == -1 || n != this.getValidFileLocations().mapToInt(iASTFileLocation -> iASTFileLocation.getStartingLineNumber()).min().getAsInt()) {
            return -1;
        }
        int n2 = this.mLineOffsetComputer.getOffset(n);
        return this.getValidFileLocations().mapToInt(IASTFileLocation::getNodeOffset).min().getAsInt() - n2 + 1;
    }

    public int getEndColumn() {
        int n = this.getEndLine();
        if (this.mLineOffsetComputer == null || n == -1 || n != this.getValidFileLocations().mapToInt(iASTFileLocation -> iASTFileLocation.getEndingLineNumber()).max().getAsInt()) {
            return -1;
        }
        int n2 = this.mLineOffsetComputer.getOffset(n);
        IASTFileLocation iASTFileLocation2 = this.getValidFileLocations().max(Comparator.comparing(IASTFileLocation::getNodeOffset)).get();
        return iASTFileLocation2.getNodeOffset() + iASTFileLocation2.getNodeLength() - n2 + 1;
    }

    @Deprecated
    public IASTNode getNode() {
        return CdtASTUtils.findCommonParent(this.mNodes.stream().filter(iASTNode -> !(iASTNode instanceof IASTTranslationUnit)).toList());
    }

    public LineDirectiveMapping getLineDirectiveMapping() {
        return this.mLineDirectiveMapping;
    }

    public LineOffsetComputer getLineOffsetComputer() {
        return this.mLineOffsetComputer;
    }

    public String toString() {
        if (this.mNodes.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("C: ").append(this.mNodes.stream().map(IASTNode::getRawSignature).toList());
        stringBuilder.append(" [");
        if (this.getStartLine() == this.getEndLine()) {
            stringBuilder.append(this.getStartLine());
        } else {
            stringBuilder.append(this.getStartLine());
            stringBuilder.append("-");
            stringBuilder.append(this.getEndLine());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations == null || this == iAnnotations) {
            return this;
        }
        if (iAnnotations instanceof CLocation) {
            CLocation cLocation = (CLocation)iAnnotations;
            boolean bl = this.ignoreDuringBacktranslation() && cLocation.ignoreDuringBacktranslation();
            LineDirectiveMapping lineDirectiveMapping = this.mLineDirectiveMapping == null ? cLocation.getLineDirectiveMapping() : this.mLineDirectiveMapping;
            LineOffsetComputer lineOffsetComputer = this.mLineOffsetComputer == null ? cLocation.getLineOffsetComputer() : this.mLineOffsetComputer;
            List<IASTNode> list = CLocation.concatNodes(this.mNodes, cLocation.mNodes);
            return new CLocation(list, bl, lineDirectiveMapping, lineOffsetComputer);
        }
        if (iAnnotations instanceof ILocation) {
            return MergedLocation.mergeToMergeLocation((ILocation)this, (ILocation)((ILocation)iAnnotations));
        }
        throw new IAnnotations.UnmergeableAnnotationsException((IAnnotations)this, iAnnotations);
    }

    private static List<IASTNode> concatNodes(List<IASTNode> list, List<IASTNode> list2) {
        if (list2.isEmpty()) {
            return list;
        }
        if (list.isEmpty()) {
            return list2;
        }
        HashSet<IASTNode> hashSet = new HashSet<IASTNode>(list);
        HashSet<IASTNode> hashSet2 = new HashSet<IASTNode>(list2);
        return Stream.concat(list.stream().filter(iASTNode -> !CLocation.hasParent(iASTNode, hashSet2)), list2.stream().filter(iASTNode -> !hashSet.contains(iASTNode) && !CLocation.hasParent(iASTNode, hashSet))).toList();
    }

    private static boolean hasParent(IASTNode iASTNode, Set<IASTNode> set) {
        IASTNode iASTNode2 = iASTNode.getParent();
        while (iASTNode2 != null) {
            if (set.contains(iASTNode2)) {
                return true;
            }
            iASTNode2 = iASTNode2.getParent();
        }
        return false;
    }

    public String getFunction() {
        return CLocation.getUniqueElementOrNull(this.mNodes.stream().map(iASTNode -> CdtASTUtils.findScope(iASTNode).getDeclarator().getName().toString()));
    }

    public CLocation getParent() {
        IASTNode iASTNode = CLocation.getUniqueElementOrNull(this.mNodes.stream().map(IASTNode::getParent));
        if (iASTNode == null) {
            return null;
        }
        return new CLocation(iASTNode, this.ignoreDuringBacktranslation(), this.mLineDirectiveMapping, this.mLineOffsetComputer);
    }

    public CLocation createIgnoreCopy() {
        return new CLocation(this.mNodes, true, this.mLineDirectiveMapping, this.mLineOffsetComputer);
    }

    public CLocation copy() {
        return new CLocation(this.mNodes, this.ignoreDuringBacktranslation(), this.mLineDirectiveMapping, this.mLineOffsetComputer);
    }
}

