/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.TermIsNotAffineException;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.UnknownFunctionException;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinearInequality
implements Serializable {
    private static final long serialVersionUID = 5640678756293667730L;
    private boolean mStrict = false;
    public PossibleMotzkinCoefficients mMotzkinCoefficient = PossibleMotzkinCoefficients.ANYTHING;
    private final Map<Term, AffineTerm> mCoefficients;
    private AffineTerm mConstant;

    public LinearInequality() {
        this.mCoefficients = new LinkedHashMap<Term, AffineTerm>();
        this.mConstant = new AffineTerm();
    }

    public LinearInequality(LinearInequality linearInequality) {
        this.mConstant = new AffineTerm(linearInequality.mConstant);
        this.mStrict = linearInequality.mStrict;
        this.mMotzkinCoefficient = linearInequality.mMotzkinCoefficient;
        this.mCoefficients = new LinkedHashMap<Term, AffineTerm>();
        for (Map.Entry<Term, AffineTerm> entry : linearInequality.mCoefficients.entrySet()) {
            this.mCoefficients.put(entry.getKey(), new AffineTerm(entry.getValue()));
        }
    }

    public static LinearInequality constructFalse() {
        LinearInequality linearInequality = new LinearInequality();
        linearInequality.setStrict(true);
        return linearInequality;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinearInequality fromTerm(Term term) throws TermException {
        LinearInequality linearInequality;
        if (term instanceof ConstantTerm) {
            linearInequality = new LinearInequality();
            linearInequality.add(new AffineTerm(SmtUtils.toRational((ConstantTerm)((ConstantTerm)term))));
            return linearInequality;
        } else if (term instanceof TermVariable) {
            linearInequality = new LinearInequality();
            linearInequality.add(term, Rational.ONE);
            return linearInequality;
        } else {
            if (!(term instanceof ApplicationTerm)) throw new TermException("Stumbled upon a Term of unknown subclass", term);
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if ("+".equals(applicationTerm.getFunction().getName())) {
                linearInequality = LinearInequality.fromTerm(applicationTerm.getParameters()[0]);
                int n = 1;
                while (n < applicationTerm.getParameters().length) {
                    linearInequality.add(LinearInequality.fromTerm(applicationTerm.getParameters()[n]));
                    ++n;
                }
                return linearInequality;
            } else if ("-".equals(applicationTerm.getFunction().getName())) {
                if (applicationTerm.getFunction().getParameterSorts().length == 1) {
                    linearInequality = LinearInequality.fromTerm(applicationTerm.getParameters()[0]);
                    linearInequality.mult(Rational.MONE);
                    return linearInequality;
                } else {
                    linearInequality = LinearInequality.fromTerm(applicationTerm.getParameters()[0]);
                    linearInequality.mult(Rational.MONE);
                    int n = 1;
                    while (n < applicationTerm.getParameters().length) {
                        linearInequality.add(LinearInequality.fromTerm(applicationTerm.getParameters()[n]));
                        ++n;
                    }
                    linearInequality.mult(Rational.MONE);
                }
                return linearInequality;
            } else if ("*".equals(applicationTerm.getFunction().getName())) {
                linearInequality = new LinearInequality();
                linearInequality.mConstant = new AffineTerm(Rational.ONE);
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray[n2];
                    LinearInequality linearInequality2 = LinearInequality.fromTerm(term2);
                    if (linearInequality.isConstant() && linearInequality.mConstant.isConstant()) {
                        linearInequality2.mult(linearInequality.mConstant.getConstant());
                        linearInequality = linearInequality2;
                    } else {
                        if (!linearInequality2.isConstant() || !linearInequality2.mConstant.isConstant()) throw new TermIsNotAffineException("Product with more than one non-constant factors found", (Term)applicationTerm);
                        linearInequality.mult(linearInequality2.mConstant.getConstant());
                    }
                    ++n2;
                }
                return linearInequality;
            } else if ("/".equals(applicationTerm.getFunction().getName())) {
                assert (applicationTerm.getParameters().length == 2);
                LinearInequality linearInequality3 = LinearInequality.fromTerm(applicationTerm.getParameters()[0]);
                LinearInequality linearInequality4 = LinearInequality.fromTerm(applicationTerm.getParameters()[1]);
                if (!linearInequality4.isConstant() || !linearInequality4.mConstant.isConstant()) {
                    throw new TermIsNotAffineException("Non-constant divisor", (Term)applicationTerm);
                }
                if (linearInequality4.mConstant.getConstant().equals((Object)Rational.ZERO)) {
                    throw new TermIsNotAffineException("Division by zero", (Term)applicationTerm);
                }
                linearInequality = linearInequality3;
                linearInequality.mult(linearInequality4.mConstant.getConstant().inverse());
                return linearInequality;
            } else {
                if (applicationTerm.getParameters().length != 0) throw new UnknownFunctionException(applicationTerm);
                linearInequality = new LinearInequality();
                linearInequality.add((Term)applicationTerm, Rational.ONE);
            }
        }
        return linearInequality;
    }

    public boolean isConstant() {
        return this.mCoefficients.isEmpty() && this.mConstant.isConstant();
    }

    public boolean allAffineTermsAreConstant() {
        boolean bl = true;
        bl &= this.mConstant.isConstant();
        for (AffineTerm affineTerm : this.mCoefficients.values()) {
            bl &= affineTerm.isConstant();
        }
        return bl;
    }

    public AffineTerm getConstant() {
        return this.mConstant;
    }

    public boolean isStrict() {
        return this.mStrict;
    }

    public void setStrict(boolean bl) {
        this.mStrict = bl;
    }

    public String getInequalitySymbol() {
        return this.mStrict ? ">" : ">=";
    }

    public String getInequalitySymbolReverse() {
        return this.mStrict ? "<" : "<=";
    }

    public AffineTerm getCoefficient(Term term) {
        AffineTerm affineTerm = this.mCoefficients.get(term);
        if (affineTerm == null) {
            return new AffineTerm();
        }
        return affineTerm;
    }

    public Collection<Term> getVariables() {
        return this.mCoefficients.keySet();
    }

    public void add(LinearInequality linearInequality) {
        this.add(linearInequality.mConstant);
        for (Map.Entry<Term, AffineTerm> entry : linearInequality.mCoefficients.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void add(Term term, AffineTerm affineTerm) {
        AffineTerm affineTerm2 = this.mCoefficients.get(term);
        if (affineTerm2 != null) {
            affineTerm2.add(affineTerm);
            if (!affineTerm2.isZero()) {
                this.mCoefficients.put(term, affineTerm2);
            } else {
                this.mCoefficients.remove(term);
            }
        } else if (!affineTerm.isZero()) {
            this.mCoefficients.put(term, affineTerm);
        }
    }

    public void add(Term term, Rational rational) {
        this.add(term, new AffineTerm(rational));
    }

    public void add(AffineTerm affineTerm) {
        this.mConstant.add(affineTerm);
    }

    public void mult(Rational rational) {
        this.mConstant.mult(rational);
        for (Map.Entry<Term, AffineTerm> entry : this.mCoefficients.entrySet()) {
            entry.getValue().mult(rational);
        }
    }

    public void negate() {
        this.mult(Rational.MONE);
        this.mStrict = !this.mStrict;
    }

    public String getSortName() {
        if (this.mCoefficients.isEmpty()) {
            return "Real";
        }
        Term term = this.mCoefficients.keySet().iterator().next();
        Sort sort = term.getSort();
        for (Term term2 : this.mCoefficients.keySet()) {
            assert (term2.getSort() == sort);
        }
        return sort.getName();
    }

    public Term asTerm(Script script) {
        String string = this.getSortName();
        boolean bl = string.equals("Real");
        Term[] termArray = new Term[this.mCoefficients.size() + 1];
        Term term2 = bl ? script.decimal(BigDecimal.ZERO) : SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO);
        int n = 0;
        for (Map.Entry<Term, AffineTerm> term3 : this.mCoefficients.entrySet()) {
            Term term;
            Term term4 = term3.getKey();
            if (bl) {
                assert (SmtSortUtils.isRealSort((Sort)term4.getSort()));
                term = term3.getValue().asRealTerm(script);
            } else {
                assert (SmtSortUtils.isIntSort((Sort)term4.getSort()));
                term = term3.getValue().asIntTerm(script);
            }
            termArray[n] = script.term("*", new Term[]{term, term3.getKey()});
            ++n;
        }
        termArray[n] = bl ? this.mConstant.asRealTerm(script) : this.mConstant.asIntTerm(script);
        Term term = SmtUtils.sum((Script)script, (Sort)script.sort(string, new Sort[0]), (Term[])termArray);
        return script.term(this.getInequalitySymbol(), new Term[]{term, term2});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0 ");
        stringBuilder.append(this.getInequalitySymbolReverse());
        stringBuilder.append(" ");
        boolean bl = true;
        for (Map.Entry<Term, AffineTerm> object : this.mCoefficients.entrySet()) {
            if (object.getValue().isZero()) continue;
            String string = object.getValue().toString();
            if (string.length() > 2 && string.substring(2).contains(" ")) {
                if (!bl) {
                    stringBuilder.append(" + ");
                }
                stringBuilder.append("(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            } else if (string.startsWith("-")) {
                if (!bl) {
                    stringBuilder.append(" -");
                    stringBuilder.append(string.substring(1));
                } else {
                    stringBuilder.append(string);
                }
            } else {
                if (!bl) {
                    stringBuilder.append(" + ");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("*");
            stringBuilder.append(object.getKey());
            bl = false;
        }
        if (!this.mConstant.isZero() || bl) {
            String string = this.mConstant.toString();
            if (string.startsWith("-")) {
                if (!bl) {
                    stringBuilder.append(" -");
                    stringBuilder.append(string.substring(1));
                } else {
                    stringBuilder.append(string);
                }
            } else {
                if (!bl) {
                    stringBuilder.append(" + ");
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static enum PossibleMotzkinCoefficients {
        ONE,
        ZERO_AND_ONE,
        ANYTHING;


        public boolean multipleValues() {
            return this == ZERO_AND_ONE || this == ANYTHING;
        }

        public boolean isFixed() {
            return this == ONE || this == ZERO_AND_ONE;
        }
    }
}

