/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.OctagonRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.AffineExpression;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.BoolValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctInterval;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctMatrix;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TVBool;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class OctDomainState
implements IAbstractState<OctDomainState> {
    private static final Comparator<IProgramVarOrConst> LEXICAL_VAR_COMPARATOR = Comparator.comparing(IProgramSymbol::getGloballyUniqueId);
    private static int sId;
    private final int mId;
    private final Function<OctDomainState, String> mLogStringFunction;
    private TVBool mIsBottom;
    private Set<IProgramVarOrConst> mVariables;
    private Map<IProgramVarOrConst, Integer> mMapNumericVarToIndex;
    private Set<IProgramVarOrConst> mNumericNonIntVars;
    private OctMatrix mNumericAbstraction;
    private Map<IProgramVarOrConst, BoolValue> mBooleanAbstraction;
    private Map<Term, IProgramVarOrConst> mTerm2Vars;

    private OctDomainState(Function<OctDomainState, String> function, TVBool tVBool) {
        this.mLogStringFunction = function;
        this.mId = sId++;
        this.mIsBottom = tVBool;
    }

    public static OctDomainState createFreshState(Function<OctDomainState, String> function) {
        return OctDomainState.createFreshState(function, false);
    }

    public static OctDomainState createFreshState(Function<OctDomainState, String> function, boolean bl) {
        OctDomainState octDomainState = new OctDomainState(function, bl ? TVBool.FIXED : TVBool.UNCHECKED);
        octDomainState.mVariables = new HashSet<IProgramVarOrConst>();
        octDomainState.mMapNumericVarToIndex = new HashMap<IProgramVarOrConst, Integer>();
        octDomainState.mNumericNonIntVars = new HashSet<IProgramVarOrConst>();
        octDomainState.mNumericAbstraction = OctMatrix.NEW;
        octDomainState.mBooleanAbstraction = new HashMap<IProgramVarOrConst, BoolValue>();
        return octDomainState;
    }

    public OctDomainState deepCopy() {
        OctDomainState octDomainState = new OctDomainState(this.mLogStringFunction, this.mIsBottom);
        octDomainState.mVariables = new HashSet<IProgramVarOrConst>(this.mVariables);
        octDomainState.mMapNumericVarToIndex = new HashMap<IProgramVarOrConst, Integer>(this.mMapNumericVarToIndex);
        octDomainState.mNumericNonIntVars = new HashSet<IProgramVarOrConst>(this.mNumericNonIntVars);
        octDomainState.mNumericAbstraction = this.mNumericAbstraction.copy();
        octDomainState.mBooleanAbstraction = new HashMap<IProgramVarOrConst, BoolValue>(this.mBooleanAbstraction);
        return octDomainState;
    }

    private OctDomainState shallowCopy() {
        OctDomainState octDomainState = new OctDomainState(this.mLogStringFunction, this.mIsBottom);
        octDomainState.mVariables = this.mVariables;
        octDomainState.mMapNumericVarToIndex = this.mMapNumericVarToIndex;
        octDomainState.mNumericNonIntVars = this.mNumericNonIntVars;
        octDomainState.mNumericAbstraction = this.mNumericAbstraction;
        octDomainState.mBooleanAbstraction = this.mBooleanAbstraction;
        return octDomainState;
    }

    private void unrefVariables(OctDomainState octDomainState) {
        if (octDomainState.mVariables == this.mVariables) {
            octDomainState.mVariables = new HashSet<IProgramVarOrConst>(this.mVariables);
        }
    }

    private void unrefOtherMapNumericVarToIndex(OctDomainState octDomainState) {
        if (octDomainState.mMapNumericVarToIndex == this.mMapNumericVarToIndex) {
            octDomainState.mMapNumericVarToIndex = new HashMap<IProgramVarOrConst, Integer>(this.mMapNumericVarToIndex);
        }
    }

    private void unrefOtherNumericNonIntVars(OctDomainState octDomainState) {
        if (octDomainState.mNumericNonIntVars == this.mNumericNonIntVars) {
            octDomainState.mNumericNonIntVars = new HashSet<IProgramVarOrConst>(this.mNumericNonIntVars);
        }
    }

    private void unrefOtherBooleanAbstraction(OctDomainState octDomainState) {
        if (octDomainState.mBooleanAbstraction == this.mBooleanAbstraction) {
            octDomainState.mBooleanAbstraction = new HashMap<IProgramVarOrConst, BoolValue>(this.mBooleanAbstraction);
        }
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return ImmutableSet.of(this.mVariables);
    }

    public OctDomainState addVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.addVariables(Collections.singleton(iProgramVarOrConst));
    }

    public OctDomainState removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.removeVariables(Collections.singleton(iProgramVarOrConst));
    }

    public OctDomainState addVariables(Collection<IProgramVarOrConst> collection) {
        OctDomainState octDomainState = this.shallowCopy();
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        octDomainState.mIsBottom = this.mIsBottom;
        if (collection.size() > 0) {
            this.unrefVariables(octDomainState);
        }
        for (IProgramVarOrConst iProgramVarOrConst : collection) {
            if (!octDomainState.mVariables.add(iProgramVarOrConst)) {
                throw new IllegalArgumentException("Variable already present: " + String.valueOf(iProgramVarOrConst));
            }
            if (SmtSortUtils.isNumericSort((Sort)iProgramVarOrConst.getSort())) {
                hashSet.add(iProgramVarOrConst);
                if (!SmtSortUtils.isRealSort((Sort)iProgramVarOrConst.getSort())) continue;
                this.unrefOtherNumericNonIntVars(octDomainState);
                octDomainState.mNumericNonIntVars.add(iProgramVarOrConst);
                continue;
            }
            if (!SmtSortUtils.isBoolSort((Sort)iProgramVarOrConst.getSort())) continue;
            this.unrefOtherBooleanAbstraction(octDomainState);
            octDomainState.mBooleanAbstraction.put(iProgramVarOrConst, BoolValue.TOP);
        }
        this.addNumericVariables(octDomainState, hashSet);
        return octDomainState;
    }

    private void addNumericVariables(OctDomainState octDomainState, Set<IProgramVarOrConst> set) {
        if (set.isEmpty()) {
            return;
        }
        TreeMap<IProgramVarOrConst, Integer> treeMap = new TreeMap<IProgramVarOrConst, Integer>(LEXICAL_VAR_COMPARATOR);
        treeMap.putAll(this.mMapNumericVarToIndex);
        set.forEach(iProgramVarOrConst -> {
            Integer n = treeMap.put((IProgramVarOrConst)iProgramVarOrConst, -1);
        });
        octDomainState.mMapNumericVarToIndex = new HashMap<IProgramVarOrConst, Integer>();
        int n = 0;
        int[] nArray = new int[this.mMapNumericVarToIndex.size() + set.size()];
        for (Map.Entry entry : treeMap.entrySet()) {
            nArray[n] = (Integer)entry.getValue();
            entry.setValue(n);
            octDomainState.mMapNumericVarToIndex.put((IProgramVarOrConst)entry.getKey(), n);
            ++n;
        }
        octDomainState.mNumericAbstraction = this.mNumericAbstraction.rearrange(nArray);
    }

    public OctDomainState removeVariables(Collection<IProgramVarOrConst> collection) {
        OctDomainState octDomainState = this.shallowCopy();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (IProgramVarOrConst iProgramVarOrConst : collection) {
            this.unrefVariables(octDomainState);
            octDomainState.mVariables.remove(iProgramVarOrConst);
            if (octDomainState.mMapNumericVarToIndex.containsKey(iProgramVarOrConst)) {
                this.unrefOtherMapNumericVarToIndex(octDomainState);
                int n = octDomainState.mMapNumericVarToIndex.remove(iProgramVarOrConst);
                hashSet.add(n);
                if (!this.mNumericNonIntVars.contains(iProgramVarOrConst)) continue;
                this.unrefOtherNumericNonIntVars(octDomainState);
                octDomainState.mNumericNonIntVars.remove(iProgramVarOrConst);
                continue;
            }
            if (!this.mBooleanAbstraction.containsKey(iProgramVarOrConst)) continue;
            this.unrefOtherBooleanAbstraction(octDomainState);
            octDomainState.mBooleanAbstraction.remove(iProgramVarOrConst);
        }
        if (!hashSet.isEmpty()) {
            octDomainState.mNumericAbstraction = this.cachedSelectiveClosure().removeVariables(hashSet);
            OctDomainState.defragmentMap(octDomainState.mMapNumericVarToIndex);
        }
        return octDomainState;
    }

    /*
     * WARNING - void declaration
     */
    public OctDomainState renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        void var10_14;
        Object object;
        Object object2;
        if (map == null || map.isEmpty()) {
            return this;
        }
        HashMap<IProgramVarOrConst, IProgramVarOrConst> hashMap = new HashMap<IProgramVarOrConst, IProgramVarOrConst>(map);
        for (Map.Entry<IProgramVarOrConst, IProgramVarOrConst> object32 : map.entrySet()) {
            object2 = object32.getKey();
            object = object32.getValue();
            if (object == null) {
                throw new IllegalArgumentException("Cannot rename " + String.valueOf(object2) + " to null");
            }
            if (object2 == object) {
                hashMap.remove(object2);
            }
            if (this.mVariables.contains(object2)) continue;
            hashMap.remove(object2);
        }
        if (hashMap.isEmpty()) {
            return this;
        }
        OctDomainState octDomainState = this.shallowCopy();
        this.unrefVariables(octDomainState);
        hashMap.entrySet().stream().forEach(entry -> {
            octDomainState.mVariables.remove(entry.getKey());
            octDomainState.mVariables.add((IProgramVarOrConst)entry.getValue());
        });
        List list = hashMap.entrySet().stream().filter(entry -> this.mBooleanAbstraction.containsKey(entry.getKey())).collect(Collectors.toList());
        object2 = hashMap.entrySet().stream().filter(entry -> this.mMapNumericVarToIndex.containsKey(entry.getKey())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            this.unrefOtherBooleanAbstraction(octDomainState);
            list.stream().forEach(entry -> {
                BoolValue boolValue = octDomainState.mBooleanAbstraction.remove(entry.getKey());
                octDomainState.mBooleanAbstraction.put((IProgramVarOrConst)entry.getValue(), boolValue);
            });
        }
        if (object2.isEmpty()) {
            return octDomainState;
        }
        object = object2.stream().filter(entry -> this.mNumericNonIntVars.contains(entry.getKey())).collect(Collectors.toList());
        if (!object.isEmpty()) {
            this.unrefOtherNumericNonIntVars(octDomainState);
            object.stream().forEach(entry -> {
                octDomainState.mNumericNonIntVars.remove(entry.getKey());
                octDomainState.mNumericNonIntVars.add((IProgramVarOrConst)entry.getValue());
            });
        }
        this.unrefOtherMapNumericVarToIndex(octDomainState);
        object2.stream().forEach(entry -> {
            Integer n = octDomainState.mMapNumericVarToIndex.remove(entry.getKey());
            octDomainState.mMapNumericVarToIndex.put((IProgramVarOrConst)entry.getValue(), n);
        });
        TreeMap<IProgramVarOrConst, Integer> treeMap = new TreeMap<IProgramVarOrConst, Integer>(LEXICAL_VAR_COMPARATOR);
        treeMap.putAll(octDomainState.mMapNumericVarToIndex);
        int[] nArray = new int[octDomainState.mMapNumericVarToIndex.size()];
        octDomainState.mMapNumericVarToIndex = new HashMap<IProgramVarOrConst, Integer>();
        int n = 0;
        for (Map.Entry n2 : treeMap.entrySet()) {
            nArray[n] = (Integer)n2.getValue();
            n2.setValue(n);
            octDomainState.mMapNumericVarToIndex.put((IProgramVarOrConst)n2.getKey(), n);
            ++n;
        }
        boolean bl = false;
        while (var10_14 < nArray.length) {
            if (nArray[var10_14] != var10_14) {
                octDomainState.mNumericAbstraction = this.mNumericAbstraction.rearrange(nArray);
                break;
            }
            ++var10_14;
        }
        return octDomainState;
    }

    private static <T> void defragmentMap(Map<T, Integer> map) {
        TreeMap<Integer, T> treeMap = new TreeMap<Integer, T>();
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            treeMap.put(entry.getValue(), entry.getKey());
        }
        map.clear();
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            map.put(entry.getValue(), n);
            ++n;
        }
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mVariables.contains(iProgramVarOrConst);
    }

    public boolean isEmpty() {
        return this.mVariables.isEmpty();
    }

    public boolean isBottom() {
        switch (this.mIsBottom) {
            case FALSE: {
                return false;
            }
            case TRUE: 
            case FIXED: {
                return true;
            }
            case UNCHECKED: {
                boolean bl = this.isBooleanAbstractionBottom() || this.isNumericAbstractionBottom();
                this.mIsBottom = bl ? TVBool.TRUE : TVBool.FALSE;
                return bl;
            }
        }
        throw new UnsupportedOperationException("Unknown LBool " + String.valueOf((Object)this.mIsBottom));
    }

    private boolean isNumericAbstractionBottom() {
        return this.cachedSelectiveClosure().hasNegativeSelfLoop();
    }

    private boolean isBooleanAbstractionBottom() {
        return this.mBooleanAbstraction.containsValue((Object)BoolValue.BOT);
    }

    private OctMatrix cachedSelectiveClosure() {
        if (this.isNumericAbstractionIntegral()) {
            return this.mNumericAbstraction.cachedTightClosure();
        }
        return this.mNumericAbstraction.cachedStrongClosure();
    }

    private OctMatrix bestAvailableClosure() {
        if (this.isNumericAbstractionIntegral() && this.mNumericAbstraction.hasCachedTightClosure()) {
            return this.mNumericAbstraction.cachedTightClosure();
        }
        if (this.mNumericAbstraction.hasCachedStrongClosure()) {
            return this.mNumericAbstraction.cachedStrongClosure();
        }
        return this.mNumericAbstraction;
    }

    private boolean isNumericAbstractionIntegral() {
        return this.mNumericNonIntVars.isEmpty();
    }

    public boolean isEqualTo(OctDomainState octDomainState) {
        if (octDomainState == null) {
            return false;
        }
        if (octDomainState == this) {
            return true;
        }
        boolean bl = this.mVariables.equals(octDomainState.mVariables) && this.mBooleanAbstraction.equals(octDomainState.mBooleanAbstraction) && this.numericAbstractionIsEqualTo(octDomainState);
        return bl;
    }

    public IAbstractState.SubsetResult isSubsetOf(OctDomainState octDomainState) {
        if (this.isBottom() && octDomainState.isBottom()) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (this.isBottom()) {
            return IAbstractState.SubsetResult.STRICT;
        }
        if (octDomainState.isBottom()) {
            return IAbstractState.SubsetResult.NONE;
        }
        for (Map.Entry<IProgramVarOrConst, BoolValue> entry : this.mBooleanAbstraction.entrySet()) {
            BoolValue boolValue = entry.getValue();
            BoolValue boolValue2 = octDomainState.mBooleanAbstraction.get(entry.getKey());
            if (boolValue2 == null || boolValue.isSubsetEqual(boolValue2)) continue;
            return IAbstractState.SubsetResult.NONE;
        }
        if (!this.cachedSelectiveClosure().elementwiseRelation(octDomainState.mNumericAbstraction, OctMatrix.sRelationLessThanOrEqual)) {
            return IAbstractState.SubsetResult.NONE;
        }
        return IAbstractState.SubsetResult.NON_STRICT;
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OctDomainState octDomainState = (OctDomainState)object;
        return this.mId == octDomainState.mId;
    }

    private boolean numericAbstractionIsEqualTo(OctDomainState octDomainState) {
        boolean bl;
        assert (this.mMapNumericVarToIndex.keySet().equals(octDomainState.mMapNumericVarToIndex.keySet()));
        OctMatrix octMatrix = this.cachedSelectiveClosure();
        OctMatrix octMatrix2 = octDomainState.cachedSelectiveClosure();
        boolean bl2 = octMatrix.hasNegativeSelfLoop();
        if (bl2 != (bl = octMatrix2.hasNegativeSelfLoop())) {
            return false;
        }
        if (bl2) {
            return true;
        }
        return octMatrix.isEqualTo(octMatrix2);
    }

    public OctDomainState intersect(OctDomainState octDomainState) {
        OctMatrix octMatrix = OctMatrix.min(this.bestAvailableClosure(), octDomainState.bestAvailableClosure());
        return this.operation(octDomainState, BoolValue::intersect, octMatrix);
    }

    public OctDomainState union(OctDomainState octDomainState) {
        if (this.isBottom()) {
            return octDomainState;
        }
        if (octDomainState.isBottom()) {
            return this;
        }
        OctMatrix octMatrix = OctMatrix.max(this.bestAvailableClosure(), octDomainState.bestAvailableClosure());
        return this.operation(octDomainState, BoolValue::union, octMatrix);
    }

    public OctDomainState widen(OctDomainState octDomainState, BiFunction<OctMatrix, OctMatrix, OctMatrix> biFunction) {
        OctMatrix octMatrix = biFunction.apply(this.mNumericAbstraction, octDomainState.bestAvailableClosure());
        return this.operation(octDomainState, BoolValue::union, octMatrix);
    }

    private OctDomainState operation(OctDomainState octDomainState, BiFunction<BoolValue, BoolValue, BoolValue> biFunction, OctMatrix octMatrix) {
        assert (this.assertNotBottomBeforeAssign());
        assert (octDomainState.assertNotBottomBeforeAssign());
        OctDomainState octDomainState2 = this.shallowCopy();
        for (Map.Entry<IProgramVarOrConst, BoolValue> entry : this.mBooleanAbstraction.entrySet()) {
            BoolValue boolValue;
            IProgramVarOrConst iProgramVarOrConst = entry.getKey();
            BoolValue boolValue2 = entry.getValue();
            if (boolValue2.equals((Object)(boolValue = biFunction.apply(boolValue2, octDomainState.mBooleanAbstraction.get(iProgramVarOrConst))))) continue;
            this.unrefOtherBooleanAbstraction(octDomainState2);
            octDomainState2.mBooleanAbstraction.put(iProgramVarOrConst, boolValue);
        }
        octDomainState2.mNumericAbstraction = octMatrix;
        octDomainState2.mIsBottom = TVBool.UNCHECKED;
        return octDomainState2;
    }

    public Term getTerm(Script script) {
        if (this.isBottom()) {
            return script.term("false", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>(this.getTermNumericAbstraction(script));
        arrayList.addAll(this.getTermBooleanAbstraction(script));
        return SmtUtils.and((Script)script, arrayList);
    }

    private List<Term> getTermNumericAbstraction(Script script) {
        Term[] termArray = new Term[this.mMapNumericVarToIndex.size()];
        for (Map.Entry<IProgramVarOrConst, Integer> entry : this.mMapNumericVarToIndex.entrySet()) {
            Term term;
            termArray[entry.getValue().intValue()] = term = OctDomainState.getTermVar(entry.getKey());
        }
        return this.cachedSelectiveClosure().getTerm(script, termArray);
    }

    private List<Term> getTermBooleanAbstraction(Script script) {
        ArrayList<Term> arrayList = new ArrayList<Term>(this.mBooleanAbstraction.size());
        for (Map.Entry<IProgramVarOrConst, BoolValue> entry : this.mBooleanAbstraction.entrySet()) {
            Term term = OctDomainState.getTermVar(entry.getKey());
            Sort sort = term.getSort().getRealSort();
            Term term2 = entry.getValue().getTerm(script, sort, term);
            arrayList.add(term2);
        }
        return arrayList;
    }

    private static Term getTermVar(IProgramVarOrConst iProgramVarOrConst) {
        if (iProgramVarOrConst instanceof IProgramVar) {
            return ((IProgramVar)iProgramVarOrConst).getTermVariable();
        }
        if (iProgramVarOrConst instanceof ProgramConst) {
            return ((ProgramConst)iProgramVarOrConst).getDefaultConstant();
        }
        throw new AssertionError((Object)("Unexpected type " + iProgramVarOrConst.getClass().getSimpleName()));
    }

    /*
     * WARNING - void declaration
     */
    public OctDomainState patch(OctDomainState octDomainState) {
        assert (this.assertNotBottomBeforeAssign());
        OctDomainState octDomainState2 = this.shallowCopy();
        octDomainState2.mIsBottom = TVBool.UNCHECKED;
        TreeMap<IProgramVarOrConst, Integer> treeMap = new TreeMap<IProgramVarOrConst, Integer>(LEXICAL_VAR_COMPARATOR);
        this.mMapNumericVarToIndex.entrySet().forEach(entry -> {
            Object v0 = treeMap.put((IProgramVarOrConst)entry.getKey(), null);
        });
        for (IProgramVarOrConst object2 : octDomainState.mVariables) {
            this.unrefVariables(octDomainState2);
            boolean bl = octDomainState2.mVariables.add(object2);
            assert (bl || this.mVariables.contains(object2));
            if (SmtSortUtils.isNumericSort((Sort)object2.getSort())) {
                int n = octDomainState.mMapNumericVarToIndex.get(object2);
                treeMap.put(object2, n);
                if (!bl || !SmtSortUtils.isRealSort((Sort)object2.getSort())) continue;
                this.unrefOtherNumericNonIntVars(octDomainState2);
                octDomainState2.mNumericNonIntVars.add(object2);
                continue;
            }
            if (!SmtSortUtils.isBoolSort((Sort)object2.getSort())) continue;
            this.unrefOtherBooleanAbstraction(octDomainState2);
            octDomainState2.mBooleanAbstraction.put(object2, octDomainState.mBooleanAbstraction.get(object2));
        }
        int[] nArray = new int[treeMap.size()];
        HashMap hashMap = new HashMap();
        octDomainState2.mMapNumericVarToIndex = new HashMap<IProgramVarOrConst, Integer>();
        boolean bl = false;
        for (Map.Entry entry2 : treeMap.entrySet()) {
            void var6_9;
            IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)entry2.getKey();
            Integer n = (Integer)entry2.getValue();
            if (n == null) {
                nArray[var6_9] = this.mMapNumericVarToIndex.get(iProgramVarOrConst);
            } else {
                nArray[var6_9] = -1;
                hashMap.put((int)var6_9, n);
            }
            octDomainState2.mMapNumericVarToIndex.put(iProgramVarOrConst, (int)var6_9);
            ++var6_9;
        }
        octDomainState2.mNumericAbstraction = this.cachedSelectiveClosure().rearrange(nArray);
        octDomainState2.mNumericAbstraction.copySelection(octDomainState.bestAvailableClosure(), hashMap);
        return octDomainState2;
    }

    public OctDomainState copyValuesOnScopeChange(OctDomainState octDomainState, List<Pair<IProgramVarOrConst, IProgramVarOrConst>> list, boolean bl) {
        Object object;
        Integer n;
        Integer n2;
        Object object2;
        assert (this.assertNotBottomBeforeAssign());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(list.size());
        Set<Object> set = bl ? this.sharedGlobalVars(octDomainState) : this.sharedGlobalVars(octDomainState).stream().filter(iProgramVarOrConst -> !AbsIntUtil.isOldVar(iProgramVarOrConst)).collect(Collectors.toSet());
        for (IProgramVarOrConst object32 : set) {
            object2 = this.mMapNumericVarToIndex.get(object32);
            if (object2 == null) continue;
            n2 = octDomainState.mMapNumericVarToIndex.get(object32);
            assert (n2 != null) : "shared variables are not really shared";
            hashMap.put((Integer)object2, n2);
        }
        for (Pair pair : list) {
            object2 = (IProgramVarOrConst)pair.getFirst();
            n2 = (IProgramVarOrConst)pair.getSecond();
            n = this.mMapNumericVarToIndex.get(object2);
            if (n != null) {
                object = octDomainState.mMapNumericVarToIndex.get(n2);
                assert (object != null) : "assigned non-numeric var to numeric var";
                hashMap.put(n, (Integer)object);
                continue;
            }
            if (!this.mBooleanAbstraction.containsKey(object2)) continue;
            assert (octDomainState.mBooleanAbstraction.containsKey(n2)) : "assigned non-boolean var to boolean var";
            arrayList.add(new Pair(object2, (Object)n2));
        }
        OctDomainState octDomainState2 = this.shallowCopy();
        octDomainState2.mIsBottom = TVBool.UNCHECKED;
        if (!hashMap.isEmpty()) {
            octDomainState2.mNumericAbstraction = this.cachedSelectiveClosure().copy();
            octDomainState2.mNumericAbstraction.copySelection(octDomainState.bestAvailableClosure(), hashMap);
        }
        if (!arrayList.isEmpty()) {
            this.unrefOtherBooleanAbstraction(octDomainState2);
            for (Pair pair : arrayList) {
                n2 = (IProgramVarOrConst)pair.getFirst();
                n = (IProgramVarOrConst)pair.getSecond();
                object = octDomainState.mBooleanAbstraction.get(n);
                octDomainState2.mBooleanAbstraction.put((IProgramVarOrConst)n2, (BoolValue)((Object)object));
            }
        }
        return octDomainState2;
    }

    public Set<IProgramVarOrConst> sharedGlobalVars(OctDomainState octDomainState) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        Set<IProgramVarOrConst> set = octDomainState.mVariables;
        for (IProgramVarOrConst iProgramVarOrConst : this.mVariables) {
            if (!AbsIntUtil.isGlobal(iProgramVarOrConst) || !set.contains(iProgramVarOrConst)) continue;
            hashSet.add(iProgramVarOrConst);
        }
        return hashSet;
    }

    protected void havocVar(IProgramVarOrConst iProgramVarOrConst) {
        this.havocVars(Collections.singleton(iProgramVarOrConst));
    }

    protected void havocVars(Collection<IProgramVarOrConst> collection) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (IProgramVarOrConst iProgramVarOrConst : collection) {
            Integer n2 = this.mMapNumericVarToIndex.get(iProgramVarOrConst);
            if (n2 != null) {
                hashSet.add(n2);
            } else if (this.mBooleanAbstraction.containsKey(iProgramVarOrConst)) {
                this.mBooleanAbstraction.put(iProgramVarOrConst, BoolValue.TOP);
            }
            assert (this.mVariables.contains(iProgramVarOrConst)) : "unknown variable in havoc: " + String.valueOf(iProgramVarOrConst);
        }
        if (!hashSet.isEmpty()) {
            this.mNumericAbstraction = this.cachedSelectiveClosure().copy();
            hashSet.forEach(n -> this.mNumericAbstraction.havocVar((int)n));
        }
    }

    protected void incrementNumericVar(IProgramVarOrConst iProgramVarOrConst, OctValue octValue) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction.incrementVar(this.numVarIndex(iProgramVarOrConst), octValue);
    }

    protected void negateNumericVar(IProgramVarOrConst iProgramVarOrConst) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction.negateVar(this.numVarIndex(iProgramVarOrConst));
    }

    protected void assignNumericVarConstant(IProgramVarOrConst iProgramVarOrConst, OctValue octValue) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction = this.cachedSelectiveClosure().copy();
        this.mNumericAbstraction.assignVarConstant(this.numVarIndex(iProgramVarOrConst), octValue);
    }

    protected void assignNumericVarInterval(IProgramVarOrConst iProgramVarOrConst, OctInterval octInterval) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction = this.cachedSelectiveClosure().copy();
        this.mNumericAbstraction.assignVarInterval(this.numVarIndex(iProgramVarOrConst), octInterval.getMin(), octInterval.getMax());
    }

    protected void assumeNumericVarConstant(IProgramVarOrConst iProgramVarOrConst, OctValue octValue) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction.assumeVarConstant(this.numVarIndex(iProgramVarOrConst), octValue);
    }

    protected void assumeNumericVarInterval(IProgramVarOrConst iProgramVarOrConst, OctValue octValue, OctValue octValue2) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction.assumeVarInterval(this.numVarIndex(iProgramVarOrConst), octValue, octValue2);
    }

    protected void assumeNumericVarRelationLeConstant(IProgramVarOrConst iProgramVarOrConst, boolean bl, IProgramVarOrConst iProgramVarOrConst2, boolean bl2, OctValue octValue) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mNumericAbstraction.assumeVarRelationLeConstant(this.numVarIndex(iProgramVarOrConst), bl, this.numVarIndex(iProgramVarOrConst2), bl2, octValue);
    }

    public OctInterval projectToInterval(IProgramVarOrConst iProgramVarOrConst) {
        return OctInterval.fromMatrix(this.cachedSelectiveClosure(), this.numVarIndex(iProgramVarOrConst));
    }

    public OctInterval projectToInterval(AffineExpression.TwoVarForm twoVarForm) {
        int n = this.mMapNumericVarToIndex.get(twoVarForm.var1) * 2;
        int n2 = this.mMapNumericVarToIndex.get(twoVarForm.var2) * 2 + 1;
        if (twoVarForm.negVar1) {
            ++n;
        }
        if (twoVarForm.negVar2) {
            --n2;
        }
        OctMatrix octMatrix = this.cachedSelectiveClosure();
        OctValue octValue = octMatrix.get(n2, n);
        OctValue octValue2 = octMatrix.get(n2 ^ 1, n ^ 1).negateIfNotInfinity();
        if (twoVarForm.constant.signum() != 0) {
            octValue = octValue.add(twoVarForm.constant);
            octValue2 = octValue2.add(twoVarForm.constant);
        }
        return new OctInterval(octValue2, octValue);
    }

    public IAbstractPostOperator.EvalResult evaluate(Script script, Term term) {
        if (this.isBottom() || SmtUtils.isTrueLiteral((Term)term)) {
            return IAbstractPostOperator.EvalResult.TRUE;
        }
        if (SmtUtils.isFalseLiteral((Term)term)) {
            return IAbstractPostOperator.EvalResult.FALSE;
        }
        PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)script, (Term)term);
        if (polynomialRelation == null || !polynomialRelation.isAffine()) {
            return IAbstractPostOperator.EvalResult.UNKNOWN;
        }
        OctagonRelation octagonRelation = OctagonRelation.from((PolynomialRelation)polynomialRelation);
        if (octagonRelation == null) {
            return IAbstractPostOperator.EvalResult.UNKNOWN;
        }
        this.mNumericAbstraction = this.cachedSelectiveClosure();
        int n = 2 * this.mMapNumericVarToIndex.get(this.getVariable(octagonRelation.getVar1())) + (octagonRelation.isNegateVar1() ? 1 : 0);
        int n2 = 2 * this.mMapNumericVarToIndex.get(this.getVariable(octagonRelation.getVar2())) + (octagonRelation.isNegateVar2() ? 1 : 0);
        return OctInterval.fromMatrix(this.mNumericAbstraction, n, n2).evaluate(octagonRelation.getRelationSymbol(), octagonRelation.getConstant());
    }

    private IProgramVarOrConst getVariable(Term term) {
        IProgramVarOrConst iProgramVarOrConst2;
        if (this.mTerm2Vars == null) {
            this.mTerm2Vars = new HashMap<Term, IProgramVarOrConst>();
            for (IProgramVarOrConst iProgramVarOrConst2 : this.mMapNumericVarToIndex.keySet()) {
                this.mTerm2Vars.put(iProgramVarOrConst2.getTerm(), iProgramVarOrConst2);
            }
            for (IProgramVarOrConst iProgramVarOrConst2 : this.mBooleanAbstraction.keySet()) {
                this.mTerm2Vars.put(iProgramVarOrConst2.getTerm(), iProgramVarOrConst2);
            }
        }
        if ((iProgramVarOrConst2 = this.mTerm2Vars.get(term)) == null) {
            throw new AssertionError((Object)("Unknown variable for the term " + String.valueOf(term)));
        }
        return iProgramVarOrConst2;
    }

    private int numVarIndex(IProgramVarOrConst iProgramVarOrConst) {
        Integer n = this.mMapNumericVarToIndex.get(iProgramVarOrConst);
        assert (n != null) : "Not a numeric variable: " + String.valueOf(iProgramVarOrConst);
        return n;
    }

    protected void copyVars(List<Pair<IProgramVarOrConst, IProgramVarOrConst>> list) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        boolean bl = false;
        for (Pair<IProgramVarOrConst, IProgramVarOrConst> pair : list) {
            IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)pair.getFirst();
            IProgramVarOrConst iProgramVarOrConst2 = (IProgramVarOrConst)pair.getSecond();
            Integer n = this.mMapNumericVarToIndex.get(iProgramVarOrConst);
            if (n != null) {
                if (!bl) {
                    this.mNumericAbstraction = this.cachedSelectiveClosure().copy();
                    bl = true;
                }
                var8_8 = this.mMapNumericVarToIndex.get(iProgramVarOrConst2);
                assert (var8_8 != null) : "Incompatible types: " + String.valueOf(iProgramVarOrConst2) + " (" + String.valueOf(iProgramVarOrConst2.getSort()) + ") has no matching target";
                this.mNumericAbstraction.assignVarCopy(n, (Integer)var8_8);
            } else if (this.mBooleanAbstraction.containsKey(iProgramVarOrConst)) {
                var8_8 = this.mBooleanAbstraction.get(iProgramVarOrConst2);
                assert (var8_8 != null) : "Incompatible types";
                this.mBooleanAbstraction.put(iProgramVarOrConst, (BoolValue)((Object)var8_8));
            }
            assert (this.mVariables.contains(iProgramVarOrConst) && this.mVariables.contains(iProgramVarOrConst2)) : "unknown variable in assignment: " + String.valueOf(iProgramVarOrConst) + " := " + String.valueOf(iProgramVarOrConst2);
        }
    }

    protected void copyVar(IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2) {
        this.copyVars(Collections.singletonList(new Pair((Object)iProgramVarOrConst, (Object)iProgramVarOrConst2)));
    }

    protected void assignBooleanVar(IProgramVarOrConst iProgramVarOrConst, BoolValue boolValue) {
        assert (this.mBooleanAbstraction.containsKey(iProgramVarOrConst)) : "unknown variable in boolean assignment: " + String.valueOf(iProgramVarOrConst);
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mBooleanAbstraction.put(iProgramVarOrConst, boolValue);
    }

    protected void assumeBooleanVar(IProgramVarOrConst iProgramVarOrConst, BoolValue boolValue) {
        assert (this.assertNotBottomBeforeAssign());
        this.mIsBottom = TVBool.UNCHECKED;
        this.mBooleanAbstraction.put(iProgramVarOrConst, this.mBooleanAbstraction.get(iProgramVarOrConst).intersect(boolValue));
    }

    protected BoolValue getBoolValue(IProgramVarOrConst iProgramVarOrConst) {
        if (!SmtSortUtils.isBoolSort((Sort)iProgramVarOrConst.getSort().getRealSort())) {
            throw new UnsupportedOperationException("Not a boolean: " + iProgramVarOrConst.getGloballyUniqueId());
        }
        if (!this.mBooleanAbstraction.containsKey(iProgramVarOrConst)) {
            throw new UnsupportedOperationException("Boolean variable " + iProgramVarOrConst.getGloballyUniqueId() + " not found in this state.");
        }
        return this.mBooleanAbstraction.get(iProgramVarOrConst);
    }

    private boolean assertNotBottomBeforeAssign() {
        return this.mIsBottom != TVBool.TRUE && this.mIsBottom != TVBool.FIXED;
    }

    public String toString() {
        return this.toLogString();
    }

    public String toLogString() {
        return this.mLogStringFunction.apply(this);
    }

    protected Function<OctDomainState, String> getLogStringFunction() {
        return this.mLogStringFunction;
    }

    public String logStringFullMatrix() {
        return this.logStringMatrix(this.mNumericAbstraction.toStringFull());
    }

    public String logStringHalfMatrix() {
        return this.logStringMatrix(this.mNumericAbstraction.toStringHalf());
    }

    private String logStringMatrix(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(string);
        stringBuilder.append("numeric vars: ").append(this.mMapNumericVarToIndex);
        stringBuilder.append("\nnumeric non-int vars: ").append(this.mNumericNonIntVars);
        stringBuilder.append("\nboolean abstraction: ").append(this.mBooleanAbstraction);
        for (Map.Entry<IProgramVarOrConst, BoolValue> entry : this.mBooleanAbstraction.entrySet()) {
            stringBuilder.append(entry.getKey()).append(" = ").append((Object)entry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String logStringTerm() {
        if (this.isBottom()) {
            return "false";
        }
        StringBuilder stringBuilder = new StringBuilder("ints: {");
        StringBuilder stringBuilder2 = new StringBuilder("reals: {");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        for (Map.Entry<IProgramVarOrConst, Integer> object22 : this.mMapNumericVarToIndex.entrySet()) {
            void var12_17;
            IProgramVarOrConst iProgramVarOrConst = object22.getKey();
            OctInterval octInterval = OctInterval.fromMatrix(this.mNumericAbstraction, object22.getValue());
            if (octInterval.isTop()) {
                ++n3;
                continue;
            }
            if (octInterval.isBottom()) {
                ++n4;
            }
            if (this.mNumericNonIntVars.contains(iProgramVarOrConst)) {
                StringBuilder stringBuilder3 = stringBuilder2;
                ++n;
            } else {
                StringBuilder stringBuilder4 = stringBuilder;
                ++n2;
            }
            var12_17.append(string);
            string = "; ";
            var12_17.append(iProgramVarOrConst).append(" = ").append(octInterval);
        }
        StringBuilder stringBuilder5 = new StringBuilder("relations: {");
        int n5 = 0;
        string = "";
        if (this.mNumericAbstraction.hasNegativeSelfLoop()) {
            stringBuilder5.append("\\bot");
            string = "; ";
            ++n5;
        }
        for (Map.Entry entry : this.mMapNumericVarToIndex.entrySet()) {
            for (Map.Entry<IProgramVarOrConst, Integer> entry2 : this.mMapNumericVarToIndex.entrySet()) {
                int n6;
                IProgramVarOrConst iProgramVarOrConst = (IProgramVarOrConst)entry.getKey();
                IProgramVarOrConst iProgramVarOrConst2 = entry2.getKey();
                int n7 = (Integer)entry.getValue() * 2;
                if (n7 <= (n6 = entry2.getValue() * 2)) continue;
                OctInterval octInterval = new OctInterval(this.mNumericAbstraction.get(n7, n6 + 1).negateIfNotInfinity(), this.mNumericAbstraction.get(n7 + 1, n6));
                OctInterval octInterval2 = new OctInterval(this.mNumericAbstraction.get(n7 + 1, n6 + 1).negateIfNotInfinity(), this.mNumericAbstraction.get(n7, n6));
                if (!octInterval.isTop()) {
                    stringBuilder5.append(string);
                    string = "; ";
                    stringBuilder5.append(iProgramVarOrConst2).append(" + ").append(iProgramVarOrConst).append(" = ").append(octInterval);
                    ++n5;
                }
                if (octInterval2.isTop()) continue;
                stringBuilder5.append(string);
                string = "; ";
                stringBuilder5.append(iProgramVarOrConst2).append(" - ").append(iProgramVarOrConst).append(" = ").append(octInterval2);
                ++n5;
            }
        }
        StringBuilder stringBuilder6 = new StringBuilder("{");
        if (n2 > 0) {
            stringBuilder6.append((CharSequence)stringBuilder).append("}, ");
        }
        if (n > 0) {
            stringBuilder6.append((CharSequence)stringBuilder2).append("}, ");
        }
        if (n3 > 0) {
            stringBuilder6.append(n3).append(" vars top, ");
        }
        if (n4 > 0) {
            stringBuilder6.append(n4).append(" vars bot, ");
        }
        if (n5 > 0) {
            stringBuilder6.append((CharSequence)stringBuilder5).append("}, ");
        }
        if (!this.mBooleanAbstraction.isEmpty()) {
            stringBuilder6.append("bools: ").append(this.mBooleanAbstraction);
        }
        stringBuilder6.append("}");
        return stringBuilder6.toString();
    }

    public OctDomainState compact() {
        return this.removeVariables((Collection)this.topVariables());
    }

    private Collection<IProgramVarOrConst> topVariables() {
        Map.Entry<IProgramVarOrConst, BoolValue> entry2;
        ArrayList<IProgramVarOrConst> arrayList = new ArrayList<IProgramVarOrConst>();
        for (Map.Entry<IProgramVarOrConst, BoolValue> entry2 : this.mBooleanAbstraction.entrySet()) {
            if (entry2.getValue() != BoolValue.TOP) continue;
            arrayList.add((IProgramVarOrConst)entry2.getKey());
        }
        entry2 = this.mNumericAbstraction.variablesWithConstraints();
        for (Map.Entry<IProgramVarOrConst, Integer> entry3 : this.mMapNumericVarToIndex.entrySet()) {
            if (entry2.contains(entry3.getValue())) continue;
            arrayList.add((IProgramVarOrConst)entry3.getKey());
        }
        return arrayList;
    }

    protected OctDomainState createFreshBottomState() {
        return OctDomainState.createFreshState(this.mLogStringFunction, true);
    }
}

