/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemlocArrayUpdaterTransformulaTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements ITransformulaTransformer {
    private final Map<StoreInfo, IProgramConst> mStoreInfoToLocLiteral;
    private final NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> mEdgeToPositionToLocUpdateInfo;
    private final int mMemLocLitCounter = 0;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final MemlocArrayManager mLocArrayManager;
    ManagedScript mMgdScript;
    private final DefaultIcfgSymbolTable mNewSymbolTable;
    private boolean mQueriedStoreAndLitInfo;
    private final HashRelation<String, IProgramNonOldVar> mNewModifiableGlobals;
    private final HashRelation<EdgeInfo, TermVariable> mEdgeToUnconstrainedVars = new HashRelation();
    private final IUltimateServiceProvider mServices;

    public MemlocArrayUpdaterTransformulaTransformer(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, MemlocArrayManager memlocArrayManager, List<IProgramVarOrConst> list, NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> nestedMap2) {
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mEdgeToPositionToLocUpdateInfo = nestedMap2;
        this.mLocArrayManager = memlocArrayManager;
        this.mStoreInfoToLocLiteral = new HashMap<StoreInfo, IProgramConst>();
        this.mHeapArrays = list;
        this.mNewSymbolTable = new DefaultIcfgSymbolTable(cfgSmtToolkit.getSymbolTable(), cfgSmtToolkit.getProcedures());
        this.mNewModifiableGlobals = new HashRelation((AbstractRelation)cfgSmtToolkit.getModifiableGlobalsTable().getProcToGlobals());
        this.mServices = iUltimateServiceProvider;
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
        Object object;
        Term term;
        Cloneable cloneable;
        assert (!this.mQueriedStoreAndLitInfo);
        EdgeInfo edgeInfo = new EdgeInfo((IcfgEdge)iIcfgTransition);
        if (this.mEdgeToPositionToLocUpdateInfo.get((Object)edgeInfo) == null && this.mEdgeToUnconstrainedVars.getImage((Object)edgeInfo) == null) {
            return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula);
        }
        HashMap<? extends IProgramVar, ? extends TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        HashMap<? extends IProgramVar, ? extends TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>();
        HashSet<? extends IProgramConst> hashSet = new HashSet<IProgramConst>();
        HashSet<? extends TermVariable> hashSet2 = new HashSet<TermVariable>();
        Map map = this.mEdgeToPositionToLocUpdateInfo.get((Object)edgeInfo);
        if (map != null) {
            cloneable = new HashMap();
            for (Map.Entry term22 : map.entrySet()) {
                cloneable.put((SubtreePosition)term22.getKey(), ((ArrayEqualityLocUpdateInfo)term22.getValue()).getFormulaWithLocUpdates());
                hashMap.putAll(((ArrayEqualityLocUpdateInfo)term22.getValue()).getExtraInVars());
                hashMap2.putAll(((ArrayEqualityLocUpdateInfo)term22.getValue()).getExtraOutVars());
                hashSet2.addAll(((ArrayEqualityLocUpdateInfo)term22.getValue()).getExtraAuxVars());
                hashSet.addAll(((ArrayEqualityLocUpdateInfo)term22.getValue()).getExtraConstants());
            }
            term = new PositionAwareSubstitution(this.mMgdScript, (Map<? extends SubtreePosition, ? extends Term>)((Object)cloneable)).transform(unmodifiableTransFormula.getFormula());
        } else {
            term = unmodifiableTransFormula.getFormula();
        }
        cloneable = new ArrayList();
        Object object22 = SmtUtils.getDisjuncts((Term)SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)unmodifiableTransFormula.getFormula()));
        int n = ((Term[])object22).length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = object22[n2];
            if (!(SmtUtils.isAtomicFormula((Term)term2) || SmtUtils.isNNF((Term)term2) && !SmtUtils.containsFunctionApplication((Term)term2, (String)"or"))) {
                throw new AssertionError((Object)"the code below only works for conjunctive formulas");
            }
            object = this.mEdgeToUnconstrainedVars.getImage((Object)edgeInfo);
            ArrayList<Term> arrayList = new ArrayList<Term>();
            arrayList.add(term);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TermVariable termVariable = (TermVariable)iterator.next();
                MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(termVariable.getSort());
                int n3 = multiDimensionalSort.getDimension();
                assert (n3 > 0);
                int n4 = 1;
                while (n4 <= n3) {
                    LocArrayInfo locArrayInfo = this.mLocArrayManager.getOrConstructLocArray(edgeInfo, (Term)termVariable, n4);
                    Term term3 = SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)locArrayInfo.getTerm(), (Term)locArrayInfo.getInitializingConstantArray());
                    arrayList.add(term3);
                    ++n4;
                }
            }
            Term term4 = SmtUtils.and((Script)this.mMgdScript.getScript(), arrayList);
            cloneable.add(term4);
            ++n2;
        }
        Term term5 = SmtUtils.or((Script)this.mMgdScript.getScript(), (Collection)((Object)cloneable));
        HashMap<? extends IProgramVar, ? extends TermVariable> hashMap3 = new HashMap<IProgramVar, TermVariable>(unmodifiableTransFormula.getInVars());
        hashMap3.putAll(hashMap);
        for (IProgramVar iProgramVar : hashMap.keySet()) {
            if (iProgramVar instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)iProgramVar);
        }
        HashMap<? extends IProgramVar, ? extends TermVariable> hashMap4 = new HashMap<IProgramVar, TermVariable>(unmodifiableTransFormula.getOutVars());
        hashMap4.putAll(hashMap2);
        for (Object object22 : hashMap2.keySet()) {
            if (object22 instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)object22);
        }
        object22 = new HashSet(unmodifiableTransFormula.getNonTheoryConsts());
        object22.addAll(hashSet);
        for (IProgramConst iProgramConst : hashSet) {
            this.mNewSymbolTable.add((IProgramVarOrConst)iProgramConst);
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(hashMap3, hashMap4, object22.isEmpty(), (Set)object22, unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)unmodifiableTransFormula.getBranchEncoders(), unmodifiableTransFormula.getAuxVars().isEmpty() && hashSet2.isEmpty());
        transFormulaBuilder.setFormula(term5);
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(DataStructureUtils.union((Set)unmodifiableTransFormula.getAuxVars(), hashSet2), this.mMgdScript);
        object = transFormulaBuilder.finishConstruction(this.mMgdScript);
        assert (SmtUtils.checkSatTerm((Script)this.mMgdScript.getScript(), (Term)iIcfgTransition.getTransformula().getClosedFormula()) == Script.LBool.UNSAT || SmtUtils.checkSatTerm((Script)this.mMgdScript.getScript(), (Term)object.getClosedFormula()) != Script.LBool.UNSAT);
        return new ITransformulaTransformer.TransformulaTransformationResult((UnmodifiableTransFormula)object);
    }

    @Override
    public void preprocessIcfg(IIcfg<?> iIcfg) {
    }

    @Override
    public String getName() {
        return "withMemlocArrayUpdates";
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mNewSymbolTable;
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mNewModifiableGlobals;
    }
}

