/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqAtomicBaseNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstantArrayNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqFunctionApplicationNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqMixArrayNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNonAtomicBaseNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EqNodeAndFunctionFactory
extends AbstractNodeAndFunctionFactory<EqNode, Term> {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final Set<Term> mNonTheoryLiteralTerms;
    private final Map<Term, EqNode> mTermToEqNode = new HashMap<Term, EqNode>();
    private final Map<Term, Term> mNormalizationCache = new HashMap<Term, Term>();
    private final List<String> mTrackedArraySubstrings;
    private final Set<String> mMixArrayFunctions;

    public EqNodeAndFunctionFactory(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Set<IProgramConst> set, List<String> list, Set<String> set2) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
        this.mNonTheoryLiteralTerms = set.stream().map(iProgramConst -> iProgramConst.getTerm()).collect(Collectors.toSet());
        this.mTrackedArraySubstrings = list;
        this.mMixArrayFunctions = set2;
    }

    public ManagedScript getScript() {
        return this.mMgdScript;
    }

    @Override
    public EqNode getOrConstructNode(Term term) {
        if (this.isConstantArray(term)) {
            return this.getOrConstructConstantArray(term);
        }
        if (this.isMixArray(term)) {
            return this.getOrConstructMixArray(term);
        }
        if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
            return this.getOrConstructEqFunctionNode((ApplicationTerm)term);
        }
        if (this.isAtomic(term)) {
            return this.getOrConstructEqAtomicBaseNode(term);
        }
        return this.getOrConstructNonAtomicBaseNode(term);
    }

    private EqNode getOrConstructNonAtomicBaseNode(Term term) {
        Term term2 = this.normalizeTerm(term);
        EqNode eqNode = this.mTermToEqNode.get(term2);
        if (eqNode == null) {
            eqNode = (EqNode)this.getBaseElement(term2, false);
            this.mTermToEqNode.put(term2, eqNode);
        }
        assert (eqNode instanceof EqNonAtomicBaseNode);
        return eqNode;
    }

    private EqNode getOrConstructEqFunctionNode(ApplicationTerm applicationTerm) {
        EqNode eqNode = this.mTermToEqNode.get(applicationTerm);
        if (eqNode == null) {
            EqNode eqNode2 = this.getOrConstructNode(applicationTerm.getParameters()[0]);
            EqNode eqNode3 = this.getOrConstructNode(applicationTerm.getParameters()[1]);
            eqNode = (EqNode)super.getOrConstructFuncAppElement((ICongruenceClosureElement)eqNode2, (ICongruenceClosureElement)eqNode3);
            this.mTermToEqNode.put((Term)applicationTerm, eqNode);
        }
        assert (eqNode instanceof EqFunctionApplicationNode);
        return eqNode;
    }

    private EqNode getOrConstructEqAtomicBaseNode(Term term) {
        Term term2 = this.normalizeTerm(term);
        EqNode eqNode = this.mTermToEqNode.get(term2);
        if (eqNode == null) {
            eqNode = (EqNode)this.getBaseElement(term2, this.isTermALiteral(term2));
            this.mTermToEqNode.put(term2, eqNode);
        }
        assert (eqNode instanceof EqAtomicBaseNode);
        return eqNode;
    }

    private Term normalizeTerm(Term term) {
        if (term instanceof TermVariable) {
            return term;
        }
        Term term2 = this.mNormalizationCache.get(term);
        if (term2 != null) {
            return term2;
        }
        this.mMgdScript.lock((Object)this);
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(this.mMgdScript.getScript()).transform(term);
        this.mMgdScript.unlock((Object)this);
        term2 = affineTerm.isErrorTerm() ? new CommuhashNormalForm(this.mServices, this.mMgdScript.getScript()).transform(term) : affineTerm.toTerm(this.mMgdScript.getScript());
        this.mNormalizationCache.put(term, term2);
        return term2;
    }

    @Override
    public boolean hasNode(Term term) {
        return this.mTermToEqNode.get(this.normalizeTerm(term)) != null;
    }

    @Override
    public EqNode getExistingNode(Term term) {
        EqNode eqNode = this.mTermToEqNode.get(this.normalizeTerm(term));
        return eqNode;
    }

    private boolean isTermALiteral(Term term) {
        if (term instanceof TermVariable) {
            return false;
        }
        if (SmtUtils.isTrueLiteral((Term)term) || SmtUtils.isFalseLiteral((Term)term)) {
            return true;
        }
        if (term instanceof ConstantTerm) {
            return true;
        }
        if (this.mNonTheoryLiteralTerms.contains(term)) {
            return true;
        }
        this.mMgdScript.lock((Object)this);
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(this.mMgdScript.getScript()).transform(term);
        this.mMgdScript.unlock((Object)this);
        if (affineTerm.isErrorTerm()) {
            return false;
        }
        return affineTerm.isConstant();
    }

    private boolean isAtomic(Term term) {
        return term instanceof TermVariable || term.getFreeVars().length == 0;
    }

    protected EqNode newBaseElement(Term term, boolean bl) {
        if (this.isAtomic(term)) {
            return new EqAtomicBaseNode(term, bl, this, this.dependsOnUntrackedArray(term));
        }
        assert (!bl);
        assert (term.getFreeVars().length > 0);
        HashSet<EqNode> hashSet = new HashSet<EqNode>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            hashSet.add(this.getOrConstructNode((Term)termVariable));
            ++n2;
        }
        return new EqNonAtomicBaseNode(term, hashSet, this, this.dependsOnUntrackedArray(term));
    }

    private boolean isConstantArray(Term term) {
        if (!term.getSort().isArraySort()) {
            return false;
        }
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term term2 = applicationTerm.getFunction().getDefinition();
        if (term2 != null) {
            return this.isConstantArray(term2);
        }
        return applicationTerm.getFunction().getName().equals("const");
    }

    private boolean isMixArray(Term term) {
        if (!term.getSort().isArraySort()) {
            return false;
        }
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term term2 = applicationTerm.getFunction().getDefinition();
        if (term2 != null) {
            return this.isMixArray(term2);
        }
        return this.mMixArrayFunctions.contains(applicationTerm.getFunction().getName());
    }

    private EqMixArrayNode getOrConstructMixArray(Term term) {
        assert (this.isMixArray(term));
        EqNode eqNode = this.mTermToEqNode.get(term);
        if (eqNode != null) {
            return (EqMixArrayNode)eqNode;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term term2 = applicationTerm.getFunction().getDefinition();
        if (term2 != null) {
            throw new AssertionError((Object)"not yet implemented");
        }
        assert (applicationTerm.getParameters().length == 3);
        assert (applicationTerm.getParameters()[2].getSort().isArraySort() && new MultiDimensionalSort(applicationTerm.getParameters()[2].getSort()).getArrayValueSort().getName().equals("Bool"));
        assert (this.mMixArrayFunctions.contains(applicationTerm.getFunction().getName()));
        EqNode eqNode2 = this.getOrConstructNode(applicationTerm.getParameters()[0]);
        EqNode eqNode3 = this.getOrConstructNode(applicationTerm.getParameters()[1]);
        EqMixArrayNode eqMixArrayNode = new EqMixArrayNode(term, this, eqNode2, eqNode3);
        this.mTermToEqNode.put(term, eqMixArrayNode);
        return eqMixArrayNode;
    }

    private EqConstantArrayNode getOrConstructConstantArray(Term term) {
        assert (this.isConstantArray(term));
        EqNode eqNode = this.mTermToEqNode.get(term);
        if (eqNode != null) {
            return (EqConstantArrayNode)eqNode;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term term2 = applicationTerm.getFunction().getDefinition();
        if (term2 != null) {
            assert (applicationTerm.getParameters().length == 1);
            TermVariable termVariable = applicationTerm.getFunction().getDefinitionVars()[0];
            Term term3 = applicationTerm.getParameters()[0];
            Term term4 = Substitution.apply((ManagedScript)this.mMgdScript, Collections.singletonMap(termVariable, term3), (Term)term2);
            return this.getOrConstructConstantArray(term4);
        }
        assert (applicationTerm.getFunction().getName().equals("const"));
        EqNode eqNode2 = this.getOrConstructNode(applicationTerm.getParameters()[0]);
        EqConstantArrayNode eqConstantArrayNode = new EqConstantArrayNode(term, this, eqNode2);
        this.mTermToEqNode.put(term, eqConstantArrayNode);
        return eqConstantArrayNode;
    }

    private boolean dependsOnUntrackedArray(Term term) {
        if (this.mTrackedArraySubstrings == null) {
            return false;
        }
        if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
            return this.dependsOnUntrackedArray(((ApplicationTerm)term).getParameters()[0]);
        }
        if (term.getSort().isArraySort() && (SmtUtils.isConstant((Term)term) || term instanceof TermVariable)) {
            for (String string : this.mTrackedArraySubstrings) {
                if (!term.toString().contains(string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected EqNode newFuncAppElement(EqNode eqNode, EqNode eqNode2) {
        Term term = this.buildSelectTerm(eqNode, eqNode2);
        return new EqFunctionApplicationNode(eqNode, eqNode2, term, this, this.dependsOnUntrackedArray(term));
    }

    private Term buildSelectTerm(EqNode eqNode, EqNode eqNode2) {
        this.mMgdScript.lock((Object)this);
        Term term = this.mMgdScript.term((Object)this, "select", new Term[]{eqNode.getTerm(), eqNode2.getTerm()});
        this.mMgdScript.unlock((Object)this);
        return term;
    }

    boolean isFunction(Term term) {
        return term.getSort().isArraySort();
    }

    public Set<Term> getNonTheoryLiterals() {
        return Collections.unmodifiableSet(this.mNonTheoryLiteralTerms);
    }

    @Override
    public Term getNonTheoryLiteralDisequalities() {
        return SmtUtils.and((Script)this.mMgdScript.getScript(), CongruenceClosureSmtUtils.createDisequalityTermsForNonTheoryLiterals(this.mMgdScript.getScript(), this.getNonTheoryLiterals()));
    }
}

