/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransFormulaBuilder {
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private final Set<IProgramConst> mNonTheoryConsts;
    private final Set<TermVariable> mAuxVars;
    private final Set<TermVariable> mBranchEncoders;
    private UnmodifiableTransFormula.Infeasibility mInfeasibility = null;
    private Term mFormula = null;
    private boolean mConstructionFinished = false;

    public TransFormulaBuilder(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, boolean bl, Set<IProgramConst> set, boolean bl2, Collection<TermVariable> collection, boolean bl3) {
        this.mInVars = map == null ? new HashMap<IProgramVar, TermVariable>() : new HashMap<IProgramVar, TermVariable>(map);
        this.mOutVars = map2 == null ? new HashMap<IProgramVar, TermVariable>() : new HashMap<IProgramVar, TermVariable>(map2);
        if (bl) {
            this.mNonTheoryConsts = ImmutableSet.empty();
            if (set != null && !set.isEmpty()) {
                throw new IllegalArgumentException("if emptyNonTheoryConsts=true, you cannot provide nonTheoryConsts");
            }
        } else {
            this.mNonTheoryConsts = set == null ? new HashSet<IProgramConst>() : new HashSet<IProgramConst>(set);
        }
        this.mAuxVars = bl3 ? ImmutableSet.empty() : new HashSet<TermVariable>();
        if (bl2) {
            this.mBranchEncoders = ImmutableSet.empty();
            if (collection != null && !collection.isEmpty()) {
                throw new IllegalArgumentException("if emptyBranchEncoders=true, you cannot provide branchEncoders");
            }
        } else {
            this.mBranchEncoders = collection == null ? new HashSet<TermVariable>() : new HashSet<TermVariable>(collection);
        }
    }

    public boolean addAuxVar(TermVariable termVariable) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mAuxVars.add(termVariable);
    }

    public void addAuxVarsButRenameToFreshCopies(Set<? extends TermVariable> set, ManagedScript managedScript) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        if (this.mFormula == null) {
            throw new IllegalStateException("Formula not yet set, cannot rename.");
        }
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (TermVariable termVariable : set) {
            TermVariable termVariable2 = managedScript.constructFreshCopy(termVariable);
            this.addAuxVar(termVariable2);
            hashMap.put(termVariable, termVariable2);
        }
        this.mFormula = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)this.mFormula);
    }

    public boolean removeAuxVar(TermVariable termVariable) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mAuxVars.remove(termVariable);
    }

    public boolean addBranchEncoder(TermVariable termVariable) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mBranchEncoders.add(termVariable);
    }

    public boolean addBranchEncoders(Collection<? extends TermVariable> collection) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mBranchEncoders.addAll(collection);
    }

    public boolean containsInVar(IProgramVar iProgramVar) {
        return this.mInVars.containsKey(iProgramVar);
    }

    public TermVariable getInVar(IProgramVar iProgramVar) {
        return this.mInVars.get(iProgramVar);
    }

    public TermVariable addInVar(IProgramVar iProgramVar, TermVariable termVariable) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mInVars.put(iProgramVar, termVariable);
    }

    public void addInVars(Map<? extends IProgramVar, ? extends TermVariable> map) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        this.mInVars.putAll(map);
    }

    public TermVariable removeInVar(IProgramVar iProgramVar) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mInVars.remove(iProgramVar);
    }

    public boolean containsOutVar(IProgramVar iProgramVar) {
        return this.mOutVars.containsKey(iProgramVar);
    }

    public TermVariable getOutVar(IProgramVar iProgramVar) {
        return this.mOutVars.get(iProgramVar);
    }

    public TermVariable addOutVar(IProgramVar iProgramVar, TermVariable termVariable) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mOutVars.put(iProgramVar, termVariable);
    }

    public void addOutVars(Map<? extends IProgramVar, ? extends TermVariable> map) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        this.mOutVars.putAll(map);
    }

    public TermVariable removeOutVar(IProgramVar iProgramVar) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mOutVars.remove(iProgramVar);
    }

    public void clearOutVars() {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        this.mOutVars.clear();
    }

    public void removeOutVarsOfLocalContext() {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        Iterator<Map.Entry<IProgramVar, TermVariable>> iterator = this.mOutVars.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IProgramVar, TermVariable> entry = iterator.next();
            if (entry.getKey().isGlobal() && !entry.getKey().isOldvar()) continue;
            iterator.remove();
        }
    }

    public boolean addProgramConst(IProgramConst iProgramConst) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mNonTheoryConsts.add(iProgramConst);
    }

    public void setInfeasibility(UnmodifiableTransFormula.Infeasibility infeasibility) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        if (this.mInfeasibility != null) {
            throw new IllegalStateException("Infeasibility already set.");
        }
        this.mInfeasibility = infeasibility;
    }

    public void setFormula(Term term) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        if (this.mFormula != null) {
            throw new IllegalStateException("Formula already set.");
        }
        this.mFormula = term;
    }

    public void ensureInternalNormalForm() {
        if (this.mFormula == null) {
            throw new IllegalStateException("Cannot ensure internal normal form without formula");
        }
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        List<TermVariable> list = Arrays.asList(this.mFormula.getFreeVars());
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mInVars.entrySet()) {
            if (this.mOutVars.containsKey(entry.getKey()) || list.contains(entry.getValue())) continue;
            this.mOutVars.put(entry.getKey(), entry.getValue());
            hashSet.add(entry.getKey());
        }
        for (IProgramVar iProgramVar : hashSet) {
            this.mInVars.remove(iProgramVar);
        }
    }

    public UnmodifiableTransFormula finishConstruction(ManagedScript managedScript) {
        if (this.mFormula == null) {
            throw new IllegalStateException("cannot finish without formula");
        }
        if (this.mInfeasibility == null) {
            throw new IllegalStateException("cannot finish without feasibility status");
        }
        this.mConstructionFinished = true;
        TransFormulaBuilder.removeSuperfluousVars(this.mFormula, this.mInVars, this.mOutVars, this.mAuxVars);
        return new UnmodifiableTransFormula(this.mFormula, Collections.unmodifiableMap(this.mInVars), Collections.unmodifiableMap(this.mOutVars), (ImmutableSet<IProgramConst>)ImmutableSet.of(this.mNonTheoryConsts), (ImmutableSet<TermVariable>)ImmutableSet.of(this.mAuxVars), (ImmutableSet<TermVariable>)ImmutableSet.of(this.mBranchEncoders), this.mInfeasibility, managedScript);
    }

    private static void removeSuperfluousVars(Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, Set<TermVariable> set) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        if (!set.isEmpty()) {
            set.retainAll(hashSet);
        }
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> object : map2.entrySet()) {
            IProgramVar iProgramVar = object.getKey();
            TermVariable termVariable = object.getValue();
            TermVariable termVariable2 = map.get(iProgramVar);
            if (termVariable2 == null) continue;
            if (termVariable2 == termVariable) {
                if (hashSet.contains(termVariable)) continue;
                map.remove(iProgramVar);
                arrayList.add(iProgramVar);
                continue;
            }
            if (!hashSet.contains(termVariable2)) {
                map.remove(iProgramVar);
                continue;
            }
            if (hashSet.contains(termVariable)) continue;
            arrayList.add(iProgramVar);
        }
        for (IProgramVar iProgramVar : arrayList) {
            map2.remove(iProgramVar);
        }
    }

    public static UnmodifiableTransFormula getTrivialTransFormula(ManagedScript managedScript) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, true, null, true);
        transFormulaBuilder.setFormula(managedScript.getScript().term("true", new Term[0]));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula constructTransFormulaFromPredicate(IPredicate iPredicate, ManagedScript managedScript) {
        return TransFormulaBuilder.constructTransFormulaFromTerm(iPredicate.getFormula(), iPredicate.getVars(), managedScript);
    }

    public static UnmodifiableTransFormula constructTransFormulaFromTerm(Term term, Set<? extends IProgramVar> set, ManagedScript managedScript) {
        Set set2;
        Term term2;
        Object object;
        Object object2;
        Set set3 = SmtUtils.extractConstants((Term)term, (boolean)false);
        if (!set3.isEmpty()) {
            throw new UnsupportedOperationException("constants not yet supported");
        }
        Term term3 = new PrenexNormalForm(managedScript).transform(term);
        if (term3 instanceof QuantifiedFormula) {
            object2 = new QuantifierSequence(managedScript, term3);
            object = (QuantifierSequence.QuantifiedVariables)object2.getQuantifierBlocks().get(0);
            if (object.getQuantifier() == 0) {
                term2 = QuantifierSequence.prependQuantifierSequence((Script)managedScript.getScript(), object2.getQuantifierBlocks().subList(1, object2.getNumberOfQuantifierBlocks()), (Term)object2.getInnerTerm());
                set2 = object.getVariables();
            } else {
                term2 = term;
                set2 = Set.of();
            }
        } else {
            term2 = term;
            set2 = Set.of();
        }
        object2 = new TransFormulaBuilder(null, null, true, null, true, null, set2.isEmpty());
        object = new HashMap();
        for (IProgramVar iProgramVar2 : set) {
            TermVariable termVariable = managedScript.constructFreshTermVariable(iProgramVar2.getGloballyUniqueId(), iProgramVar2.getTermVariable().getSort());
            object.put(iProgramVar2.getTermVariable(), termVariable);
            ((TransFormulaBuilder)object2).addInVar(iProgramVar2, termVariable);
            ((TransFormulaBuilder)object2).addOutVar(iProgramVar2, termVariable);
        }
        Term term4 = Substitution.apply((ManagedScript)managedScript, (Map)object, (Term)term2);
        ((TransFormulaBuilder)object2).setFormula(term4);
        if (!set2.isEmpty()) {
            ((TransFormulaBuilder)object2).addAuxVarsButRenameToFreshCopies(set2, managedScript);
        }
        ((TransFormulaBuilder)object2).setInfeasibility(SmtUtils.isFalseLiteral((Term)term4) ? UnmodifiableTransFormula.Infeasibility.INFEASIBLE : UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return ((TransFormulaBuilder)object2).finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula constructAssignment(List<? extends IProgramVar> list, List<Term> list2, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript) {
        return TransFormulaBuilder.constructEquality(list, list2, iIcfgSymbolTable, managedScript, false);
    }

    public static UnmodifiableTransFormula constructEqualityAssumption(List<? extends IProgramVar> list, List<Term> list2, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript) {
        return TransFormulaBuilder.constructEquality(list, list2, iIcfgSymbolTable, managedScript, true);
    }

    private static UnmodifiableTransFormula constructEquality(List<? extends IProgramVar> list, List<Term> list2, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript, boolean bl) {
        ArrayList<Term> arrayList;
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("different number of argument on LHS and RHS");
        }
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (Term object2 : list2) {
            Set set = SmtUtils.extractConstants((Term)object2, (boolean)false);
            if (!set.isEmpty()) {
                throw new UnsupportedOperationException("constants not yet supported");
            }
            arrayList = TermVarsFuns.computeTermVarsFuns(object2, managedScript, iIcfgSymbolTable);
            hashSet.addAll(((TermVarsFuns)((Object)arrayList)).getVars());
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, true, null, true);
        HashMap hashMap = new HashMap();
        for (IProgramVar iProgramVar : hashSet) {
            TermVariable termVariable = managedScript.constructFreshTermVariable(iProgramVar.getGloballyUniqueId(), iProgramVar.getTermVariable().getSort());
            hashMap.put(iProgramVar.getTermVariable(), termVariable);
            transFormulaBuilder.addInVar(iProgramVar, termVariable);
            transFormulaBuilder.addOutVar(iProgramVar, termVariable);
        }
        List list3 = list2.stream().map(term -> Substitution.apply((ManagedScript)managedScript, (Map)hashMap, (Term)term)).collect(Collectors.toList());
        arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < list.size()) {
            IProgramVar iProgramVar = list.get(n);
            TermVariable termVariable = transFormulaBuilder.getOutVar(iProgramVar);
            if (termVariable == null || !bl) {
                termVariable = managedScript.constructFreshTermVariable(iProgramVar.getGloballyUniqueId(), iProgramVar.getTermVariable().getSort());
                transFormulaBuilder.addOutVar(iProgramVar, termVariable);
                if (bl) {
                    transFormulaBuilder.addInVar(iProgramVar, termVariable);
                }
            }
            arrayList.add(SmtUtils.binaryEquality((Script)managedScript.getScript(), (Term)termVariable, (Term)((Term)list3.get(n))));
            ++n;
        }
        Term term2 = SmtUtils.and((Script)managedScript.getScript(), arrayList);
        transFormulaBuilder.setFormula(term2);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula constructAssignment(List<? extends IProgramVar> list, List<? extends IProgramVar> list2, ManagedScript managedScript) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("different number of argument on LHS and RHS");
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, true, null, true);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < list.size()) {
            IProgramVar iProgramVar = list.get(n);
            IProgramVar iProgramVar2 = list2.get(n);
            TermVariable termVariable = managedScript.constructFreshTermVariable(iProgramVar.getGloballyUniqueId(), iProgramVar.getTermVariable().getSort());
            TermVariable termVariable2 = managedScript.constructFreshTermVariable(iProgramVar2.getGloballyUniqueId(), iProgramVar2.getTermVariable().getSort());
            transFormulaBuilder.addInVar(iProgramVar2, termVariable2);
            if (transFormulaBuilder.getOutVar(iProgramVar2) == null) {
                transFormulaBuilder.addOutVar(iProgramVar2, termVariable2);
            }
            transFormulaBuilder.addOutVar(iProgramVar, termVariable);
            arrayList.add(SmtUtils.binaryEquality((Script)managedScript.getScript(), (Term)termVariable, (Term)termVariable2));
            ++n;
        }
        Term term = SmtUtils.and((Script)managedScript.getScript(), arrayList);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    /*
     * WARNING - void declaration
     */
    public static UnmodifiableTransFormula constructCopy(ManagedScript managedScript, TransFormula transFormula, Collection<IProgramVar> collection, Collection<IProgramVar> collection2, Map<IProgramVar, TermVariable> map) {
        void var8_16;
        boolean bl;
        TermVariable termVariable;
        TermVariable termVariable2;
        Set<Object> set = transFormula instanceof UnmodifiableTransFormula ? ((UnmodifiableTransFormula)transFormula).getBranchEncoders() : ImmutableSet.empty();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(transFormula.getInVars(), transFormula.getOutVars(), transFormula.getNonTheoryConsts().isEmpty(), transFormula.getNonTheoryConsts().isEmpty() ? null : transFormula.getNonTheoryConsts(), set.isEmpty(), (Collection<TermVariable>)(set.isEmpty() ? null : set), false);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(transFormula.getAuxVars());
        for (IProgramVar object2 : collection) {
            assert (transFormulaBuilder.mInVars.containsKey(object2)) : "illegal to remove variable not that is contained";
            termVariable2 = transFormulaBuilder.mInVars.get(object2);
            termVariable = transFormulaBuilder.mOutVars.get(object2);
            transFormulaBuilder.mInVars.remove(object2);
            if (termVariable2 == termVariable) continue;
            bl = hashSet.add(termVariable2);
            assert (bl) : "similar var already there";
        }
        for (IProgramVar iProgramVar : collection2) {
            assert (transFormulaBuilder.mOutVars.containsKey(iProgramVar)) : "illegal to remove variable not that is contained";
            termVariable2 = transFormulaBuilder.mInVars.get(iProgramVar);
            termVariable = transFormulaBuilder.mOutVars.get(iProgramVar);
            transFormulaBuilder.mOutVars.remove(iProgramVar);
            if (termVariable2 == termVariable) continue;
            bl = hashSet.add(termVariable);
            assert (bl) : "similar var already there";
        }
        for (Map.Entry entry : map.entrySet()) {
            termVariable2 = transFormulaBuilder.mOutVars.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
            if (termVariable2 == null) continue;
            throw new IllegalArgumentException("Will not add outvar for " + String.valueOf(entry.getKey()) + " it already  has an outVar");
        }
        if (transFormula instanceof UnmodifiableTransFormula) {
            UnmodifiableTransFormula.Infeasibility infeasibility = ((UnmodifiableTransFormula)transFormula).isInfeasible();
        } else {
            UnmodifiableTransFormula.Infeasibility infeasibility = UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        }
        transFormulaBuilder.setFormula(transFormula.getFormula());
        transFormulaBuilder.setInfeasibility((UnmodifiableTransFormula.Infeasibility)var8_16);
        if (!hashSet.isEmpty()) {
            transFormulaBuilder.addAuxVarsButRenameToFreshCopies(hashSet, managedScript);
        }
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends IProgramVar> UnmodifiableTransFormula constructCopy(ManagedScript managedScript, TransFormula transFormula, Map<E, E> map) {
        void var8_12;
        Object object;
        Object object2;
        Map.Entry<IProgramVar, TermVariable> entry2;
        Set<Object> set = transFormula instanceof UnmodifiableTransFormula ? ((UnmodifiableTransFormula)transFormula).getBranchEncoders() : ImmutableSet.empty();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(transFormula.getAuxVars());
        HashMap<Term, Object> hashMap = new HashMap<Term, Object>();
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry2 : transFormula.getInVars().entrySet()) {
            object2 = (IProgramVar)map.get(entry2.getKey());
            if (object2 != null) {
                object = managedScript.constructFreshCopy(object2.getTermVariable());
                hashMap.put((Term)transFormula.getInVars().get(entry2.getKey()), object);
                hashMap2.put((IProgramVar)object2, (TermVariable)object);
                continue;
            }
            hashMap2.put((IProgramVar)entry2.getKey(), (TermVariable)entry2.getValue());
        }
        entry2 = new HashMap();
        for (Map.Entry entry3 : transFormula.getOutVars().entrySet()) {
            object = (IProgramVar)map.get(entry3.getKey());
            if (object != null) {
                TermVariable termVariable;
                if (((TermVariable)entry3.getValue()).equals(transFormula.getInVars().get(entry3.getKey()))) {
                    termVariable = (TermVariable)hashMap2.get(object);
                } else {
                    termVariable = managedScript.constructFreshCopy(object.getTermVariable());
                    hashMap.put((Term)transFormula.getOutVars().get(entry3.getKey()), termVariable);
                }
                entry2.put((IProgramVar)object, termVariable);
                continue;
            }
            entry2.put((IProgramVar)entry3.getKey(), (TermVariable)entry3.getValue());
        }
        if (transFormula instanceof UnmodifiableTransFormula) {
            UnmodifiableTransFormula.Infeasibility infeasibility = ((UnmodifiableTransFormula)transFormula).isInfeasible();
        } else {
            UnmodifiableTransFormula.Infeasibility infeasibility = UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        }
        object2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)transFormula.getFormula());
        object = new TransFormulaBuilder(hashMap2, (Map<IProgramVar, TermVariable>)((Object)entry2), transFormula.getNonTheoryConsts().isEmpty(), transFormula.getNonTheoryConsts().isEmpty() ? null : transFormula.getNonTheoryConsts(), set.isEmpty(), (Collection<TermVariable>)(set.isEmpty() ? null : set), false);
        ((TransFormulaBuilder)object).setFormula((Term)object2);
        ((TransFormulaBuilder)object).setInfeasibility((UnmodifiableTransFormula.Infeasibility)var8_12);
        if (!hashSet.isEmpty()) {
            ((TransFormulaBuilder)object).addAuxVarsButRenameToFreshCopies(hashSet, managedScript);
        }
        return ((TransFormulaBuilder)object).finishConstruction(managedScript);
    }

    /*
     * WARNING - void declaration
     */
    public static UnmodifiableTransFormula transferTransformula(TransferrerWithVariableCache transferrerWithVariableCache, ManagedScript managedScript, TransFormula transFormula, boolean bl) {
        void var8_18;
        Object object;
        Object object2;
        Object object6;
        Object object7;
        if (transFormula instanceof UnmodifiableTransFormula) {
            object7 = ((UnmodifiableTransFormula)transFormula).getBranchEncoders();
            object6 = object7.stream().map(transferrerWithVariableCache::transferTerm).collect(Collectors.toSet());
        } else {
            object6 = ImmutableSet.empty();
        }
        object7 = new HashMap();
        for (Map.Entry<IProgramVar, TermVariable> entry : transFormula.getInVars().entrySet()) {
            IProgramVar iProgramVar = transferrerWithVariableCache.transferProgramVar(entry.getKey());
            if (bl) {
                object2 = managedScript.constructFreshTermVariable(iProgramVar.getGloballyUniqueId(), iProgramVar.getSort());
                transferrerWithVariableCache.getTransferrer().getTransferMapping().put((Term)entry.getValue(), object2);
            } else {
                object2 = transferrerWithVariableCache.transferTerm(entry.getValue());
            }
            object7.put(iProgramVar, object2);
        }
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : transFormula.getOutVars().entrySet()) {
            object2 = transferrerWithVariableCache.transferProgramVar(entry.getKey());
            if (entry.getValue() == transFormula.getInVars().get(entry.getKey())) {
                object = (TermVariable)object7.get(object2);
            } else if (bl) {
                object = managedScript.constructFreshTermVariable(object2.getGloballyUniqueId(), object2.getSort());
                transferrerWithVariableCache.getTransferrer().getTransferMapping().put((Term)entry.getValue(), object);
            } else {
                object = transferrerWithVariableCache.transferTerm(entry.getValue());
            }
            hashMap.put((IProgramVar)object2, (TermVariable)object);
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : transFormula.getAuxVars()) {
            object = managedScript.constructFreshTermVariable("auxVar", transferrerWithVariableCache.getTransferrer().transferSort(termVariable.getSort()));
            transferrerWithVariableCache.getTransferrer().getTransferMapping().put(termVariable, object);
            hashSet.add((TermVariable)object);
        }
        if (transFormula instanceof UnmodifiableTransFormula) {
            UnmodifiableTransFormula.Infeasibility infeasibility = ((UnmodifiableTransFormula)transFormula).isInfeasible();
        } else {
            UnmodifiableTransFormula.Infeasibility infeasibility = UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        }
        object2 = transferrerWithVariableCache.transferTerm(transFormula.getFormula());
        object = transFormula.getNonTheoryConsts().stream().map(transferrerWithVariableCache::transferProgramConst).collect(Collectors.toSet());
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder((Map<IProgramVar, TermVariable>)object7, hashMap, object.isEmpty(), (Set<IProgramConst>)(object.isEmpty() ? null : object), object6.isEmpty(), (Collection<TermVariable>)(object6.isEmpty() ? null : object6), false);
        for (TermVariable termVariable : hashSet) {
            transFormulaBuilder.addAuxVar(termVariable);
        }
        transFormulaBuilder.setFormula((Term)object2);
        transFormulaBuilder.setInfeasibility((UnmodifiableTransFormula.Infeasibility)var8_18);
        return transFormulaBuilder.finishConstruction(managedScript);
    }
}

