/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BuchiPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BasicPredicateFactory
extends SmtFreePredicateFactory {
    protected static final Set<IProgramVar> EMPTY_VARS = Collections.emptySet();
    protected final IIcfgSymbolTable mSymbolTable;
    protected final Script mScript;
    protected final IUltimateServiceProvider mServices;
    protected final ManagedScript mMgdScript;
    protected final ILogger mLogger;

    public BasicPredicateFactory(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mSymbolTable = iIcfgSymbolTable;
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
    }

    public BasicPredicate newPredicate(Term term) {
        assert (term == this.mDontCareTerm || UltimateNormalFormUtils.respectsUltimateNormalForm((Term)term)) : "Term not in UltimateNormalForm";
        TermVarsFuns termVarsFuns = this.constructTermVarsProc(term);
        BasicPredicate basicPredicate = new BasicPredicate(this.constructFreshSerialNumber(), termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula());
        return basicPredicate;
    }

    protected TermVarsFuns constructTermVarsProc(Term term) {
        TermVarsFuns termVarsFuns = term == this.mDontCareTerm ? this.constructDontCare() : TermVarsFuns.computeTermVarsFuns(term, this.mMgdScript, this.mSymbolTable);
        return termVarsFuns;
    }

    private TermVarsFuns constructDontCare() {
        return new TermVarsFuns(this.mDontCareTerm, EMPTY_VARS, Collections.emptySet(), this.mDontCareTerm);
    }

    public IPredicate newBuchiPredicate(Set<IPredicate> set) {
        Term term = this.andTermFromPreds(set, SmtUtils.SimplificationTechnique.NONE);
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns(term, this.mMgdScript, this.mSymbolTable);
        return new BuchiPredicate(this.constructFreshSerialNumber(), termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula(), set);
    }

    public IPredicate and(IPredicate ... iPredicateArray) {
        return this.and(Arrays.asList(iPredicateArray));
    }

    public IPredicate and(SmtUtils.SimplificationTechnique simplificationTechnique, IPredicate ... iPredicateArray) {
        return this.and(simplificationTechnique, Arrays.asList(iPredicateArray));
    }

    public IPredicate and(Collection<IPredicate> collection) {
        return this.and(SmtUtils.SimplificationTechnique.NONE, collection);
    }

    public IPredicate and(SmtUtils.SimplificationTechnique simplificationTechnique, Collection<IPredicate> collection) {
        return this.newPredicate(this.andTermFromPreds(collection, simplificationTechnique));
    }

    public IPredicate or(IPredicate ... iPredicateArray) {
        return this.or(Arrays.asList(iPredicateArray));
    }

    public IPredicate or(SmtUtils.SimplificationTechnique simplificationTechnique, IPredicate ... iPredicateArray) {
        return this.or(simplificationTechnique, Arrays.asList(iPredicateArray));
    }

    public IPredicate or(Collection<IPredicate> collection) {
        return this.or(SmtUtils.SimplificationTechnique.NONE, collection);
    }

    public IPredicate or(SmtUtils.SimplificationTechnique simplificationTechnique, Collection<IPredicate> collection) {
        return this.newPredicate(this.orTermFromPreds(collection, simplificationTechnique));
    }

    public IPredicate not(IPredicate iPredicate) {
        return this.newPredicate(this.notTerm(iPredicate));
    }

    public IPredicate andT(Term ... termArray) {
        return this.andT(Arrays.asList(termArray));
    }

    public IPredicate andT(SmtUtils.SimplificationTechnique simplificationTechnique, Term ... termArray) {
        return this.andT(simplificationTechnique, Arrays.asList(termArray));
    }

    public IPredicate andT(Collection<Term> collection) {
        return this.andT(SmtUtils.SimplificationTechnique.NONE, collection);
    }

    public IPredicate andT(SmtUtils.SimplificationTechnique simplificationTechnique, Collection<Term> collection) {
        return this.newPredicate(this.andTerm(collection, simplificationTechnique));
    }

    public IPredicate orT(Term ... termArray) {
        return this.orT(Arrays.asList(termArray));
    }

    public IPredicate orT(SmtUtils.SimplificationTechnique simplificationTechnique, Term ... termArray) {
        return this.orT(simplificationTechnique, Arrays.asList(termArray));
    }

    public IPredicate orT(Collection<Term> collection) {
        return this.orT(SmtUtils.SimplificationTechnique.NONE, collection);
    }

    public IPredicate orT(SmtUtils.SimplificationTechnique simplificationTechnique, Collection<Term> collection) {
        return this.newPredicate(this.orTerm(collection, simplificationTechnique));
    }

    private Term orTermFromPreds(Collection<IPredicate> collection, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return this.xJunctTermFromPreds(collection, simplificationTechnique, SmtUtils::or, this::getFalse);
    }

    private Term andTermFromPreds(Collection<IPredicate> collection, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return this.xJunctTermFromPreds(collection, simplificationTechnique, SmtUtils::and, this::getTrue);
    }

    private Term xJunctTermFromPreds(Collection<IPredicate> collection, SmtUtils.SimplificationTechnique simplificationTechnique, BiFunction<Script, Collection<Term>, Term> biFunction, Supplier<Term> supplier) {
        List<Term> list = collection.stream().map(IPredicate::getFormula).collect(Collectors.toList());
        return this.xJunctTerm(list, simplificationTechnique, biFunction, supplier);
    }

    private Term orTerm(Collection<Term> collection, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return this.xJunctTerm(collection, simplificationTechnique, SmtUtils::or, this::getFalse);
    }

    private Term andTerm(Collection<Term> collection, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return this.xJunctTerm(collection, simplificationTechnique, SmtUtils::and, this::getTrue);
    }

    private Term xJunctTerm(Collection<Term> collection, SmtUtils.SimplificationTechnique simplificationTechnique, BiFunction<Script, Collection<Term>, Term> biFunction, Supplier<Term> supplier) {
        if (collection.stream().anyMatch(this::isDontCare)) {
            return this.mDontCareTerm;
        }
        if (collection.isEmpty()) {
            return supplier.get();
        }
        Term term = biFunction.apply(this.mScript, collection);
        if (simplificationTechnique != SmtUtils.SimplificationTechnique.NONE) {
            return SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        }
        return term;
    }

    private Term notTerm(IPredicate iPredicate) {
        if (this.isDontCare(iPredicate)) {
            return this.mDontCareTerm;
        }
        return SmtUtils.not((Script)this.mScript, (Term)iPredicate.getFormula());
    }

    private Term getTrue() {
        return this.mScript.term("true", new Term[0]);
    }

    private Term getFalse() {
        return this.mScript.term("false", new Term[0]);
    }

    public <T extends IPredicate> T construct(PredicateConstructorFunction<T> predicateConstructorFunction) {
        return predicateConstructorFunction.construct(this.constructFreshSerialNumber(), this.mScript);
    }

    public static interface PredicateConstructorFunction<T extends IPredicate> {
        public T construct(int var1, Script var2);
    }
}

