/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BuchiAcceptsRecursive<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final NestedWord<LETTER> mStem;
    private final NestedWord<LETTER> mLoop;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mNwa;
    private final boolean mAccepted;

    public BuchiAcceptsRecursive(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedLassoWord<LETTER> nestedLassoWord) {
        super(automataLibraryServices);
        this.mNwa = iNwaOutgoingLetterAndTransitionProvider;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mStem = nestedLassoWord.getStem();
        this.mLoop = nestedLassoWord.getLoop();
        if (!this.checkInputValidity()) {
            this.mAccepted = false;
            return;
        }
        this.mAccepted = this.computeResult(iNwaOutgoingLetterAndTransitionProvider);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mNwa;
    }

    @Override
    public Boolean getResult() {
        return this.mAccepted;
    }

    private boolean checkInputValidity() {
        if (this.mStem.containsPendingReturns()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"This implementation of Buchi acceptance rejects lasso words where the stem contains pending returns.");
            }
            return false;
        }
        if (this.mLoop.containsPendingReturns()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"This implementation of Buchi acceptance rejects lasso words where the loop contains pending returns.");
            }
            return false;
        }
        if (this.mLoop.length() == 0) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"LassoWords with empty lasso are rejected by every B\u00fcchi automaton");
            }
            return false;
        }
        return true;
    }

    private boolean computeResult(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        HashSet hashSet = new HashSet();
        Iterable iterable = iNwaOutgoingLetterAndTransitionProvider.getInitialStates();
        for (Object STATE : iterable) {
            Set set = this.getReachableStates(0, STATE, new LinkedList());
            hashSet.addAll(set);
        }
        boolean bl = false;
        for (Iterator<Object> iterator : hashSet) {
            boolean bl2 = bl = bl || this.isCompleteableToAcceptingRun(new HashMap(), 0, iterator, new LinkedList());
        }
        return bl;
    }

    private Set<STATE> getReachableStates(int n, STATE STATE, List<STATE> list) {
        if (n >= this.mStem.length()) {
            return Collections.singleton(STATE);
        }
        Object LETTER = this.mStem.getSymbol(n);
        Iterable iterable = this.getOutgoingTransitions(n, STATE, list, LETTER, this.mStem, "stem");
        if (!iterable.iterator().hasNext()) {
            return Collections.emptySet();
        }
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (IOutgoingTransitionlet object2 : iterable) {
            arrayList.add(object2.getSucc());
        }
        HashSet hashSet = new HashSet();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            List<STATE> list2 = n2 != arrayList.size() - 1 ? new LinkedList<STATE>(list) : list;
            Set set = this.getReachableStates(n + 1, arrayList.get(n2), list2);
            hashSet.addAll(set);
            ++n2;
        }
        return hashSet;
    }

    boolean isCompleteableToAcceptingRun(Map<STATE, Boolean> map, int n, STATE STATE, List<STATE> list) {
        Object object2;
        int n2 = n;
        assert (n2 <= this.mLoop.length());
        if (n2 == this.mLoop.length()) {
            n2 = 0;
        }
        if (n2 == 0) {
            if (map.containsKey(STATE)) {
                return map.get(STATE);
            }
            map.put(STATE, Boolean.FALSE);
        }
        if (this.mNwa.isFinal(STATE)) {
            for (Object object2 : map.keySet()) {
                map.put(object2, Boolean.TRUE);
            }
        }
        object2 = this.mLoop.getSymbol(n2);
        Iterable iterable = this.getOutgoingTransitions(n2, STATE, list, object2, this.mLoop, "loop");
        ArrayList arrayList = new ArrayList();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            IOutgoingTransitionlet iOutgoingTransitionlet = (IOutgoingTransitionlet)iterator.next();
            arrayList.add(iOutgoingTransitionlet.getSucc());
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        return this.isCompleteableToAcceptingRunHelper(map, list, n2, arrayList);
    }

    private boolean isCompleteableToAcceptingRunHelper(Map<STATE, Boolean> map, List<STATE> list, int n, List<STATE> list2) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < list2.size()) {
            Map<STATE, Boolean> map2;
            List<STATE> list3;
            if (n2 != list2.size() - 1) {
                list3 = new LinkedList<STATE>(list);
                map2 = new HashMap<STATE, Boolean>(map);
            } else {
                list3 = list;
                map2 = map;
            }
            bl = bl || this.isCompleteableToAcceptingRun(map2, n + 1, list2.get(n2), list3);
            ++n2;
        }
        return bl;
    }

    private Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>> getOutgoingTransitions(int n, STATE STATE, List<STATE> list, LETTER LETTER, NestedWord<LETTER> nestedWord, String string) {
        Iterable<IOutgoingTransitionlet<LETTER, STATE>> iterable;
        if (nestedWord.isInternalPosition(n)) {
            iterable = this.mNwa.internalSuccessors(STATE, LETTER);
        } else if (nestedWord.isCallPosition(n)) {
            list.add(STATE);
            iterable = this.mNwa.callSuccessors(STATE, LETTER);
        } else if (nestedWord.isReturnPosition(n)) {
            assert (!list.isEmpty()) : "restricted to " + string + " without pending return";
            STATE STATE2 = list.remove(list.size() - 1);
            iterable = this.mNwa.returnSuccessors(STATE, STATE2, LETTER);
        } else {
            throw new IllegalArgumentException();
        }
        return iterable;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

