/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaCombinator;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import java.util.Arrays;

public class MinimizeNwaPattern<LETTER, STATE>
extends MinimizeNwaCombinator<LETTER, STATE> {
    private final MinimizeNwaCombinator.MinimizationMethods[] mPattern;

    public MinimizeNwaPattern(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, null, false, 0);
    }

    public MinimizeNwaPattern(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, int n) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, partitionBackedSetOfPairs, bl, MinimizeNwaPattern.getDefaultPattern(), n);
    }

    public MinimizeNwaPattern(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, int n, int n2) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, partitionBackedSetOfPairs, bl, MinimizeNwaPattern.getEveryNthPattern(n), n2);
    }

    public MinimizeNwaPattern(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, MinimizeNwaCombinator.MinimizationMethods[] minimizationMethodsArray, int n) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton);
        this.mPattern = Arrays.copyOf(minimizationMethodsArray, minimizationMethodsArray.length);
        int n2 = n % this.mPattern.length;
        this.mMode = this.mPattern[n2];
        super.run(partitionBackedSetOfPairs, bl);
    }

    private static MinimizeNwaCombinator.MinimizationMethods[] getEveryNthPattern(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The minimization index must be strictly positive.");
        }
        MinimizeNwaCombinator.MinimizationMethods[] minimizationMethodsArray = new MinimizeNwaCombinator.MinimizationMethods[n];
        minimizationMethodsArray[n - 1] = MinimizeNwaCombinator.MinimizationMethods.SEVPA;
        int n2 = n - 2;
        while (n2 >= 0) {
            minimizationMethodsArray[n2] = MinimizeNwaCombinator.MinimizationMethods.NONE;
            --n2;
        }
        return minimizationMethodsArray;
    }

    private static MinimizeNwaCombinator.MinimizationMethods[] getDefaultPattern() {
        return new MinimizeNwaCombinator.MinimizationMethods[]{MinimizeNwaCombinator.MinimizationMethods.NONE, MinimizeNwaCombinator.MinimizationMethods.SEVPA, MinimizeNwaCombinator.MinimizationMethods.NONE, MinimizeNwaCombinator.MinimizationMethods.SEVPA, MinimizeNwaCombinator.MinimizationMethods.NONE, MinimizeNwaCombinator.MinimizationMethods.SHRINK_NWA};
    }
}

