/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.Senwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.SenwaWalker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class SenwaBuilder<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>>
implements SenwaWalker.ISuccessorVisitor<LETTER, STATE> {
    private final ISenwaStateFactory<STATE> mStateFactory;
    private final Senwa<LETTER, STATE> mSenwa;
    private final INestedWordAutomaton<LETTER, STATE> mNwa;
    private final Map<STATE, STATE> mResult2Operand = new HashMap<STATE, STATE>();
    private final Map<STATE, Map<STATE, STATE>> mEntry2Operand2Result = new HashMap<STATE, Map<STATE, STATE>>();

    public SenwaBuilder(AutomataLibraryServices automataLibraryServices, ISenwaStateFactory<STATE> iSenwaStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mStateFactory = iSenwaStateFactory;
        this.mNwa = iNestedWordAutomaton;
        this.mLogger.info((Object)this.startMessage());
        this.mSenwa = new Senwa(this.mServices, this.mNwa.getVpAlphabet(), iSenwaStateFactory);
        new SenwaWalker<LETTER, STATE>(this.mServices, this.mSenwa, this, true);
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mSenwa.sizeInformation();
    }

    private STATE getOrConstructResultState(STATE STATE, STATE STATE2, boolean bl) {
        STATE STATE3;
        assert (this.mNwa.getStates().contains(STATE2));
        assert (this.mNwa.getStates().contains(STATE));
        Map<STATE, STATE> map = this.mEntry2Operand2Result.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, STATE>();
            this.mEntry2Operand2Result.put(STATE, map);
        }
        if ((STATE3 = map.get(STATE2)) == null) {
            STATE3 = this.mStateFactory.senwa(STATE, STATE2);
            map.put(STATE2, STATE3);
            this.mResult2Operand.put(STATE3, STATE2);
            STATE STATE4 = map.get(STATE);
            assert (STATE4 != null);
            this.mSenwa.addState(STATE3, bl, this.mNwa.isFinal(STATE2), STATE4);
        }
        return STATE3;
    }

    private STATE getOperandState(STATE STATE) {
        assert (this.mSenwa.getStates().contains(STATE));
        STATE STATE2 = this.mResult2Operand.get(STATE);
        assert (STATE2 != null);
        return STATE2;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        HashSet hashSet = new HashSet();
        for (Object e : this.mNwa.getInitialStates()) {
            Object e2 = this.getOrConstructResultState(e, e, true);
            hashSet.add(e2);
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> visitAndGetInternalSuccessors(STATE STATE) {
        STATE STATE2 = this.mSenwa.getEntry(STATE);
        STATE STATE3 = this.getOperandState(STATE2);
        HashSet<STATE> hashSet = new HashSet<STATE>();
        STATE STATE4 = this.getOperandState(STATE);
        for (Object LETTER : this.mNwa.lettersInternal(STATE4)) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE4, LETTER)) {
                STATE STATE5 = outgoingInternalTransition.getSucc();
                STATE STATE6 = this.getOrConstructResultState(STATE3, STATE5, false);
                hashSet.add(STATE6);
                this.mSenwa.addInternalTransition(STATE, LETTER, STATE6);
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> visitAndGetCallSuccessors(STATE STATE) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        STATE STATE2 = this.getOperandState(STATE);
        for (Object LETTER : this.mNwa.lettersCall(STATE2)) {
            for (OutgoingCallTransition outgoingCallTransition : this.mNwa.callSuccessors(STATE2, LETTER)) {
                STATE STATE3 = outgoingCallTransition.getSucc();
                STATE STATE4 = this.getOrConstructResultState(STATE3, STATE3, false);
                hashSet.add(STATE4);
                this.mSenwa.addCallTransition(STATE, LETTER, STATE4);
            }
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> visitAndGetReturnSuccessors(STATE STATE, STATE STATE2) {
        STATE STATE3 = this.getOperandState(STATE);
        STATE STATE4 = this.getOperandState(STATE2);
        STATE STATE5 = this.mSenwa.getEntry(STATE2);
        STATE STATE6 = this.getOperandState(STATE5);
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (OutgoingReturnTransition outgoingReturnTransition : this.mNwa.returnSuccessorsGivenHier(STATE3, STATE4)) {
            STATE STATE7 = outgoingReturnTransition.getSucc();
            STATE STATE8 = this.getOrConstructResultState(STATE6, STATE7, false);
            hashSet.add(STATE8);
            this.mSenwa.addReturnTransition(STATE, STATE2, outgoingReturnTransition.getLetter(), STATE8);
        }
        return hashSet;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mNwa;
    }

    @Override
    public Senwa<LETTER, STATE> getResult() {
        return this.mSenwa;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        if (!(bl = new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mNwa, this.mSenwa).getResult().booleanValue())) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "", this.mNwa);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }
}

