/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class CachedPersistentSetChoice<L, S>
implements IPersistentSetChoice<L, S> {
    private final Map<Object, Set<L>> mCache = new HashMap<Object, Set<L>>();
    private final IPersistentSetChoice<L, S> mUnderlying;
    private final Function<S, Object> mNormalizer;

    public CachedPersistentSetChoice(IPersistentSetChoice<L, S> iPersistentSetChoice, Function<S, Object> function) {
        this.mUnderlying = iPersistentSetChoice;
        this.mNormalizer = function;
    }

    @Override
    public Set<L> persistentSet(S s) {
        Object object = this.normalize(s);
        if (this.mCache.containsKey(object)) {
            return this.mCache.get(object);
        }
        Set<L> set = this.mUnderlying.persistentSet(s);
        this.mCache.put(object, set);
        return set;
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mUnderlying.getStatistics();
    }

    @Override
    public boolean ensuresCompatibility(IDfsOrder<L, S> iDfsOrder) {
        return this.mUnderlying.ensuresCompatibility(iDfsOrder);
    }

    private Object normalize(S s) {
        if (this.mNormalizer == null) {
            return s;
        }
        return this.mNormalizer.apply(s);
    }
}

