/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.ISuccessorTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Candidate<LETTER, PLACE> {
    private final ISuccessorTransitionProvider<LETTER, PLACE> mSuccTransProvider;
    private final LinkedList<Condition<LETTER, PLACE>> mInstantiated;
    private final LinkedList<PLACE> mNotInstantiated;
    private final Map<PLACE, Set<Condition<LETTER, PLACE>>> mPossibleInstantiationsMap;
    private final LinkedList<Condition<LETTER, PLACE>> mInstantiatedButNotInitially;

    public Candidate(ISuccessorTransitionProvider<LETTER, PLACE> iSuccessorTransitionProvider, Collection<Condition<LETTER, PLACE>> collection, HashRelation<PLACE, Condition<LETTER, PLACE>> hashRelation) {
        this.mSuccTransProvider = iSuccessorTransitionProvider;
        this.mInstantiated = new LinkedList();
        this.mNotInstantiated = new LinkedList<PLACE>(this.mSuccTransProvider.getPredecessorPlaces());
        this.mInstantiatedButNotInitially = new LinkedList();
        for (Condition<LETTER, PLACE> condition : collection) {
            boolean bl = this.mNotInstantiated.remove(condition.getPlace());
            if (!bl) continue;
            this.mInstantiated.add(condition);
        }
        this.mPossibleInstantiationsMap = this.mNotInstantiated.stream().collect(Collectors.toMap(object -> object, arg_0 -> hashRelation.getImage(arg_0)));
    }

    public Candidate(ISuccessorTransitionProvider<LETTER, PLACE> iSuccessorTransitionProvider, LinkedList<PLACE> linkedList, LinkedList<Condition<LETTER, PLACE>> linkedList2, Map<PLACE, Set<Condition<LETTER, PLACE>>> map) {
        this.mSuccTransProvider = iSuccessorTransitionProvider;
        this.mInstantiated = linkedList2;
        this.mNotInstantiated = linkedList;
        this.mPossibleInstantiationsMap = map;
        this.mInstantiatedButNotInitially = null;
    }

    public ISuccessorTransitionProvider<LETTER, PLACE> getTransition() {
        return this.mSuccTransProvider;
    }

    public boolean isFullyInstantiated() {
        return this.mNotInstantiated.isEmpty();
    }

    public PLACE getNextUninstantiatedPlace() {
        return this.mNotInstantiated.getLast();
    }

    public Map<PLACE, Set<Condition<LETTER, PLACE>>> getPossibleInstantiationsMap() {
        return this.mPossibleInstantiationsMap;
    }

    public List<PLACE> getNotInstantiated() {
        return this.mNotInstantiated;
    }

    public Set<Condition<LETTER, PLACE>> getPossibleInstantiations(PLACE PLACE) {
        assert (this.mPossibleInstantiationsMap.get(PLACE) != null) : "p must be contained in the map";
        return this.mPossibleInstantiationsMap.get(PLACE);
    }

    public void instantiateNext(Condition<LETTER, PLACE> condition) {
        if (!this.getNextUninstantiatedPlace().equals(condition.getPlace())) {
            throw new IllegalStateException();
        }
        this.mInstantiatedButNotInitially.add(condition);
        this.mInstantiated.add(condition);
        this.mNotInstantiated.remove(this.mNotInstantiated.size() - 1);
    }

    public void undoOneInstantiation() {
        Condition<LETTER, PLACE> condition = this.mInstantiated.remove(this.mInstantiated.size() - 1);
        this.mInstantiatedButNotInitially.remove(this.mInstantiatedButNotInitially.size() - 1);
        this.mNotInstantiated.add(condition.getPlace());
    }

    public List<Condition<LETTER, PLACE>> getInstantiatedButNotInitially() {
        return this.mInstantiatedButNotInitially;
    }

    public List<Condition<LETTER, PLACE>> getInstantiated() {
        return Collections.unmodifiableList(this.mInstantiated);
    }

    public String toString() {
        return this.mSuccTransProvider.toString();
    }
}

