/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventEventsCoRelation<LETTER, PLACE>
implements ICoRelation<LETTER, PLACE> {
    private static final boolean EXTENDED_ASSERTION_CHECKING = true;
    private long mQueryCounterYes;
    private long mQueryCounterNo;
    private final HashRelation<Event<LETTER, PLACE>, Event<LETTER, PLACE>> mConflictRelation = new HashRelation();
    private final BranchingProcess<LETTER, PLACE> mBranchingProcess;

    public EventEventsCoRelation(BranchingProcess<LETTER, PLACE> branchingProcess) {
        this.mBranchingProcess = branchingProcess;
    }

    @Override
    public long getQueryCounterYes() {
        return this.mQueryCounterYes;
    }

    @Override
    public long getQueryCounterNo() {
        return this.mQueryCounterNo;
    }

    @Override
    public void initialize(Set<Condition<LETTER, PLACE>> set) {
    }

    private Stream<Event<LETTER, PLACE>> streamCoRelatedEvents(Condition<LETTER, PLACE> condition) {
        if (condition.getPredecessorEvent() == this.mBranchingProcess.getDummyRoot()) {
            return Stream.empty();
        }
        HashSet<Event<LETTER, PLACE>> hashSet = new HashSet<Event<LETTER, PLACE>>(this.mBranchingProcess.getEvents());
        hashSet.remove(this.mBranchingProcess.getDummyRoot());
        hashSet.removeAll(condition.getPredecessorEvent().getLocalConfiguration().getEvents());
        return hashSet.stream().filter(event -> !this.mConflictRelation.containsPair(condition.getPredecessorEvent(), event) && !event.getLocalConfiguration().contains(condition.getPredecessorEvent()));
    }

    private Stream<Event<LETTER, PLACE>> streamNonCutoffCoRelatedEvents(Condition<LETTER, PLACE> condition) {
        return this.streamCoRelatedEvents(condition).filter(event -> !event.isCutoffEvent());
    }

    private Stream<Condition<LETTER, PLACE>> streamCoRelatedConditions(Condition<LETTER, PLACE> condition) {
        return Stream.concat(condition.getPredecessorEvent().getConditionMark().stream(), this.streamCoRelatedEvents(condition).flatMap(event -> event.getSuccessorConditions().stream()));
    }

    private Stream<Condition<LETTER, PLACE>> streamNonCutoffCoRelatedConditions(Condition<LETTER, PLACE> condition) {
        return Stream.concat(condition.getPredecessorEvent().getConditionMark().stream(), this.streamNonCutoffCoRelatedEvents(condition).flatMap(event -> event.getSuccessorConditions().stream()));
    }

    @Override
    public void update(Event<LETTER, PLACE> event) {
        Serializable serializable2;
        if (event.getTransition() == null) {
            assert (event.getPredecessorConditions().isEmpty()) : "not initial event";
            return;
        }
        for (Event<LETTER, PLACE> serializable22 : event.getPredecessorEvents()) {
            if (event == serializable22) continue;
            for (Serializable serializable2 : this.mConflictRelation.getImage(serializable22)) {
                assert (event != serializable2) : "event is in conflict to itself";
                this.mConflictRelation.addPair(event, serializable2);
                this.mConflictRelation.addPair(serializable2, event);
            }
        }
        HashSet<Event<LETTER, PLACE>> hashSet = new HashSet<Event<LETTER, PLACE>>();
        hashSet.add(event);
        Set<Condition<LETTER, PLACE>> set = event.getPredecessorConditions();
        serializable2 = new HashSet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            for (Event event2 : condition.getSuccessorEvents()) {
                if (event == event2) continue;
                serializable2.add(event2);
            }
        }
        block4: for (Event event3 : this.mBranchingProcess.getEvents()) {
            Iterator iterator2 = serializable2.iterator();
            while (iterator2.hasNext()) {
                Event event2;
                event2 = iterator2.next();
                if (!event3.getLocalConfiguration().contains(event2)) continue;
                this.mConflictRelation.addPair((Object)event3, event);
                this.mConflictRelation.addPair(event, (Object)event3);
                continue block4;
            }
        }
    }

    @Override
    public boolean isInCoRelation(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        Event<LETTER, PLACE> event;
        boolean bl;
        Event<LETTER, PLACE> event2 = condition.getPredecessorEvent();
        boolean bl2 = bl = !this.mConflictRelation.containsPair(event2, event = condition2.getPredecessorEvent()) && !event2.getLocalConfiguration().contains(event) && !event.getLocalConfiguration().contains(event2) && event2.getAncestors() != 0 && event.getAncestors() != 0 || condition.getPredecessorEvent().conditionMarkContains(condition2) || condition2.getPredecessorEvent().conditionMarkContains(condition);
        if (bl) {
            ++this.mQueryCounterYes;
        } else {
            ++this.mQueryCounterNo;
        }
        return bl;
    }

    public boolean isInIrreflexiveCoRelation(Event<LETTER, PLACE> event, Event<LETTER, PLACE> event2) {
        if (event == event2) {
            return false;
        }
        if (this.mBranchingProcess.getDummyRoot() == event || this.mBranchingProcess.getDummyRoot() == event2) {
            return false;
        }
        Set<Condition<LETTER, PLACE>> set = event.getPredecessorConditions();
        Set<Condition<LETTER, PLACE>> set2 = event2.getPredecessorConditions();
        for (Condition condition : set) {
            if (!set2.contains(condition) && this.isCoset(set2, condition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInCoRelation(Condition<LETTER, PLACE> condition, Event<LETTER, PLACE> event) {
        if (event.getPredecessorConditions().contains(condition)) {
            return false;
        }
        return this.isCoset(event.getPredecessorConditions(), condition);
    }

    @Override
    public boolean isCoset(Collection<Condition<LETTER, PLACE>> collection, Condition<LETTER, PLACE> condition) {
        for (Condition<LETTER, PLACE> condition2 : collection) {
            if (this.isInCoRelation(condition, condition2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mConflictRelation.toString();
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeCoRelatatedConditions(Condition<LETTER, PLACE> condition) {
        Set<Condition<LETTER, PLACE>> set = this.streamCoRelatedConditions(condition).collect(Collectors.toSet());
        assert (set.equals(this.computeCoRelatatedConditionsInefficient(condition))) : "inconsistent co-relation information";
        return set;
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeNonCutoffCoRelatatedConditions(Condition<LETTER, PLACE> condition) {
        Set<Condition<LETTER, PLACE>> set = this.streamNonCutoffCoRelatedConditions(condition).collect(Collectors.toSet());
        return set;
    }

    private Set<Condition<LETTER, PLACE>> computeCoRelatatedConditionsInefficient(Condition<LETTER, PLACE> condition) {
        HashSet<Condition<LETTER, PLACE>> hashSet = new HashSet<Condition<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition2 : this.mBranchingProcess.getConditions()) {
            if (!this.isInCoRelation(condition, condition2)) continue;
            hashSet.add(condition2);
        }
        return hashSet;
    }

    @Override
    public int computeMaximalDegree() {
        Function<Condition, Integer> function = condition -> this.streamCoRelatedEvents((Condition<LETTER, PLACE>)condition).map(event -> event.getSuccessorConditions().size()).reduce(0, Integer::sum);
        Integer n = this.mBranchingProcess.getConditions().stream().map(function).max(Integer::compare).orElse(0);
        return n;
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeCoRelatatedConditions(Condition<LETTER, PLACE> condition2, PLACE PLACE) {
        return this.streamCoRelatedConditions(condition2).filter(condition -> condition.getPlace().equals(PLACE)).collect(Collectors.toSet());
    }

    @Override
    public Set<Event<LETTER, PLACE>> computeCoRelatatedEvents(Event<LETTER, PLACE> event) {
        Set<Condition<LETTER, PLACE>> set = event.getSuccessorConditions();
        if (set.isEmpty()) {
            throw new UnsupportedOperationException("event without successor conditions");
        }
        Iterator<Condition<LETTER, PLACE>> iterator = set.iterator();
        Condition<LETTER, PLACE> condition = iterator.next();
        Set<Event<LETTER, PLACE>> set2 = this.streamCoRelatedEvents(condition).collect(Collectors.toSet());
        while (iterator.hasNext()) {
            Condition<LETTER, PLACE> condition2 = iterator.next();
            Set set3 = this.streamCoRelatedEvents(condition2).collect(Collectors.toSet());
            set2.retainAll(set3);
        }
        return set2;
    }

    @Override
    public Set<Event<LETTER, PLACE>> computeCoRelatatedEvents(Condition<LETTER, PLACE> condition) {
        return this.streamCoRelatedEvents(condition).collect(Collectors.toSet());
    }
}

