/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetAndAutomataInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConditionMarking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IFinitePrefix2PetriNetStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class FinitePrefix2PetriNet<LETTER, PLACE>
extends GeneralOperation<LETTER, PLACE, IPetriNetAndAutomataInclusionStateFactory<PLACE>> {
    private final BranchingProcess<LETTER, PLACE> mInput;
    private final BoundedPetriNet<LETTER, PLACE> mNet;
    private final HashDeque<Pair<Event<LETTER, PLACE>, Event<LETTER, PLACE>>> mMergingCandidates;
    private final HashRelation<Event<LETTER, PLACE>, Condition<LETTER, PLACE>> mConditionPredecessors = new HashRelation();
    private final HashRelation<Condition<LETTER, PLACE>, Event<LETTER, PLACE>> mEventSuccessors = new HashRelation();
    private final UnionFind<Condition<LETTER, PLACE>> mConditionRepresentatives;
    private final UnionFind<Event<LETTER, PLACE>> mEventRepresentatives;
    private final IFinitePrefix2PetriNetStateFactory<PLACE> mStateFactory;
    private final HashRelation<PLACE, PLACE> mOldToNewPlaces = new HashRelation();
    private final HashRelation<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> mOldToNewTransitions = new HashRelation();
    private final boolean mUsePetrification = false;
    private final boolean mRemoveDeadTransitions;
    private int mNumberOfCallsOfMergeCondidates = 0;
    private int mNumberOfMergingCondidates = 0;
    private int mNumberOfMergedEventPairs = 0;
    private int mNumberOfAddOperationsToTheCandQueue = 0;
    private final Set<Event<LETTER, PLACE>> mVitalRepresentatives = new HashSet<Event<LETTER, PLACE>>();

    public FinitePrefix2PetriNet(AutomataLibraryServices automataLibraryServices, IFinitePrefix2PetriNetStateFactory<PLACE> iFinitePrefix2PetriNetStateFactory, BranchingProcess<LETTER, PLACE> branchingProcess) {
        this(automataLibraryServices, iFinitePrefix2PetriNetStateFactory, branchingProcess, false);
    }

    public FinitePrefix2PetriNet(AutomataLibraryServices automataLibraryServices, IFinitePrefix2PetriNetStateFactory<PLACE> iFinitePrefix2PetriNetStateFactory, BranchingProcess<LETTER, PLACE> branchingProcess, boolean bl) {
        super(automataLibraryServices);
        this.mStateFactory = iFinitePrefix2PetriNetStateFactory;
        this.mInput = branchingProcess;
        this.mRemoveDeadTransitions = bl;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        BoundedPetriNet boundedPetriNet = (BoundedPetriNet)this.mInput.getNet();
        this.mMergingCandidates = new HashDeque();
        this.mNet = new BoundedPetriNet(this.mServices, boundedPetriNet.getAlphabet(), false);
        this.mConditionRepresentatives = new UnionFind();
        this.mEventRepresentatives = new UnionFind();
        this.constructNet(branchingProcess);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private void constructNet(BranchingProcess<LETTER, PLACE> branchingProcess) {
        Object object;
        Serializable serializable;
        Object object2;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"CONDITIONS:");
            for (Condition serializable42 : branchingProcess.getConditions()) {
                this.mLogger.debug((Object)serializable42);
            }
            this.mLogger.debug((Object)"EVENTS:");
            for (Event event : branchingProcess.getEvents()) {
                this.mLogger.debug((Object)(String.valueOf(event.getPredecessorConditions()) + " || " + String.valueOf(event) + " || " + String.valueOf(event.getSuccessorConditions())));
            }
        }
        for (Event event : branchingProcess.getEvents()) {
            this.mEventRepresentatives.makeEquivalenceClass((Object)event);
            for (Condition condition : event.getSuccessorConditions()) {
                assert (this.mConditionRepresentatives.find(condition) == null);
                this.mConditionRepresentatives.makeEquivalenceClass(condition);
            }
            for (Condition condition : event.getPredecessorConditions()) {
                this.mEventSuccessors.addPair(condition, (Object)event);
            }
            this.mConditionPredecessors.addAllPairs((Object)event, event.getPredecessorConditions());
        }
        for (Event event : branchingProcess.getEvents()) {
            if (!event.isCutoffEvent()) continue;
            Event event2 = event.getCompanion();
            ConditionMarking conditionMarking = event2.getConditionMark();
            Object object3 = event.getConditionMark();
            this.mergeConditions(((ConditionMarking)object3).getConditions(), conditionMarking.getConditions());
            while (!this.mMergingCandidates.isEmpty()) {
                Iterator iterator;
                ++this.mNumberOfMergingCondidates;
                object2 = (Pair)this.mMergingCandidates.poll();
                Event event3 = (Event)this.mEventRepresentatives.find((Object)((Event)object2.getFirst()));
                if (event3.equals(iterator = (Event)this.mEventRepresentatives.find((Object)((Event)object2.getSecond()))) || !this.mConditionPredecessors.getImage((Object)event3).equals(this.mConditionPredecessors.getImage(iterator))) continue;
                this.mEventRepresentatives.union((Object)event3, iterator);
                serializable = (Event)this.mEventRepresentatives.find((Object)event3);
                Object object4 = ((Event)serializable).equals(event3) ? iterator : event3;
                for (Condition condition : this.mConditionPredecessors.getImage(object4)) {
                    this.mEventSuccessors.removePair((Object)condition, object4);
                    this.mEventSuccessors.addPair((Object)condition, (Object)serializable);
                }
                this.mConditionPredecessors.addAllPairs((Object)serializable, (Collection)this.mConditionPredecessors.getImage(object4));
                this.mConditionPredecessors.removeDomainElement(object4);
                ++this.mNumberOfMergedEventPairs;
                this.mergeConditions(event3.getSuccessorConditions(), ((Event)((Object)iterator)).getSuccessorConditions());
            }
        }
        HashSet hashSet = new HashSet(this.mEventRepresentatives.getAllRepresentatives());
        hashSet.remove(this.mInput.getDummyRoot());
        if (this.mRemoveDeadTransitions) {
            object = new HashRelation();
            for (Event<LETTER, PLACE> event : branchingProcess.getEvents()) {
                if (!event.isCutoffEvent()) continue;
                object.addPair(event.getCompanion(), event);
            }
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            for (Condition condition : branchingProcess.getAcceptingConditions()) {
                object2 = (Event)this.mEventRepresentatives.find(condition.getPredecessorEvent());
                if (this.mVitalRepresentatives.add((Event<LETTER, PLACE>)object2)) {
                    arrayDeque.add(object2);
                }
                for (Event event : branchingProcess.getCoRelation().computeCoRelatatedEvents(condition)) {
                    if (!this.mVitalRepresentatives.add((Event)this.mEventRepresentatives.find(event))) continue;
                    arrayDeque.add((Event)this.mEventRepresentatives.find(event));
                }
            }
            while (!arrayDeque.isEmpty()) {
                Event event = (Event)arrayDeque.removeFirst();
                for (Object object3 : this.mEventRepresentatives.getEquivalenceClassMembers((Object)event)) {
                    for (Event event4 : ((Event)object3).getPredecessorEvents()) {
                        serializable = (Event)this.mEventRepresentatives.find(event4);
                        if (!this.mVitalRepresentatives.add((Event<LETTER, PLACE>)serializable)) continue;
                        arrayDeque.add(serializable);
                    }
                    for (Event event5 : object.getImage(object3)) {
                        serializable = (Event)this.mEventRepresentatives.find(event5);
                        if (!this.mVitalRepresentatives.add((Event<LETTER, PLACE>)serializable)) continue;
                        arrayDeque.add(serializable);
                    }
                }
            }
            this.mVitalRepresentatives.remove(branchingProcess.getDummyRoot());
            hashSet.retainAll(this.mVitalRepresentatives);
        }
        object = new HashMap();
        for (Condition condition : this.mConditionRepresentatives.getAllRepresentatives()) {
            boolean bl = this.containsInitial((Set<Condition<LETTER, PLACE>>)this.mConditionRepresentatives.getEquivalenceClassMembers((Object)condition), branchingProcess.initialConditions());
            boolean bl2 = branchingProcess.getNet().isAccepting(condition.getPlace());
            PLACE PLACE = this.mStateFactory.finitePrefix2net(condition);
            this.mOldToNewPlaces.addPair(condition.getPlace(), PLACE);
            boolean bl3 = this.mNet.addPlace(PLACE, bl, bl2);
            if (!bl3) {
                throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(PLACE)));
            }
            object.put(condition, PLACE);
        }
        for (Event event : hashSet) {
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            for (Condition condition : event.getPredecessorConditions()) {
                serializable = (Condition)this.mConditionRepresentatives.find(condition);
                hashSet2.add(object.get(serializable));
            }
            for (Condition condition : event.getSuccessorConditions()) {
                serializable = (Condition)this.mConditionRepresentatives.find(condition);
                hashSet3.add(object.get(serializable));
            }
            Transition<LETTER, PLACE> transition = this.mNet.addTransition(event.getTransition().getSymbol(), ImmutableSet.of(hashSet2), ImmutableSet.of(hashSet3));
            this.mOldToNewTransitions.addPair(transition, event.getTransition());
        }
    }

    public Set<Transition<LETTER, PLACE>> computeVitalTransitions() {
        assert (this.mRemoveDeadTransitions) : "remove dead transitions must be enabled";
        return this.mVitalRepresentatives.stream().map(Event::getTransition).collect(Collectors.toSet());
    }

    private boolean containsInitial(Set<Condition<LETTER, PLACE>> set, Collection<Condition<LETTER, PLACE>> collection) {
        return collection.stream().anyMatch(condition -> set.contains(condition));
    }

    private boolean petriNetLanguageEquivalence(BoundedPetriNet<LETTER, PLACE> boundedPetriNet, BoundedPetriNet<LETTER, PLACE> boundedPetriNet2, IPetriNetAndAutomataInclusionStateFactory<PLACE> iPetriNetAndAutomataInclusionStateFactory) throws AutomataLibraryException {
        boolean bl;
        NestedRun nestedRun;
        boolean bl2;
        Object object;
        Object object2;
        NestedRun nestedRun2;
        boolean bl3;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Testing Petri net language equivalence");
        }
        boolean bl4 = bl3 = (nestedRun2 = new IsIncluded(this.mServices, iPetriNetAndAutomataInclusionStateFactory, object2 = new PetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, iPetriNetAndAutomataInclusionStateFactory, boundedPetriNet).getResult(), object = new PetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, iPetriNetAndAutomataInclusionStateFactory, boundedPetriNet2).getResult()).getCounterexample()) == null;
        if (!bl3 && this.mLogger.isErrorEnabled()) {
            this.mLogger.error((Object)("Only accepted by first: " + String.valueOf(nestedRun2.getWord())));
        }
        boolean bl5 = bl2 = (nestedRun = new IsIncluded(this.mServices, iPetriNetAndAutomataInclusionStateFactory, object, object2).getCounterexample()) == null;
        if (!bl2 && this.mLogger.isErrorEnabled()) {
            this.mLogger.error((Object)("Only accepted by second: " + String.valueOf(nestedRun.getWord())));
        }
        boolean bl6 = bl = bl3 && bl2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Finished Petri net language equivalence");
        }
        return bl;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Input " + this.mInput.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mNet.sizeInformation() + ". Original net " + this.mInput.getNet().sizeInformation() + ".";
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mNet;
    }

    private void mergeConditions(Set<Condition<LETTER, PLACE>> set, Set<Condition<LETTER, PLACE>> set2) {
        Condition condition2;
        ++this.mNumberOfCallsOfMergeCondidates;
        HashMap<PLACE, Condition> hashMap = new HashMap<PLACE, Condition>();
        Set set3 = set2.stream().map(condition -> (Condition)this.mConditionRepresentatives.find(condition)).collect(Collectors.toSet());
        for (Condition<LETTER, PLACE> condition3 : set) {
            condition2 = (Condition)this.mConditionRepresentatives.find(condition3);
            if (set3.remove(condition2)) continue;
            hashMap.put(condition3.getPlace(), condition2);
        }
        for (Condition<LETTER, PLACE> condition3 : set3) {
            Serializable serializable2;
            condition2 = condition3.getPlace();
            assert (condition2 != null) : "no place for condition " + String.valueOf(condition3);
            Condition condition4 = (Condition)hashMap.get(condition2);
            assert (condition4 != null) : "no condition for place " + String.valueOf(condition2);
            for (Serializable serializable2 : this.mEventSuccessors.getImage((Object)condition4)) {
                for (Event event : this.mEventSuccessors.getImage(condition3)) {
                    if (!((Event)serializable2).getTransition().equals(event.getTransition())) continue;
                    this.mMergingCandidates.add((Object)new Pair((Object)((Event)this.mEventRepresentatives.find((Object)serializable2)), (Object)((Event)this.mEventRepresentatives.find((Object)event))));
                    ++this.mNumberOfAddOperationsToTheCandQueue;
                }
            }
            this.mConditionRepresentatives.union((Object)condition4, condition3);
            serializable2 = (Condition)this.mConditionRepresentatives.find((Object)condition4);
            Condition<LETTER, PLACE> condition5 = ((Condition)serializable2).equals(condition4) ? condition3 : condition4;
            for (Event event : this.mEventSuccessors.getImage((Object)condition5)) {
                this.mConditionPredecessors.removePair((Object)event, (Object)condition5);
                this.mConditionPredecessors.addPair((Object)event, (Object)serializable2);
            }
            this.mEventSuccessors.addAllPairs((Object)serializable2, (Collection)this.mEventSuccessors.getImage((Object)condition5));
            this.mEventSuccessors.removeDomainElement((Object)condition5);
        }
    }

    public HashRelation<PLACE, PLACE> getOldToNewPlaces() {
        return this.mOldToNewPlaces;
    }

    public HashRelation<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> getOldToNewTransitions() {
        return this.mOldToNewTransitions;
    }

    private static <LETTER, PLACE> boolean areIndependent(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        Set set = condition.getSuccessorEvents().stream().map(Event::getTransition).collect(Collectors.toSet());
        Set set2 = condition2.getSuccessorEvents().stream().map(Event::getTransition).collect(Collectors.toSet());
        return Collections.disjoint(set, set2);
    }

    public LinkedHashSet<Condition<LETTER, PLACE>> collectRelevantEvents() {
        LinkedHashSet<Condition<LETTER, PLACE>> linkedHashSet = new LinkedHashSet<Condition<LETTER, PLACE>>();
        for (Event<LETTER, PLACE> event : this.mInput.getEvents()) {
            if (event.isCutoffEvent()) continue;
            linkedHashSet.addAll(event.getSuccessorConditions());
        }
        return linkedHashSet;
    }

    private Map<PLACE, UnionFind<Condition<LETTER, PLACE>>> computeEquivalenceClasses(Collection<Condition<LETTER, PLACE>> collection) {
        HashMap<Object, UnionFind> hashMap = new HashMap<Object, UnionFind>();
        for (Condition<LETTER, PLACE> condition : collection) {
            UnionFind unionFind = hashMap.computeIfAbsent(condition.getPlace(), object -> new UnionFind());
            ArrayList<Condition> arrayList = new ArrayList<Condition>();
            for (Set set : unionFind.getAllEquivalenceClasses()) {
                for (Condition condition2 : set) {
                    boolean bl = FinitePrefix2PetriNet.areIndependent(condition, condition2);
                    if (bl) continue;
                    arrayList.add(condition2);
                }
            }
            unionFind.makeEquivalenceClass(condition);
            for (Condition condition3 : arrayList) {
                unionFind.union(condition, (Object)condition3);
            }
        }
        return hashMap;
    }

    private BoundedPetriNet<LETTER, PLACE> buildPetrification(BranchingProcess<LETTER, PLACE> branchingProcess) {
        LinkedHashSet<Condition<LETTER, PLACE>> linkedHashSet = this.collectRelevantEvents();
        Map<PLACE, UnionFind<Condition<LETTER, PLACE>>> map = this.computeEquivalenceClasses(linkedHashSet);
        Map<Condition<LETTER, PLACE>, PLACE> map2 = this.computeCondition2Place(map, this.mStateFactory);
        BoundedPetriNet boundedPetriNet = new BoundedPetriNet(this.mServices, branchingProcess.getAlphabet(), false);
        for (Map.Entry<Condition<LETTER, PLACE>, PLACE> entry : map2.entrySet()) {
            if (boundedPetriNet.getPlaces().contains(entry.getValue())) continue;
            boolean bl = entry.getKey().getPredecessorEvent() == branchingProcess.getDummyRoot();
            boolean bl2 = branchingProcess.getNet().isAccepting(entry.getKey().getPlace());
            boolean bl3 = boundedPetriNet.addPlace(entry.getValue(), bl, bl2);
            if (!bl3) {
                throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(entry.getValue())));
            }
        }
        this.computeTransitions(branchingProcess.getEvents(), map2).forEach(triple -> {
            Transition transition = boundedPetriNet.addTransition(triple.getFirst(), (ImmutableSet)triple.getSecond(), (ImmutableSet)triple.getThird());
        });
        return boundedPetriNet;
    }

    private HashRelation3<LETTER, ImmutableSet<PLACE>, ImmutableSet<PLACE>> computeTransitions(Collection<Event<LETTER, PLACE>> collection, Map<Condition<LETTER, PLACE>, PLACE> map) {
        HashRelation3 hashRelation3 = new HashRelation3();
        for (Event<LETTER, PLACE> event : collection) {
            ImmutableSet immutableSet;
            if (event.getTransition() == null) continue;
            ImmutableSet immutableSet2 = (ImmutableSet)event.getPredecessorConditions().stream().map(map::get).collect(ImmutableSet.collector());
            assert (!immutableSet2.contains(null));
            if (event.getCompanion() != null) {
                Event<LETTER, PLACE> event2 = event.getCompanion();
                if (event2.getTransition() != event.getTransition()) {
                    throw new UnsupportedOperationException("finite prefix with same transition cut-off required");
                }
                immutableSet = (ImmutableSet)event2.getSuccessorConditions().stream().map(map::get).collect(ImmutableSet.collector());
            } else {
                immutableSet = (ImmutableSet)event.getSuccessorConditions().stream().map(map::get).collect(ImmutableSet.collector());
            }
            assert (!immutableSet.contains(null));
            hashRelation3.addTriple(event.getTransition().getSymbol(), (Object)immutableSet2, (Object)immutableSet);
        }
        return hashRelation3;
    }

    private Map<Condition<LETTER, PLACE>, PLACE> computeCondition2Place(Map<PLACE, UnionFind<Condition<LETTER, PLACE>>> map, IFinitePrefix2PetriNetStateFactory<PLACE> iFinitePrefix2PetriNetStateFactory) {
        HashMap<Condition, PLACE> hashMap = new HashMap<Condition, PLACE>();
        for (Map.Entry<PLACE, UnionFind<Condition<LETTER, PLACE>>> entry : map.entrySet()) {
            for (Condition condition : entry.getValue().getAllRepresentatives()) {
                PLACE PLACE = iFinitePrefix2PetriNetStateFactory.finitePrefix2net(condition);
                for (Condition condition2 : entry.getValue().getEquivalenceClassMembers((Object)condition)) {
                    hashMap.put(condition2, PLACE);
                }
            }
        }
        return hashMap;
    }

    @Override
    public boolean checkResult(IPetriNetAndAutomataInclusionStateFactory<PLACE> iPetriNetAndAutomataInclusionStateFactory) throws AutomataLibraryException {
        if (!(this.mInput.getNet() instanceof BoundedPetriNet)) {
            throw new AssertionError((Object)"implement result checking for on-demand inputs");
        }
        BoundedPetriNet boundedPetriNet = (BoundedPetriNet)this.mInput.getNet();
        boolean bl = this.petriNetLanguageEquivalence(boundedPetriNet, this.mNet, iPetriNetAndAutomataInclusionStateFactory);
        if (!bl) {
            this.mLogger.error((Object)("The result of the " + FinitePrefix2PetriNet.class.getSimpleName() + " recognizes a different language than the original net."));
        }
        return bl;
    }

    class TransitionSet {
        private final Map<LETTER, Map<Set<PLACE>, Set<Set<PLACE>>>> mLetter2Predset2Succsets = new HashMap();

        TransitionSet() {
        }

        void addTransition(LETTER LETTER, Set<PLACE> set, Set<PLACE> set2) {
            Set set3;
            Map map = this.mLetter2Predset2Succsets.get(LETTER);
            if (map == null) {
                map = new HashMap();
                this.mLetter2Predset2Succsets.put(LETTER, map);
            }
            if ((set3 = map.get(set)) == null) {
                set3 = new HashSet();
                map.put(set, set3);
            }
            set3.add(set2);
        }

        void addAllTransitionsToNet(BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
            for (Map.Entry entry : this.mLetter2Predset2Succsets.entrySet()) {
                Object LETTER = entry.getKey();
                Map map = entry.getValue();
                for (Map.Entry entry2 : map.entrySet()) {
                    Set set = entry2.getKey();
                    Set set2 = entry2.getValue();
                    for (Set set3 : set2) {
                        boundedPetriNet.addTransition(LETTER, ImmutableSet.copyOf(set), ImmutableSet.copyOf(set3));
                    }
                }
            }
        }
    }
}

