/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractAssumption;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;

public class VariableNotZeroAssumption
extends AbstractAssumption {
    private final LinkedList<Term> mVariables;

    public VariableNotZeroAssumption(Script script, Term term) {
        super(script, term.getSort(), VariableNotZeroAssumption::notEqualZero);
        this.mVariables = new LinkedList();
        this.mVariables.add(term);
    }

    public VariableNotZeroAssumption(Script script, Sort sort, VariableNotZeroAssumption ... variableNotZeroAssumptionArray) {
        super(script, sort, VariableNotZeroAssumption::notEqualZero);
        assert (variableNotZeroAssumptionArray.length > 1) : "This constructor only makes sense for 2 or more assumptions";
        this.mVariables = variableNotZeroAssumptionArray[0].getVariables();
        int n = 1;
        while (n < variableNotZeroAssumptionArray.length) {
            this.mVariables.addAll(variableNotZeroAssumptionArray[n].getVariables());
            ++n;
        }
    }

    public static Term notEqualZero(Script script, Sort sort, Term term) {
        if (SmtSortUtils.isRealSort(sort)) {
            return VariableNotZeroAssumption.notEqualZeroReal(script, term);
        }
        if (SmtSortUtils.isIntSort(sort)) {
            return VariableNotZeroAssumption.notEqualZeroInt(script, term);
        }
        throw new UnsupportedOperationException("This method is not implemented for this sort.");
    }

    private static Term notEqualZeroReal(Script script, Term term) {
        return SmtUtils.not(script, SmtUtils.binaryEquality(script, term, SmtUtils.rational2Term(script, Rational.ZERO, SmtSortUtils.getRealSort(script))));
    }

    private static Term notEqualZeroInt(Script script, Term term) {
        return SmtUtils.not(script, SmtUtils.binaryEquality(script, term, SmtUtils.constructIntValue(script, BigInteger.ZERO)));
    }

    @Override
    public boolean hasContractedForm() {
        return true;
    }

    @Override
    protected Term constructContractedLhs() {
        Term term;
        Term[] termArray = new Term[this.mVariables.size()];
        int n = 0;
        Iterator iterator = this.mVariables.iterator();
        while (iterator.hasNext()) {
            termArray[n] = term = (Term)iterator.next();
            ++n;
        }
        term = SmtUtils.mul(this.mScript, this.mSort, termArray);
        return (Term)this.mRhsAppender.apply(this.mScript, this.mSort, term);
    }

    @Override
    protected Term[] getConjunctsForExplicitForm() {
        Term[] termArray = new Term[this.mVariables.size()];
        int n = 0;
        for (Term term : this.mVariables) {
            termArray[n] = (Term)this.mRhsAppender.apply(this.mScript, this.mSort, term);
            ++n;
        }
        return termArray;
    }

    private LinkedList<Term> getVariables() {
        return this.mVariables;
    }
}

